/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.MockListParameter;
import csbase.logic.algorithms.parameters.TextListParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public final class TextListParameterTest {
    @Test
    public void testTextListParameterWithTrueIsOptional() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = new Integer(50);
        TextListParameter parameter = new TextListParameter(name, label, description, null, isOptional, true, commandLinePattern, maxCharacters);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertNull((Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)maxCharacters, (Object)parameter.getMaxCharacters());
    }

    @Test
    public void testTextListParameterWithFalseIsOptional() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = new Integer(50);
        TextListParameter parameter = new TextListParameter(name, label, description, null, isOptional, true, commandLinePattern, maxCharacters);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertNull((Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)maxCharacters, (Object)parameter.getMaxCharacters());
    }

    @Test
    public void testTextListParameterWithNullMaxCharacters() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        TextListParameter parameter = new TextListParameter(name, label, description, null, isOptional, true, commandLinePattern, null);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertNull((Object)parameter.getDefaultValue());
        Assert.assertNull((Object)parameter.getMaxCharacters());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTextListParameterWithNullName() {
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        new TextListParameter(null, label, description, null, isOptional, true, commandLinePattern, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTextListParameterWithNullLabel() {
        String name = "Nome do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        new TextListParameter(name, null, description, null, isOptional, true, commandLinePattern, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTextListParameterWithNullDescription() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        new TextListParameter(name, label, null, null, isOptional, true, commandLinePattern, null);
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = false;
        MockListParameter outputParameter = new MockListParameter(name, label, description, isOptional, isVisible, false, true, "{0}={1}");
        LinkedList<String> defaultValues = new LinkedList<String>();
        defaultValues.add("Valor-padr\u00e3o 1");
        defaultValues.add("Valor-padr\u00e3o 2");
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject((Object)outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        MockListParameter inputParameter = (MockListParameter)((Object)objectInput.readObject());
        Assert.assertEquals((Object)((Object)outputParameter), (Object)((Object)inputParameter));
        Assert.assertEquals((Object)outputParameter.getName(), (Object)inputParameter.getName());
        Assert.assertEquals((Object)outputParameter.getLabel(), (Object)inputParameter.getLabel());
        Assert.assertEquals((Object)outputParameter.getDescription(), (Object)inputParameter.getDescription());
        Assert.assertEquals((Object)outputParameter.getDefaultValue(), (Object)inputParameter.getDefaultValue());
        Assert.assertEquals((Object)outputParameter.isOptional(), (Object)inputParameter.isOptional());
        Assert.assertEquals((Object)outputParameter.isVisible(), (Object)inputParameter.isVisible());
    }
}

