/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.URLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class URLListParameterTest {
    private String clientHostName = "TEST_CLIENT";

    @Test
    public void testURLListParameterWithSingleValidValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean mustExist = true;
        boolean mustSort = false;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue value = new URLValue("test.txt");
        values.add(value);
        InputURLListParameter parameter = new InputURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, localization, type, mode, mustSort, allowedProtocols);
        this.assertURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, type, mode, mustExist, mustSort, localization, allowedProtocols, (URLListParameter)parameter);
    }

    @Test
    public void testURLListParameterWithMultipleValidValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean mustExist = true;
        boolean mustSort = false;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue value1 = new URLValue("test.txt");
        URLValue value2 = new URLValue("test2.txt");
        URLValue value3 = new URLValue("test3.txt");
        values.add(value1);
        values.add(value2);
        values.add(value3);
        InputURLListParameter parameter = new InputURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, localization, type, mode, mustSort, allowedProtocols);
        this.assertURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, type, mode, mustExist, mustSort, localization, allowedProtocols, (URLListParameter)parameter);
    }

    @Test
    public void testURLListParameterWithNonOptionalValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = false;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean mustExist = true;
        boolean mustSort = false;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue value = new URLValue("test.txt");
        values.add(value);
        InputURLListParameter parameter = new InputURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, localization, type, mode, mustSort, allowedProtocols);
        this.assertURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, type, mode, mustExist, mustSort, localization, allowedProtocols, (URLListParameter)parameter);
    }

    @Test
    public void testURLListParameterWithNullFileType() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = false;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean mustExist = true;
        boolean mustSort = false;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue value = new URLValue("test.txt");
        values.add(value);
        InputURLListParameter parameter = new InputURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, localization, type, mode, mustSort, allowedProtocols);
        this.assertURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, type, mode, mustExist, mustSort, localization, allowedProtocols, (URLListParameter)parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testURLListParameterWithNullName() {
        new InputURLListParameter(null, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testURLListParameterWithNullLabel() {
        new InputURLListParameter("Nome do par\u00e2metro", null, "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testURLListParameterWithNullDescription() {
        new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", null, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", null, FileParameterMode.REGULAR_FILE, true, EnumSet.allOf(URLProtocol.class));
    }

    @Test
    public void testURLListParameterWithValueOnlyCommandLinePattern() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = false;
        boolean isVisible = true;
        String commandLinePattern = "$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean mustExist = true;
        boolean mustSort = false;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue value = new URLValue("test.txt");
        values.add(value);
        InputURLListParameter parameter = new InputURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, localization, type, mode, mustSort, allowedProtocols);
        this.assertURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, type, mode, mustExist, mustSort, localization, allowedProtocols, (URLListParameter)parameter);
    }

    @Test
    public void testURLListParameterWithDirectoryMode() {
        FileParameterMode mode = FileParameterMode.DIRECTORY;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        boolean mustExist = true;
        boolean mustSort = false;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue value = new URLValue("test");
        values.add(value);
        InputURLListParameter parameter = new InputURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, localization, type, mode, mustSort, allowedProtocols);
        this.assertURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, type, mode, mustExist, mustSort, localization, allowedProtocols, (URLListParameter)parameter);
    }

    @Test
    public void testURLListParameterWithDirectoryAndFileMode() {
        FileParameterMode mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        boolean mustExist = true;
        boolean mustSort = false;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue value = new URLValue("test");
        values.add(value);
        InputURLListParameter parameter = new InputURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, localization, type, mode, mustSort, allowedProtocols);
        this.assertURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, type, mode, mustExist, mustSort, localization, allowedProtocols, (URLListParameter)parameter);
    }

    @Test
    public void testURLListParameterWithExistingFile() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        boolean mustExist = false;
        boolean mustSort = false;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue value = new URLValue("test");
        values.add(value);
        OutputURLListParameter parameter = new OutputURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, localization, type, mode, mustSort, allowedProtocols);
        this.assertURLListParameter(name, label, description, values, isOptional, isVisible, commandLinePattern, type, mode, mustExist, mustSort, localization, allowedProtocols, (URLListParameter)parameter);
    }

    @Test
    public void testGetValueAsTextWithNullValue() {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertNull((Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithSingleFileValueWithFileType() {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "DOC");
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:DOC:project", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithMultipleFileValueWithFileType() {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file1 = new URLValue("dir1/dir2/arq", "DOC");
        URLValue file2 = new URLValue("dir1/dir2/text", "TEXT");
        values.add(file1);
        values.add(file2);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:DOC:project|dir1/dir2/text:TEXT:project", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithSingleFileValueWithProjectProtocol() {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.PROJECT);
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:TEXT:project", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithSingleFileValueWithLocalProtocol() {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.LOCAL);
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:TEXT:local", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithSingleFileValueWithSGAProtocol() {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.SGA);
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:TEXT:sga", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithSingleFileValueWithHost() {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.SGA, "sga-name");
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:TEXT:sga:sga-name", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithSingleFileValueWithNullProtocol() {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", null, "sga-name");
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)("dir1/dir2/arq:TEXT:" + parameter.getDefaultProtocol().getType() + ":sga-name"), (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithMultipleFilesValueWithMultipleProtocols() {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file1 = new URLValue("data/proj.txt", "TEXT", URLProtocol.PROJECT);
        URLValue file2 = new URLValue("public/ftp.doc", "DOC");
        URLValue file3 = new URLValue("/tmp/files/1", null, URLProtocol.LOCAL);
        URLValue file4 = new URLValue("/sgad/s/arq.xml", "XML", URLProtocol.SGA, "mysgad");
        values.add(file1);
        values.add(file2);
        values.add(file3);
        values.add(file4);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)("data/proj.txt:TEXT:project|public/ftp.doc:DOC:" + parameter.getDefaultProtocol().getType() + "|" + "/tmp/files/1:" + "UNKNOWN" + ":local|/sgad/s/arq.xml:XML:sga:mysgad"), (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithSingleFileValueWithNoFileType() {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq");
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:UNKNOWN:project", (Object)parameter.getValueAsText());
    }

    @Test
    public void testSetValueAsTextWithNullValue() throws ParseException {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "DOC");
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals(values, (Object)parameter.getValue());
        parameter.setValueAsText(null);
        Assert.assertNull((Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithSingleFileValueWithNoFileType() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq1:UNKNOWN");
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq1");
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithMultipleFilesValue() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq1:UNKNOWN|dir1/dir2/arq2:DOC");
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file1 = new URLValue("dir1/dir2/arq1");
        URLValue file2 = new URLValue("dir1/dir2/arq2", "DOC");
        values.add(file1);
        values.add(file2);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testAddElementWithSortedValue() throws ParseException {
        boolean mustSort = true;
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, mustSort, EnumSet.allOf(URLProtocol.class));
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file1 = new URLValue("dir1/dir2/arq1");
        URLValue file2 = new URLValue("dir1/dir2/arq2", "DOC");
        URLValue file3 = new URLValue("dir1/dir2/arq3", "DOC", URLProtocol.PROJECT);
        values.add(file1);
        values.add(file2);
        values.add(file3);
        parameter.addElement((Object)file3);
        parameter.addElement((Object)file2);
        parameter.addElement((Object)file1);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testAddElementWithUnSortedValue() throws ParseException {
        boolean mustSort = false;
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, mustSort, EnumSet.allOf(URLProtocol.class));
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file1 = new URLValue("dir1/dir2/arq1");
        URLValue file2 = new URLValue("dir1/dir2/arq2", "DOC");
        URLValue file3 = new URLValue("dir1/dir2/arq3", "DOC", URLProtocol.PROJECT);
        values.add(file3);
        values.add(file2);
        values.add(file1);
        parameter.addElement((Object)file3);
        parameter.addElement((Object)file2);
        parameter.addElement((Object)file1);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithSingleFileValueWithFileType() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:DOC");
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "DOC");
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetValueAsTextWithSingleFileValueWithInvalidProtocol() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:invalido");
    }

    @Test
    public void testSetValueAsTextWithSingleFileValueWithNonAllowedProtocol() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.of(URLProtocol.SGA));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:project");
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.PROJECT);
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithSingleFileValueWithProjectProtocol() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:project");
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.PROJECT);
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithSingleFileValueWithLocalProtocol() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:local");
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.LOCAL);
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithSingleFileValueWithSGAProtocol() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:sga");
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.SGA);
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithSingleFileValueWithHost() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:sga:sga-name");
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.SGA, "sga-name");
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testGetCommandLineWithSingleFileWithProjectProtocolWithUnixSeparator() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, false, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '/', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("dir1/dir2/dir3:DIRECTORY_TYPE");
        Assert.assertEquals((Object)("PARAM_NAME=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + "/dir1/dir2/dir3 Localizacao=project"), (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithSingleFileWithProjectProtocolWithWindowsSeparator() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, false, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '\\', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("dir1\\dir2\\dir3:DIRECTORY_TYPE");
        Assert.assertEquals((Object)("PARAM_NAME=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + "\\dir1\\dir2\\dir3 Localizacao=project"), (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithSingleFileWithLocalProtocolWithWindowsSeparator() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, false, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '\\', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("c:\\dir1\\dir2\\dir3:DIRECTORY_TYPE:LOCAL");
        Assert.assertEquals((Object)"PARAM_NAME=c:\\dir1\\dir2\\dir3 Localizacao=local", (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithSingleFileWithSgaProtocolWithUnixSeparator() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, false, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '/', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("/dir1/dir2/dir3:DIRECTORY_TYPE:SGA");
        Assert.assertEquals((Object)"PARAM_NAME=/dir1/dir2/dir3 Localizacao=sga", (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithSingleFileWithSgaProtocolWithWindowsSeparator() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, false, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '\\', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("c:\\dir1\\dir2\\dir3:DIRECTORY_TYPE:SGA");
        Assert.assertEquals((Object)"PARAM_NAME=c:\\dir1\\dir2\\dir3 Localizacao=sga", (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithSingleFileWithLocalProtocolWithUnixSeparator() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, false, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '/', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("/dir1/dir2/dir3:DIRECTORY_TYPE:LOCAL");
        Assert.assertEquals((Object)"PARAM_NAME=/dir1/dir2/dir3 Localizacao=local", (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testSetValueAsTextWithFileValueWithWindowsPathWithUnixSeparator() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, true, EnumSet.allOf(URLProtocol.class));
        String path = "c:/dir1/dir2/arq.txt";
        parameter.setValueAsText(path + ":TEXT:local");
        URLValue file = new URLValue(path, "TEXT", URLProtocol.LOCAL);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithWindowsPath() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, true, EnumSet.allOf(URLProtocol.class));
        String path = "c:\\dir1\\dir2\\arq.txt";
        parameter.setValueAsText(path + ":TEXT:local");
        URLValue file = new URLValue(path, "TEXT", URLProtocol.LOCAL);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithWindowsRootDir() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, true, EnumSet.allOf(URLProtocol.class));
        String path = "c:\\";
        parameter.setValueAsText(path + ":DIRECTORY_TYPE:local");
        URLValue file = new URLValue(path, "DIRECTORY_TYPE", URLProtocol.LOCAL);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        values.add(file);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithWindowsPathWithUnixSeparator() throws ParseException {
        String path = "c:/dir1/dir2/arq.txt";
        URLValue file = new URLValue(path, "TEXT", URLProtocol.LOCAL);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, true, EnumSet.allOf(URLProtocol.class));
        String valueAsText = path + ":TEXT:local";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithWindowsPath() throws ParseException {
        URLValue file = new URLValue("c:\\dir1\\dir2\\arq.txt", "TEXT", URLProtocol.LOCAL);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, true, EnumSet.allOf(URLProtocol.class));
        String valueAsText = "c:/dir1/dir2/arq.txt:TEXT:local";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithWindowsRootDir() throws ParseException {
        URLValue file = new URLValue("c:\\", "DIRECTORY_TYPE", URLProtocol.LOCAL);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        values.add(file);
        InputURLListParameter parameter = new InputURLListParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", values, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, true, EnumSet.allOf(URLProtocol.class));
        String valueAsText = "c:/:DIRECTORY_TYPE:local";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetCommandLineWithMultipleFiles() throws ParseException {
        InputURLListParameter parameter = new InputURLListParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, false, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '/', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("dir1/dir2/a.txt:TEXT|dir1/dir2/test.xml:XML");
        String proj = CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR);
        Assert.assertEquals((Object)("PARAM_NAME=" + proj + "/dir1/dir2/a.txt," + proj + "/dir1/dir2/test.xml Localizacao=project"), (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithNullValue() {
        InputURLListParameter parameter = new InputURLListParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        Assert.assertNull((Object)parameter.getCommandLine(null));
    }

    private void assertURLListParameter(String name, String label, String description, List<URLValue> value, boolean isOptional, boolean isVisible, String commandLinePattern, String type, FileParameterMode mode, boolean mustExist, boolean mustSort, String localization, EnumSet<URLProtocol> allowedProtocols, URLListParameter parameter) {
        List<URLValue> paramValue;
        Assert.assertNotNull((Object)parameter);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals((Object)type, (Object)parameter.getFileType());
        Assert.assertEquals((Object)mode, (Object)parameter.getMode());
        Assert.assertEquals((Object)isVisible, (Object)parameter.isVisible());
        Assert.assertEquals(value, (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)mustExist, (Object)parameter.mustExist());
        Assert.assertEquals((Object)mustSort, (Object)parameter.mustSort());
        if (mustSort) {
            paramValue = new ArrayList<URLValue>(value);
            Collections.sort(paramValue);
        } else {
            paramValue = value;
        }
        Assert.assertEquals(paramValue, (Object)parameter.getValue());
        Assert.assertEquals((Object)localization, (Object)parameter.getLocalization());
        Assert.assertEquals(allowedProtocols, (Object)parameter.getAllowedProtocols());
    }
}

