/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.conditions;

import csbase.logic.algorithms.parameters.conditions.MockCompositeOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.MockCondition;
import java.util.Arrays;
import junit.framework.TestCase;

public final class CompositeOperatorConditionTest
extends TestCase {
    public void testBinaryOperatorCondition() {
        MockCondition firstCondition = new MockCondition(true);
        MockCondition secondCondition = new MockCondition(true);
        MockCompositeOperatorCondition condition = new MockCompositeOperatorCondition(firstCondition, secondCondition);
        CompositeOperatorConditionTest.assertEquals(Arrays.asList(firstCondition, secondCondition), (Object)condition.getConditions());
    }

    public void testEqualsObject() {
        MockCondition firstCondition1 = new MockCondition(true);
        MockCondition secondCondition1 = new MockCondition(true);
        MockCompositeOperatorCondition condition1 = new MockCompositeOperatorCondition(firstCondition1, secondCondition1);
        MockCompositeOperatorCondition condition2 = new MockCompositeOperatorCondition(firstCondition1, secondCondition1);
        CompositeOperatorConditionTest.assertEquals((Object)((Object)condition1), (Object)((Object)condition2));
    }

    public void testEqualsObjectWithNull() {
        MockCondition firstCondition1 = new MockCondition(true);
        MockCondition secondCondition1 = new MockCondition(true);
        MockCompositeOperatorCondition condition1 = new MockCompositeOperatorCondition(firstCondition1, secondCondition1);
        CompositeOperatorConditionTest.assertFalse((boolean)condition1.equals(null));
    }

    public void testEqualsObjectWithAnotherClass() {
        MockCondition firstCondition1 = new MockCondition(true);
        MockCondition secondCondition1 = new MockCondition(true);
        MockCompositeOperatorCondition condition1 = new MockCompositeOperatorCondition(firstCondition1, secondCondition1);
        CompositeOperatorConditionTest.assertFalse((boolean)condition1.equals("Outra classe"));
    }

    public void testEqualsObjectWithDifferentFirstCondition() {
        MockCondition firstCondition1 = new MockCondition(true);
        MockCondition secondCondition1 = new MockCondition(true);
        MockCompositeOperatorCondition condition1 = new MockCompositeOperatorCondition(firstCondition1, secondCondition1);
        MockCondition firstCondition2 = new MockCondition(true);
        MockCompositeOperatorCondition condition2 = new MockCompositeOperatorCondition(firstCondition2, secondCondition1);
        CompositeOperatorConditionTest.assertFalse((boolean)condition1.equals((Object)condition2));
    }

    public void testEqualsObjectWithDifferentSecondCondition() {
        MockCondition firstCondition1 = new MockCondition(true);
        MockCondition secondCondition1 = new MockCondition(true);
        MockCompositeOperatorCondition condition1 = new MockCompositeOperatorCondition(firstCondition1, secondCondition1);
        MockCondition secondCondition2 = new MockCondition(true);
        MockCompositeOperatorCondition condition2 = new MockCompositeOperatorCondition(firstCondition1, secondCondition2);
        CompositeOperatorConditionTest.assertFalse((boolean)condition1.equals((Object)condition2));
    }

    public void testEqualsObjectWithDifferentConditions() {
        MockCondition firstCondition1 = new MockCondition(true);
        MockCondition secondCondition1 = new MockCondition(true);
        MockCompositeOperatorCondition condition1 = new MockCompositeOperatorCondition(firstCondition1, secondCondition1);
        MockCondition firstCondition2 = new MockCondition(true);
        MockCondition secondCondition2 = new MockCondition(true);
        MockCompositeOperatorCondition condition2 = new MockCompositeOperatorCondition(firstCondition2, secondCondition2);
        CompositeOperatorConditionTest.assertFalse((boolean)condition1.equals((Object)condition2));
    }

    public void testHashCode() {
        MockCondition firstCondition1 = new MockCondition(true);
        MockCondition secondCondition1 = new MockCondition(true);
        MockCompositeOperatorCondition condition1 = new MockCompositeOperatorCondition(firstCondition1, secondCondition1);
        MockCompositeOperatorCondition condition2 = new MockCompositeOperatorCondition(firstCondition1, secondCondition1);
        CompositeOperatorConditionTest.assertEquals((int)condition1.hashCode(), (int)condition2.hashCode());
    }
}

