/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.ChangeDefaultValueTrigger;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class ChangeDefaultValueTriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testChangeDefaultValueTrigger1() {
        SimpleParameter<?> parameter = this.createMockParameter();
        Condition condition = this.createMockCondition();
        String defaultValue = "Valor-padr\u00e3o do gatilho";
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger(parameter, condition, (Object)defaultValue);
        Assert.assertEquals(parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)defaultValue, (Object)trigger.getDefaultValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeDefaultValueTrigger2() {
        Condition condition = this.createMockCondition();
        String defaultValue = "Valor-padr\u00e3o do gatilho";
        new ChangeDefaultValueTrigger(null, condition, (Object)defaultValue);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeDefaultValueTrigger3() {
        SimpleParameter<?> parameter = this.createMockParameter();
        String defaultValue = "Valor-padr\u00e3o do gatilho";
        new ChangeDefaultValueTrigger(parameter, null, (Object)defaultValue);
    }

    @Test
    public void testChangeDefaultValueTrigger4() {
        SimpleParameter<?> parameter = this.createMockParameter();
        Condition condition = this.createMockCondition();
        Object defaultValue = null;
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger(parameter, condition, defaultValue);
        Assert.assertEquals(parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(defaultValue, (Object)trigger.getDefaultValue());
    }

    @Test
    public void testDoAction1() {
        String parameterName = "Nome do par\u00e2metro";
        String parameterDefaultValue = "Valor-padr\u00e3o";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName, parameterDefaultValue);
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)parameterDefaultValue);
        String newParameterDefaultValue = "Novo valor-padr\u00e3o";
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger(parameter, (Condition)condition, (Object)newParameterDefaultValue);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter(parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newParameterDefaultValue, (Object)parameter.getDefaultValue());
    }

    @Test
    public void testDoAction2() {
        String parameterName = "Nome do par\u00e2metro";
        String parameterDefaultValue = "Valor-padr\u00e3o";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName, parameterDefaultValue);
        String anotherParameterDefaultValue = "Outro valor-padr\u00e3o";
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)anotherParameterDefaultValue);
        String newParameterDefaultValue = "Novo valor-padr\u00e3o";
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger(parameter, (Condition)condition, (Object)newParameterDefaultValue);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter(parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)parameterDefaultValue, (Object)parameter.getDefaultValue());
    }

    @Test
    public void testEquals1() {
        SimpleParameter<?> parameter = this.createMockParameter();
        SimpleCondition condition1 = new SimpleCondition("Par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Par\u00e2metro 2", (Object)"Valor 2");
        String defaultValue = "Valor-padr\u00e3o do gatilho";
        ChangeDefaultValueTrigger trigger1 = new ChangeDefaultValueTrigger(parameter, (Condition)condition1, (Object)defaultValue);
        ChangeDefaultValueTrigger trigger2 = new ChangeDefaultValueTrigger(parameter, (Condition)condition2, (Object)defaultValue);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals2() {
        SimpleParameter<?> parameter1 = this.createMockParameter("Par\u00e2metro 1");
        SimpleParameter<?> parameter2 = this.createMockParameter("Par\u00e2metro 2");
        Condition condition = this.createMockCondition();
        String defaultValue = "Valor-padr\u00e3o do gatilho";
        ChangeDefaultValueTrigger trigger1 = new ChangeDefaultValueTrigger(parameter1, condition, (Object)defaultValue);
        ChangeDefaultValueTrigger trigger2 = new ChangeDefaultValueTrigger(parameter2, condition, (Object)defaultValue);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals3() {
        SimpleParameter<?> parameter = this.createMockParameter();
        Condition condition = this.createMockCondition();
        String defaultValue1 = "Valor-padr\u00e3o 1";
        String defaultValue2 = "Valor-padr\u00e3o 2";
        ChangeDefaultValueTrigger trigger1 = new ChangeDefaultValueTrigger(parameter, condition, (Object)defaultValue1);
        ChangeDefaultValueTrigger trigger2 = new ChangeDefaultValueTrigger(parameter, condition, (Object)defaultValue2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals4() {
        SimpleParameter<?> parameter = this.createMockParameter();
        Condition condition = this.createMockCondition();
        String defaultValue = "Valor-padr\u00e3o";
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger(parameter, condition, (Object)defaultValue);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals5() {
        SimpleParameter<?> parameter = this.createMockParameter();
        Condition condition = this.createMockCondition();
        String defaultValue = "Valor-padr\u00e3o";
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger(parameter, condition, (Object)defaultValue);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    private SimpleAlgorithmConfigurator createMockAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private Condition createMockCondition() {
        return new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor qualquer");
    }

    private SimpleParameter<?> createMockParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockParameter(parameterName);
    }

    private SimpleParameter<?> createMockParameter(String parameterName) {
        String defaultValue = "Valor-padr\u00e3o do par\u00e2metro";
        return this.createMockParameter(parameterName, defaultValue);
    }

    private SimpleParameter<?> createMockParameter(String parameterName, Object defaultValue) {
        return new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, "{0}={1}");
    }

    private ParameterGroup createMockParameterGroup() {
        return new ParameterGroup("Grupo de par\u00e2metros");
    }
}

