/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.Column;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FormulaParameter;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.OutputFileListParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.OutputFileParameterFactory;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextColumn;
import csbase.logic.algorithms.parameters.TextListParameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.ValidationExpression;
import csbase.logic.algorithms.parameters.conditions.AndOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.GenericCondition;
import csbase.logic.algorithms.parameters.conditions.NotOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.OrOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.ChangeDefaultValueTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeFileTypeTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeLabelTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForDoublesTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForIntegersTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMinimumForDoublesTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMinimumForIntegersTrigger;
import csbase.logic.algorithms.parameters.triggers.DisableParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.EnableParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.HideGroupTrigger;
import csbase.logic.algorithms.parameters.triggers.HideParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.SetVisibleEnumerationItemTrigger;
import csbase.logic.algorithms.parameters.triggers.ShowGroupTrigger;
import csbase.logic.algorithms.parameters.triggers.ShowParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.SimpleAlgorithmParser;
import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.test.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public final class SimpleAlgorithmParserTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testAlgorithmCreation() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithNoCommand() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo/>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testAlgorithmCreationWithDescription() throws ParseException {
        String command = "Comando_do_algoritmo";
        String description = "";
        description = description + "Esta \u00e9 a descri\u00e7\u00e3o do algoritmo de teste.\n";
        description = description + "Este elemento cria a descri\u00e7\u00e3o do algoritmo.";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, description, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<descricao>\n";
        xml = xml + description;
        xml = xml + "\n</descricao>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithAbbreviation() throws ParseException {
        String command = "Comando_do_algoritmo";
        String abbreviation = "Abreviatura da vers\u00e3o";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, abbreviation, false, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' abreviatura='" + abbreviation + "'/>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithNoCommandIdentifier() throws ParseException {
        String command = "Comando_do_algoritmo";
        boolean provideId = false;
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, provideId, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' fornecer_identificador='" + provideId + "'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithCommandIdentifier() throws ParseException {
        String command = "Comando_do_algoritmo";
        boolean provideId = true;
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, provideId, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' fornecer_identificador='" + provideId + "'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithEmptyDescription() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<descricao>\n";
        xml = xml + "</descricao>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithShell() throws ParseException {
        String command = "Comando_do_algoritmo";
        String shell = "Shell_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, shell, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' shell='" + shell + "'>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithDefaultInputFile() throws ParseException {
        String command = "Comando_do_algoritmo";
        String parameterName = "Nome do Arquivo de Entrada";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, parameterName);
        String groupName = "Nome do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        expectedVersion.addGroup(group);
        String parameterLabel = "R\u00f3tulo do Arquivo de Entrada";
        String parameterDescription = "Descri\u00e7\u00e3o do Arquivo de Entrada";
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' arquivo_de_entrada_padrao='" + parameterName + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithNonExistantDefaultInputFile() {
        String command = "Comando_do_algoritmo";
        String otherParameterName = "Outro par\u00e2metro de entrada";
        String groupName = "Nome do grupo";
        String parameterName = "Nome do Arquivo de Entrada";
        String parameterLabel = "R\u00f3tulo do Arquivo de Entrada";
        String parameterDescription = "Descri\u00e7\u00e3o do Arquivo de Entrada";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' arquivo_de_entrada_padrao='" + otherParameterName + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testAlgorithmCreationWithSimpleExecution() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' tipo_de_execucao='simples'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithExitCode() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        expectedVersion.setHasExitCode(true);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' capturar_codigo_de_saida='sim'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithNoExitCode() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        expectedVersion.setHasExitCode(false);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' capturar_codigo_de_saida='nao'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithMultipleExecution() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.MULTIPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' tipo_de_execucao='multipla'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithExecutionLocationAsBinaryDir() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' local_de_execucao='BINARY_DIR'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithExecutionLocationAsPersistencyDir() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.PERSISTENCY_DIR, null, false, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' local_de_execucao='PERSISTENCY_DIR'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithExecutionLocationAsSandbox() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.SANDBOX, null, false, null, null);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' local_de_execucao='SANDBOX'>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAlgorithmCreationWithUnknownAttributes() {
        String command = "Comando_do_algoritmo";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "' desconhecido='valor'>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testAlgorithmCreationWithUnknownDescriptionAttributes() {
        String command = "Comando_do_algoritmo";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<descricao desconhecido='valor'>\n";
        xml = xml + "conteudo";
        xml = xml + "</descricao>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testAlgorithmCreationWithDescriptionChildElements() {
        String command = "Comando_do_algoritmo";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<descricao>\n";
        xml = xml + "conteudo";
        xml = xml + "<filho/>";
        xml = xml + "</descricao>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testAlgorithmCreationWithAllParameterTypes() throws ParseException {
        String commandLinePattern = "Nome: $NOME_DO_PARAMETRO - Valor: $VALOR_DO_PARAMETRO";
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command);
        String groupName = "Par\u00e2metros";
        ParameterGroup group = new ParameterGroup(groupName);
        expectedVersion.addGroup(group);
        String booleanParameterName = "Booleano";
        String booleanParameterLabel = "Booleano";
        String booleanParameterDescription = "Booleano";
        BooleanParameter booleanParameter = new BooleanParameter(booleanParameterName, booleanParameterLabel, booleanParameterDescription, false, true, commandLinePattern, null, null);
        group.addParameter((Parameter)booleanParameter);
        String textParameterName = "Texto";
        String textParameterLabel = "Texto";
        String textParameterDescription = "Texto";
        TextParameter textParameter = new TextParameter(textParameterName, textParameterLabel, textParameterDescription, null, false, true, commandLinePattern, null);
        group.addParameter((Parameter)textParameter);
        String textListParameterName = "Lista_de_Texto";
        String textListParameterLabel = "Lista de Texto";
        String textListParameterDescription = "Lista de Texto";
        TextListParameter textListParameter = new TextListParameter(textListParameterName, textListParameterLabel, textListParameterDescription, null, false, true, commandLinePattern, null);
        group.addParameter((Parameter)textListParameter);
        String integerParameterName = "Inteiro";
        String integerParameterLabel = "Inteiro";
        String integerParameterDescription = "Inteiro";
        IntegerParameter integerParameter = new IntegerParameter(integerParameterName, integerParameterLabel, integerParameterDescription, null, false, true, commandLinePattern, null, null);
        group.addParameter((Parameter)integerParameter);
        String integerListParameterName = "Lista_de_Inteiros";
        String integerListParameterLabel = "Lista de Inteiros";
        String integerListParameterDescription = "Lista de Inteiros";
        IntegerListParameter integerListParameter = new IntegerListParameter(integerListParameterName, integerListParameterLabel, integerListParameterDescription, null, false, true, commandLinePattern, null, null);
        group.addParameter((Parameter)integerListParameter);
        String doubleParameterName = "Real";
        String doubleParameterLabel = "Real";
        String doubleParameterDescription = "Real";
        DoubleParameter doubleParameter = new DoubleParameter(doubleParameterName, doubleParameterLabel, doubleParameterDescription, null, false, true, commandLinePattern, null, false, null, false);
        group.addParameter((Parameter)doubleParameter);
        String doubleListParameterName = "Lista_de_Reais";
        String doubleListParameterLabel = "Lista de Reais";
        String doubleListParameterDescription = "Lista de Reais";
        DoubleListParameter doubleListParameter = new DoubleListParameter(doubleListParameterName, doubleListParameterLabel, doubleListParameterDescription, null, false, true, commandLinePattern, null, false, null, false);
        group.addParameter((Parameter)doubleListParameter);
        String tableParameterName = "Tabela";
        String tableParameterLabel = "Tabela";
        String tableParameterDescription = "Tabela";
        String columnId = "Coluna";
        String columnName = "Coluna";
        TextColumn column = new TextColumn(columnId, columnName, null, false, true, null);
        List<Column> columns = Arrays.asList(column);
        TableParameter tableParameter = new TableParameter(tableParameterName, tableParameterLabel, tableParameterDescription, false, true, commandLinePattern, columns, false, false, null, null, null, null);
        group.addParameter((Parameter)tableParameter);
        String inputFileParameterName = "Arquivo_de_entrada";
        String inputFileParameterLabel = "Arquivo de entrada";
        String inputFileParameterDescription = "Arquivo de entrada";
        InputFileParameter inputFileParameter = new InputFileParameter(inputFileParameterName, inputFileParameterLabel, inputFileParameterDescription, null, false, true, commandLinePattern, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String outputFileParameterName = "Arquivo_de_saida";
        String outputFileParameterLabel = "Arquivo de sa\u00edda";
        String outputFileParameterDescription = "Arquivo de sa\u00edda";
        OutputFileParameter outputFileParameter = new OutputFileParameter(outputFileParameterName, outputFileParameterLabel, outputFileParameterDescription, null, false, true, commandLinePattern, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        group.addParameter((Parameter)outputFileParameter);
        OutputFileParameter logFileParameter = OutputFileParameter.createLogFile((String)commandLinePattern);
        group.addParameter((Parameter)logFileParameter);
        String enumerationItemId = "Item";
        String enumerationItemLabel = "Item";
        String enumerationItemValue = "Item";
        EnumerationItem enumerationItem = new EnumerationItem(enumerationItemId, enumerationItemLabel, enumerationItemValue, null);
        String enumerationParameterName = "Enumeracao";
        String enumerationParameterLabel = "Enumera\u00e7\u00e3o";
        String enumerationParameterDescription = "Enumera\u00e7\u00e3o";
        boolean enumerationMustSortItems = true;
        EnumerationParameter enumerationParameter = new EnumerationParameter(enumerationParameterName, enumerationParameterLabel, enumerationParameterDescription, enumerationItem, true, commandLinePattern, Arrays.asList(enumerationItem), enumerationMustSortItems);
        group.addParameter((Parameter)enumerationParameter);
        String enumerationListParameterName = "Lista_de_Enumeracao";
        String enumerationListParameterLabel = "Lista de Enumera\u00e7\u00e3o";
        String enumerationListParameterDescription = "Lista de Enumera\u00e7\u00e3o";
        EnumerationListParameter enumerationListParameter = new EnumerationListParameter(enumerationListParameterName, enumerationListParameterLabel, enumerationListParameterDescription, null, false, true, commandLinePattern);
        enumerationListParameter.setItems(Arrays.asList(enumerationItem));
        group.addParameter((Parameter)enumerationListParameter);
        String hiddenParameterName = "Oculto";
        String hiddenParameterValue = "Valor_do_Oculto";
        HiddenParameter hiddenParameter = new HiddenParameter(hiddenParameterName, hiddenParameterValue, commandLinePattern);
        expectedVersion.addHiddenParameter(hiddenParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<booleano nome='" + booleanParameterName + "' rotulo='" + booleanParameterLabel + "' dica='" + booleanParameterDescription + "'/>";
        xml = xml + "<texto nome='" + textParameterName + "' rotulo='" + textParameterLabel + "' dica='" + textParameterDescription + "'/>";
        xml = xml + "<lista_de_texto nome='" + textListParameterName + "' rotulo='" + textListParameterLabel + "' dica='" + textListParameterDescription + "'/>";
        xml = xml + "<inteiro nome='" + integerParameterName + "' rotulo='" + integerParameterLabel + "' dica='" + integerParameterDescription + "'/>";
        xml = xml + "<lista_de_inteiros nome='" + integerListParameterName + "' rotulo='" + integerListParameterLabel + "' dica='" + integerListParameterDescription + "'/>";
        xml = xml + "<real nome='" + doubleParameterName + "' rotulo='" + doubleParameterLabel + "' dica='" + doubleParameterDescription + "'/>";
        xml = xml + "<lista_de_reais nome='" + doubleListParameterName + "' rotulo='" + doubleListParameterLabel + "' dica='" + doubleListParameterDescription + "'/>";
        xml = xml + "<tabela nome='" + tableParameterName + "' rotulo='" + tableParameterLabel + "' dica='" + tableParameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto id='" + columnId + "' rotulo='" + columnName + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "<arquivo_de_entrada nome='" + inputFileParameterName + "' rotulo='" + inputFileParameterLabel + "' dica='" + inputFileParameterDescription + "'/>";
        xml = xml + "<arquivo_de_saida nome='" + outputFileParameterName + "' rotulo='" + outputFileParameterLabel + "' dica='" + outputFileParameterDescription + "'/>";
        xml = xml + "<arquivo_de_log/>";
        xml = xml + "<enumeracao nome='" + enumerationParameterName + "' rotulo='" + enumerationParameterLabel + "' dica='" + enumerationParameterDescription + "' padrao='" + enumerationItemId + "' selecao_multipla='nao'>\n";
        xml = xml + "<item_de_enumeracao rotulo='" + enumerationItemLabel + "' id='" + enumerationItemId + "' valor='" + enumerationItemValue + "'/>";
        xml = xml + "</enumeracao>\n";
        xml = xml + "<enumeracao nome='" + enumerationListParameterName + "' rotulo='" + enumerationListParameterLabel + "' dica='" + enumerationListParameterDescription + "' selecao_multipla='sim'>\n";
        xml = xml + "<item_de_enumeracao rotulo='" + enumerationItemLabel + "' id='" + enumerationItemId + "' valor='" + enumerationItemValue + "'/>";
        xml = xml + "</enumeracao>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "<oculto nome='" + hiddenParameterName + "' valor='" + hiddenParameterValue + "'/>";
        xml = xml + "<formato_no_comando>\n";
        xml = xml + commandLinePattern;
        xml = xml + "</formato_no_comando>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testSimpleParameterGroup() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "R\u00f3tulo do grupo 1";
        String groupName2 = "R\u00f3tulo do grupo 2";
        String groupId1 = "IdGrupo1";
        String groupId2 = "Id Grupo 2";
        ParameterGroup group1 = new ParameterGroup(groupId1, groupName1, false);
        ParameterGroup group2 = new ParameterGroup(groupId2, groupName2, false);
        expectedVersion.addGroup(group1);
        expectedVersion.addGroup(group2);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'/>";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testCollapsibleParameterGroup() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "R\u00f3tulo do grupo";
        String groupId1 = "IdGrupo";
        ParameterGroup group1 = new ParameterGroup(groupId1, groupName1, true);
        expectedVersion.addGroup(group1);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "' minimizavel='verdadeiro'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testNonCollapsibleParameterGroup() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "R\u00f3tulo do grupo";
        String groupId1 = "IdGrupo";
        ParameterGroup group1 = new ParameterGroup(groupId1, groupName1, false);
        expectedVersion.addGroup(group1);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "' minimizavel='falso'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testParameterGroupWithNoId() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo 1";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testParameterGroupWithNoLabelOrId() {
        String command = "Comando_do_algoritmo";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testParameterGroupWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupId = "IdGrupo1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testParameterGroupsWithSameLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "Grupo 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'/>";
        xml = xml + "<grupo rotulo='" + groupName + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testParameterGroupWithinAnotherGroup() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "Group1";
        ParameterGroup group1 = new ParameterGroup(groupName1);
        version.addGroup(group1);
        String groupName11 = "Group1.1";
        ParameterGroup group11 = new ParameterGroup(groupName11);
        group1.addParameter((Parameter)group11);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + group1 + "'>";
        xml = xml + "<grupo rotulo='" + group11 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testParameterGroupWithUnknownAttribute() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "' desconhecido='valor'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testParameterGroupWithUnknownChildElement() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<filho/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testSimpleBooleanParameters() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = false;
        String trueCommand1 = "1";
        String falseCommand1 = "0";
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, CMD_PATTERN, falseCommand1, trueCommand1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String trueCommand2 = "1";
        String falseCommand2 = "0";
        boolean parameterDefaultValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, true, CMD_PATTERN, falseCommand2, trueCommand2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDuplicateBooleanParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanParameterWithDefaultValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = true;
        String trueCommand1 = "1";
        String falseCommand1 = "0";
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, CMD_PATTERN, falseCommand1, trueCommand1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String trueCommand2 = "1";
        String falseCommand2 = "0";
        boolean parameterDefaultValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, true, CMD_PATTERN, falseCommand2, trueCommand2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testBooleanParameterWithNonBooleanDefaultValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='Valor n\u00e3o booleano'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanParameterWithNoName() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanParameterWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanParameterWithNoDescription() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        boolean parameterDefaultValue1 = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano rotulo='" + parameterLabel1 + "' nome='" + parameterName1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanParameterWithCustomTrueAndFalseCommands() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = false;
        String trueCommand1 = "SIM";
        String falseCommand1 = "NAO";
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, CMD_PATTERN, falseCommand1, trueCommand1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "' falso='" + falseCommand1 + "' verdadeiro='" + trueCommand1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testHiddenBooleanParameterWithNoValue() {
        String command = "Comando";
        String parameterGroupName = "Grupo";
        String parameterName = "Nome do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + parameterGroupName + "'>\n";
        xml = xml + "<booleano nome='" + parameterName + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHiddenBooleanParameterWithNonBooleanValue() {
        String command = "Comando";
        String parameterGroupName = "Grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterValue = "Valor n\u00e3o-booleano";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + parameterGroupName + "'>\n";
        xml = xml + "<booleano nome='" + parameterName + "' valor='" + parameterValue + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanParameterWithUnknownAttributes() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro 1";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' desconhecido='valor'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanParameterWithCustomCommandPatternShowingNameAndValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = false;
        String trueCommand1 = "1";
        String falseCommand1 = "0";
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, "Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO", falseCommand1, trueCommand1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO</formato_no_comando>\n";
        xml = xml + "</booleano>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testBooleanParameterWithCustomCommandPatternWithNoNameOrValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = false;
        String trueCommand1 = "1";
        String falseCommand1 = "0";
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, null, falseCommand1, trueCommand1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando/>\n";
        xml = xml + "</booleano>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testSimpleDoubleParameters() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        Double parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        Double maximum2 = null;
        boolean includeMaximum2 = true;
        Double minimum2 = null;
        boolean includeMinimum2 = true;
        DoubleParameter parameter2 = new DoubleParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, maximum2, includeMaximum2, minimum2, includeMinimum2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<real nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDuplicateDoubleParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithNoName() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<real rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<real nome='" + parameterName1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithNoDescription() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithNoDefaultValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = 100.0;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleParameterWithNonDoubleDefaultValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = "Valor n\u00e3o real";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithNullDefaultValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = 10.0;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleParameterWithNonDoubleMinimumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String minimum1 = "Valor n\u00e3o real";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithMaximumValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = 1000.0;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleParameterWithNonDoubleMaximumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String maximum1 = "Valor n\u00e3o real";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithMinimumValueGreaterThanMaximumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double minimum1 = 1.0;
        Double maximum1 = -1.0;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithDefaultValueGreaterThanMaximumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double defaultValue1 = 20.0;
        Double minimum1 = 1.0;
        Double maximum1 = 10.0;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' maximo='" + maximum1 + "' padrao='" + defaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithDefaultValueSmallerThanMinimumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double defaultValue1 = 20.0;
        Double minimum1 = 1.0;
        Double maximum1 = 10.0;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' maximo='" + maximum1 + "' padrao='" + defaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithNonInclusiveMaximumValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = 1000.0;
        boolean includeMaximum1 = false;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "' incluir_maximo='" + includeMaximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleParameterWithInclusiveMaximumValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = 1000.0;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "' incluir_maximo='" + includeMaximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleParameterWithNonBooleanIncludeMaximumAttributeValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String includeMaximum1 = "Valor n\u00e3o booleano";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' incluir_maximo='" + includeMaximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithNonInclusiveMinimumValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = 1000.0;
        boolean includeMinimum1 = false;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' incluir_minimo='" + includeMinimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleParameterWithInclusiveMinimumValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = 1000.0;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' incluir_minimo='" + includeMinimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleParameterWithNonBooleanIncludeMinimumAttributeValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String includeMinimum1 = "Valor n\u00e3o booleano";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' incluir_maximo='" + includeMinimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOptionalDoubleParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = true;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testNonOptionalDoubleParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleParameterWithNonBooleanOptionalAttributeValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String isOptional1 = "Valor n\u00e3o booleano";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithSameMaximumAndMinimumValues() throws ParseException {
        Double maximum1;
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double minimum1 = maximum1 = Double.valueOf(10.0);
        DoubleParameter parameter = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, null, false, true, CMD_PATTERN, maximum1, true, minimum1, true);
        group.addParameter((Parameter)parameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "' minimo='" + minimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testDoubleParameterWithUnknownAttributes() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' desconhecido='valor'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleParameterWithCommandPatternShowingNameAndValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, "Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO", maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO</formato_no_comando>\n";
        xml = xml + "</real>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleParameterWithCustomCommandPatternWithNoNameOrValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, null, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando/>\n";
        xml = xml + "</real>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testSimpleIntegerParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        Integer parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        Integer maximum2 = null;
        Integer minimum2 = null;
        IntegerParameter parameter2 = new IntegerParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, maximum2, minimum2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<inteiro nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDuplicateIntegerParameter() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithNoName() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithNoDescription() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithDefaultValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = 100;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerParameterWithNonIntegerDefaultValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = "Valor n\u00e3o inteiro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithMinimumValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = 10;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerParameterWithNonIntegerMinimumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String minimum1 = "Valor n\u00e3o inteiro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithMaximuValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Integer maximum1 = 1000;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerParameterWithNonIntegerMaximumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String maximum1 = "Valor n\u00e3o inteiro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithSameMinimumAndMaximumValues() throws ParseException {
        Integer minimum;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator("Comando", null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup("Grupo");
        Integer maximum = minimum = Integer.valueOf(100);
        IntegerParameter parameter = new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, CMD_PATTERN, maximum, minimum);
        group.addParameter((Parameter)parameter);
        version.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + version.getCommandBinaryName() + "'>\n";
        xml = xml + "<grupo rotulo='" + group.getName() + "'>";
        xml = xml + "<inteiro nome='" + parameter.getName() + "' rotulo='" + parameter.getLabel() + "' dica='" + parameter.getDescription() + "' maximo='" + maximum + "' minimo='" + minimum + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testIntegerParameterWithMininumValueGreaterThanMaximumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer minimum1 = 1;
        Integer maximum1 = -1;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithDefaultValueGreaterThanMaximumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer defaultValue1 = 20;
        Integer minimum1 = 1;
        Integer maximum1 = 10;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' maximo='" + maximum1 + "' padrao='" + defaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithDefaultValueSmallerThanMinimumValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer defaultValue1 = -2;
        Integer minimum1 = 1;
        Integer maximum1 = 10;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' maximo='" + maximum1 + "' padrao='" + defaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testNonOptionalIntegerParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testOptionalIntegerParameter17() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = true;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerParameterNonBooleanOptionAttributeValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = true;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testHiddenIntegerParameterWithNoValue() {
        String command = "Comando";
        String parameterGroupName = "Grupo";
        String parameterName = "Nome do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + parameterGroupName + "'>\n";
        xml = xml + "<inteiro nome='" + parameterName + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHiddenIntegerParameterWithNonIntegerValue() {
        String command = "Comando";
        String parameterGroupName = "Grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterValue = "Valor n\u00e3o-inteiro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + parameterGroupName + "'>\n";
        xml = xml + "<inteiro nome='" + parameterName + "' valor='" + parameterValue + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithUnkownAttributes() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' desconhecido='valor'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerParameterWithCommandPatternShowingNameAndValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        String commandLinePattern1 = "Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO";
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, commandLinePattern1, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>";
        xml = xml + commandLinePattern1;
        xml = xml + "</formato_no_comando>";
        xml = xml + "</inteiro>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerParameterWithCommandPatternWithNoNameOrValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, null, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>";
        xml = xml + "</formato_no_comando>";
        xml = xml + "</inteiro>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testSimpleTextParameters() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDuplicateTextParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextParameterWithNoName() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextParameterWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextParameterWithNoDescription() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextParameterWithDefaultValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = "Valor-padr\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testOptionalTextParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = true;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' opcional='" + isOptional2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextParameterWithNonBooleanOptionalValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String isOptional1 = "Valor n\u00e3o booleano";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextParameterWithMaximumCharacters() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = "Valor-padr\u00e3o 1";
        Integer maxCharacters1 = 10;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maxCharacters1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "' opcional='" + isOptional1 + "' maximo_de_caracteres='" + maxCharacters1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextParameterWithNonIntegerMaximumCharacters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = "Valor-padr\u00e3o 1";
        boolean isOptional1 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "' opcional='" + isOptional1 + "' maximo_de_caracteres='Valor n\u00e3o-inteiro'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextParameterWithNegativeMaximumCharacters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = "Valor-padr\u00e3o 1";
        Integer maxCharacters1 = 0;
        boolean isOptional1 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "' opcional='" + isOptional1 + "' maximo_de_caracteres='" + maxCharacters1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextParameterWithNoDefaultValue() {
        String command = "Comando";
        String parameterGroupName = "Grupo";
        String parameterName = "Nome do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + parameterGroupName + "'>\n";
        xml = xml + "<texto nome='" + parameterName + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextParameterWithUnkownAttributes() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro 1";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' desconhecido='valor'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextParameterWithCommandPatternShowingNameAndValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        String commandLinePattern1 = "Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO";
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, commandLinePattern1, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>" + commandLinePattern1 + "</formato_no_comando>\n";
        xml = xml + "</texto>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextParameterWithCommandPatternWithNoNameOrValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, null, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>\n";
        xml = xml + "</texto>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testSimpleFormulaParameters() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        FormulaParameter parameter1 = new FormulaParameter(parameterName1, parameterLabel1, parameterDescription1, isOptional1, true, CMD_PATTERN);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean isOptional2 = false;
        FormulaParameter parameter2 = new FormulaParameter(parameterName2, parameterLabel2, parameterDescription2, isOptional2, true, CMD_PATTERN);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<formula nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<formula nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDuplicateFormulaParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<formula nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<formula nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testFormulaParameterWithNoName() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<formula rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testFormulaParameterWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<formula nome='" + parameterName1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testFormulaParameter5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<formula nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOptionalAndNonOptionalFormulaParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        FormulaParameter parameter1 = new FormulaParameter(parameterName1, parameterLabel1, parameterDescription1, isOptional1, true, CMD_PATTERN);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean isOptional2 = true;
        FormulaParameter parameter2 = new FormulaParameter(parameterName2, parameterLabel2, parameterDescription2, isOptional2, true, CMD_PATTERN);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<formula nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "<formula nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' opcional='" + isOptional2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testFormulaParameterWithNonBooleanOptionalAttributeValue() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String isOptional1 = "Valor n\u00e3o booleano";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<formula nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testFormulaParameterWithUnknownAttribute() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro 1";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<formula nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' desconhecido='valor'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testFormulaParameterWithCommandPatternShowingNameAndValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        String commandLinePattern1 = "Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO";
        FormulaParameter parameter1 = new FormulaParameter(parameterName1, parameterLabel1, parameterDescription1, isOptional1, true, commandLinePattern1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<formula nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>" + commandLinePattern1 + "</formato_no_comando>\n";
        xml = xml + "</formula>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testFormulaParameterWithCommandPatternWithNoNameOrValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        FormulaParameter parameter1 = new FormulaParameter(parameterName1, parameterLabel1, parameterDescription1, isOptional1, true, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<formula nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>\n";
        xml = xml + "</formula>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testSimpleEnumerationParameters() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultItemId1 = "ID 11";
        String parameterDefaultItemName1 = "Nome do item padr\u00e3o 1.1";
        String parameterDefaultItemValue1 = "V1.1";
        EnumerationItem parameterDefaultValue1 = new EnumerationItem(parameterDefaultItemId1, parameterDefaultItemName1, parameterDefaultItemValue1, null);
        String parameterItemId1 = "ID 12";
        String parameterItemName1 = "Nome do item padr\u00e3o 1.2";
        String parameterItemValue1 = "V1.2";
        EnumerationItem parameterValue1 = new EnumerationItem(parameterItemId1, parameterItemName1, parameterItemValue1, null);
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(parameterDefaultValue1);
        items1.add(parameterValue1);
        boolean mustSortItems = true;
        EnumerationParameter parameter1 = new EnumerationParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, CMD_PATTERN, items1, mustSortItems);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultItemId1 + "'>";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId1 + "' rotulo='" + parameterDefaultItemName1 + "' valor='" + parameterDefaultItemValue1 + "'/>";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId1 + "' rotulo='" + parameterItemName1 + "' valor='" + parameterItemValue1 + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDuplicateEnumerationParameters() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        int parameterDefaultItemId1 = 1;
        int parameterDefaultItemId2 = 2;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='grupo'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "'\n";
        xml = xml + "            rotulo='R\u00f3tulo do par\u00e2metro 1'\n";
        xml = xml + "            dica='Dica do par\u00e2metro 1'\n";
        xml = xml + "            padrao='" + parameterDefaultItemId1 + "'\n";
        xml = xml + ">\n";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId1 + "'\n";
        xml = xml + "                    rotulo='Nome 1'\n";
        xml = xml + "                    valor='Valor 1'/>\n";
        xml = xml + "</enumeracao>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "'\n";
        xml = xml + "            rotulo='R\u00f3tulo do par\u00e2metro 2'\n";
        xml = xml + "            dica='Dica do par\u00e2metro 2'\n";
        xml = xml + "            padrao='" + parameterDefaultItemId2 + "'\n";
        xml = xml + ">\n";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId2 + "'\n";
        xml = xml + "                    rotulo='Nome 2'\n";
        xml = xml + "                    valor='Valor 2'\n";
        xml = xml + "/>\n";
        xml = xml + "</enumeracao>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>\n";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameterWithNoName() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='grupo'>";
        xml = xml + "<enumeracao rotulo='rotulo' dica='dica' padrao='1'>";
        xml = xml + "<item_de_enumeracao id='1' rotulo='rotulo' valor='valor'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameterWithNoLabel() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='rotulo'>";
        xml = xml + "<enumeracao nome='nome' dica='dica' padrao='1'>";
        xml = xml + "<item_de_enumeracao id='1' rotulo='rotulo' valor='valor'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameterWithNoDescription() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='rotulo'>";
        xml = xml + "<enumeracao nome='nome' rotulo='rotulo' padrao='1'>";
        xml = xml + "<item_de_enumeracao id='1' rotulo='rotulo' valor='valor'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameterWithNoDefaultValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultItemId1 = "ID 11";
        String parameterDefaultItemName1 = "Nome do item padr\u00e3o 1.1";
        String parameterDefaultItemValue1 = "V1.1";
        EnumerationItem parameterDefaultValue1 = new EnumerationItem(parameterDefaultItemId1, parameterDefaultItemName1, parameterDefaultItemValue1, null);
        String parameterItemId1 = "ID 12";
        String parameterItemName1 = "Nome do item padr\u00e3o 1.2";
        String parameterItemValue1 = "V1.2";
        EnumerationItem parameterValue1 = new EnumerationItem(parameterItemId1, parameterItemName1, parameterItemValue1, null);
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(parameterDefaultValue1);
        items1.add(parameterValue1);
        boolean mustSortItems1 = true;
        EnumerationParameter parameter1 = new EnumerationParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, CMD_PATTERN, items1, mustSortItems1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId1 + "' rotulo='" + parameterDefaultItemName1 + "' valor='" + parameterDefaultItemValue1 + "'/>";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId1 + "' rotulo='" + parameterItemName1 + "' valor='" + parameterItemValue1 + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnumerationParameter7() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='rotulo'>";
        xml = xml + "<enumeracao nome='nome' rotulo='rotulo' dica='dica' padrao='2'>";
        xml = xml + "<item_de_enumeracao id='1' rotulo='rotulo' valor='valor'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameter9() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='rotulo'>";
        xml = xml + "<enumeracao nome='nome' rotulo='rotulo' dica='dica' padrao='1'>";
        xml = xml + "<item_de_enumeracao id='1' rotulo='rotulo 1' valor='valor 1'/>";
        xml = xml + "<item_de_enumeracao id='1' rotulo='rotulo 2' valor='valor 2'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameter10() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='rotulo'>";
        xml = xml + "<enumeracao nome='nome' rotulo='rotulo' dica='dica' padrao='1'>";
        xml = xml + "<item_de_enumeracao id='1' rotulo='rotulo' valor='valor 1'/>";
        xml = xml + "<item_de_enumeracao id='2' rotulo='rotulo' valor='valor 2'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameter11() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='rotulo'>";
        xml = xml + "<enumeracao nome='nome' rotulo='rotulo' dica='dica' padrao='1'>";
        xml = xml + "<item_de_enumeracao rotulo='rotulo 1' valor='valor 1'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameter13() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='rotulo'>";
        xml = xml + "<enumeracao nome='nome' rotulo='rotulo' dica='dica' padrao='1'>";
        xml = xml + "<item_de_enumeracao id='1' valor='valor 1'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameter14() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='rotulo'>";
        xml = xml + "<enumeracao nome='nome' rotulo='rotulo' dica='dica' padrao='1'>";
        xml = xml + "<item_de_enumeracao id='1' rotulo='rotulo 1'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameter15() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultItemId1 = "ID 11";
        String parameterDefaultItemName1 = "Nome do item padr\u00e3o 1.1";
        String parameterDefaultItemValue1 = "V1.1";
        String parameterItemId1 = "ID 12";
        String parameterItemName1 = "Nome do item padr\u00e3o 1.2";
        String parameterItemValue1 = "V1.2";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultItemId1 + "' desconhecido='valor'>";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId1 + "' rotulo='" + parameterDefaultItemName1 + "' valor='" + parameterDefaultItemValue1 + "'/>";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId1 + "' rotulo='" + parameterItemName1 + "' valor='" + parameterItemValue1 + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameter16() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultItemId = "ID 11";
        String parameterDefaultItemName = "Nome do item padr\u00e3o 1.1";
        String parameterDefaultItemValue = "V1.1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' padrao='" + parameterDefaultItemId + "'>";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId + "' rotulo='" + parameterDefaultItemName + "' valor='" + parameterDefaultItemValue + "' desconhecido='valor'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameter18() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultItemId = "ID 11";
        String parameterDefaultItemName = "Nome do item padr\u00e3o 1.1";
        String parameterDefaultItemValue = "V1.1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' padrao='" + parameterDefaultItemId + "'>";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId + "' rotulo='" + parameterDefaultItemName + "' valor='" + parameterDefaultItemValue + "'>\n";
        xml = xml + "<filho/>\n";
        xml = xml + "</item_de_enumeracao>\n";
        xml = xml + "</enumeracao>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>\n";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnumerationParameter19() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultItemId1 = "ID 11";
        String parameterDefaultItemName1 = "Nome do item padr\u00e3o 1.1";
        String parameterDefaultItemValue1 = "V1.1";
        EnumerationItem parameterDefaultValue1 = new EnumerationItem(parameterDefaultItemId1, parameterDefaultItemName1, parameterDefaultItemValue1, null);
        String parameterItemId1 = "ID 12";
        String parameterItemName1 = "Nome do item padr\u00e3o 1.2";
        String parameterItemValue1 = "V1.2";
        EnumerationItem parameterValue1 = new EnumerationItem(parameterItemId1, parameterItemName1, parameterItemValue1, null);
        String commandLinePattern1 = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(parameterDefaultValue1);
        items1.add(parameterValue1);
        boolean mustSortItems1 = true;
        EnumerationParameter parameter1 = new EnumerationParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, commandLinePattern1, items1, mustSortItems1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultItemId1 + "' selecao_multipla='nao'>\n";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId1 + "' rotulo='" + parameterDefaultItemName1 + "' valor='" + parameterDefaultItemValue1 + "'/>\n";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId1 + "' rotulo='" + parameterItemName1 + "' valor='" + parameterItemValue1 + "'/>\n";
        xml = xml + "<formato_no_comando>\n";
        xml = xml + commandLinePattern1;
        xml = xml + "</formato_no_comando>\n";
        xml = xml + "</enumeracao>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnumerationParameter20() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultItemId1 = "ID 11";
        String parameterDefaultItemName1 = "Nome do item padr\u00e3o 1.1";
        String parameterDefaultItemValue1 = "V1.1";
        EnumerationItem parameterDefaultValue1 = new EnumerationItem(parameterDefaultItemId1, parameterDefaultItemName1, parameterDefaultItemValue1, null);
        String parameterItemId1 = "ID 12";
        String parameterItemName1 = "Nome do item padr\u00e3o 1.2";
        String parameterItemValue1 = "V1.2";
        EnumerationItem parameterValue1 = new EnumerationItem(parameterItemId1, parameterItemName1, parameterItemValue1, null);
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(parameterDefaultValue1);
        items1.add(parameterValue1);
        boolean mustSortItems1 = true;
        EnumerationParameter parameter1 = new EnumerationParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, null, items1, mustSortItems1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultItemId1 + "' selecao_multipla='nao'>\n";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId1 + "' rotulo='" + parameterDefaultItemName1 + "' valor='" + parameterDefaultItemValue1 + "'/>\n";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId1 + "' rotulo='" + parameterItemName1 + "' valor='" + parameterItemValue1 + "'/>\n";
        xml = xml + "<formato_no_comando>\n";
        xml = xml + "</formato_no_comando>\n";
        xml = xml + "</enumeracao>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnumerationParameter21() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterItemId1 = "ID 11";
        String parameterItemName1 = "Nome do item padr\u00e3o 1.1";
        String parameterItemValue1 = "V1.1";
        EnumerationItem parameterValue1 = new EnumerationItem(parameterItemId1, parameterItemName1, parameterItemValue1, null);
        String parameterItemId2 = "ID 12";
        String parameterItemName2 = "Nome do item padr\u00e3o 1.2";
        String parameterItemValue2 = "V1.2";
        EnumerationItem parameterValue2 = new EnumerationItem(parameterItemId2, parameterItemName2, parameterItemValue2, null);
        String commandLinePattern1 = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(parameterValue1);
        items1.add(parameterValue2);
        EnumerationListParameter parameter1 = new EnumerationListParameter(parameterName1, parameterLabel1, parameterDescription1, null, false, true, commandLinePattern1);
        parameter1.setItems(items1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' selecao_multipla='sim'>\n";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId1 + "' rotulo='" + parameterItemName1 + "' valor='" + parameterItemValue1 + "'/>\n";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId2 + "' rotulo='" + parameterItemName2 + "' valor='" + parameterItemValue2 + "'/>\n";
        xml = xml + "<formato_no_comando>\n";
        xml = xml + commandLinePattern1;
        xml = xml + "</formato_no_comando>\n";
        xml = xml + "</enumeracao>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnumerationParameter22() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterItemId1 = "ID 11";
        String parameterItemName1 = "Nome do item padr\u00e3o 1.1";
        String parameterItemValue1 = "V1.1";
        EnumerationItem parameterValue1 = new EnumerationItem(parameterItemId1, parameterItemName1, parameterItemValue1, null);
        String parameterItemId2 = "ID 12";
        String parameterItemName2 = "Nome do item padr\u00e3o 1.2";
        String parameterItemValue2 = "V1.2";
        EnumerationItem parameterValue2 = new EnumerationItem(parameterItemId2, parameterItemName2, parameterItemValue2, null);
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(parameterValue1);
        items1.add(parameterValue2);
        EnumerationListParameter parameter1 = new EnumerationListParameter(parameterName1, parameterLabel1, parameterDescription1, null, false, true, null);
        parameter1.setItems(items1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' selecao_multipla='sim'>\n";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId1 + "' rotulo='" + parameterItemName1 + "' valor='" + parameterItemValue1 + "'/>\n";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId2 + "' rotulo='" + parameterItemName2 + "' valor='" + parameterItemValue2 + "'/>\n";
        xml = xml + "<formato_no_comando>\n";
        xml = xml + "</formato_no_comando>\n";
        xml = xml + "</enumeracao>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextListParameter1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        TextListParameter parameter1 = new TextListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean isOptional2 = false;
        TextListParameter parameter2 = new TextListParameter(parameterName2, parameterLabel2, parameterDescription2, null, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<lista_de_texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextListParameter2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextListParameter3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextListParameter4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextListParameter5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextListParameter6() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = true;
        TextListParameter parameter1 = new TextListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean isOptional2 = false;
        TextListParameter parameter2 = new TextListParameter(parameterName2, parameterLabel2, parameterDescription2, null, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "<lista_de_texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' opcional='" + isOptional2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextListParameter7() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='Valor n\u00e3o booleano'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextListParameter8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer maxCharacters1 = 10;
        boolean isOptional1 = false;
        TextListParameter parameter1 = new TextListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maxCharacters1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "' maximo_de_caracteres='" + maxCharacters1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextListParameter9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer maxCharacters1 = 0;
        boolean isOptional1 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "' maximo_de_caracteres='" + maxCharacters1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextListParameter10() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' " + "desconhecido='valor'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextListParameter12() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String commandLinePattern1 = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        boolean isOptional1 = false;
        TextListParameter parameter1 = new TextListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, commandLinePattern1, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>\n";
        xml = xml + commandLinePattern1;
        xml = xml + "</formato_no_comando>\n";
        xml = xml + "</lista_de_texto>\n";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextListParameter13() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        TextListParameter parameter1 = new TextListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, null, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>\n";
        xml = xml + "</formato_no_comando>\n";
        xml = xml + "</lista_de_texto>\n";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerListParameter1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerListParameter2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerListParameter3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerListParameter4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerListParameter5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerListParameter6() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Integer maximum1 = 1000;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerListParameter7() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='Valor n\u00e3o inteiro'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerListParameter8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Integer minimum1 = 1000;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerListParameter9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='Valor n\u00e3o inteiro'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerListParameter10() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer minimum1 = 1;
        Integer maximum1 = -1;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerListParameter11() throws ParseException {
        Integer minimum;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator("comando", null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        Integer maximum = minimum = Integer.valueOf(10);
        IntegerListParameter parameter = new IntegerListParameter("Nome do inteiro", "R\u00f3tulo do inteiro", "Descri\u00e7\u00e3o do inteiro", null, false, true, CMD_PATTERN, maximum, minimum);
        ParameterGroup group = new ParameterGroup("Grupo");
        group.addParameter((Parameter)parameter);
        version.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + version.getCommandBinaryName() + "'>\n";
        xml = xml + "<grupo rotulo='" + group.getName() + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameter.getName() + "' rotulo='" + parameter.getLabel() + "' dica='" + parameter.getDescription() + "' minimo='" + minimum + "' maximo='" + maximum + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testIntegerListParameter12() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = true;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerListParameter13() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerListParameter14() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='Valor n\u00e3o booleano'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerListParameter15() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' " + "desconhecido='valor'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerListParameter16() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String commandLinePattern1 = "Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO";
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, commandLinePattern1, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>";
        xml = xml + commandLinePattern1;
        xml = xml + "</formato_no_comando>";
        xml = xml + "</lista_de_inteiros>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerListParameter17() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, null, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>";
        xml = xml + "</formato_no_comando>";
        xml = xml + "</lista_de_inteiros>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean isOptional2 = false;
        Double maximum2 = null;
        boolean includeMaximum2 = true;
        Double minimum2 = null;
        boolean includeMinimum2 = true;
        DoubleListParameter parameter2 = new DoubleListParameter(parameterName2, parameterLabel2, parameterDescription2, null, isOptional2, true, CMD_PATTERN, maximum2, includeMaximum2, minimum2, includeMinimum2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleListParameter3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_reais rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleListParameter4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleListParameter5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleListParameter6() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = 10.0;
        boolean includeMinimum1 = true;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter7() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='Valor n\u00e3o real'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleListParameter8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Double maximum1 = 1000.0;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='Valor n\u00e3o real'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleListParameter10() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double minimum1 = 1.0;
        Double maximum1 = -1.0;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' maximo='" + maximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleListParameter11() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Double maximum1 = 1000.0;
        boolean includeMaximum1 = false;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "' incluir_maximo='" + includeMaximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter12() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Double maximum1 = 1000.0;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "' incluir_maximo='" + includeMaximum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter13() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = 1000.0;
        boolean includeMinimum1 = false;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' incluir_minimo='" + includeMinimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter14() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double maximum1 = 1000.0;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' maximo='" + maximum1 + "' incluir_maximo='Valor n\u00e3o booleano'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleListParameter15() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Double minimum1 = 1000.0;
        boolean includeMaximum1 = true;
        Double maximum1 = null;
        boolean includeMinimum1 = true;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' incluir_minimo='" + includeMinimum1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter16() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double minimum1 = 1000.0;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' minimo='" + minimum1 + "' incluir_minimo='Valor n\u00e3o booleano'/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleListParameter17() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = true;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean isOptional2 = false;
        Double maximum2 = null;
        boolean includeMaximum2 = true;
        Double minimum2 = null;
        boolean includeMinimum2 = true;
        DoubleListParameter parameter2 = new DoubleListParameter(parameterName2, parameterLabel2, parameterDescription2, null, isOptional2, true, CMD_PATTERN, maximum2, includeMaximum2, minimum2, includeMinimum2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' opcional='" + isOptional1 + "'/>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' opcional='" + isOptional2 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter19() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, "Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO", maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando>Nome:$NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO</formato_no_comando>\n";
        xml = xml + "</lista_de_reais>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleListParameter22() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleListParameter parameter1 = new DoubleListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, null, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<lista_de_reais nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'>\n";
        xml = xml + "<formato_no_comando/>\n";
        xml = xml + "</lista_de_reais>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn2() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String defaultValue1 = "Valor-padr\u00e3o 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, defaultValue1, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "' padrao='" + defaultValue1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn5() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = true;
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, isOptional1, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "' opcional='" + isOptional1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn6() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = false;
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, isOptional1, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "' opcional='" + isOptional1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn7() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "' opcional='Valor n\u00e3o-booleano'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Integer maxCharacters1 = 5000;
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, maxCharacters1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "' maximo_de_caracteres='" + maxCharacters1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName = "Nome da coluna";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName + "' maximo_de_caracteres='Valor n\u00e3o-inteiro'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn10() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName = "Nome da coluna";
        int maxCharacters = 0;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName + "' maximo_de_caracteres='" + maxCharacters + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn11() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "' desconhecido='valor'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn12() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'>\n";
        xml = xml + "<filho/>\n";
        xml = xml + "</coluna_de_texto>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn13() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "' editavel='sim'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "' editavel='sim'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn14() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, false, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, false, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "' editavel='nao'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "' editavel='nao'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn15() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnId1 = "Id da coluna 1";
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnId1, columnName1, null, false, true, null);
        String columnId2 = "Id da coluna 2";
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnId2, columnName2, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto id='" + columnId1 + "' rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto id='" + columnId2 + "' rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn16() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String columnId = "Nome da coluna 1";
        String columnLabel = "R\u00f3tulo da coluna1";
        TextColumn column = new TextColumn(columnId, columnLabel, null, false, true, null);
        Integer rowIndex = 1;
        String cellValue = "Valor 1";
        column.addDefaultValue(rowIndex.intValue(), (Object)cellValue);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, isOptional, true, CMD_PATTERN, Arrays.asList(column), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + isOptional + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnLabel + "' id='" + columnId + "'/>\n";
        xml = xml + "<celula indice_da_linha='" + rowIndex + "' id_da_coluna='" + columnId + "' valor='" + cellValue + "'/>";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTextColumn17() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String columnId = "Nome da coluna 1";
        String columnLabel = "R\u00f3tulo da coluna1";
        String cellValue = "Valor 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + isOptional + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnLabel + "' id='" + columnId + "'/>\n";
        xml = xml + "<celula id_da_coluna='" + columnId + "'>";
        xml = xml + cellValue;
        xml = xml + "</celula>";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn18() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String columnId = "Nome da coluna 1";
        String columnLabel = "R\u00f3tulo da coluna1";
        String cellValue = "Valor 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + isOptional + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnLabel + "' id='" + columnId + "'/>\n";
        xml = xml + "<celula indice_da_linha='-1' id_da_coluna='" + columnId + "'>";
        xml = xml + cellValue;
        xml = xml + "</celula>";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn19() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String columnId = "Nome da coluna 1";
        String columnLabel = "R\u00f3tulo da coluna1";
        String cellValue = "Valor 1";
        Integer rowIndex = 0;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + isOptional + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnLabel + "' id='" + columnId + "'/>\n";
        xml = xml + "<celula indice_da_linha='" + rowIndex + "'>";
        xml = xml + cellValue;
        xml = xml + "</celula>";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn20() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String columnId = "Nome da coluna 1";
        String columnLabel = "R\u00f3tulo da coluna1";
        String cellValue = "Valor 1";
        Integer rowIndex = 0;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + isOptional + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnLabel + "' id='" + columnId + "'/>\n";
        xml = xml + "<celula indice_da_linha='" + rowIndex + "' id_da_coluna='outro_id'>";
        xml = xml + cellValue;
        xml = xml + "</celula>";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTextColumn21() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String columnId = "Nome da coluna 1";
        String columnLabel = "R\u00f3tulo da coluna1";
        TextColumn column = new TextColumn(columnId, columnLabel, null, false, true, null);
        Integer rowIndex = 1;
        Object cellValue = null;
        column.addDefaultValue(rowIndex.intValue(), cellValue);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, isOptional, true, CMD_PATTERN, Arrays.asList(column), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + isOptional + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnLabel + "' id='" + columnId + "'/>\n";
        xml = xml + "<celula indice_da_linha='" + rowIndex + "' id_da_coluna='" + columnId + "'/>";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testBooleanColumn1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        BooleanColumn column1 = new BooleanColumn(columnName1, columnName1, false, true, null, null);
        String columnName2 = "Nome da coluna 2";
        BooleanColumn column2 = new BooleanColumn(columnName2, columnName2, false, true, null, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testBooleanColumn2() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isEditable = true;
        String columnName1 = "Nome da coluna 1";
        BooleanColumn column1 = new BooleanColumn(columnName1, columnName1, false, isEditable, null, null);
        String columnName2 = "Nome da coluna 2";
        BooleanColumn column2 = new BooleanColumn(columnName2, columnName2, false, isEditable, null, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "' editavel='" + isEditable + "'/>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName2 + "' editavel='" + isEditable + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testBooleanColumn3() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isEditable = false;
        BooleanColumn column1 = new BooleanColumn(columnName1, columnName1, false, isEditable, null, null);
        String columnName2 = "Nome da coluna 2";
        BooleanColumn column2 = new BooleanColumn(columnName2, columnName2, false, isEditable, null, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "' editavel='" + isEditable + "'/>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName2 + "' editavel='" + isEditable + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testBooleanColumn4() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String falseCommand1 = "Comando Falso 1";
        String trueCommand1 = "Comando Verdadeiro 1";
        BooleanColumn column1 = new BooleanColumn(columnName1, columnName1, false, true, falseCommand1, trueCommand1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "' verdadeiro='" + trueCommand1 + "' falso='" + falseCommand1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testBooleanColumn5() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean defaultValue1 = false;
        BooleanColumn column1 = new BooleanColumn(columnName1, columnName1, defaultValue1, true, null, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "' padrao='" + defaultValue1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testBooleanColumn6() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean defaultValue1 = true;
        BooleanColumn column1 = new BooleanColumn(columnName1, columnName1, defaultValue1, true, null, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "' padrao='" + defaultValue1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testBooleanColumn7() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanColumn8() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanColumn9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "' " + "desconhecido='valor'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanColumn10() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos rotulo='" + columnName1 + "'>\n";
        xml = xml + "<filho/>";
        xml = xml + "</coluna_de_booleanos>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testBooleanColumn11() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnId1 = "Id da coluna 1";
        String columnName1 = "Nome da coluna 1";
        BooleanColumn column1 = new BooleanColumn(columnId1, columnName1, false, true, null, null);
        String columnId2 = "Id da coluna 2";
        String columnName2 = "Nome da coluna 2";
        BooleanColumn column2 = new BooleanColumn(columnId2, columnName2, false, true, null, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_booleanos id='" + columnId1 + "' rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_booleanos id='" + columnId2 + "' rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerColumn1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Integer defaultValue1 = null;
        boolean isEditable1 = true;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerColumn column1 = new IntegerColumn(columnName1, columnName1, defaultValue1, isOptional1, isEditable1, maximum1, minimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerColumn2() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Integer defaultValue1 = 1234;
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerColumn column1 = new IntegerColumn(columnName1, columnName1, defaultValue1, isOptional1, isEditable1, maximum1, minimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' padrao='" + defaultValue1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerColumn3() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Integer defaultValue1 = null;
        boolean isEditable1 = true;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerColumn column1 = new IntegerColumn(columnName1, columnName1, defaultValue1, isOptional1, isEditable1, maximum1, minimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' editavel='" + isEditable1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerColumn4() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Integer defaultValue1 = null;
        boolean isEditable1 = false;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerColumn column1 = new IntegerColumn(columnName1, columnName1, defaultValue1, isOptional1, isEditable1, maximum1, minimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' editavel='" + isEditable1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerColumn5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn6() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn7() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Integer defaultValue1 = null;
        boolean isOptional1 = true;
        boolean isEditable1 = true;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerColumn column1 = new IntegerColumn(columnName1, columnName1, defaultValue1, isOptional1, isEditable1, maximum1, minimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' opcional='" + isOptional1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerColumn8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Integer defaultValue1 = null;
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerColumn column1 = new IntegerColumn(columnName1, columnName1, defaultValue1, isOptional1, isEditable1, maximum1, minimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' opcional='" + isOptional1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerColumn9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' opcional='Valor n\u00e3o-booleano'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn10() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Integer defaultValue1 = null;
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Integer maximum1 = -10;
        Integer minimum1 = null;
        IntegerColumn column1 = new IntegerColumn(columnName1, columnName1, defaultValue1, isOptional1, isEditable1, maximum1, minimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' maximo='" + maximum1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerColumn11() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' maximo='Valor n\u00e3o-inteiro'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn12() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Integer defaultValue1 = null;
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Integer maximum1 = null;
        Integer minimum1 = -10;
        IntegerColumn column1 = new IntegerColumn(columnName1, columnName1, defaultValue1, isOptional1, isEditable1, maximum1, minimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' minimo='" + minimum1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testIntegerColumn13() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' minimo='Valor n\u00e3o-inteiro'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn14() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer maximum = -1;
        Integer minimum = 1;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "' minimo='" + minimum + "' maximo='" + maximum + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn15() throws ParseException {
        Integer minimum;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator("comando", null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        Integer maximum = minimum = Integer.valueOf(10);
        IntegerColumn column = new IntegerColumn("Nome da coluna", "Nome da coluna", null, false, true, maximum, minimum);
        TableParameter parameter = new TableParameter("Nome da tabela", "R\u00f3tulo da tabela", "Descri\u00e7\u00e3o da tabela", false, true, CMD_PATTERN, Arrays.asList(column), false, false, null, null, null, null);
        ParameterGroup group = new ParameterGroup("grupo");
        group.addParameter((Parameter)parameter);
        version.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + version.getCommandBinaryName() + "'>";
        xml = xml + "<grupo rotulo='" + group.getName() + "'>";
        xml = xml + "<tabela nome='" + parameter.getName() + "' rotulo='" + parameter.getLabel() + "' dica='" + parameter.getDescription() + "'>";
        xml = xml + "<coluna_de_inteiros rotulo='" + column.getLabel() + "' minimo='" + minimum + "' maximo='" + maximum + "'/>";
        xml = xml + "</tabela>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testIntegerColumn16() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = -2;
        Integer maximum = 1;
        Integer minimum = -1;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName + "' minimo='" + minimum + "' maximo='" + maximum + "' padrao='" + defaultValue + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn17() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        Integer defaultValue = 2;
        Integer maximum = 1;
        Integer minimum = -1;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName + "' minimo='" + minimum + "' maximo='" + maximum + "' padrao='" + defaultValue + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn18() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "'" + " desconhecido='valor'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn19() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros rotulo='" + columnName1 + "'>\n";
        xml = xml + "<filho/>\n";
        xml = xml + "</coluna_de_inteiros>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testIntegerColumn20() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnId1 = "Identificador da coluna 1";
        String columnName1 = "Nome da coluna 1";
        Integer defaultValue1 = null;
        boolean isEditable1 = true;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerColumn column1 = new IntegerColumn(columnId1, columnName1, defaultValue1, isOptional1, isEditable1, maximum1, minimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_inteiros id='" + columnId1 + "' rotulo='" + columnName1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, false, true, null, true, null, true);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn2() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        Double defaultValue1 = 1234.56789;
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, defaultValue1, false, true, null, true, null, true);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' padrao='" + defaultValue1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleColumn4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleColumn5() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = true;
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, isOptional1, true, null, true, null, true);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' opcional='" + isOptional1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn6() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = false;
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, isOptional1, true, null, true, null, true);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' opcional='" + isOptional1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn7() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' opcional='Valor n\u00e3o-booleano'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleColumn8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Double maximum1 = -10.5;
        Double minimum1 = null;
        boolean includeMaximum1 = true;
        boolean includeMinimum1 = true;
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, isOptional1, isEditable1, maximum1, includeMaximum1, minimum1, includeMinimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' maximo='" + maximum1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' maximo='Valor n\u00e3o-real'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleColumn10() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Double maximum1 = null;
        Double minimum1 = -10.5;
        boolean includeMaximum1 = true;
        boolean includeMinimum1 = true;
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, isOptional1, isEditable1, maximum1, includeMaximum1, minimum1, includeMinimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' minimo='" + minimum1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn11() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' minimo='Valor n\u00e3o-real'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleColumn12() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        Double maximum = -1.1;
        Double minimum = 1.1;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' minimo='" + minimum + "' maximo='" + maximum + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleColumn13() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Double maximum1 = 123.456;
        boolean includeMaximum1 = false;
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, isOptional1, isEditable1, maximum1, includeMaximum1, null, true);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' maximo='" + maximum1 + "' incluir_maximo='" + includeMaximum1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn14() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Double maximum1 = 123.456;
        boolean includeMaximum1 = true;
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, isOptional1, isEditable1, maximum1, includeMaximum1, null, true);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' maximo='" + maximum1 + "' incluir_maximo='" + includeMaximum1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn15() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Double minimum1 = 123.456;
        boolean includeMinimum1 = true;
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, isOptional1, isEditable1, null, false, minimum1, includeMinimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' minimo='" + minimum1 + "' incluir_minimo='" + includeMinimum1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn16() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        boolean isOptional1 = false;
        boolean isEditable1 = true;
        Double minimum1 = 123.456;
        boolean includeMinimum1 = false;
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, isOptional1, isEditable1, null, false, minimum1, includeMinimum1);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' minimo='" + minimum1 + "' incluir_minimo='" + includeMinimum1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn17() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' " + "desconhecido='valor'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleColumn18() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "'>\n";
        xml = xml + "<filho/>\n";
        xml = xml + "</coluna_de_reais>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDoubleColumn19() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isEditable1 = true;
        String columnName1 = "Nome da coluna 1";
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, false, isEditable1, null, true, null, true);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' editavel='" + isEditable1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn20() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isEditable1 = false;
        String columnName1 = "Nome da coluna 1";
        DoubleColumn column1 = new DoubleColumn(columnName1, columnName1, null, false, isEditable1, null, true, null, true);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais rotulo='" + columnName1 + "' editavel='" + isEditable1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDoubleColumn21() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnId1 = "Identificador da Coluna 1";
        String columnName1 = "Nome da coluna 1";
        DoubleColumn column1 = new DoubleColumn(columnId1, columnName1, null, false, true, null, true, null, true);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_reais id='" + columnId1 + "' rotulo='" + columnName1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTableParameter1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, isOptional, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + isOptional + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTableParameter2() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, isOptional, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + isOptional + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTableParameter3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String columnName2 = "Nome da coluna 2";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='Valor n\u00e3o booleano'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTableParameter4() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean delimitTable = false;
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), delimitTable, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' delimitar_tabela='" + delimitTable + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTableParameter5() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean delimitTable = true;
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), delimitTable, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' delimitar_tabela='" + delimitTable + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTableParameter6() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String columnName2 = "Nome da coluna 2";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' delimitar_tabela='Valor n\u00e3o booleano'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTableParameter7() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean delimitRows = false;
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, delimitRows, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' delimitar_linhas='" + delimitRows + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTableParameter8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean delimitRows = true;
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, Arrays.asList(column1, column2), false, delimitRows, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' delimitar_linhas='" + delimitRows + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTableParameter9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String columnName2 = "Nome da coluna 2";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' delimitar_linhas='Valor n\u00e3o booleano'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTableParameter10() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String columnName2 = "Nome da coluna 2";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTableParameter11() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String columnName2 = "Nome da coluna 2";
        String parameterName = "Nome do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTableParameter12() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String columnName1 = "Nome da coluna 1";
        String columnName2 = "Nome da coluna 2";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTableParameter13() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTableParameter14() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String columnName1 = "Nome da coluna 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' desconhecido='valor'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testTableParameter15() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String columnName2 = "Nome da coluna 2";
        TextColumn column2 = new TextColumn(columnName2, columnName2, null, false, true, null);
        int rowCount = 10;
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, isOptional, true, CMD_PATTERN, Arrays.asList(column1, column2), false, false, Integer.valueOf(rowCount), null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + isOptional + "' quantidade_de_linhas='" + rowCount + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName2 + "'/>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTableParameter16() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        String commandLinePattern = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, isOptional, true, commandLinePattern, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<formato_no_comando>\n";
        xml = xml + commandLinePattern;
        xml = xml + "</formato_no_comando>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testTableParameter17() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String columnName1 = "Nome da coluna 1";
        TextColumn column1 = new TextColumn(columnName1, columnName1, null, false, true, null);
        TableParameter parameter = new TableParameter(parameterName, parameterLabel, parameterDescription, isOptional, true, null, Arrays.asList(column1), false, false, null, null, null, null);
        group.addParameter((Parameter)parameter);
        expectedVersion.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<tabela nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<coluna_de_texto rotulo='" + columnName1 + "'/>\n";
        xml = xml + "<formato_no_comando>\n";
        xml = xml + "</formato_no_comando>\n";
        xml = xml + "</tabela>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testOutputURLListParameterAsMandatoryParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean parameterOptional = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter urlParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterAsOptionalParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean parameterOptional = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter urlParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithFileCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter urlParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' categoria='arquivo' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter urlParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.DIRECTORY, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' categoria='diretorio' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithFileAndDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='ambos'  selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLListParameterWithNoName() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLListParameterWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLListParameterWithNoDescription() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLListParameterWithInvalidCategory() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='erro' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLListParameterWithUnknownAttributes() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' " + "desconhecido='valor'  selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLListParameterWithCommandPatternShowingNameAndValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String commandLinePattern = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        OutputURLListParameter urlParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, commandLinePattern, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' selecao_multipla='sim'>\n";
        xml = xml + "<formato_no_comando>" + commandLinePattern + "</formato_no_comando>";
        xml = xml + "</url_de_saida>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithCustomCommandPatternWithNoNameOrValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter inputFileParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' selecao_multipla='sim'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</url_de_saida>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithProjectProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean mustExist = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter inputFileParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, mustExist, EnumSet.of(URLProtocol.PROJECT));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithLocalProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean mustExist = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter inputFileParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, mustExist, EnumSet.of(URLProtocol.LOCAL));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.LOCAL.getType() + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithSGAProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean mustExist = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter inputFileParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, mustExist, EnumSet.of(URLProtocol.SGA));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.SGA.getType() + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithMultipleProtocols() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean mustExist = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter inputFileParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, mustExist, EnumSet.of(URLProtocol.PROJECT, URLProtocol.LOCAL));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "," + URLProtocol.LOCAL.getType() + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithInvalidProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' protocolos='" + "PROTOCOLO_DESCONHECIDO" + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLListParameterWithOneInvalidProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "," + "PROTOCOLO_DESCONHECIDO" + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLListParameterWithMandatoryAttributes() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLListParameter urlParameter = new OutputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLListParameterWithSameParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLListParameterWithMandatoryAttributes() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter urlParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithSameParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLListParameterAsMandatoryParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean parameterOptional = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter urlParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterAsOptionalParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean parameterOptional = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter urlParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithFileCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter urlParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' categoria='arquivo' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter urlParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.DIRECTORY, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' categoria='diretorio' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithFileAndDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='ambos'  selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLListParameterWithNoName() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLListParameterWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' dica='" + parameterDescription + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLListParameterWithNoDescription() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLListParameterWithInvalidCategory() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='erro'  selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLListParameterWithUnknownAttributes() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' " + "desconhecido='valor'  selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLListParameterWithCommandPatternShowingNameAndValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String commandLinePattern = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        InputURLListParameter urlParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, commandLinePattern, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' selecao_multipla='sim'>\n";
        xml = xml + "<formato_no_comando>" + commandLinePattern + "</formato_no_comando>";
        xml = xml + "</url_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithCustomCommandPatternWithNoNameOrValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter inputFileParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, localization, null, FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' selecao_multipla='sim'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</url_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithProjectProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean mustExist = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter inputFileParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, mustExist, EnumSet.of(URLProtocol.PROJECT));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithLocalProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean mustExist = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter inputFileParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, mustExist, EnumSet.of(URLProtocol.LOCAL));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.LOCAL.getType() + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithSGAProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean mustExist = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter inputFileParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, mustExist, EnumSet.of(URLProtocol.SGA));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.SGA.getType() + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithMultipleProtocols() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean mustExist = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLListParameter inputFileParameter = new InputURLListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, mustExist, EnumSet.of(URLProtocol.PROJECT, URLProtocol.LOCAL));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "," + URLProtocol.LOCAL.getType() + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLListParameterWithInvalidProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' protocolos='" + "PROTOCOLO_DESCONHECIDO" + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLListParameterWithOneInvalidProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "," + "PROTOCOLO_DESCONHECIDO" + "' selecao_multipla='sim'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLParameterAsMandatoryParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean parameterOptional = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter urlParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterAsOptionalParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean parameterOptional = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter urlParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithFileCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter urlParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' categoria='arquivo'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter urlParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.DIRECTORY, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' categoria='diretorio'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithFileAndDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='ambos'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLParameterWithNoName() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLParameterWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLParameterWithNoDescription() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLParameterWithInvalidCategory() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='erro'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLParameterWithUnknownAttributes() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' " + "desconhecido='valor'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLParameterWithCommandPatternShowingNameAndValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String commandLinePattern = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        OutputURLParameter urlParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, commandLinePattern, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<formato_no_comando>" + commandLinePattern + "</formato_no_comando>";
        xml = xml + "</url_de_saida>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithCustomCommandPatternWithNoNameOrValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter inputFileParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</url_de_saida>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithProjectProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter inputFileParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.of(URLProtocol.PROJECT));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithLocalProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter inputFileParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.of(URLProtocol.LOCAL));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.LOCAL.getType() + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithSGAProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter inputFileParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.of(URLProtocol.SGA));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.SGA.getType() + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithMultipleProtocols() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter inputFileParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.of(URLProtocol.PROJECT, URLProtocol.LOCAL));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "," + URLProtocol.LOCAL.getType() + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithInvalidProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' protocolos='" + "PROTOCOLO_DESCONHECIDO" + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLParameterWithOneInvalidProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "," + "PROTOCOLO_DESCONHECIDO" + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputURLParameterWithMandatoryAttributes() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputURLParameter urlParameter = new OutputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputURLParameterWithSameParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "<url_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLParameterWithMandatoryAttributes() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter urlParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithSameParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLParameterAsMandatoryParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean parameterOptional = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter urlParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterAsOptionalParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean parameterOptional = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter urlParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithFileCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter urlParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' categoria='arquivo'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter urlParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.DIRECTORY, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' categoria='diretorio'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithFileAndDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='ambos'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLParameterWithNoName() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLParameterWithNoLabel() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLParameterWithNoDescription() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLParameterWithInvalidCategory() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='erro'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLParameterWithUnknownAttributes() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' " + "desconhecido='valor'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLParameterWithCommandPatternShowingNameAndValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String commandLinePattern = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        InputURLParameter urlParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, commandLinePattern, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)urlParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<formato_no_comando>" + commandLinePattern + "</formato_no_comando>";
        xml = xml + "</url_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithCustomCommandPatternWithNoNameOrValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter inputFileParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</url_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithProjectProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter inputFileParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.of(URLProtocol.PROJECT));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithLocalProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter inputFileParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.of(URLProtocol.LOCAL));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.LOCAL.getType() + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithSGAProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter inputFileParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.of(URLProtocol.SGA));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.SGA.getType() + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithMultipleProtocols() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputURLParameter inputFileParameter = new InputURLParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, localization, null, FileParameterMode.REGULAR_FILE, EnumSet.of(URLProtocol.PROJECT, URLProtocol.LOCAL));
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' localizacao='" + localization + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "," + URLProtocol.LOCAL.getType() + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputURLParameterWithInvalidProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' protocolos='" + "PROTOCOLO_DESCONHECIDO" + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputURLParameterWithOneInvalidProtocol() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<url_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' protocolos='" + URLProtocol.PROJECT.getType() + "," + "PROTOCOLO_DESCONHECIDO" + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputFileParameter1() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputFileParameter3() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterOptional = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter4() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterOptional = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter7() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='arquivo'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter8() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.DIRECTORY, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='diretorio'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter9() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='ambos'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter10() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputFileParameter11() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputFileParameter12() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputFileParameter13() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='erro'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputFileParameter14() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' permitir_pipe='true'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter15() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.FALSE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' permitir_pipe='false'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter17() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.ALWAYS, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' permitir_pipe='always'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter16() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' " + "desconhecido='valor'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputFileParameter18() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String commandLinePattern = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, commandLinePattern, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<formato_no_comando>" + commandLinePattern + "</formato_no_comando>";
        xml = xml + "</arquivo_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter19() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</arquivo_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileParameter20() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean usesFilter = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, usesFilter);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' usar_filtro='" + String.valueOf(true) + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</arquivo_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileRegularSingleWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</arquivo_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputFileListRegularWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " selecao_multipla='sim'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</arquivo_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testInputFileDirectorySingleWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        FileParameterValue rootDirAsDefault = new FileParameterValue(".");
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, rootDirAsDefault, false, true, null, null, FileParameterMode.DIRECTORY, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " categoria='diretorio'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</arquivo_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListDirectoryWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        ArrayList<FileParameterValue> rootDirAsDefault = new ArrayList<FileParameterValue>();
        rootDirAsDefault.add(new FileParameterValue("."));
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, rootDirAsDefault, false, true, null, null, FileParameterMode.DIRECTORY, true, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " categoria='diretorio'" + " selecao_multipla='sim'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</arquivo_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileRegularOrDirectorySingleWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        FileParameterValue rootDirAsDefault = new FileParameterValue(".");
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileParameter inputFileParameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, rootDirAsDefault, false, true, null, null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        group.addParameter((Parameter)inputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " categoria='ambos'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</arquivo_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListRegularOrDirectoryWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        ArrayList<FileParameterValue> rootDirAsDefault = new ArrayList<FileParameterValue>();
        rootDirAsDefault.add(new FileParameterValue("."));
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, rootDirAsDefault, false, true, null, null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " categoria='ambos'" + " selecao_multipla='sim'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</arquivo_de_entrada>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithDefaultValues() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter outputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false, false);
        group.addParameter((Parameter)outputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithMandatoryValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterOptional = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter inputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithOptionalValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterOptional = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter inputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithRegularFileCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter inputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='arquivo'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter outputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.DIRECTORY, true, false, false);
        group.addParameter((Parameter)outputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='diretorio'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithBothCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='ambos'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileListParameterWithSorting() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterMustSort = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter inputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, parameterMustSort, false, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' ordenar='" + parameterMustSort + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithNoSorting() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterMustSort = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter inputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, parameterMustSort, false, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' ordenar='" + parameterMustSort + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithFiltering() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean usesFilter = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter inputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, usesFilter, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' usar_filtro='" + String.valueOf(true) + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithNoFiltering() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean usesFilter = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter inputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, usesFilter, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' usar_filtro='" + String.valueOf(false) + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithoutForcedExtension() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterMustForceExtension = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter inputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false, parameterMustForceExtension);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' forcar_extensao='" + parameterMustForceExtension + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListParameterWithForcedExtension() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterMustForceExtension = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileListParameter inputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false, parameterMustForceExtension);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' forcar_extensao='" + parameterMustForceExtension + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithDefaultValues() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithMandatoryValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterOptional = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithOptionalValue() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterOptional = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, parameterOptional, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithRegularFileCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='arquivo'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithDirectoryCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.DIRECTORY, true, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='diretorio'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithBothCategory() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.DIRECTORY_AND_REGULAR_FILE, true, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='ambos'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithSorting() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterMustSort = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, parameterMustSort, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' ordenar='" + parameterMustSort + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithNoSorting() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterMustSort = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, parameterMustSort, false);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' ordenar='" + parameterMustSort + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithFiltering() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean usesFilter = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, usesFilter);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' usar_filtro='" + String.valueOf(true) + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testInputFileListParameterWithNoFiltering() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean usesFilter = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        InputFileListParameter inputFileListParameter = new InputFileListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, true, usesFilter);
        group.addParameter((Parameter)inputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_entrada selecao_multipla='sim' nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' usar_filtro='" + String.valueOf(false) + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter1() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileParameter3() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterOptional = false;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("isOptional", parameterOptional));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter4() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean parameterOptional = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("isOptional", parameterOptional));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' opcional='" + parameterOptional + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter5() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        FileParameterMode parameterMode = FileParameterMode.REGULAR_FILE;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("mode", parameterMode));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='arquivo'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter6() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        FileParameterMode parameterMode = FileParameterMode.DIRECTORY;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("mode", parameterMode));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='diretorio'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter7() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileParameter8() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' dica='" + parameterDescription + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileParameter9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String category = "ambos";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='" + category + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileParameter10() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileParameter11() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' categoria='erro'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileParameter12() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        FileParameterPipeAcceptance parameterCanUsePipe = FileParameterPipeAcceptance.TRUE;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("canUsePipe", parameterCanUsePipe));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' permitir_pipe='" + parameterCanUsePipe + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter13() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        FileParameterPipeAcceptance parameterCanUsePipe = FileParameterPipeAcceptance.FALSE;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("canUsePipe", parameterCanUsePipe));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' permitir_pipe='" + parameterCanUsePipe + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter14() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' " + "desconhecido='valor'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileParameter18() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String parameterCommandLinePattern = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("commandLinePattern", parameterCommandLinePattern));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<formato_no_comando>" + parameterCommandLinePattern + "</formato_no_comando>";
        xml = xml + "</arquivo_de_saida>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter19() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("commandLinePattern", null));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>";
        xml = xml + "</arquivo_de_saida>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileParameter20() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean usesFilter = true;
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("usar_filtro", usesFilter));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "' usar_filtro='" + String.valueOf(true) + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileRegularSingleWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileListRegularWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " selecao_multipla='sim'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOutputFileDirectorySingleWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameterFactory.create(new Pair("name", parameterName), new Pair("label", parameterLabel), new Pair("description", parameterDescription), new Pair("mode", FileParameterMode.DIRECTORY), new Pair("usar_diretorio_raiz_como_padrao", true));
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " categoria='diretorio'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputFileListDirectoryWithRootAsDefault() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        ArrayList<FileParameterValue> rootDirAsDefault = new ArrayList<FileParameterValue>();
        rootDirAsDefault.add(new FileParameterValue("."));
        OutputFileListParameter outputFileListParameter = new OutputFileListParameter(parameterName, parameterLabel, parameterDescription, rootDirAsDefault, false, true, CMD_PATTERN, null, FileParameterMode.DIRECTORY, true, false, false);
        group.addParameter((Parameter)outputFileListParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'" + " categoria='diretorio'" + " selecao_multipla='sim'" + " usar_diretorio_raiz_como_padrao='" + String.valueOf(true) + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testExpression1() throws ParseException, FormulaCreationException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "P1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = false;
        String trueCommand1 = "1";
        String falseCommand1 = "0";
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, CMD_PATTERN, falseCommand1, trueCommand1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "P2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String trueCommand2 = "1";
        String falseCommand2 = "0";
        boolean parameterDefaultValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, true, CMD_PATTERN, falseCommand2, trueCommand2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String errorMessage1 = "Mensagem de erro 1";
        String expressionText1 = "P1 && P2";
        String errorMessage2 = "Mensagem de erro 2";
        String expressionText2 = "P1 || P2";
        ValidationExpression expression1 = new ValidationExpression(expectedVersion, expressionText1, errorMessage1);
        ValidationExpression expression2 = new ValidationExpression(expectedVersion, expressionText2, errorMessage2);
        expectedVersion.addExpression(expression1);
        expectedVersion.addExpression(expression2);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<expressao erro='" + errorMessage1 + "'>";
        xml = xml + "<![CDATA[" + expressionText1 + "]]>";
        xml = xml + "</expressao>";
        xml = xml + "<expressao erro='" + errorMessage2 + "'>";
        xml = xml + "<![CDATA[" + expressionText2 + "]]>";
        xml = xml + "</expressao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testExpression2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "P1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "P2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String errorMessage1 = "Mensagem de erro 1";
        String expressionText1 = "P1 && P2";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<expressao erro='" + errorMessage1 + "'>";
        xml = xml + "<![CDATA[" + expressionText1 + "]]>";
        xml = xml + "</expressao>";
        xml = xml + "<expressao erro='" + errorMessage1 + "'>";
        xml = xml + "<![CDATA[" + expressionText1 + "]]>";
        xml = xml + "</expressao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testExpression3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "P1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "P2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String expressionText1 = "P1 && P2";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<expressao>";
        xml = xml + "<![CDATA[" + expressionText1 + "]]>";
        xml = xml + "</expressao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testExpression4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "P1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "P2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String errorMessage1 = "Mensagem de erro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<expressao erro='" + errorMessage1 + "'>";
        xml = xml + "</expressao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testExpression5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "P1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "P2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String errorMessage1 = "Mensagem de erro 1";
        String expressionText1 = "P1 && P2";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<expressao erro='" + errorMessage1 + "' desconhecido='valor'>";
        xml = xml + "<![CDATA[" + expressionText1 + "]]>";
        xml = xml + "</expressao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testExpression6() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "P1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "P2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String errorMessage1 = "Mensagem de erro 1";
        String expressionText1 = "P1 && P2";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<expressao erro='" + errorMessage1 + "'>";
        xml = xml + "<![CDATA[" + expressionText1 + "]]>";
        xml = xml + "<filho/>";
        xml = xml + "</expressao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger2() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), null);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger3() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = true;
        String trueCommand1 = "1";
        String falseCommand1 = "0";
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, CMD_PATTERN, falseCommand1, trueCommand1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterDefaultValue2 = true;
        String trueCommand2 = "1";
        String falseCommand2 = "0";
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, true, CMD_PATTERN, falseCommand2, trueCommand2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        Boolean value = Boolean.TRUE;
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = true;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterDefaultValue2 = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterDefaultValue1 = true;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterDefaultValue2 = true;
        String xml = "";
        String conditionValue = "Valor de tipo errado.";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + conditionValue + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger6() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = 1000;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        Integer parameterDefaultValue2 = 1000;
        boolean isOptional2 = false;
        Integer maximum2 = null;
        Integer minimum2 = null;
        IntegerParameter parameter2 = new IntegerParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, maximum2, minimum2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        Integer value = 10;
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<inteiro nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger7() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = 1000;
        boolean isOptional1 = false;
        Integer maximum1 = null;
        Integer minimum1 = null;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        Integer parameterDefaultValue2 = 1000;
        boolean isOptional2 = false;
        Integer maximum2 = null;
        Integer minimum2 = null;
        IntegerParameter parameter2 = new IntegerParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, maximum2, minimum2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), null);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<inteiro nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger8() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        int parameterDefaultValue1 = 11;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        int parameterDefaultValue2 = 222;
        String xml = "";
        String conditionValue = "Valor de tipo errado.";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<inteiro nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + conditionValue + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger10() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = 1.5;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        Double parameterDefaultValue2 = 0.5;
        boolean isOptional2 = false;
        Double maximum2 = null;
        boolean includeMaximum2 = true;
        Double minimum2 = null;
        boolean includeMinimum2 = true;
        DoubleParameter parameter2 = new DoubleParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, maximum2, includeMaximum2, minimum2, includeMinimum2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        Double value = 1.2;
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<real nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger11() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = 1000.0;
        boolean isOptional1 = false;
        Double maximum1 = null;
        boolean includeMaximum1 = true;
        Double minimum1 = null;
        boolean includeMinimum1 = true;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, includeMaximum1, minimum1, includeMinimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        Double parameterDefaultValue2 = 1000.0;
        boolean isOptional2 = false;
        Double maximum2 = null;
        boolean includeMaximum2 = true;
        Double minimum2 = null;
        boolean includeMinimum2 = true;
        DoubleParameter parameter2 = new DoubleParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, maximum2, includeMaximum2, minimum2, includeMinimum2);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), null);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<real nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger12() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        double parameterDefaultValue1 = 1.1;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        double parameterDefaultValue2 = 22.22;
        String xml = "";
        String conditionValue = "Valor de tipo errado.";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultValue1 + "'/>";
        xml = xml + "<real nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterDefaultValue2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + conditionValue + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger13() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultItemId1 = "ID 11";
        String parameterDefaultItemName1 = "Nome do item padr\u00e3o 1.1";
        String parameterDefaultItemValue1 = "V1.1";
        EnumerationItem parameterDefaultValue1 = new EnumerationItem(parameterDefaultItemId1, parameterDefaultItemName1, parameterDefaultItemValue1, null);
        String parameterItemId1 = "ID 12";
        String parameterItemName1 = "Nome do item padr\u00e3o 1.2";
        String parameterItemValue1 = "V1.2";
        EnumerationItem parameterValue1 = new EnumerationItem(parameterItemId1, parameterItemName1, parameterItemValue1, null);
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(parameterDefaultValue1);
        items1.add(parameterValue1);
        boolean mustSortItems = true;
        EnumerationParameter parameter1 = new EnumerationParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, true, CMD_PATTERN, items1, mustSortItems);
        group.addParameter((Parameter)parameter1);
        expectedVersion.addGroup(group);
        SimpleCondition condition = new SimpleCondition(parameter1.getName(), (Object)parameterDefaultValue1);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterDefaultItemId1 + "'>";
        xml = xml + "<item_de_enumeracao id='" + parameterDefaultItemId1 + "' rotulo='" + parameterDefaultItemName1 + "' valor='" + parameterDefaultItemValue1 + "'/>";
        xml = xml + "<item_de_enumeracao id='" + parameterItemId1 + "' rotulo='" + parameterItemName1 + "' valor='" + parameterItemValue1 + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName1 + "' valor='" + parameterDefaultItemId1 + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger14() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='grupo'>\n";
        xml = xml + "<enumeracao nome='nome_da_enumeracao'\n";
        xml = xml + "            rotulo='rotulo da enumeracao'\n";
        xml = xml + "            dica='dica da enumeracao'\n";
        xml = xml + "            padrao='1'>\n";
        xml = xml + "<item_de_enumeracao id='1' rotulo='item 1' valor='valor 1'/>\n";
        xml = xml + "</enumeracao>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "<habilitar parametro='nome_da_enumeracao'>\n";
        xml = xml + "<condicao parametro='nome_da_enumeracao'/>\n";
        xml = xml + "</habilitar>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger15() {
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='comando'>\n";
        xml = xml + "<grupo rotulo='grupo'>\n";
        xml = xml + "<enumeracao nome='nome_da_enumeracao'\n";
        xml = xml + "            rotulo='rotulo da enumeracao'\n";
        xml = xml + "            dica='dica da enumeracao'\n";
        xml = xml + "            padrao='1'>\n";
        xml = xml + "<item_de_enumeracao id='1' rotulo='item 1' valor='valor 1'/>\n";
        xml = xml + "</enumeracao>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "<habilitar parametro='nome_da_enumeracao'>\n";
        xml = xml + "<condicao parametro='nome_da_enumeracao' valor='2'/>\n";
        xml = xml + "</habilitar>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger16() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger17() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String notExistantParameterName = "Nome do par\u00e2metro que n\u00e3o existe";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + notExistantParameterName + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger18() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String notExistantParameterName = "Nome do par\u00e2metro que n\u00e3o existe";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName2 + "'>";
        xml = xml + "<condicao parametro='" + notExistantParameterName + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger19() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName2 + "'>";
        xml = xml + "<condicao valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger20() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName2 + "'>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger21() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger22() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "' " + "desconhecido='valor'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger23() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName1 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testEnableParameterTrigger24() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        EnableParameterTrigger trigger1 = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger1);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger25() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        String parameterName3 = "Nome do par\u00e2metro 3";
        String parameterLabel3 = "R\u00f3tulo do par\u00e2metro 3";
        String parameterDescription3 = "Descri\u00e7\u00e3o do par\u00e2metro 3";
        String parameterDefaultValue3 = null;
        boolean isOptional3 = false;
        TextParameter parameter3 = new TextParameter(parameterName3, parameterLabel3, parameterDescription3, parameterDefaultValue3, isOptional3, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter3);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        EnableParameterTrigger trigger1 = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger1);
        EnableParameterTrigger trigger2 = new EnableParameterTrigger((SimpleParameter)parameter3, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger2);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "<texto nome='" + parameterName3 + "' rotulo='" + parameterLabel3 + "' dica='" + parameterDescription3 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<parametro nome='" + parameterName3 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testEnableParameterTrigger26() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='Nome do par\u00e2metro 3' valor='" + value + "'/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOrCondition1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition1 = new SimpleCondition(parameter1.getName(), null);
        SimpleCondition condition2 = new SimpleCondition(parameter2.getName(), (Object)value);
        SimpleCondition condition3 = new SimpleCondition(parameter2.getName(), null);
        OrOperatorCondition condition = new OrOperatorCondition(new Condition[]{condition1, condition2, condition3});
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<ou>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "'/>";
        xml = xml + "</ou>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testOrCondition2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<ou>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "</ou>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOrCondition3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<ou/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testOrCondition4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<ou desconhecido='valor'>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</ou>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testAndCondition1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition1 = new SimpleCondition(parameter1.getName(), null);
        SimpleCondition condition2 = new SimpleCondition(parameter2.getName(), (Object)value);
        SimpleCondition condition3 = new SimpleCondition(parameter2.getName(), null);
        AndOperatorCondition condition = new AndOperatorCondition(new Condition[]{condition1, condition2, condition3});
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<e>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "'/>";
        xml = xml + "</e>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testAndCondition2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<e/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testAndCondition3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<e>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "</e>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testAndCondition4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<e desconhecido='valor'>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</e>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testNotCondition1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        NotOperatorCondition notCondition = new NotOperatorCondition((Condition)condition);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)notCondition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<nao>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</nao>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testNotCondition2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<nao/>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testNotCondition3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<nao desconhecido='valor'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</nao>";
        xml = xml + "</habilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testGenericCondition1() throws ParseException, FormulaCreationException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome_do_parametro_2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        Integer parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        IntegerParameter parameter2 = new IntegerParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        int value = 3;
        String expressionText2 = parameterName2 + " == " + value;
        GenericCondition condition = new GenericCondition(expressionText2);
        EnableParameterTrigger trigger = new EnableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<inteiro nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "<habilitar parametro='" + parameterName1 + "'>\n";
        xml = xml + "<condicao>\n";
        xml = xml + "<![CDATA[" + expressionText2 + "]]>\n";
        xml = xml + "</condicao>\n";
        xml = xml + "</habilitar>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testShowParameterTriggerWithValidCondition() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ShowParameterTrigger trigger = new ShowParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</exibir>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testShowParameterTriggerWithSameParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</exibir>";
        xml = xml + "<exibir parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</exibir>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterTriggerWithNoParameter() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "</exibir>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterTriggerWithNoCondition() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir parametro='" + parameterName1 + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterTriggerWithUnknownParameter() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</exibir>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterTriggerWithUnknownAttribute() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir parametro='" + parameterName1 + "' desconhecido='valor'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</exibir>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterTriggerWithInternalParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ShowParameterTrigger trigger1 = new ShowParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger1);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</exibir>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testShowParameterTriggerWithMultipleParameters() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        String parameterName3 = "Nome do par\u00e2metro 3";
        String parameterLabel3 = "R\u00f3tulo do par\u00e2metro 3";
        String parameterDescription3 = "Descri\u00e7\u00e3o do par\u00e2metro 3";
        String parameterDefaultValue3 = null;
        boolean isOptional3 = false;
        TextParameter parameter3 = new TextParameter(parameterName3, parameterLabel3, parameterDescription3, parameterDefaultValue3, isOptional3, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter3);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ShowParameterTrigger trigger1 = new ShowParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger1);
        ShowParameterTrigger trigger2 = new ShowParameterTrigger((SimpleParameter)parameter3, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger2);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "<texto nome='" + parameterName3 + "' rotulo='" + parameterLabel3 + "' dica='" + parameterDescription3 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<parametro nome='" + parameterName3 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</exibir>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testShowParameterTriggerWithConditionWithUnknownParameter() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='Nome do par\u00e2metro 3' valor='" + value + "'/>";
        xml = xml + "</exibir>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithNoId() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "Nome do grupo 1";
        String groupName2 = "Nome do grupo 2";
        ParameterGroup group1 = new ParameterGroup(groupName1);
        version.addGroup(group1);
        ParameterGroup group2 = new ParameterGroup(groupName2);
        version.addGroup(group2);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterValue1, true, CMD_PATTERN, null, null);
        group1.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group2.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)parameterValue2);
        ShowGroupTrigger trigger = new ShowGroupTrigger(group1, (Condition)condition);
        version.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_grupo grupo='" + groupName1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithId() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        ParameterGroup group1 = new ParameterGroup(groupId1, groupName1, false);
        version.addGroup(group1);
        ParameterGroup group2 = new ParameterGroup(groupId2, groupName2, false);
        version.addGroup(group2);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterValue1, true, CMD_PATTERN, null, null);
        group1.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group2.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)parameterValue2);
        ShowGroupTrigger trigger = new ShowGroupTrigger(group1, (Condition)condition);
        version.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithUnknownAttribute() {
        String command = "Comando";
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_grupo grupo='" + groupId1 + "'  desconhecido='valor'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithSameGroups() {
        String command = "Comando";
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "<exibir_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithNoGroup() {
        String command = "Comando";
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_grupo>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithNoCondition() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String groupId1 = "Id do grupo 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<exibir_grupo grupo='" + groupId1 + "'/>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithUnknownGroup() {
        String command = "Comando";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithInternalGroup() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "Nome do grupo 1";
        String groupName2 = "Nome do grupo 2";
        ParameterGroup group1 = new ParameterGroup(groupName1);
        version.addGroup(group1);
        ParameterGroup group2 = new ParameterGroup(groupName2);
        version.addGroup(group2);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterValue1, true, CMD_PATTERN, null, null);
        group1.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group2.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)parameterValue2);
        ShowGroupTrigger trigger1 = new ShowGroupTrigger(group1, (Condition)condition);
        version.addTrigger((Trigger)trigger1);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_grupo>\n";
        xml = xml + "<grupo id='" + groupName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithMultipleGroups() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "Nome do grupo 1";
        String groupName2 = "Nome do grupo 2";
        ParameterGroup group1 = new ParameterGroup(groupName1);
        version.addGroup(group1);
        ParameterGroup group2 = new ParameterGroup(groupName2);
        version.addGroup(group2);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterValue1, true, CMD_PATTERN, null, null);
        group1.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group2.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)parameterValue2);
        ShowGroupTrigger trigger1 = new ShowGroupTrigger(group1, (Condition)condition);
        version.addTrigger((Trigger)trigger1);
        ShowGroupTrigger trigger2 = new ShowGroupTrigger(group2, (Condition)condition);
        version.addTrigger((Trigger)trigger2);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_grupo>\n";
        xml = xml + "<grupo id='" + groupName1 + "'/>";
        xml = xml + "<grupo id='" + groupName2 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testShowParameterGroupTriggerWithConditionWithUnknownParameter() {
        String command = "Comando";
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String parameterName3 = "Nome do par\u00e2metro 3";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName3 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDisableParameterTrigger1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        DisableParameterTrigger trigger = new DisableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<desabilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</desabilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDisableParameterTrigger2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<desabilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</desabilitar>";
        xml = xml + "<desabilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</desabilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDisableParameterTrigger3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<desabilitar>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "</desabilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDisableParameterTrigger4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<desabilitar parametro='" + parameterName1 + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDisableParameterTrigger5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<desabilitar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</desabilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDisableParameterTrigger6() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<desabilitar parametro='" + parameterName1 + "' " + "desconhecido='valor'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</desabilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testDisableParameterTrigger7() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        DisableParameterTrigger trigger1 = new DisableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger1);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<desabilitar>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</desabilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDisableParameterTrigger8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        String parameterName3 = "Nome do par\u00e2metro 3";
        String parameterLabel3 = "R\u00f3tulo do par\u00e2metro 3";
        String parameterDescription3 = "Descri\u00e7\u00e3o do par\u00e2metro 3";
        String parameterDefaultValue3 = null;
        boolean isOptional3 = false;
        TextParameter parameter3 = new TextParameter(parameterName3, parameterLabel3, parameterDescription3, parameterDefaultValue3, isOptional3, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter3);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        DisableParameterTrigger trigger1 = new DisableParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger1);
        DisableParameterTrigger trigger2 = new DisableParameterTrigger((SimpleParameter)parameter3, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger2);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "<texto nome='" + parameterName3 + "' rotulo='" + parameterLabel3 + "' dica='" + parameterDescription3 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<desabilitar>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<parametro nome='" + parameterName3 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</desabilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testDisableParameterTrigger9() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<desabilitar>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='Nome do par\u00e2metro 3' valor='" + value + "'/>";
        xml = xml + "</desabilitar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterTriggerWithValidCondition() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        HideParameterTrigger trigger = new HideParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</ocultar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testHideParameterTriggerWithSameParameters() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</ocultar>";
        xml = xml + "<ocultar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</ocultar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterTriggerWithNoParameter() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar>";
        xml = xml + "<condicao parametro='" + parameterName1 + "'/>";
        xml = xml + "</ocultar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterTriggerWithNoCondition() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar parametro='" + parameterName1 + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterTriggerWithConditionWithNoParameter() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</ocultar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterTriggerWithUnknownAttribute() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar parametro='" + parameterName1 + "' desconhecido='valor'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</ocultar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterTriggerWithInternalParameter() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        HideParameterTrigger trigger1 = new HideParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger1);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</ocultar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testHideParameterTriggerWithMultipleParameters() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        String parameterName3 = "Nome do par\u00e2metro 3";
        String parameterLabel3 = "R\u00f3tulo do par\u00e2metro 3";
        String parameterDescription3 = "Descri\u00e7\u00e3o do par\u00e2metro 3";
        String parameterDefaultValue3 = null;
        boolean isOptional3 = false;
        TextParameter parameter3 = new TextParameter(parameterName3, parameterLabel3, parameterDescription3, parameterDefaultValue3, isOptional3, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter3);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        HideParameterTrigger trigger1 = new HideParameterTrigger((SimpleParameter)parameter1, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger1);
        HideParameterTrigger trigger2 = new HideParameterTrigger((SimpleParameter)parameter3, (Condition)condition);
        expectedVersion.addTrigger((Trigger)trigger2);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "<texto nome='" + parameterName3 + "' rotulo='" + parameterLabel3 + "' dica='" + parameterDescription3 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<parametro nome='" + parameterName3 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</ocultar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testHideParameterTriggerWithConditionWithUnknownParameter() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar>";
        xml = xml + "<parametro nome='" + parameterName1 + "'/>";
        xml = xml + "<condicao parametro='Nome do par\u00e2metro 3' valor='" + value + "'/>";
        xml = xml + "</ocultar>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeDefaultValueTrigger1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String itemId11 = "ID 11";
        String itemName11 = "Nome do item 1.1";
        String itemValue11 = "Valor do item 1.1";
        EnumerationItem item11 = new EnumerationItem(itemId11, itemName11, itemValue11, null);
        String itemId12 = "ID 12";
        String itemName12 = "Nome do item 1.2";
        String itemValue12 = "Valor do item 1.2";
        EnumerationItem item12 = new EnumerationItem(itemId12, itemName12, itemValue12, null);
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(item11);
        items1.add(item12);
        boolean mustSortItems = true;
        EnumerationParameter parameter1 = new EnumerationParameter(parameterName1, parameterLabel1, parameterDescription1, item11, true, CMD_PATTERN, items1, mustSortItems);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger((SimpleParameter)parameter1, (Condition)condition, (Object)item12);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + itemId11 + "'>";
        xml = xml + "<item_de_enumeracao id='" + itemId11 + "' rotulo='" + itemName11 + "' valor='" + itemValue11 + "'/>";
        xml = xml + "<item_de_enumeracao id='" + itemId12 + "' rotulo='" + itemName12 + "' valor='" + itemValue12 + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + itemId12 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeDefaultValueTrigger2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String value1 = "Valor 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + value1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + value1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeDefaultValueTrigger3() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String itemName11 = "Nome do item 1.1";
        String itemValue11 = "Valor do item 1.1";
        String itemName12 = "Nome do item 1.2";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + itemName11 + "'>";
        xml = xml + "<item_de_enumeracao nome='" + itemName11 + "' valor='" + itemValue11 + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + itemName12 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeDefaultValueTrigger4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String itemName11 = "Nome do item 1.1";
        String itemValue11 = "Valor do item 1.1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + itemName11 + "'>";
        xml = xml + "<item_de_enumeracao nome='" + itemName11 + "' valor='" + itemValue11 + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeDefaultValueTrigger5() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean defaultValue1 = false;
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, defaultValue1, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        Boolean newDefaultValue = Boolean.TRUE;
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger((SimpleParameter)parameter1, (Condition)condition, (Object)newDefaultValue);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + defaultValue1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + newDefaultValue + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeDefaultValueTrigger6() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean defaultValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + defaultValue1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeDefaultValueTrigger7() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean defaultValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String newDefaultValue = "Valor n\u00e3o booleano";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + defaultValue1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + newDefaultValue + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeDefaultValueTrigger8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        String newDefaultValue = "Novo valor-padr\u00e3o";
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger((SimpleParameter)parameter1, (Condition)condition, (Object)newDefaultValue);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + newDefaultValue + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeDefaultValueTrigger9() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger((SimpleParameter)parameter1, (Condition)condition, null);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeDefaultValueTrigger10() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        Integer newDefaultValue = 1000;
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger((SimpleParameter)parameter1, (Condition)condition, (Object)newDefaultValue);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + newDefaultValue + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeDefaultValueTrigger11() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger((SimpleParameter)parameter1, (Condition)condition, null);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeDefaultValueTrigger12() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null, false, null, false);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        Double newDefaultValue = 1000.0;
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger((SimpleParameter)parameter1, (Condition)condition, (Object)newDefaultValue);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + newDefaultValue + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeDefaultValueTrigger13() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null, false, null, false);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeDefaultValueTrigger trigger = new ChangeDefaultValueTrigger((SimpleParameter)parameter1, (Condition)condition, null);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeDefaultValueTrigger14() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String newDefaultValue = "Valor n\u00e3o-real";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_valor_padrao parametro='" + parameterName1 + "' novo_valor_padrao='" + newDefaultValue + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_valor_padrao>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeMaximumTrigger1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null, false, null, false);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        Double newMaximum = 1000.0;
        boolean isNewMaximumIncluded = true;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter1, (Condition)condition, newMaximum, isNewMaximumIncluded);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "' novo_maximo='" + newMaximum + "' incluir_novo_maximo='" + isNewMaximumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMaximumTrigger2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        Double newMaximum = 1000.0;
        boolean isNewMaximumIncluded = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "' novo_maximo='" + newMaximum + "' incluir_novo_maximo='" + isNewMaximumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "' novo_maximo='" + newMaximum + "' incluir_novo_maximo='" + isNewMaximumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeMaximumTrigger3() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null, false, null, false);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter1, (Condition)condition, null, true);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMaximumTrigger4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String newMaximum = "Valor n\u00e3o-real";
        boolean isNewMaximumIncluded = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "' novo_maximo='" + newMaximum + "' incluir_novo_maximo='" + isNewMaximumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeMaximumTrigger5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        Double newMaximum = 1.2;
        String isNewMaximumIncluded = "valor n\u00e3o-booleano";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "' novo_maximo='" + newMaximum + "' incluir_novo_maximo='" + isNewMaximumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeMaximumTrigger6() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        Double newMaximum = 1000.0;
        boolean isNewMaximumIncluded = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "' novo_maximo='" + newMaximum + "' incluir_novo_maximo='" + isNewMaximumIncluded + "' " + "desconhecido='valor'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeMaximumTrigger7() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        Integer maximum1 = null;
        Integer minimum1 = null;
        boolean isOptional1 = false;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        Integer newMaximum = 1000;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter1, (Condition)condition, newMaximum);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "' novo_maximo='" + newMaximum + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMaximumTrigger8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        Integer maximum1 = null;
        Integer minimum1 = null;
        boolean isOptional1 = false;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter1, (Condition)condition, null);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMaximumTrigger9() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer maximum1 = null;
        Integer minimum1 = null;
        boolean isOptional1 = false;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        Integer newMaximum = 1000;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter1, (Condition)condition, newMaximum);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' " + "rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "' novo_maximo='" + newMaximum + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMaximumTrigger10() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer maximum1 = null;
        Integer minimum1 = null;
        boolean isOptional1 = false;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter1, (Condition)condition, null);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' " + "rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_maximo parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_maximo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMinimumTrigger1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null, false, null, false);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        Double newMinimum = 1000.0;
        boolean isNewMinimumIncluded = true;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter1, (Condition)condition, newMinimum, isNewMinimumIncluded);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "' novo_minimo='" + newMinimum + "' incluir_novo_minimo='" + isNewMinimumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMinimumTrigger2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        Double newMinimum = 1000.0;
        boolean isNewMinimumIncluded = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "' novo_minimo='" + newMinimum + "' incluir_novo_minimo='" + isNewMinimumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "' novo_minimo='" + newMinimum + "' incluir_novo_minimo='" + isNewMinimumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeMinimumTrigger3() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Double parameterDefaultValue1 = null;
        boolean isOptional1 = false;
        DoubleParameter parameter1 = new DoubleParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, null, false, null, false);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter1, (Condition)condition, null, true);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMinimumTrigger4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String newMinimum = "Valor n\u00e3o-real";
        boolean isNewMinimumIncluded = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "' novo_minimo='" + newMinimum + "' incluir_novo_minimo='" + isNewMinimumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeMinimumTrigger5() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        Double newMinimum = 1000.0;
        String isNewMinimumIncluded = "Valor n\u00e3o-booleano";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "' novo_minimo='" + newMinimum + "' incluir_novo_minimo='" + isNewMinimumIncluded + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeMinimumTrigger6() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        Double newMinimum = 1000.0;
        boolean isNewMinimumIncluded = true;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<real nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "' novo_minimo='" + newMinimum + "' incluir_novo_minimo='" + isNewMinimumIncluded + "' desconhecido='valor'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeMinimumTrigger7() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        Integer maximum1 = null;
        Integer minimum1 = null;
        boolean isOptional1 = false;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        Integer newMinimum = 1000;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter1, (Condition)condition, newMinimum);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "' novo_minimo='" + newMinimum + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMinimumTrigger8() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer parameterDefaultValue1 = null;
        Integer maximum1 = null;
        Integer minimum1 = null;
        boolean isOptional1 = false;
        IntegerParameter parameter1 = new IntegerParameter(parameterName1, parameterLabel1, parameterDescription1, parameterDefaultValue1, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter1, (Condition)condition, null);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<inteiro nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMinimumTrigger9() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer maximum1 = null;
        Integer minimum1 = null;
        boolean isOptional1 = false;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        Integer newMinimum = 1000;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter1, (Condition)condition, newMinimum);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "' novo_minimo='" + newMinimum + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeMinimumTrigger10() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        Integer maximum1 = null;
        Integer minimum1 = null;
        boolean isOptional1 = false;
        IntegerListParameter parameter1 = new IntegerListParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, maximum1, minimum1);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter1, (Condition)condition, null);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<lista_de_inteiros nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<trocar_minimo parametro='" + parameterName1 + "'>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>";
        xml = xml + "</trocar_minimo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeFileTypeTrigger1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        OutputFileParameter parameter1 = new OutputFileParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        String fileType = "Tipo";
        ChangeFileTypeTrigger trigger = new ChangeFileTypeTrigger((FileParameter)parameter1, (Condition)condition, fileType);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "<trocar_tipo_de_arquivo parametro='" + parameterName1 + "' novo_tipo='" + fileType + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>\n";
        xml = xml + "</trocar_tipo_de_arquivo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeFileTypeTrigger2() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String fileType = "Tipo";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "<trocar_tipo_de_arquivo parametro='" + parameterName1 + "' novo_tipo='" + fileType + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>\n";
        xml = xml + "</trocar_tipo_de_arquivo>\n";
        xml = xml + "<trocar_tipo_de_arquivo parametro='" + parameterName1 + "' novo_tipo='" + fileType + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>\n";
        xml = xml + "</trocar_tipo_de_arquivo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeFileTypeTrigger3() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        OutputFileParameter parameter1 = new OutputFileParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        ChangeFileTypeTrigger trigger = new ChangeFileTypeTrigger((FileParameter)parameter1, (Condition)condition, null);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "<trocar_tipo_de_arquivo parametro='" + parameterName1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>\n";
        xml = xml + "</trocar_tipo_de_arquivo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testChangeFileTypeTrigger4() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String value = "Valor";
        String fileType = "Tipo";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<arquivo_de_saida nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "<trocar_tipo_de_arquivo parametro='" + parameterName1 + "' novo_tipo='" + fileType + "' desconhecido='valor'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>\n";
        xml = xml + "</trocar_tipo_de_arquivo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowEnumerationItemTrigger1() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "Nome do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String defaultItemId = "ID 1";
        String defaultItemName = "Nome do item padr\u00e3o";
        String defaultItemValue = "Valor do item padr\u00e3o";
        EnumerationItem defaultItem = new EnumerationItem(defaultItemId, defaultItemName, defaultItemValue, null);
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(defaultItem);
        EnumerationParameter parameter1 = new EnumerationParameter(parameterName1, parameterLabel1, parameterDescription1, defaultItem, true, CMD_PATTERN, items1, mustSortItems);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)new Boolean(parameterValue2));
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter1, (Condition)condition, defaultItemId, true);
        version.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + defaultItemId + "'>\n";
        xml = xml + "<item_de_enumeracao id='" + defaultItemId + "' rotulo='" + defaultItemId + "' valor='" + defaultItemValue + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_item parametro='" + parameterName1 + "' item='" + defaultItemId + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_item>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testShowEnumerationItemTrigger2() {
        String command = "Comando";
        String groupName = "Nome do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String defaultItemId = "ID 1";
        String defaultItemValue = "Valor do item padr\u00e3o";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + defaultItemId + "'>\n";
        xml = xml + "<item_de_enumeracao id='" + defaultItemId + "' rotulo='" + defaultItemId + "' valor='" + defaultItemValue + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<exibir_item parametro='" + parameterName1 + "' item='" + defaultItemId + "' desconhecido='valor'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</exibir_item>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testShowEnumerationItemTrigger3() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "Nome do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String defaultItemId = "ID 1";
        String defaultItemName = "Nome do item padr\u00e3o";
        String defaultItemValue = "Valor do item padr\u00e3o";
        EnumerationItem defaultItem = new EnumerationItem(defaultItemId, defaultItemName, defaultItemValue, null);
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(defaultItem);
        boolean mustSortItems = true;
        EnumerationParameter parameter1 = new EnumerationParameter(parameterName1, parameterLabel1, parameterDescription1, defaultItem, true, CMD_PATTERN, items1, mustSortItems);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)new Boolean(parameterValue2));
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter1, (Condition)condition, defaultItemId, false);
        version.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + defaultItemId + "'>\n";
        xml = xml + "<item_de_enumeracao id='" + defaultItemId + "' rotulo='" + defaultItemName + "' valor='" + defaultItemValue + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_item parametro='" + parameterName1 + "' item='" + defaultItemId + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_item>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testHideEnumerationItemTrigger1() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "Nome do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String defaultItemId = "ID 1";
        String defaultItemName = "Nome do item padr\u00e3o";
        String defaultItemValue = "Valor do item padr\u00e3o";
        EnumerationItem defaultItem = new EnumerationItem(defaultItemId, defaultItemName, defaultItemValue, null);
        boolean mustSortItems = true;
        LinkedList<EnumerationItem> items1 = new LinkedList<EnumerationItem>();
        items1.add(defaultItem);
        EnumerationParameter parameter1 = new EnumerationParameter(parameterName1, parameterLabel1, parameterDescription1, defaultItem, true, CMD_PATTERN, items1, mustSortItems);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)new Boolean(parameterValue2));
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter1, (Condition)condition, defaultItemId, false);
        version.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + defaultItemId + "'>\n";
        xml = xml + "<item_de_enumeracao id='" + defaultItemId + "' rotulo='" + defaultItemId + "' valor='" + defaultItemValue + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_item parametro='" + parameterName1 + "' item='" + defaultItemId + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_item>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testHideEnumerationItemTrigger2() {
        String command = "Comando";
        String groupName = "Nome do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String defaultItemId = "ID 1";
        String defaultItemName = "Nome do item padr\u00e3o";
        String defaultItemValue = "Valor do item padr\u00e3o";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<enumeracao nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + defaultItemId + "'>\n";
        xml = xml + "<item_de_enumeracao id='" + defaultItemId + "' rotulo='" + defaultItemName + "' valor='" + defaultItemValue + "'/>";
        xml = xml + "</enumeracao>";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_item parametro='" + parameterName1 + "' item='" + defaultItemId + "' desconhecido='valor'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_item>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithNoId() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "Nome do grupo 1";
        String groupName2 = "Nome do grupo 2";
        ParameterGroup group1 = new ParameterGroup(groupName1);
        version.addGroup(group1);
        ParameterGroup group2 = new ParameterGroup(groupName2);
        version.addGroup(group2);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterValue1, true, CMD_PATTERN, null, null);
        group1.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group2.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)parameterValue2);
        HideGroupTrigger trigger = new HideGroupTrigger(group1, (Condition)condition);
        version.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_grupo grupo='" + groupName1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithId() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        ParameterGroup group1 = new ParameterGroup(groupId1, groupName1, false);
        version.addGroup(group1);
        ParameterGroup group2 = new ParameterGroup(groupId2, groupName2, false);
        version.addGroup(group2);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterValue1, true, CMD_PATTERN, null, null);
        group1.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group2.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)parameterValue2);
        HideGroupTrigger trigger = new HideGroupTrigger(group1, (Condition)condition);
        version.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithUnknownAttribute() {
        String command = "Comando";
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_grupo grupo='" + groupId1 + "'  desconhecido='valor'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithSameGroups() {
        String command = "Comando";
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "<ocultar_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithNoGroup() {
        String command = "Comando";
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_grupo>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithNoCondition() {
        String command = "Comando_do_algoritmo";
        String groupName = "R\u00f3tulo do grupo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        String groupId1 = "Id do grupo 1";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>";
        xml = xml + "</grupo>";
        xml = xml + "<ocultar_grupo grupo='" + groupId1 + "'/>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithUnknownGroup() {
        String command = "Comando";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithInternalGroup() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "Nome do grupo 1";
        String groupName2 = "Nome do grupo 2";
        ParameterGroup group1 = new ParameterGroup(groupName1);
        version.addGroup(group1);
        ParameterGroup group2 = new ParameterGroup(groupName2);
        version.addGroup(group2);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterValue1, true, CMD_PATTERN, null, null);
        group1.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group2.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)parameterValue2);
        HideGroupTrigger trigger1 = new HideGroupTrigger(group1, (Condition)condition);
        version.addTrigger((Trigger)trigger1);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_grupo>\n";
        xml = xml + "<grupo id='" + groupName1 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithMultipleGroups() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName1 = "Nome do grupo 1";
        String groupName2 = "Nome do grupo 2";
        ParameterGroup group1 = new ParameterGroup(groupName1);
        version.addGroup(group1);
        ParameterGroup group2 = new ParameterGroup(groupName2);
        version.addGroup(group2);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        BooleanParameter parameter1 = new BooleanParameter(parameterName1, parameterLabel1, parameterDescription1, parameterValue1, true, CMD_PATTERN, null, null);
        group1.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        BooleanParameter parameter2 = new BooleanParameter(parameterName2, parameterLabel2, parameterDescription2, parameterValue2, true, CMD_PATTERN, null, null);
        group2.addParameter((Parameter)parameter2);
        SimpleCondition condition = new SimpleCondition(parameterName2, (Object)parameterValue2);
        HideGroupTrigger trigger1 = new HideGroupTrigger(group1, (Condition)condition);
        version.addTrigger((Trigger)trigger1);
        HideGroupTrigger trigger2 = new HideGroupTrigger(group2, (Condition)condition);
        version.addTrigger((Trigger)trigger2);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_grupo>\n";
        xml = xml + "<grupo id='" + groupName1 + "'/>";
        xml = xml + "<grupo id='" + groupName2 + "'/>";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testHideParameterGroupTriggerWithConditionWithUnknownParameter() {
        String command = "Comando";
        String groupName1 = "Nome do grupo 1";
        String groupId1 = "Id do grupo 1";
        String groupName2 = "Nome do grupo 2";
        String groupId2 = "Id do grupo 2";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean parameterValue1 = false;
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        boolean parameterValue2 = false;
        String parameterName3 = "Nome do par\u00e2metro 3";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo id='" + groupId1 + "' rotulo='" + groupName1 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "' padrao='" + parameterValue1 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<grupo id='" + groupId2 + "' rotulo='" + groupName2 + "'>\n";
        xml = xml + "<booleano nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "' padrao='" + parameterValue2 + "'/>";
        xml = xml + "</grupo>\n";
        xml = xml + "<ocultar_grupo grupo='" + groupId1 + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName3 + "' valor='" + parameterValue2 + "'/>\n";
        xml = xml + "</ocultar_grupo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testChangeLabelTrigger1() throws ParseException {
        String command = "Comando_do_algoritmo";
        SimpleAlgorithmConfigurator expectedVersion = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String groupName = "R\u00f3tulo do grupo";
        ParameterGroup group = new ParameterGroup(groupName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterLabel1 = "R\u00f3tulo do par\u00e2metro 1";
        String parameterDescription1 = "Descri\u00e7\u00e3o do par\u00e2metro 1";
        boolean isOptional1 = false;
        TextParameter parameter1 = new TextParameter(parameterName1, parameterLabel1, parameterDescription1, null, isOptional1, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        String parameterLabel2 = "R\u00f3tulo do par\u00e2metro 2";
        String parameterDescription2 = "Descri\u00e7\u00e3o do par\u00e2metro 2";
        String parameterDefaultValue2 = null;
        boolean isOptional2 = false;
        TextParameter parameter2 = new TextParameter(parameterName2, parameterLabel2, parameterDescription2, parameterDefaultValue2, isOptional2, true, CMD_PATTERN, null);
        group.addParameter((Parameter)parameter2);
        expectedVersion.addGroup(group);
        String value = "Valor";
        SimpleCondition condition = new SimpleCondition(parameter2.getName(), (Object)value);
        String newLabel = "Novo R\u00f3tulo";
        ChangeLabelTrigger trigger = new ChangeLabelTrigger((SimpleParameter)parameter1, (Condition)condition, newLabel);
        expectedVersion.addTrigger((Trigger)trigger);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo rotulo='" + groupName + "'>\n";
        xml = xml + "<texto nome='" + parameterName1 + "' rotulo='" + parameterLabel1 + "' dica='" + parameterDescription1 + "'/>\n";
        xml = xml + "<texto nome='" + parameterName2 + "' rotulo='" + parameterLabel2 + "' dica='" + parameterDescription2 + "'/>\n";
        xml = xml + "</grupo>\n";
        xml = xml + "<trocar_rotulo parametro='" + parameterName1 + "' novo_rotulo='" + newLabel + "'>\n";
        xml = xml + "<condicao parametro='" + parameterName2 + "' valor='" + value + "'/>\n";
        xml = xml + "</trocar_rotulo>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(expectedVersion, xml);
    }

    @Test
    public void testInputGroup1() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup inputGroup = new ParameterGroup("Par\u00e2metros de entrada");
        version.addGroup(inputGroup);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo_de_entrada/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testOutputGroup2() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup outputGroup = new ParameterGroup("Par\u00e2metros de sa\u00edda");
        version.addGroup(outputGroup);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo_de_saida/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testHiddenParameter1() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String parameterName = "Nome_do_parametro";
        String parameterValue = "Valor do par\u00e2metro";
        HiddenParameter parameter = new HiddenParameter(parameterName, parameterValue, CMD_PATTERN);
        version.addHiddenParameter(parameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<oculto nome='" + parameterName + "' valor='" + parameterValue + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testHiddenParameter2() {
        String command = "Comando";
        String parameterName = "Nome do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<oculto nome='" + parameterName + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHiddenParameter3() {
        String command = "Comando";
        String parameterValue = "Valor do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<oculto valor='" + parameterValue + "'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHiddenParameter4() {
        String command = "Comando";
        String parameterName = "Nome_do_parametro";
        String parameterValue = "Valor do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<oculto nome='" + parameterName + "' valor='" + parameterValue + "' desconhecido='valor'/>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testHiddenParameter5() throws ParseException {
        String command = "Comando";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        String parameterName = "Nome_do_parametro";
        String parameterValue = "Valor do par\u00e2metro";
        String commandLinePattern = "Nome: $NOME_DO_PARAMETRO Valor: $VALOR_DO_PARAMETRO";
        HiddenParameter parameter = new HiddenParameter(parameterName, parameterValue, commandLinePattern);
        version.addHiddenParameter(parameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<oculto nome='" + parameterName + "' valor='" + parameterValue + "'>\n";
        xml = xml + "<formato_no_comando>" + commandLinePattern + "</formato_no_comando>\n";
        xml = xml + "</oculto>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testHiddenParameter6() {
        String command = "Comando";
        String parameterName = "Nome_do_parametro";
        String parameterValue = "Valor do par\u00e2metro";
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<oculto nome='" + parameterName + "' valor='" + parameterValue + "'>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>\n";
        xml = xml + "</oculto>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(xml);
    }

    @Test
    public void testLogFileParameter1() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "Par\u00e2metros de log";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameter.createLogFile((String)CMD_PATTERN);
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<log/>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testLogFileParameter2() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "Par\u00e2metros de log";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameter.createLogFile((String)CMD_PATTERN);
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo_de_log>\n";
        xml = xml + "<arquivo_de_log/>\n";
        xml = xml + "</grupo_de_log>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testLogFileParameter3() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "Par\u00e2metros de log";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        String commandLinePattern = "Nome: $NOME_DO_PARAMETRO Valor:$VALOR_DO_PARAMETRO";
        OutputFileParameter outputFileParameter = OutputFileParameter.createLogFile((String)commandLinePattern);
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo_de_log>\n";
        xml = xml + "<arquivo_de_log>\n";
        xml = xml + "<formato_no_comando>" + commandLinePattern + "</formato_no_comando>\n";
        xml = xml + "</arquivo_de_log>\n";
        xml = xml + "</grupo_de_log>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    @Test
    public void testLogFileParameter4() throws ParseException {
        String command = "Comando_do_algoritmo";
        String groupName = "Par\u00e2metros de log";
        SimpleAlgorithmConfigurator version = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, null, null);
        ParameterGroup group = new ParameterGroup(groupName);
        version.addGroup(group);
        OutputFileParameter outputFileParameter = OutputFileParameter.createLogFile(null);
        group.addParameter((Parameter)outputFileParameter);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>\n";
        xml = xml + "<grupo_de_log>\n";
        xml = xml + "<arquivo_de_log>\n";
        xml = xml + "<formato_no_comando></formato_no_comando>\n";
        xml = xml + "</arquivo_de_log>\n";
        xml = xml + "</grupo_de_log>\n";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(version, xml);
    }

    public void testParametersPropertiesWithCustomCommandLinePattern() throws IOException, ParseException {
        String parameterName = "real";
        String parameterLabel = "Real";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro real";
        String command = "comando";
        String customCommandLinePattern = "$NOME_DO_PARAMETRO : $VALOR_DO_PARAMETRO";
        HashMap<String, String> configMap = SimpleAlgorithmParserTest.createReplacementMap();
        String prop = "";
        prop = prop + "<real nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'>";
        prop = prop + "<formato_no_comando>";
        prop = prop + customCommandLinePattern;
        prop = prop + "</formato_no_comando>";
        prop = prop + "</real>";
        configMap.put("real_especial", prop);
        SimpleAlgorithmConfigurator configurator = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command);
        String groupLabel = "Grupo";
        ParameterGroup group = new ParameterGroup(groupLabel);
        DoubleParameter parameter = new DoubleParameter(parameterName, parameterLabel, parameterDescription, null, false, true, customCommandLinePattern, null, true, null, true);
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>";
        xml = xml + "<grupo rotulo='" + groupLabel + "'>";
        xml = xml + "<real_especial/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        SimpleAlgorithmParserTest.assertXml(configurator, xml, configMap, SimpleAlgorithmParserTest.createParamMap());
    }

    @Test
    public void testConfigProperties1() throws ParseException, IOException {
        String parameterName = "ESPECIAL";
        String parameterLabel = "Especial";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro especial";
        HashMap<String, String> configProperties = SimpleAlgorithmParserTest.createReplacementMap();
        HashMap<String, String> paramProperties = SimpleAlgorithmParserTest.createParamMap();
        configProperties.put("especial", "<booleano nome='" + parameterName + "' rotulo='" + parameterLabel + "' dica='" + parameterDescription + "'/>");
        String command = "comando";
        SimpleAlgorithmConfigurator configurator = SimpleAlgorithmParserTest.createAlgorithmConfigurator(command);
        String groupLabel = "Grupo";
        ParameterGroup group = new ParameterGroup(groupLabel);
        BooleanParameter parameter = new BooleanParameter(parameterName, parameterLabel, parameterDescription, false, true, CMD_PATTERN, null, null);
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        String xml = "";
        xml = xml + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = xml + "<algoritmo comando='" + command + "'>";
        xml = xml + "<grupo rotulo='" + groupLabel + "'>";
        xml = xml + "<especial/>";
        xml = xml + "</grupo>";
        xml = xml + "</algoritmo>";
        StringReader configXmlReader = new StringReader(xml);
        AlgorithmVersionInfo algorithmVersion = configurator.getAlgorithmVersion();
        SimpleAlgorithmParser parser = new SimpleAlgorithmParser();
        SimpleAlgorithmConfigurator loadedConfigurator = parser.load((Reader)configXmlReader, configProperties, paramProperties, algorithmVersion, ExecutionLocation.BINARY_DIR, CMD_PATTERN);
        SimpleAlgorithmParserTest.assertConfigurator(configurator, loadedConfigurator);
    }

    static final void assertXml(SimpleAlgorithmConfigurator expectedConfigurator, String xml, Map<String, String> replacementMap, Map<String, String> paramProperties) throws ParseException {
        SimpleAlgorithmConfigurator loadedVersion = SimpleAlgorithmParserTest.loadXml(expectedConfigurator.getAlgorithmVersion(), xml, replacementMap, paramProperties);
        SimpleAlgorithmParserTest.assertConfigurator(expectedConfigurator, loadedVersion);
    }

    static final void assertXml(SimpleAlgorithmConfigurator expectedConfigurator, String xml) throws ParseException {
        try {
            SimpleAlgorithmConfigurator loadedVersion = SimpleAlgorithmParserTest.loadXml(expectedConfigurator.getAlgorithmVersion(), xml);
            SimpleAlgorithmParserTest.assertConfigurator(expectedConfigurator, loadedVersion);
        }
        catch (IOException e) {
            Assert.fail((String)("Erro ao carregar arquivo de configura\u00e7\u00e3o: " + e.getMessage()));
        }
    }

    static final void assertXml(String xml) {
        try {
            SimpleAlgorithmParserTest.loadXml(SimpleAlgorithmParserTest.createAlgorithmConfigurator("comando").getAlgorithmVersion(), xml);
            Assert.fail((String)"Esperada ParseException");
        }
        catch (ParseException e) {
        }
        catch (IOException e) {
            Assert.fail((String)("Erro ao carregar arquivo de configura\u00e7\u00e3o: " + e.getMessage()));
        }
    }

    static SimpleAlgorithmConfigurator createAlgorithmConfigurator(String command) {
        String description = null;
        ExecutionType executionType = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = null;
        boolean provideId = false;
        String shell = null;
        String defaultInputFileParameterName = null;
        return SimpleAlgorithmParserTest.createAlgorithmConfigurator(command, description, executionType, executionLocation, abbreviation, provideId, shell, defaultInputFileParameterName);
    }

    static SimpleAlgorithmConfigurator createAlgorithmConfigurator(String command, String description, ExecutionType executionType, ExecutionLocation executionLocation, String abbreviation, boolean provideId, String shell, String defaultInputFileParameterName) {
        AlgorithmVersionInfo algorithmVersion = SimpleAlgorithmParserTest.createAlgorithmVersion();
        return new SimpleAlgorithmConfigurator(algorithmVersion, description, executionType, executionLocation, abbreviation, provideId, command, shell, defaultInputFileParameterName, true, CMD_PATTERN);
    }

    private static AlgorithmVersionInfo createAlgorithmVersion() {
        String algorithmName = "Algoritmo";
        int major = 1;
        int minor = 2;
        int patch = 3;
        AlgorithmInfo algorithm = new AlgorithmInfo("ID " + algorithmName, algorithmName, "DIR " + algorithmName, "algorithms", new Hashtable());
        AlgorithmVersionInfo algorithmVersion = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(major, minor, patch), new Hashtable(), new HashMap());
        return algorithmVersion;
    }

    private static void assertConfigurator(SimpleAlgorithmConfigurator expectedVersion, SimpleAlgorithmConfigurator loadedVersion) {
        Assert.assertNotNull((Object)loadedVersion);
        Assert.assertEquals((Object)expectedVersion, (Object)loadedVersion);
        Assert.assertEquals((Object)expectedVersion.getAlgorithmVersion(), (Object)loadedVersion.getAlgorithmVersion());
        Assert.assertEquals((String)expectedVersion.getCommandBinaryName(), (String)loadedVersion.getCommandBinaryName());
        Assert.assertEquals((String)expectedVersion.getDescription(), (String)loadedVersion.getDescription());
        Assert.assertEquals((String)expectedVersion.getShell(), (String)loadedVersion.getShell());
        SimpleAlgorithmParserTest.assertGroups(expectedVersion.getGroups(), loadedVersion.getGroups());
        SimpleAlgorithmParserTest.assertExpressions(expectedVersion.getExpressions(), loadedVersion.getExpressions());
        SimpleAlgorithmParserTest.assertTriggers(expectedVersion.getTriggers(), loadedVersion.getTriggers());
        Assert.assertEquals((Object)expectedVersion.getExecutionType(), (Object)loadedVersion.getExecutionType());
        Assert.assertEquals((String)expectedVersion.getDefaultInputFileParameterName(), (String)loadedVersion.getDefaultInputFileParameterName());
        Assert.assertEquals((String)expectedVersion.getAbbreviation(), (String)loadedVersion.getAbbreviation());
        Assert.assertEquals((boolean)expectedVersion.provideId(), (boolean)loadedVersion.provideId());
        Assert.assertEquals((boolean)expectedVersion.hasExitCode(), (boolean)loadedVersion.hasExitCode());
        SimpleAlgorithmParserTest.assertHiddenParameters(expectedVersion.getHiddenParameters(), loadedVersion.getHiddenParameters());
    }

    private static void assertColumns(List<Column<?>> expectedColumns, List<Column<?>> loadedColumns) {
        Assert.assertEquals((int)expectedColumns.size(), (int)loadedColumns.size());
        Iterator<Column<?>> expectedColumnIterator = expectedColumns.iterator();
        Iterator<Column<?>> loadedColumnIterator = loadedColumns.iterator();
        while (expectedColumnIterator.hasNext()) {
            Column<?> expectedColumn = expectedColumnIterator.next();
            Column<?> loadedColumn = loadedColumnIterator.next();
            Assert.assertEquals((String)expectedColumn.getId(), (String)loadedColumn.getId());
            Assert.assertEquals((String)expectedColumn.getLabel(), (String)loadedColumn.getLabel());
            Assert.assertEquals(expectedColumn.getClass(), loadedColumn.getClass());
            Assert.assertEquals((boolean)expectedColumn.isOptional(), (boolean)loadedColumn.isOptional());
            Assert.assertEquals((boolean)expectedColumn.isEditable(), (boolean)loadedColumn.isEditable());
            Assert.assertEquals((Object)expectedColumn.getDefaultValue(), (Object)loadedColumn.getDefaultValue());
            Set rowIndexes = expectedColumn.getRowIndexes();
            for (Integer rowIndex : rowIndexes) {
                Assert.assertEquals((Object)expectedColumn.getDefaultValue(rowIndex.intValue()), (Object)loadedColumn.getDefaultValue(rowIndex.intValue()));
            }
            if (expectedColumn instanceof TextColumn) {
                TextColumn expectedTextColumn = (TextColumn)expectedColumn;
                TextColumn loadedTextColumn = (TextColumn)loadedColumn;
                Assert.assertEquals((Object)expectedTextColumn.getMaxCharacters(), (Object)loadedTextColumn.getMaxCharacters());
                continue;
            }
            if (expectedColumn instanceof IntegerColumn) {
                IntegerColumn expectedIntegerColumn = (IntegerColumn)expectedColumn;
                IntegerColumn loadedIntegerColumn = (IntegerColumn)loadedColumn;
                Assert.assertEquals((String)expectedIntegerColumn.getLabel(), (String)loadedIntegerColumn.getLabel());
                Assert.assertEquals((Object)expectedIntegerColumn.getMaximum(), (Object)loadedIntegerColumn.getMaximum());
                Assert.assertEquals((Object)expectedIntegerColumn.getMinimum(), (Object)loadedIntegerColumn.getMinimum());
                continue;
            }
            if (expectedColumn instanceof DoubleColumn) {
                DoubleColumn expectedDoubleColumn = (DoubleColumn)expectedColumn;
                DoubleColumn loadedDoubleColumn = (DoubleColumn)loadedColumn;
                Assert.assertEquals((String)expectedDoubleColumn.getLabel(), (String)loadedDoubleColumn.getLabel());
                Assert.assertEquals((Object)expectedDoubleColumn.getMaximum(), (Object)loadedDoubleColumn.getMaximum());
                Assert.assertEquals((Object)expectedDoubleColumn.getMinimum(), (Object)loadedDoubleColumn.getMinimum());
                Assert.assertEquals((boolean)expectedDoubleColumn.isMaximumIncluded(), (boolean)loadedDoubleColumn.isMaximumIncluded());
                Assert.assertEquals((boolean)expectedDoubleColumn.isMinimumIncluded(), (boolean)loadedDoubleColumn.isMinimumIncluded());
                continue;
            }
            if (!(expectedColumn instanceof BooleanColumn)) continue;
            BooleanColumn expectedBooleanColumn = (BooleanColumn)expectedColumn;
            BooleanColumn loadedBooleanColumn = (BooleanColumn)loadedColumn;
            Assert.assertEquals((String)expectedBooleanColumn.getTrueCommand(), (String)loadedBooleanColumn.getTrueCommand());
            Assert.assertEquals((String)expectedBooleanColumn.getFalseCommand(), (String)loadedBooleanColumn.getFalseCommand());
        }
    }

    private static void assertTriggers(Set<Trigger<?>> expectedTriggers, Set<Trigger<?>> loadedTriggers) {
        Assert.assertNotNull(loadedTriggers);
        Assert.assertEquals((int)expectedTriggers.size(), (int)loadedTriggers.size());
        Iterator<Trigger<?>> expectedTriggerIterator = expectedTriggers.iterator();
        Iterator<Trigger<?>> loadedTriggerIterator = loadedTriggers.iterator();
        while (expectedTriggerIterator.hasNext()) {
            Trigger<?> expectedTrigger = expectedTriggerIterator.next();
            Trigger<?> loadedTrigger = loadedTriggerIterator.next();
            SimpleAlgorithmParserTest.assertTrigger(expectedTrigger, loadedTrigger);
        }
    }

    private static void assertTrigger(Trigger<?> expectedTrigger, Trigger<?> loadedTrigger) {
        Assert.assertEquals(expectedTrigger, loadedTrigger);
        Assert.assertEquals((Object)expectedTrigger.getCondition(), (Object)loadedTrigger.getCondition());
        Assert.assertEquals((Object)expectedTrigger.getParameter(), (Object)loadedTrigger.getParameter());
        if (expectedTrigger instanceof ChangeMaximumForDoublesTrigger) {
            ChangeMaximumForDoublesTrigger expectedDoubleChangeMaximumTrigger = (ChangeMaximumForDoublesTrigger)expectedTrigger;
            ChangeMaximumForDoublesTrigger loadedDoubleChangeMaximumTrigger = (ChangeMaximumForDoublesTrigger)loadedTrigger;
            Assert.assertEquals((Object)expectedDoubleChangeMaximumTrigger.getMaximum(), (Object)loadedDoubleChangeMaximumTrigger.getMaximum());
            Assert.assertEquals((boolean)expectedDoubleChangeMaximumTrigger.isMaximumIncluded(), (boolean)loadedDoubleChangeMaximumTrigger.isMaximumIncluded());
        } else if (expectedTrigger instanceof ChangeMinimumForDoublesTrigger) {
            ChangeMinimumForDoublesTrigger expectedDoubleChangeMinimumTrigger = (ChangeMinimumForDoublesTrigger)expectedTrigger;
            ChangeMinimumForDoublesTrigger loadedDoubleChangeMinimumTrigger = (ChangeMinimumForDoublesTrigger)loadedTrigger;
            Assert.assertEquals((Object)expectedDoubleChangeMinimumTrigger.getMinimum(), (Object)loadedDoubleChangeMinimumTrigger.getMinimum());
            Assert.assertEquals((boolean)expectedDoubleChangeMinimumTrigger.isMinimumIncluded(), (boolean)loadedDoubleChangeMinimumTrigger.isMinimumIncluded());
        } else if (expectedTrigger instanceof ChangeFileTypeTrigger) {
            ChangeFileTypeTrigger expectedChangeFileTypeTrigger = (ChangeFileTypeTrigger)expectedTrigger;
            ChangeFileTypeTrigger loadedChangeFileTypeTrigger = (ChangeFileTypeTrigger)loadedTrigger;
            Assert.assertEquals((String)expectedChangeFileTypeTrigger.getFileType(), (String)loadedChangeFileTypeTrigger.getFileType());
        } else if (expectedTrigger instanceof SetVisibleEnumerationItemTrigger) {
            SetVisibleEnumerationItemTrigger expectedSetVisibleEnumerationItemTrigger = (SetVisibleEnumerationItemTrigger)expectedTrigger;
            SetVisibleEnumerationItemTrigger loadedSetVisibleEnumerationItemTrigger = (SetVisibleEnumerationItemTrigger)loadedTrigger;
            Assert.assertEquals((String)expectedSetVisibleEnumerationItemTrigger.getItemId(), (String)loadedSetVisibleEnumerationItemTrigger.getItemId());
            Assert.assertEquals((boolean)expectedSetVisibleEnumerationItemTrigger.isVisible(), (boolean)loadedSetVisibleEnumerationItemTrigger.isVisible());
        } else if (expectedTrigger instanceof ChangeDefaultValueTrigger) {
            ChangeDefaultValueTrigger expectedChangeDefaultValueTrigger = (ChangeDefaultValueTrigger)expectedTrigger;
            ChangeDefaultValueTrigger loadedChangeDefaultValueTrigger = (ChangeDefaultValueTrigger)loadedTrigger;
            Assert.assertEquals((Object)expectedChangeDefaultValueTrigger.getDefaultValue(), (Object)loadedChangeDefaultValueTrigger.getDefaultValue());
        }
    }

    private static void assertExpressions(Set<ValidationExpression> expectedExpressions, Set<ValidationExpression> loadedExpressions) {
        Assert.assertNotNull(loadedExpressions);
        Assert.assertEquals((int)expectedExpressions.size(), (int)loadedExpressions.size());
        Iterator<ValidationExpression> expectedExpressionIterator = expectedExpressions.iterator();
        Iterator<ValidationExpression> loadedExpressionIterator = loadedExpressions.iterator();
        while (expectedExpressionIterator.hasNext()) {
            ValidationExpression expectedExpression = expectedExpressionIterator.next();
            ValidationExpression loadedExpression = loadedExpressionIterator.next();
            Assert.assertEquals((Object)expectedExpression, (Object)loadedExpression);
            Assert.assertEquals((String)expectedExpression.toString(), (String)loadedExpression.toString());
            Assert.assertEquals((String)expectedExpression.getErrorMessage(), (String)loadedExpression.getErrorMessage());
        }
    }

    private static void assertGroups(List<ParameterGroup> expectedGroups, List<ParameterGroup> loadedGroups) {
        Assert.assertNotNull(loadedGroups);
        Assert.assertEquals(expectedGroups, loadedGroups);
        Iterator<ParameterGroup> expectedGroupIterator = expectedGroups.iterator();
        Iterator<ParameterGroup> loadedGroupIterator = loadedGroups.iterator();
        while (expectedGroupIterator.hasNext()) {
            ParameterGroup expectedGroup = expectedGroupIterator.next();
            ParameterGroup loadedGroup = loadedGroupIterator.next();
            SimpleAlgorithmParserTest.assertGroups(expectedGroup, loadedGroup);
        }
    }

    private static void assertGroups(ParameterGroup expectedGroup, ParameterGroup loadedGroup) {
        Assert.assertEquals((Object)expectedGroup, (Object)loadedGroup);
        Assert.assertEquals((String)expectedGroup.getName(), (String)loadedGroup.getName());
        Assert.assertEquals((String)expectedGroup.getLabel(), (String)loadedGroup.getLabel());
        Assert.assertEquals((boolean)expectedGroup.isVisible(), (boolean)loadedGroup.isVisible());
        Assert.assertEquals((boolean)expectedGroup.isCollapsible(), (boolean)loadedGroup.isCollapsible());
        SimpleAlgorithmParserTest.assertParameters(expectedGroup.getParameters(), loadedGroup.getParameters());
    }

    private static void assertHiddenParameters(Set<HiddenParameter> expectedHiddenParameters, Set<HiddenParameter> loadedHiddenParameters) {
        Assert.assertEquals(expectedHiddenParameters, loadedHiddenParameters);
        for (HiddenParameter expectedHiddenParameter : expectedHiddenParameters) {
            for (HiddenParameter loadedHiddenParameter : loadedHiddenParameters) {
                if (!expectedHiddenParameter.equals((Object)loadedHiddenParameter)) continue;
                Assert.assertEquals((String)expectedHiddenParameter.getValue(), (String)loadedHiddenParameter.getValue());
                Assert.assertEquals((String)expectedHiddenParameter.getCommandLinePattern(), (String)loadedHiddenParameter.getCommandLinePattern());
            }
        }
    }

    private static void assertParameters(List<Parameter<?>> expectedParameters, List<Parameter<?>> loadedParameters) {
        Assert.assertNotNull(loadedParameters);
        Assert.assertEquals((int)expectedParameters.size(), (int)loadedParameters.size());
        Iterator<Parameter<?>> expectedParameterIterator = expectedParameters.iterator();
        Iterator<Parameter<?>> loadedParameterIterator = loadedParameters.iterator();
        while (expectedParameterIterator.hasNext()) {
            Parameter<?> expectedParameter = expectedParameterIterator.next();
            Parameter<?> loadedParameter = loadedParameterIterator.next();
            Assert.assertEquals(expectedParameter.getClass(), loadedParameter.getClass());
            if (expectedParameter instanceof SimpleParameter) {
                SimpleParameter expectedSimpleParameter = (SimpleParameter)expectedParameter;
                SimpleParameter loadedSimpleParameter = (SimpleParameter)loadedParameter;
                SimpleAlgorithmParserTest.assertSimpleParameters(expectedSimpleParameter, loadedSimpleParameter);
                continue;
            }
            if (expectedParameter instanceof ParameterGroup) {
                ParameterGroup expectedGroup = (ParameterGroup)expectedParameter;
                ParameterGroup loadedGroup = (ParameterGroup)loadedParameter;
                SimpleAlgorithmParserTest.assertGroups(expectedGroup, loadedGroup);
                continue;
            }
            Assert.fail((String)("Tipo de par\u00e2metro desconhecido.\nTipo: " + expectedParameter.getClass().getName()));
        }
    }

    private static void assertSimpleParameters(SimpleParameter<?> expectedParameter, SimpleParameter<?> loadedParameter) {
        Assert.assertEquals(expectedParameter.getClass(), loadedParameter.getClass());
        Assert.assertEquals(expectedParameter, loadedParameter);
        Assert.assertEquals((Object)expectedParameter.getDefaultValue(), (Object)loadedParameter.getDefaultValue());
        Assert.assertEquals((String)expectedParameter.getDescription(), (String)loadedParameter.getDescription());
        Assert.assertEquals((String)expectedParameter.getLabel(), (String)loadedParameter.getLabel());
        Assert.assertEquals((String)expectedParameter.getName(), (String)loadedParameter.getName());
        Assert.assertEquals((boolean)expectedParameter.isOptional(), (boolean)loadedParameter.isOptional());
        Assert.assertEquals((String)expectedParameter.getCommandLinePattern(), (String)loadedParameter.getCommandLinePattern());
        if (expectedParameter instanceof IntegerParameter) {
            IntegerParameter expectedIntegerParameter = (IntegerParameter)expectedParameter;
            IntegerParameter loadedIntegerParameter = (IntegerParameter)loadedParameter;
            Assert.assertEquals((Object)expectedIntegerParameter.getMaximum(), (Object)loadedIntegerParameter.getMaximum());
            Assert.assertEquals((Object)expectedIntegerParameter.getMinimum(), (Object)loadedIntegerParameter.getMinimum());
        } else if (expectedParameter instanceof DoubleParameter) {
            DoubleParameter expectedDoubleParameter = (DoubleParameter)expectedParameter;
            DoubleParameter loadedDoubleParameter = (DoubleParameter)loadedParameter;
            Assert.assertEquals((Object)expectedDoubleParameter.getMaximum(), (Object)loadedDoubleParameter.getMaximum());
            Assert.assertEquals((Object)expectedDoubleParameter.getMinimum(), (Object)loadedDoubleParameter.getMinimum());
            Assert.assertEquals((boolean)expectedDoubleParameter.isMaximumIncluded(), (boolean)loadedDoubleParameter.isMaximumIncluded());
            Assert.assertEquals((boolean)expectedDoubleParameter.isMinimumIncluded(), (boolean)loadedDoubleParameter.isMinimumIncluded());
        } else if (expectedParameter instanceof IntegerListParameter) {
            IntegerListParameter expectedIntegerParameter = (IntegerListParameter)expectedParameter;
            IntegerListParameter loadedIntegerParameter = (IntegerListParameter)loadedParameter;
            Assert.assertEquals((Object)expectedIntegerParameter.getMaximum(), (Object)loadedIntegerParameter.getMaximum());
            Assert.assertEquals((Object)expectedIntegerParameter.getMinimum(), (Object)loadedIntegerParameter.getMinimum());
        } else if (expectedParameter instanceof DoubleListParameter) {
            DoubleListParameter expectedDoubleParameter = (DoubleListParameter)expectedParameter;
            DoubleListParameter loadedDoubleParameter = (DoubleListParameter)loadedParameter;
            Assert.assertEquals((Object)expectedDoubleParameter.getMaximum(), (Object)loadedDoubleParameter.getMaximum());
            Assert.assertEquals((Object)expectedDoubleParameter.getMinimum(), (Object)loadedDoubleParameter.getMinimum());
            Assert.assertEquals((boolean)expectedDoubleParameter.isMaximumIncluded(), (boolean)loadedDoubleParameter.isMaximumIncluded());
            Assert.assertEquals((boolean)expectedDoubleParameter.isMinimumIncluded(), (boolean)loadedDoubleParameter.isMinimumIncluded());
        } else if (expectedParameter instanceof EnumerationParameter) {
            EnumerationParameter expectedEnumerationParameter = (EnumerationParameter)expectedParameter;
            EnumerationParameter loadedEnumerationParameter = (EnumerationParameter)loadedParameter;
            Assert.assertNotNull((Object)expectedEnumerationParameter.getItems());
            Assert.assertNotNull((Object)loadedEnumerationParameter.getItems());
            Assert.assertEquals((int)expectedEnumerationParameter.getItems().size(), (int)loadedEnumerationParameter.getItems().size());
        } else if (expectedParameter instanceof EnumerationListParameter) {
            EnumerationListParameter expectedEnumerationParameter = (EnumerationListParameter)expectedParameter;
            EnumerationListParameter loadedEnumerationParameter = (EnumerationListParameter)loadedParameter;
            Assert.assertNotNull((Object)expectedEnumerationParameter.getItems());
            Assert.assertNotNull((Object)loadedEnumerationParameter.getItems());
            Assert.assertEquals((int)expectedEnumerationParameter.getItems().size(), (int)loadedEnumerationParameter.getItems().size());
        } else if (expectedParameter instanceof TextParameter) {
            TextParameter expectedTextParameter = (TextParameter)expectedParameter;
            TextParameter loadedTextParameter = (TextParameter)loadedParameter;
            Assert.assertEquals((Object)expectedTextParameter.getMaxCharacters(), (Object)loadedTextParameter.getMaxCharacters());
        } else if (expectedParameter instanceof TextListParameter) {
            TextListParameter expectedTextListParameter = (TextListParameter)expectedParameter;
            TextListParameter loadedTextListParameter = (TextListParameter)loadedParameter;
            Assert.assertEquals((Object)expectedTextListParameter.getMaxCharacters(), (Object)loadedTextListParameter.getMaxCharacters());
        } else if (expectedParameter instanceof TableParameter) {
            TableParameter expectedTableParameter = (TableParameter)expectedParameter;
            TableParameter loadedTableParameter = (TableParameter)loadedParameter;
            Assert.assertEquals((boolean)expectedTableParameter.delimitRows(), (boolean)loadedTableParameter.delimitRows());
            Assert.assertEquals((boolean)expectedTableParameter.delimitTable(), (boolean)loadedTableParameter.delimitTable());
            SimpleAlgorithmParserTest.assertColumns(expectedTableParameter.getColumns(), loadedTableParameter.getColumns());
            Assert.assertEquals((int)expectedTableParameter.getRowCount(), (int)loadedTableParameter.getRowCount());
            int rowCount = expectedTableParameter.getRowCount();
            int columnCount = expectedTableParameter.getColumnCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                    Assert.assertEquals((Object)expectedTableParameter.getItemValue(rowIndex, columnIndex), (Object)loadedTableParameter.getItemValue(rowIndex, columnIndex));
                }
            }
        } else if (expectedParameter instanceof BooleanParameter) {
            BooleanParameter expectedBooleanParameter = (BooleanParameter)expectedParameter;
            BooleanParameter loadedBooleanParameter = (BooleanParameter)loadedParameter;
            Assert.assertEquals((String)expectedBooleanParameter.getFalseCommand(), (String)loadedBooleanParameter.getFalseCommand());
            Assert.assertEquals((String)expectedBooleanParameter.getTrueCommand(), (String)loadedBooleanParameter.getTrueCommand());
        } else if (expectedParameter instanceof FileParameter) {
            FileParameter expectedFileParameter = (FileParameter)expectedParameter;
            FileParameter loadedFileParameter = (FileParameter)loadedParameter;
            Assert.assertEquals((Object)expectedFileParameter.getMode(), (Object)loadedFileParameter.getMode());
            Assert.assertEquals((String)expectedFileParameter.getFileType(), (String)loadedFileParameter.getFileType());
            Assert.assertEquals((Object)expectedFileParameter.usesPipe(), (Object)loadedFileParameter.usesPipe());
            Assert.assertEquals((boolean)expectedFileParameter.usesFilter(), (boolean)loadedFileParameter.usesFilter());
            if (expectedParameter instanceof OutputFileParameter) {
                OutputFileParameter expectedOutputFileParameter = (OutputFileParameter)expectedParameter;
                OutputFileParameter loadedOutputFileParameter = (OutputFileParameter)loadedParameter;
                Assert.assertEquals((boolean)expectedOutputFileParameter.mustForceExtension(), (boolean)loadedOutputFileParameter.mustForceExtension());
            } else if (!(expectedParameter instanceof InputFileParameter)) {
                Assert.fail((String)("Tipo inesperado: " + expectedParameter.getClass().getName()));
            }
        } else if (expectedParameter instanceof InputFileListParameter) {
            InputFileListParameter expectedInputFileListParameter = (InputFileListParameter)expectedParameter;
            InputFileListParameter loadedInputFileListParameter = (InputFileListParameter)loadedParameter;
            Assert.assertEquals((String)expectedInputFileListParameter.getFileType(), (String)loadedInputFileListParameter.getFileType());
            Assert.assertEquals((Object)expectedInputFileListParameter.getMode(), (Object)loadedInputFileListParameter.getMode());
            Assert.assertEquals((boolean)expectedInputFileListParameter.mustSort(), (boolean)loadedInputFileListParameter.mustSort());
            Assert.assertEquals((boolean)expectedInputFileListParameter.usesFilter(), (boolean)loadedInputFileListParameter.usesFilter());
        } else if (expectedParameter instanceof OutputFileListParameter) {
            OutputFileListParameter expectedInputFileListParameter = (OutputFileListParameter)expectedParameter;
            OutputFileListParameter loadedInputFileListParameter = (OutputFileListParameter)loadedParameter;
            Assert.assertEquals((String)expectedInputFileListParameter.getFileType(), (String)loadedInputFileListParameter.getFileType());
            Assert.assertEquals((Object)expectedInputFileListParameter.getMode(), (Object)loadedInputFileListParameter.getMode());
            Assert.assertEquals((boolean)expectedInputFileListParameter.mustSort(), (boolean)loadedInputFileListParameter.mustSort());
            Assert.assertEquals((boolean)expectedInputFileListParameter.usesFilter(), (boolean)loadedInputFileListParameter.usesFilter());
            Assert.assertEquals((boolean)expectedInputFileListParameter.mustForceExtension(), (boolean)loadedInputFileListParameter.mustForceExtension());
        } else if (expectedParameter instanceof InputURLParameter) {
            InputURLParameter expectedFileParameter = (InputURLParameter)expectedParameter;
            InputURLParameter loadedFileParameter = (InputURLParameter)loadedParameter;
            Assert.assertEquals((boolean)expectedFileParameter.mustExist(), (boolean)loadedFileParameter.mustExist());
            Assert.assertEquals((Object)expectedFileParameter.getMode(), (Object)loadedFileParameter.getMode());
            Assert.assertEquals((String)expectedFileParameter.getLocalization(), (String)loadedFileParameter.getLocalization());
            Assert.assertEquals((String)expectedFileParameter.getFileType(), (String)loadedFileParameter.getFileType());
            Assert.assertEquals((Object)expectedFileParameter.getAllowedProtocols(), (Object)loadedFileParameter.getAllowedProtocols());
        } else if (expectedParameter instanceof OutputURLParameter) {
            OutputURLParameter expectedFileParameter = (OutputURLParameter)expectedParameter;
            OutputURLParameter loadedFileParameter = (OutputURLParameter)loadedParameter;
            Assert.assertEquals((boolean)expectedFileParameter.mustExist(), (boolean)loadedFileParameter.mustExist());
            Assert.assertEquals((Object)expectedFileParameter.getMode(), (Object)loadedFileParameter.getMode());
            Assert.assertEquals((String)expectedFileParameter.getLocalization(), (String)loadedFileParameter.getLocalization());
            Assert.assertEquals((String)expectedFileParameter.getFileType(), (String)loadedFileParameter.getFileType());
            Assert.assertEquals((Object)expectedFileParameter.getAllowedProtocols(), (Object)loadedFileParameter.getAllowedProtocols());
        } else if (expectedParameter instanceof InputURLListParameter) {
            InputURLListParameter expectedFileParameter = (InputURLListParameter)expectedParameter;
            InputURLListParameter loadedFileParameter = (InputURLListParameter)loadedParameter;
            Assert.assertEquals((boolean)expectedFileParameter.mustExist(), (boolean)loadedFileParameter.mustExist());
            Assert.assertEquals((Object)expectedFileParameter.getMode(), (Object)loadedFileParameter.getMode());
            Assert.assertEquals((String)expectedFileParameter.getLocalization(), (String)loadedFileParameter.getLocalization());
            Assert.assertEquals((String)expectedFileParameter.getFileType(), (String)loadedFileParameter.getFileType());
            Assert.assertEquals((Object)expectedFileParameter.getAllowedProtocols(), (Object)loadedFileParameter.getAllowedProtocols());
        } else if (expectedParameter instanceof OutputURLListParameter) {
            OutputURLListParameter expectedFileParameter = (OutputURLListParameter)expectedParameter;
            OutputURLListParameter loadedFileParameter = (OutputURLListParameter)loadedParameter;
            Assert.assertEquals((boolean)expectedFileParameter.mustExist(), (boolean)loadedFileParameter.mustExist());
            Assert.assertEquals((Object)expectedFileParameter.getMode(), (Object)loadedFileParameter.getMode());
            Assert.assertEquals((String)expectedFileParameter.getLocalization(), (String)loadedFileParameter.getLocalization());
            Assert.assertEquals((String)expectedFileParameter.getFileType(), (String)loadedFileParameter.getFileType());
            Assert.assertEquals((Object)expectedFileParameter.getAllowedProtocols(), (Object)loadedFileParameter.getAllowedProtocols());
        } else if (!(expectedParameter instanceof FormulaParameter)) {
            Assert.fail((String)("Tipo inesperado: " + expectedParameter.getClass().getName()));
        }
    }

    private static SimpleAlgorithmConfigurator loadXml(AlgorithmVersionInfo algorithmVersion, String xml) throws ParseException, IOException {
        return SimpleAlgorithmParserTest.loadXml(algorithmVersion, xml, SimpleAlgorithmParserTest.createReplacementMap(), SimpleAlgorithmParserTest.createParamMap());
    }

    private static SimpleAlgorithmConfigurator loadXml(AlgorithmVersionInfo algorithmVersion, String xml, Map<String, String> replacementMap, Map<String, String> paramProperties) throws ParseException {
        StringReader reader = new StringReader(xml);
        return new SimpleAlgorithmParser().load((Reader)reader, replacementMap, paramProperties, algorithmVersion, ExecutionLocation.BINARY_DIR, CMD_PATTERN);
    }

    private static HashMap<String, String> createParamMap() throws IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String propertiesFile = "AlgorithmParameters.properties";
        return SimpleAlgorithmParserTest.loadPropsToMap(paramMap, propertiesFile);
    }

    private static HashMap<String, String> loadPropsToMap(HashMap<String, String> paramMap, String propertiesFile) throws IOException, FileNotFoundException {
        InputStream inStream = AlgorithmService.class.getResourceAsStream(propertiesFile);
        if (inStream == null) {
            throw new FileNotFoundException("N\u00e3o foi poss\u00edvel encontrar o arquivo " + propertiesFile + ".");
        }
        Properties props = new Properties();
        props.load(inStream);
        SimpleAlgorithmParserTest.addPropertiesToMap(props, paramMap);
        inStream.close();
        return paramMap;
    }

    private static HashMap<String, String> createReplacementMap() throws IOException {
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        String propertiesFile = "AlgorithmParametersConfiguration.properties";
        return SimpleAlgorithmParserTest.loadPropsToMap(replacementMap, propertiesFile);
    }

    private static <K, V> void addPropertiesToMap(Properties properties, Map<K, V> map) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
    }
}

