/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.UI;

import csbase.client.facilities.configurabletable.UI.ORIENTATION;
import csbase.client.facilities.configurabletable.UI.SplitPane4Tables;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.model.AgeColumn;
import csbase.client.facilities.configurabletable.model.Community;
import csbase.client.facilities.configurabletable.model.CommunityNameColumn;
import csbase.client.facilities.configurabletable.model.NameColumn;
import csbase.client.facilities.configurabletable.model.NumberOfMembersColumn;
import csbase.client.facilities.configurabletable.model.Person;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;
import tecgraf.javautils.core.filter.IFilter;

public class SplitPane4TablesTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstrutorIdNull() {
        new SplitPane4Tables(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstrutorOrientationNull() {
        new SplitPane4Tables("pane1", null);
    }

    @Test
    public void testConstrutorSucess() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        Assert.assertEquals((String)"panel1", (String)panel.getId());
    }

    @Test
    public void testConvertOrientation() {
        Assert.assertTrue((SplitPane4Tables.convertOrientation(null) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((SplitPane4Tables.convertOrientation((ORIENTATION)ORIENTATION.vertical) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((SplitPane4Tables.convertOrientation((ORIENTATION)ORIENTATION.Vertical) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((SplitPane4Tables.convertOrientation((ORIENTATION)ORIENTATION.VERTICAL) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((1 == SplitPane4Tables.convertOrientation((ORIENTATION)ORIENTATION.horizontal) ? 1 : 0) != 0);
        Assert.assertTrue((1 == SplitPane4Tables.convertOrientation((ORIENTATION)ORIENTATION.Horizontal) ? 1 : 0) != 0);
        Assert.assertTrue((1 == SplitPane4Tables.convertOrientation((ORIENTATION)ORIENTATION.HORIZONTAL) ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddTableNullTable() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        panel.addTable(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddTableNullLabel() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddTableNullDataType() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label", null);
    }

    @Test
    public void testAddTableSucess() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label", Person.class);
        Assert.assertNotNull((Object)panel.getTableById("id"));
    }

    @Test(expected=RuntimeException.class)
    public void testAddthreeTables() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label1", Person.class);
        panel.addTable(table, "label2", Person.class);
        panel.addTable(table, "label3", Person.class);
    }

    @Test
    public void testGetTableByIdNullId() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label", Person.class);
        Assert.assertNull((Object)panel.getTableById(null));
    }

    @Test
    public void testGetTableByIdInexist() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label", Person.class);
        Assert.assertNull((Object)panel.getTableById("other"));
    }

    @Test
    public void testGetTableByIdSucess() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label", Person.class);
        Assert.assertNotNull((Object)panel.getTableById("id"));
    }

    @Test
    public void testGetTableByIdAndClassNullId() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label", Person.class);
        Assert.assertNull((Object)panel.getTableById(null, null));
    }

    @Test
    public void testGetTableByIdAndClassInexist() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label", Person.class);
        Assert.assertNull((Object)panel.getTableById("other", Person.class));
    }

    @Test
    public void testGetTableByIdAndClassRightIdWrongClass() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label", Person.class);
        Assert.assertNull((Object)panel.getTableById("id", String.class));
    }

    @Test
    public void testGetTableByIdAndClassSucess() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table = this.getConfigurableTable4Person();
        panel.addTable(table, "label", Person.class);
        Assert.assertNotNull((Object)panel.getTableById("id", Person.class));
    }

    @Test
    public void testGetAllTables() {
        SplitPane4Tables panel = new SplitPane4Tables("panel1", ORIENTATION.horizontal);
        ConfigurableTable<?> table1 = this.getConfigurableTable4Person();
        ConfigurableTable<?> table2 = this.getConfigurableTable4Community();
        Assert.assertTrue((panel.getAllTables().size() == 0 ? 1 : 0) != 0);
        panel.addTable(table1, "label1", Person.class);
        panel.addTable(table2, "label2", Community.class);
        Assert.assertTrue((panel.getAllTables().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((panel.getAllTables(Person.class).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((panel.getAllTables(Community.class).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((panel.getAllTables(String.class).size() == 0 ? 1 : 0) != 0);
    }

    private ConfigurableTable<?> getConfigurableTable4Person() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        IFilter<Person> filter = new IFilter<Person>(){

            public boolean accept(Person t) {
                return t.getAge() > 50;
            }
        };
        ConfigurableTable table = new ConfigurableTable("id", columns, (IFilter)filter);
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Silvio Berlusconi", 75));
        people.add(new Person("Fulano1", 30));
        table.updateRows(people);
        return table;
    }

    private ConfigurableTable<?> getConfigurableTable4Community() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new CommunityNameColumn("name", true, null, 0));
        columns.add(new NumberOfMembersColumn("number", true, null, 0));
        ConfigurableTable table = new ConfigurableTable("community", columns, null);
        ArrayList<Community> communities = new ArrayList<Community>();
        communities.add(new Community("CommunityA", new ArrayList<Person>()));
        communities.add(new Community("CommunityB", new ArrayList<Person>()));
        table.updateRows(communities);
        return table;
    }
}

