/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.table;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.column.IConfigurableColumn;
import csbase.client.facilities.configurabletable.model.AgeColumn;
import csbase.client.facilities.configurabletable.model.NameColumn;
import csbase.client.facilities.configurabletable.model.Person;
import csbase.client.facilities.configurabletable.table.ConfigurableTableModel;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import tecgraf.javautils.core.filter.IFilter;

public final class ConfigurableTableModelTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstrutorColumnsNull() {
        new ConfigurableTableModel(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstrutorEmptyColumns() {
        ArrayList columns = new ArrayList();
        new ConfigurableTableModel(columns, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstrutorNullRows() {
        ArrayList<AgeColumn> columns = new ArrayList<AgeColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        new ConfigurableTableModel(columns, null, null);
    }

    @Test
    public void testColumnsFromModel() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", false, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, new ArrayList());
        Assert.assertTrue((model.getColumns().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((model.getColumnCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((model.getAllColumns().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"name", (String)((IConfigurableColumn)model.getColumns().get(0)).getId());
        Assert.assertEquals((String)"age", (String)((IConfigurableColumn)model.getAllColumns().get(0)).getId());
        Assert.assertEquals((String)"name", (String)((IConfigurableColumn)model.getAllColumns().get(1)).getId());
        ((IConfigurableColumn)columns.get(1)).setVisible(false);
        model.fireTableStructureChanged();
        Assert.assertTrue((model.getColumns().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((model.getColumnCount() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((model.getAllColumns().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"age", (String)((IConfigurableColumn)model.getAllColumns().get(0)).getId());
        Assert.assertEquals((String)"name", (String)((IConfigurableColumn)model.getAllColumns().get(1)).getId());
    }

    @Test
    public void testRowsFromModel() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        IFilter<Person> filter = new IFilter<Person>(){

            public boolean accept(Person t) {
                return t.getAge() > 50;
            }
        };
        ConfigurableTableModel model = new ConfigurableTableModel(columns, (IFilter)filter, people);
        Assert.assertTrue((model.getRowCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((model.getAllRows().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Berlusconi", (String)((Person)model.getRow(0)).getName());
        Assert.assertTrue((((Person)model.getRow(0)).getAge() == 75 ? 1 : 0) != 0);
        model.setFilter(null);
        model.fireTableDataChanged();
        Assert.assertTrue((model.getRowCount() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((model.getAllRows().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Berlusconi", (String)((Person)model.getRow(0)).getName());
        Assert.assertTrue((((Person)model.getRow(0)).getAge() == 75 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Tiger", (String)((Person)model.getRow(1)).getName());
        Assert.assertTrue((((Person)model.getRow(1)).getAge() == 30 ? 1 : 0) != 0);
    }

    @Test
    public void testGetColumnNameAndClass() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, new ArrayList());
        Assert.assertTrue((model.getColumnCount() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Name", (String)model.getColumnName(1));
        Assert.assertEquals(Integer.class, (Object)model.getColumnClass(0));
        Assert.assertEquals((String)"Age", (String)model.getColumnName(0));
        Assert.assertEquals(String.class, (Object)model.getColumnClass(1));
        Assert.assertEquals((String)"Name", (String)model.getColumnName(1));
        ((IConfigurableColumn)model.getColumns().get(0)).setVisible(false);
        model.fireTableStructureChanged();
        Assert.assertTrue((model.getColumnCount() == 1 ? 1 : 0) != 0);
        Assert.assertEquals(String.class, (Object)model.getColumnClass(0));
        Assert.assertEquals((String)"Name", (String)model.getColumnName(0));
    }

    @Test(expected=RuntimeException.class)
    public void testGetValueAtInexistRowIndex() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.getValueAt(3, 0);
    }

    @Test(expected=RuntimeException.class)
    public void testGetValueAtInexistColumnIndex() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.getValueAt(0, 3);
    }

    @Test
    public void testGetValueAtSucess() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertEquals((Object)75, (Object)model.getValueAt(0, 0));
        Assert.assertEquals((Object)"Berlusconi", (Object)model.getValueAt(0, 1));
        Assert.assertEquals((Object)30, (Object)model.getValueAt(1, 0));
        Assert.assertEquals((Object)"Tiger", (Object)model.getValueAt(1, 1));
    }

    @Test(expected=RuntimeException.class)
    public void testSetValueAtInexistRowIndex() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.setValueAt((Object)"foo", 3, 0);
    }

    @Test(expected=RuntimeException.class)
    public void testSetValueAtInexistColumnIndex() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.setValueAt((Object)"foo", 0, 3);
    }

    @Test
    public void testSetValueAtSucess() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.setValueAt((Object)80, 0, 0);
        Assert.assertEquals((Object)80, (Object)model.getValueAt(0, 0));
        model.setValueAt((Object)"BB", 0, 1);
        Assert.assertEquals((Object)"BB", (Object)model.getValueAt(0, 1));
        model.setValueAt((Object)40, 1, 0);
        Assert.assertEquals((Object)40, (Object)model.getValueAt(1, 0));
        model.setValueAt((Object)"TT", 1, 1);
        Assert.assertEquals((Object)"TT", (Object)model.getValueAt(1, 1));
    }

    @Test(expected=RuntimeException.class)
    public void testIsCellEditableInexistRowIndex() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, new ArrayList());
        model.isCellEditable(3, 0);
    }

    @Test(expected=RuntimeException.class)
    public void testIsCellEditableInexistColumnIndex() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.isCellEditable(0, 3);
    }

    @Test
    public void testIsCellEditableSucess() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertTrue((boolean)model.isCellEditable(0, 0));
        Assert.assertTrue((boolean)model.isCellEditable(1, 0));
        Assert.assertFalse((boolean)model.isCellEditable(0, 1));
        Assert.assertFalse((boolean)model.isCellEditable(1, 1));
    }

    @Test
    public void testClear() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertTrue((model.getRowCount() == 2 ? 1 : 0) != 0);
        model.clear();
        Assert.assertTrue((model.getRowCount() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetRowsNullList() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertTrue((model.getRowCount() == 2 ? 1 : 0) != 0);
        model.setRows(null);
    }

    @Test
    public void testSetRowsEmptyList() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertTrue((model.getRowCount() == 2 ? 1 : 0) != 0);
        model.setRows(new ArrayList());
        Assert.assertTrue((model.getRowCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetRowsSucess() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertTrue((model.getRowCount() == 2 ? 1 : 0) != 0);
        ArrayList<Person> newPeople = new ArrayList<Person>();
        newPeople.add(new Person("Fulano1", 20));
        newPeople.add(new Person("Fulano2", 30));
        newPeople.add(new Person("Fulano3", 40));
        model.setRows(newPeople);
        Assert.assertTrue((model.getRowCount() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Fulano1", (String)((Person)model.getRows().get(0)).getName());
        Assert.assertTrue((((Person)model.getRow(0)).getAge() == 20 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Fulano2", (String)((Person)model.getRows().get(1)).getName());
        Assert.assertTrue((((Person)model.getRow(1)).getAge() == 30 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Fulano3", (String)((Person)model.getRows().get(2)).getName());
        Assert.assertTrue((((Person)model.getRow(2)).getAge() == 40 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullElement() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.add(null);
    }

    @Test
    public void testAddElementAlreadyInTable() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        ((Person)people.get(0)).setAge(80);
        model.add((Object)((Person)people.get(0)));
        Assert.assertTrue((model.getRowCount() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Berlusconi", (String)((Person)model.getRows().get(0)).getName());
        Assert.assertTrue((((Person)model.getRow(0)).getAge() == 80 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Tiger", (String)((Person)model.getRows().get(1)).getName());
        Assert.assertTrue((((Person)model.getRow(1)).getAge() == 30 ? 1 : 0) != 0);
    }

    @Test
    public void testAddSucess() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.add((Object)new Person("Patrick", 40));
        Assert.assertTrue((model.getRowCount() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Berlusconi", (String)((Person)model.getRows().get(0)).getName());
        Assert.assertTrue((((Person)model.getRow(0)).getAge() == 75 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Tiger", (String)((Person)model.getRows().get(1)).getName());
        Assert.assertTrue((((Person)model.getRow(1)).getAge() == 30 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Patrick", (String)((Person)model.getRows().get(2)).getName());
        Assert.assertTrue((((Person)model.getRow(2)).getAge() == 40 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddAllNullParameter() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.addAll(null);
    }

    @Test
    public void testAddAllEmptyList() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertTrue((model.getRowCount() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Berlusconi", (String)((Person)model.getRows().get(0)).getName());
        Assert.assertTrue((((Person)model.getRow(0)).getAge() == 75 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Tiger", (String)((Person)model.getRows().get(1)).getName());
        Assert.assertTrue((((Person)model.getRow(1)).getAge() == 30 ? 1 : 0) != 0);
        model.addAll(new ArrayList());
        Assert.assertTrue((model.getRowCount() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Berlusconi", (String)((Person)model.getRows().get(0)).getName());
        Assert.assertTrue((((Person)model.getRow(0)).getAge() == 75 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Tiger", (String)((Person)model.getRows().get(1)).getName());
        Assert.assertTrue((((Person)model.getRow(1)).getAge() == 30 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveNullParameter() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.remove(null);
    }

    @Test
    public void testRemoveElementNotInTable() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertFalse((boolean)model.remove((Object)new Person("Fulano", 50)));
    }

    @Test
    public void testRemoveSucess() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertTrue((boolean)model.remove((Object)((Person)people.get(0))));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveIndexOutOfBounds() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.remove(5);
    }

    @Test
    public void testRemoveIndexSucess() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Person removed = (Person)model.remove(0);
        Assert.assertEquals((String)"Berlusconi", (String)removed.getName());
        Assert.assertTrue((removed.getAge() == 75 ? 1 : 0) != 0);
        Assert.assertTrue((model.getRowCount() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Tiger", (String)((Person)model.getRow(0)).getName());
        Assert.assertTrue((((Person)model.getRow(0)).getAge() == 30 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveAllNullParameter() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.removeAll(null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveAllIndexOutOfBounds() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        int[] indexes = new int[]{2, 5, 10};
        model.removeAll(indexes);
    }

    @Test
    public void testRemoveAllSucess() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        people.add(new Person("Fulano", 50));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        int[] nArray = new int[2];
        nArray[1] = 2;
        int[] indexes = nArray;
        List removed = (List)model.removeAll(indexes);
        Assert.assertTrue((removed.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Berlusconi", (String)((Person)removed.get(0)).getName());
        Assert.assertTrue((((Person)removed.get(0)).getAge() == 75 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Fulano", (String)((Person)removed.get(1)).getName());
        Assert.assertTrue((((Person)removed.get(1)).getAge() == 50 ? 1 : 0) != 0);
        Assert.assertTrue((model.getRowCount() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Tiger", (String)((Person)model.getRow(0)).getName());
        Assert.assertTrue((((Person)model.getRow(0)).getAge() == 30 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetColumnByIdNull() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        model.getColumnById(null);
    }

    @Test
    public void testGetColumnByIdInexist() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertNull((Object)model.getColumnById("nickname"));
    }

    @Test
    public void testGetColumnByIdSucess() {
        ArrayList<AbstractConfigurableColumn> columns = new ArrayList<AbstractConfigurableColumn>();
        columns.add(new AgeColumn("age", true, null, 0));
        columns.add(new NameColumn("name", true, null, 0));
        ArrayList<Person> people = new ArrayList<Person>();
        people.add(new Person("Berlusconi", 75));
        people.add(new Person("Tiger", 30));
        ConfigurableTableModel model = new ConfigurableTableModel(columns, null, people);
        Assert.assertNotNull((Object)model.getColumnById("age"));
        Assert.assertTrue((boolean)model.getColumnById("age").isVisible());
        Assert.assertTrue((model.getColumnById("age").getAlign() == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)model.getColumnById("name"));
        Assert.assertTrue((boolean)model.getColumnById("name").isVisible());
        Assert.assertTrue((model.getColumnById("name").getAlign() == 0 ? 1 : 0) != 0);
    }
}

