/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ProgressData;
import csbase.logic.ProgressDataParser;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProgressDataParserTest {
    private ProgressDataParser parser;
    private static final String PROGRESS_KEY = "progresso";

    @Before
    public void setup() {
        this.parser = new ProgressDataParser();
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleCommentedProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "10/20 # Passo 10");
        hashMap.put("progresso.2", "4/4 # Terminou");
        hashMap.put("progresso.3", "3/10 # Lendo arquivo");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)60.0, (Object)progress.getValue());
        Assert.assertEquals((String)"60%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleCommentedProgressInfoAndNoValue() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "10/20 # Passo 10");
        hashMap.put("progresso.2", "4/4 # Terminou");
        hashMap.put("progresso.3", "# Lendo arquivo");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleDescriptiveProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "10/20");
        hashMap.put("progresso.2", "4/4");
        hashMap.put("progresso.3", "3/10");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)60.0, (Object)progress.getValue());
        Assert.assertEquals((String)"60%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleEmptyData() {
        ProgressData progress = this.parser.extractOverallProgressData(new HashMap(), 5);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleInvalidDescriptiveProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "10/20");
        hashMap.put("progresso.2", "4/4");
        hashMap.put("progresso.3", "8/5");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleInvalidDescriptiveProgressInfo2() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "10/20");
        hashMap.put("progresso.2", "4/0");
        hashMap.put("progresso.3", "8/");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleInvalidNumericProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "1");
        hashMap.put("progresso.2", "0.2");
        hashMap.put("progresso.3", "3");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleInvalidPercentageProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "100%");
        hashMap.put("progresso.2", "20%");
        hashMap.put("progresso.3", "300%");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleNullData() {
        ProgressData progress = this.parser.extractOverallProgressData(null, 5);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleNumericProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "1");
        hashMap.put("progresso.2", "0.2");
        hashMap.put("progresso.3", "0.3");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)50.0, (Object)progress.getValue());
        Assert.assertEquals((String)"50%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleProgressInfoWithNonSequentialKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.3", "1");
        hashMap.put("progresso.9", "0.5");
        hashMap.put("progresso.16", "0.3");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)60.0, (Object)progress.getValue());
        Assert.assertEquals((String)"60%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithMultiplePercentageProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "100%");
        hashMap.put("progresso.2", "20%");
        hashMap.put("progresso.3", "30%");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)50.0, (Object)progress.getValue());
        Assert.assertEquals((String)"50%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleProgressInfoValueTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "10/20 # Passo 10");
        hashMap.put("progresso.2", "100%");
        hashMap.put("progresso.3", "0.6# Lendo arquivo");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)70.0, (Object)progress.getValue());
        Assert.assertEquals((String)"70%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleProgressInfoWithOtherKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "10/20 # Passo 10");
        hashMap.put("progresso.2", "100%");
        hashMap.put("progresso.3", "0.6# Lendo arquivo");
        hashMap.put("OTHER_KEY", "VALOR");
        hashMap.put("progresso_2", "100%");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)70.0, (Object)progress.getValue());
        Assert.assertEquals((String)"70%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleProgressInfoWithSingleKey() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "60%");
        hashMap.put("progresso.1", "Primeiro passo");
        hashMap.put("progresso.2", "Segundo passo");
        hashMap.put("progresso.3", "Terceiro passo");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)60.0, (Object)progress.getValue());
        Assert.assertEquals((String)"60%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithMultipleTextualProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "Primeiro passo");
        hashMap.put("progresso.2", "Segundo passo");
        hashMap.put("progresso.3", "Terceiro passo");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 3);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithSingleCommentedProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "1/4 # Primeiro passo");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)25.0, (Object)progress.getValue());
        Assert.assertEquals((String)"Primeiro passo", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSingleCommentedProgressInfoAndNoValue() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "# Primeiro passo");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)Double.NaN, (Object)progress.getValue());
        Assert.assertEquals((String)"Primeiro passo", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSingleDescriptiveProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "10/20");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)50.0, (Object)progress.getValue());
        Assert.assertEquals((String)"10/20", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSingleEmptyData() {
        ProgressData progress = this.parser.extractOverallProgressData(new HashMap(), 1);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithSingleInvalidDescriptiveProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "8/5");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)Double.NaN, (Object)progress.getValue());
        Assert.assertEquals((String)"8/5", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSingleInvalidDescriptiveProgressInfo2() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "4/");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)Double.NaN, (Object)progress.getValue());
        Assert.assertEquals((String)"4/", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSingleInvalidNumericProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "10");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)Double.NaN, (Object)progress.getValue());
        Assert.assertEquals((String)"10", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSingleInvalidPercentageProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "300%");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)Double.NaN, (Object)progress.getValue());
        Assert.assertEquals((String)"300%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSingleNullData() {
        ProgressData progress = this.parser.extractOverallProgressData(null, 1);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithSingleNumericProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "0.3");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)30.0, (Object)progress.getValue());
        Assert.assertEquals((String)"0.3", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSinglePercentageProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "10%");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)10.0, (Object)progress.getValue());
        Assert.assertEquals((String)"10%", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSingleProgressInfoWithMultipleKey() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "Primeiro passo");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNull((Object)progress);
    }

    @Test
    public void testExtractOverallProgressDataWithSingleProgressInfoWithOtherKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "10/20 # Passo 10");
        hashMap.put("OTHER_KEY", "VALOR");
        hashMap.put("AND_OTHER_KEY.2", "100%");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)50.0, (Object)progress.getValue());
        Assert.assertEquals((String)"Passo 10", (String)progress.getDescription());
    }

    @Test
    public void testExtractOverallProgressDataWithSingleTextualProgressInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "Primeiro passo");
        ProgressData progress = this.parser.extractOverallProgressData(hashMap, 1);
        Assert.assertNotNull((Object)progress);
        Assert.assertEquals((Object)Double.NaN, (Object)progress.getValue());
        Assert.assertEquals((String)"Primeiro passo", (String)progress.getDescription());
    }

    @Test
    public void testExtractProgressDataMapWithNullData() {
        Map progressMap = this.parser.extractProgressDataMap(null);
        Assert.assertNotNull((Object)progressMap);
        Assert.assertTrue((boolean)progressMap.isEmpty());
    }

    @Test
    public void testExtractProgressDataMapWithEmptyData() {
        Map progressMap = this.parser.extractProgressDataMap(new HashMap());
        Assert.assertNotNull((Object)progressMap);
        Assert.assertTrue((boolean)progressMap.isEmpty());
    }

    @Test
    public void testExtractProgressDataMapWithSingleDataKey() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROGRESS_KEY, "10/20 # Passo 10");
        Map progressMap = this.parser.extractProgressDataMap(hashMap);
        Assert.assertNotNull((Object)progressMap);
        Assert.assertTrue((boolean)progressMap.isEmpty());
    }

    @Test
    public void testExtractProgressDataMapWithSingleData() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.7", "10/20 # Passo 10");
        Map progressMap = this.parser.extractProgressDataMap(hashMap);
        Assert.assertNotNull((Object)progressMap);
        Assert.assertEquals((int)1, (int)progressMap.size());
        Assert.assertTrue((boolean)progressMap.containsKey(7));
        ProgressData progress = (ProgressData)progressMap.get(7);
        Assert.assertEquals((Object)50.0, (Object)progress.getValue());
        Assert.assertEquals((String)"Passo 10", (String)progress.getDescription());
    }

    @Test
    public void testExtractProgressDataMapWithMultipleData() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.1", "10/20 # Passo 10");
        hashMap.put("progresso.2", "100%");
        hashMap.put("progresso.3", "0.6# Lendo arquivo");
        Map progressMap = this.parser.extractProgressDataMap(hashMap);
        Assert.assertNotNull((Object)progressMap);
        Assert.assertEquals((int)3, (int)progressMap.size());
        Assert.assertTrue((boolean)progressMap.containsKey(1));
        Assert.assertTrue((boolean)progressMap.containsKey(2));
        Assert.assertTrue((boolean)progressMap.containsKey(3));
        ProgressData progressData1 = (ProgressData)progressMap.get(1);
        ProgressData progressData2 = (ProgressData)progressMap.get(2);
        ProgressData progressData3 = (ProgressData)progressMap.get(3);
        Assert.assertNotNull((Object)progressData1);
        Assert.assertNotNull((Object)progressData2);
        Assert.assertNotNull((Object)progressData3);
        Assert.assertEquals((Object)50.0, (Object)progressData1.getValue());
        Assert.assertEquals((String)"Passo 10", (String)progressData1.getDescription());
        Assert.assertEquals((Object)100.0, (Object)progressData2.getValue());
        Assert.assertEquals((String)"100%", (String)progressData2.getDescription());
        Assert.assertEquals((Object)60.0, (Object)progressData3.getValue());
        Assert.assertEquals((String)"Lendo arquivo", (String)progressData3.getDescription());
    }

    @Test
    public void testExtractProgressDataMapWithMultipleDataWithNonSequentialKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("progresso.3", "10/20 # Passo 10");
        hashMap.put("progresso.9", "100%");
        hashMap.put("progresso.16", "0.6# Lendo arquivo");
        Map progressMap = this.parser.extractProgressDataMap(hashMap);
        Assert.assertNotNull((Object)progressMap);
        Assert.assertEquals((int)3, (int)progressMap.size());
        Assert.assertTrue((boolean)progressMap.containsKey(3));
        Assert.assertTrue((boolean)progressMap.containsKey(9));
        Assert.assertTrue((boolean)progressMap.containsKey(16));
        ProgressData progressData3 = (ProgressData)progressMap.get(3);
        ProgressData progressData9 = (ProgressData)progressMap.get(9);
        ProgressData progressData16 = (ProgressData)progressMap.get(16);
        Assert.assertNotNull((Object)progressData3);
        Assert.assertNotNull((Object)progressData9);
        Assert.assertNotNull((Object)progressData16);
        Assert.assertEquals((Object)50.0, (Object)progressData3.getValue());
        Assert.assertEquals((String)"Passo 10", (String)progressData3.getDescription());
        Assert.assertEquals((Object)100.0, (Object)progressData9.getValue());
        Assert.assertEquals((String)"100%", (String)progressData9.getDescription());
        Assert.assertEquals((Object)60.0, (Object)progressData16.getValue());
        Assert.assertEquals((String)"Lendo arquivo", (String)progressData16.getDescription());
    }

    @Test
    public void testExtractProgressDataMapWithMultipleDataWithOtherKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OTHER_KEY", "VALOR");
        hashMap.put("progresso.1", "10/20 # Passo 10");
        hashMap.put("OTHER_KEY.2", "0.5");
        hashMap.put("progresso.2", "0.6# Lendo arquivo");
        hashMap.put("progresso_2", "100%");
        Map progressMap = this.parser.extractProgressDataMap(hashMap);
        Assert.assertNotNull((Object)progressMap);
        Assert.assertEquals((int)2, (int)progressMap.size());
        Assert.assertTrue((boolean)progressMap.containsKey(1));
        Assert.assertTrue((boolean)progressMap.containsKey(2));
        ProgressData progressData1 = (ProgressData)progressMap.get(1);
        ProgressData progressData2 = (ProgressData)progressMap.get(2);
        Assert.assertNotNull((Object)progressData1);
        Assert.assertNotNull((Object)progressData2);
        Assert.assertEquals((Object)50.0, (Object)progressData1.getValue());
        Assert.assertEquals((String)"Passo 10", (String)progressData1.getDescription());
        Assert.assertEquals((Object)60.0, (Object)progressData2.getValue());
        Assert.assertEquals((String)"Lendo arquivo", (String)progressData2.getDescription());
    }
}

