/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionIdTest;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.MockAlgorithmConfigurator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import junit.framework.TestCase;

public final class AlgorithmConfiguratorTest
extends TestCase {
    public void testAlgorithmConfigurator1() {
        AlgorithmInfo algorithm = AlgorithmConfiguratorTest.createAlgorithm("Nome do algoritmo");
        AlgorithmVersionId id = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersion = new AlgorithmVersionInfo(algorithm, id, new Hashtable(), new Hashtable());
        String description = "Descri\u00e7\u00e3o da vers\u00e3o";
        ExecutionType executionType = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = "Abreviatura da vers\u00e3o";
        boolean provideId = false;
        MockAlgorithmConfigurator configurator = new MockAlgorithmConfigurator(algorithmVersion, description, executionType, executionLocation, abbreviation, provideId);
        this.assertConfigurator(algorithm, id, description, executionType, abbreviation, provideId, configurator);
    }

    public void testAlgorithmConfigurator2() {
        AlgorithmInfo algorithm = AlgorithmConfiguratorTest.createAlgorithm("Nome do algoritmo");
        AlgorithmVersionId id = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersion = new AlgorithmVersionInfo(algorithm, id, new Hashtable(), new Hashtable());
        String description = "Descri\u00e7\u00e3o da vers\u00e3o";
        ExecutionType executionType = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = "Abreviatura da vers\u00e3o";
        boolean provideId = true;
        MockAlgorithmConfigurator configurator = new MockAlgorithmConfigurator(algorithmVersion, description, executionType, executionLocation, abbreviation, provideId);
        this.assertConfigurator(algorithm, id, description, executionType, abbreviation, provideId, configurator);
    }

    public void testAlgorithmConfigurator3() {
        AlgorithmInfo algorithm = AlgorithmConfiguratorTest.createAlgorithm("Nome do algoritmo");
        AlgorithmVersionId id = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersion = new AlgorithmVersionInfo(algorithm, id, new Hashtable(), new Hashtable());
        String description = "Descri\u00e7\u00e3o da vers\u00e3o";
        ExecutionType executionType = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = null;
        boolean provideId = false;
        MockAlgorithmConfigurator configurator = new MockAlgorithmConfigurator(algorithmVersion, description, executionType, executionLocation, abbreviation, provideId);
        this.assertConfigurator(algorithm, id, description, executionType, abbreviation, provideId, configurator);
    }

    public void testAlgorithmConfigurator4() {
        AlgorithmVersionInfo algorithmVersion = null;
        String description = "Descri\u00e7\u00e3o da vers\u00e3o";
        ExecutionType executionType = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = "Abreviatura da vers\u00e3o";
        boolean provideId = false;
        try {
            new MockAlgorithmConfigurator(algorithmVersion, description, executionType, executionLocation, abbreviation, provideId);
            AlgorithmConfiguratorTest.fail((String)"Esperada IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAlgorithmConfigurator5() {
        AlgorithmInfo algorithm = AlgorithmConfiguratorTest.createAlgorithm("Algoritmo");
        AlgorithmVersionId id = AlgorithmVersionIdTest.create();
        AlgorithmVersionInfo algorithmVersion = new AlgorithmVersionInfo(algorithm, id, new Hashtable(), new Hashtable());
        String description = null;
        ExecutionType executionType = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = "Abreviatura da vers\u00e3o";
        boolean provideId = false;
        MockAlgorithmConfigurator configurator = new MockAlgorithmConfigurator(algorithmVersion, description, executionType, executionLocation, abbreviation, provideId);
        this.assertConfigurator(algorithm, id, description, executionType, abbreviation, provideId, configurator);
    }

    public void testAlgorithmConfigurator6() {
        try {
            new MockAlgorithmConfigurator(AlgorithmConfiguratorTest.createAlgorithmVersion(1, 2, 3), "Descri\u00e7\u00e3o da vers\u00e3o", null, null, "Abreviatura da vers\u00e3o", false);
            AlgorithmConfiguratorTest.fail((String)"Esperada IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEquals1() {
        AlgorithmVersionInfo algorithmVersion = AlgorithmConfiguratorTest.createAlgorithmVersion(1, 2, 3);
        String description1 = "Descri\u00e7\u00e3o da vers\u00e3o 1";
        ExecutionType executionType1 = ExecutionType.MULTIPLE;
        ExecutionLocation executionLocation1 = ExecutionLocation.PERSISTENCY_DIR;
        String abbreviation1 = "Abreviatura 1";
        boolean provideId1 = true;
        MockAlgorithmConfigurator configurator1 = new MockAlgorithmConfigurator(algorithmVersion, description1, executionType1, executionLocation1, abbreviation1, provideId1);
        String description2 = "Descri\u00e7\u00e3o da vers\u00e3o 2";
        ExecutionType executionType2 = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation2 = ExecutionLocation.SANDBOX;
        String abbreviation2 = "Abreviatura 2";
        boolean provideId2 = false;
        MockAlgorithmConfigurator configurator2 = new MockAlgorithmConfigurator(algorithmVersion, description2, executionType2, executionLocation2, abbreviation2, provideId2);
        AlgorithmConfiguratorTest.assertTrue((boolean)configurator1.equals((Object)configurator2));
    }

    public void testEquals2() {
        String filePath = "diretorio/arquivo.xml";
        String description1 = "Descri\u00e7\u00e3o da vers\u00e3o 1";
        ExecutionType executionType1 = ExecutionType.MULTIPLE;
        ExecutionLocation executionLocation1 = ExecutionLocation.PERSISTENCY_DIR;
        String abbreviation1 = "Abreviatura 1";
        boolean provideId1 = true;
        MockAlgorithmConfigurator configurator1 = new MockAlgorithmConfigurator(filePath, description1, executionType1, executionLocation1, abbreviation1, provideId1);
        String description2 = "Descri\u00e7\u00e3o da vers\u00e3o 2";
        ExecutionType executionType2 = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation2 = ExecutionLocation.SANDBOX;
        String abbreviation2 = "Abreviatura 2";
        boolean provideId2 = false;
        MockAlgorithmConfigurator configurator2 = new MockAlgorithmConfigurator(filePath, description2, executionType2, executionLocation2, abbreviation2, provideId2);
        AlgorithmConfiguratorTest.assertTrue((boolean)configurator1.equals((Object)configurator2));
    }

    public void testEquals3() {
        AlgorithmVersionInfo algorithmVersion1 = AlgorithmConfiguratorTest.createAlgorithmVersion(1, 1, 1);
        String description = "Descri\u00e7\u00e3o da vers\u00e3o 1";
        ExecutionType executionType = ExecutionType.MULTIPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = "Abreviatura 1";
        boolean provideId = true;
        MockAlgorithmConfigurator configurator1 = new MockAlgorithmConfigurator(algorithmVersion1, description, executionType, executionLocation, abbreviation, provideId);
        AlgorithmVersionInfo algorithmVersion2 = AlgorithmConfiguratorTest.createAlgorithmVersion(2, 2, 2);
        MockAlgorithmConfigurator configurator2 = new MockAlgorithmConfigurator(algorithmVersion2, description, executionType, executionLocation, abbreviation, provideId);
        AlgorithmConfiguratorTest.assertFalse((boolean)configurator1.equals((Object)configurator2));
    }

    public void testEquals4() {
        String filePath1 = "diretorio/arquivo1.xml";
        String description = "Descri\u00e7\u00e3o da vers\u00e3o 1";
        ExecutionType executionType = ExecutionType.MULTIPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = "Abreviatura 1";
        boolean provideId = true;
        MockAlgorithmConfigurator configurator1 = new MockAlgorithmConfigurator(filePath1, description, executionType, executionLocation, abbreviation, provideId);
        String filePath2 = "diretorio/arquivo2.xml";
        MockAlgorithmConfigurator configurator2 = new MockAlgorithmConfigurator(filePath2, description, executionType, executionLocation, abbreviation, provideId);
        AlgorithmConfiguratorTest.assertFalse((boolean)configurator1.equals((Object)configurator2));
    }

    public void testEquals5() {
        String filePath = "diretorio/arquivo.xml";
        String description = "Descri\u00e7\u00e3o do vers\u00e3o";
        ExecutionType executionType = ExecutionType.MULTIPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = "Abreviatura";
        boolean provideId = false;
        MockAlgorithmConfigurator configurator1 = new MockAlgorithmConfigurator(filePath, description, executionType, executionLocation, abbreviation, provideId);
        AlgorithmConfiguratorTest.assertFalse((boolean)configurator1.equals(null));
    }

    public void testEquals6() {
        String filePath = "diretorio/arquivo.xml";
        String description = "Descri\u00e7\u00e3o do vers\u00e3o";
        ExecutionType executionType = ExecutionType.MULTIPLE;
        ExecutionLocation executionLocation = ExecutionLocation.BINARY_DIR;
        String abbreviation = "Abreviatura";
        boolean provideId = false;
        MockAlgorithmConfigurator configurator1 = new MockAlgorithmConfigurator(filePath, description, executionType, executionLocation, abbreviation, provideId);
        AlgorithmConfiguratorTest.assertFalse((boolean)configurator1.equals("Objeto de outra classe"));
    }

    public void testHashCode1() {
        AlgorithmVersionInfo algorithmVersion = AlgorithmConfiguratorTest.createAlgorithmVersion(1, 2, 3);
        String description1 = "Descri\u00e7\u00e3o da vers\u00e3o 1";
        ExecutionType executionType1 = ExecutionType.MULTIPLE;
        ExecutionLocation executionLocation1 = ExecutionLocation.BINARY_DIR;
        String abbreviation1 = "Abreviatura 1";
        boolean provideId1 = true;
        MockAlgorithmConfigurator configurator1 = new MockAlgorithmConfigurator(algorithmVersion, description1, executionType1, executionLocation1, abbreviation1, provideId1);
        String description2 = "Descri\u00e7\u00e3o da vers\u00e3o 2";
        ExecutionType executionType2 = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation2 = ExecutionLocation.SANDBOX;
        String abbreviation2 = "Abreviatura 2";
        boolean provideId2 = false;
        MockAlgorithmConfigurator configurator2 = new MockAlgorithmConfigurator(algorithmVersion, description2, executionType2, executionLocation2, abbreviation2, provideId2);
        AlgorithmConfiguratorTest.assertEquals((int)configurator1.hashCode(), (int)configurator2.hashCode());
    }

    public void testHashCode2() {
        String filePath = "diretorio/arquivo.xml";
        String description1 = "Descri\u00e7\u00e3o da vers\u00e3o 1";
        ExecutionType executionType1 = ExecutionType.MULTIPLE;
        ExecutionLocation executionLocation1 = ExecutionLocation.PERSISTENCY_DIR;
        String abbreviation1 = "Abreviatura 1";
        boolean provideId1 = true;
        MockAlgorithmConfigurator configurator1 = new MockAlgorithmConfigurator(filePath, description1, executionType1, executionLocation1, abbreviation1, provideId1);
        String description2 = "Descri\u00e7\u00e3o da vers\u00e3o 2";
        ExecutionType executionType2 = ExecutionType.SIMPLE;
        ExecutionLocation executionLocation2 = ExecutionLocation.BINARY_DIR;
        String abbreviation2 = "Abreviatura 2";
        boolean provideId2 = false;
        MockAlgorithmConfigurator configurator2 = new MockAlgorithmConfigurator(filePath, description2, executionType2, executionLocation2, abbreviation2, provideId2);
        AlgorithmConfiguratorTest.assertEquals((int)configurator1.hashCode(), (int)configurator2.hashCode());
    }

    public void testToString1() {
        String name = "Nome do algoritmo";
        AlgorithmVersionId versionId = AlgorithmVersionIdTest.create();
        AlgorithmConfigurator configurator = AlgorithmConfiguratorTest.createConfigurator(AlgorithmConfiguratorTest.createAlgorithm(name), versionId);
        AlgorithmConfiguratorTest.assertNotNull((Object)configurator.toString());
        String toString = String.valueOf(name) + " (" + versionId + ")";
        AlgorithmConfiguratorTest.assertEquals((String)toString, (String)configurator.toString());
    }

    public void testToString2() {
        String name = "config.xml";
        AlgorithmConfigurator configurator = AlgorithmConfiguratorTest.createConfigurator(name);
        AlgorithmConfiguratorTest.assertNotNull((Object)configurator.toString());
        AlgorithmConfiguratorTest.assertEquals((String)"", (String)configurator.toString());
    }

    public void testAddAlgorithmConfiguratorListener2() {
        AlgorithmVersionInfo version = AlgorithmConfiguratorTest.createAlgorithmVersion(3, 2, 1);
        MockAlgorithmConfigurator configurator = new MockAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false);
        try {
            configurator.addAlgorithmConfiguratorListener(null);
            AlgorithmConfiguratorTest.fail((String)"Esperada IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSerialize1() throws IOException, ClassNotFoundException {
        AlgorithmVersionInfo algorithmVersion = AlgorithmConfiguratorTest.createAlgorithmVersion(1, 2, 3);
        String description = "Descri\u00e7\u00e3o do algoritmo";
        String abbreviation = "Abreviatura do algoritmo";
        boolean provideId = true;
        MockAlgorithmConfigurator expectedVersion = new MockAlgorithmConfigurator(algorithmVersion, description, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, abbreviation, provideId);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject((Object)expectedVersion);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        AlgorithmConfigurator loadedVersion = (AlgorithmConfigurator)objectInput.readObject();
        AlgorithmConfiguratorTest.assertEquals((String)expectedVersion.getAbbreviation(), (String)loadedVersion.getAbbreviation());
        AlgorithmConfiguratorTest.assertEquals((Object)expectedVersion.getAlgorithmVersion(), (Object)loadedVersion.getAlgorithmVersion());
        AlgorithmConfiguratorTest.assertEquals((String)expectedVersion.getDescription(), (String)loadedVersion.getDescription());
        AlgorithmConfiguratorTest.assertSame((Object)expectedVersion.getExecutionType(), (Object)loadedVersion.getExecutionType());
        AlgorithmConfiguratorTest.assertEquals((boolean)expectedVersion.provideId(), (boolean)loadedVersion.provideId());
    }

    private static AlgorithmInfo createAlgorithm(String algorithmName) {
        return new AlgorithmInfo("ID " + algorithmName, algorithmName, "diret\u00f3rio", "algorithms", new Hashtable());
    }

    private static AlgorithmVersionInfo createAlgorithmVersion(int major, int minor, int patch) {
        AlgorithmInfo algorithm = AlgorithmConfiguratorTest.createAlgorithm("Algoritmo");
        AlgorithmVersionId versionId = new AlgorithmVersionId(major, minor, patch);
        return new AlgorithmVersionInfo(algorithm, versionId, new Hashtable(), new Hashtable());
    }

    private static AlgorithmConfigurator createConfigurator(String filePath) {
        return new MockAlgorithmConfigurator(filePath, "Descri\u00e7\u00e3o da vers\u00e3o", ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false);
    }

    private static AlgorithmConfigurator createConfigurator(AlgorithmInfo algorithm, AlgorithmVersionId versionId) {
        AlgorithmVersionInfo algorithmVersion = new AlgorithmVersionInfo(algorithm, versionId, new Hashtable(), new Hashtable());
        return new MockAlgorithmConfigurator(algorithmVersion, "Descri\u00e7\u00e3o da vers\u00e3o", ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false);
    }

    private void assertConfigurator(AlgorithmInfo algorithm, AlgorithmVersionId id, String description, ExecutionType executionType, String abbreviation, boolean provideId, AlgorithmConfigurator configurator) {
        AlgorithmConfiguratorTest.assertEquals((Object)algorithm, (Object)configurator.getAlgorithmVersion().getInfo());
        AlgorithmConfiguratorTest.assertEquals((Object)id, (Object)configurator.getAlgorithmVersion().getId());
        this.assertConfigurator(description, executionType, abbreviation, provideId, configurator);
    }

    private void assertConfigurator(String description, ExecutionType executionType, String abbreviation, boolean provideId, AlgorithmConfigurator configurator) {
        AlgorithmConfiguratorTest.assertEquals((String)description, (String)configurator.getDescription());
        AlgorithmConfiguratorTest.assertEquals((Object)executionType, (Object)configurator.getExecutionType());
        AlgorithmConfiguratorTest.assertEquals((String)abbreviation, (String)configurator.getAbbreviation());
        AlgorithmConfiguratorTest.assertEquals((boolean)provideId, (boolean)configurator.provideId());
    }
}

