/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows;

import csbase.exception.ConfigurationException;
import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowAlgorithmParser;
import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.LinkParameter;
import csbase.logic.algorithms.flows.NodeParameter;
import csbase.logic.algorithms.flows.Point;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.MockAlgorithmService;
import java.util.HashSet;
import java.util.LinkedList;
import junit.framework.TestCase;

public final class FlowAlgorithmParserTest
extends TestCase {
    static {
        ClientRemoteLocator.algorithmService = new MockAlgorithmService();
    }

    public void testReadEmptyFlow() throws ParseException, OperationFailureException {
        Flow expectedFlow = new Flow(null, null, new HashSet(), new HashSet());
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadFlowWithName() throws ParseException, OperationFailureException {
        String name = "Nome do Fluxo";
        Flow expectedFlow = new Flow(name, null, new HashSet(), new HashSet());
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo nome = '" + name + "'>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadFlowWithDescription() throws ParseException, OperationFailureException {
        String description = "Descri\u00e7\u00e3o do Fluxo";
        Flow expectedFlow = new Flow(null, description, new HashSet(), new HashSet());
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo descricao = '" + description + "'>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadSingleNodeFlow() throws ParseException, OperationFailureException {
        int nodeId = 1;
        String algorithmName = "Nome do algoritmo";
        String name = "Nome do fluxo";
        String description = "Descri\u00e7\u00e3o do fluxo";
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(11, 22, 33);
        HashSet parameters = new HashSet();
        int x = 10;
        int y = 20;
        int width = 30;
        int height = 40;
        FlowNode node = new FlowNode(nodeId, algorithmName, algorithmVersionId, parameters, x, y, width, height);
        HashSet<FlowNode> nodes = new HashSet<FlowNode>();
        nodes.add(node);
        Flow expectedFlow = new Flow(name, description, nodes, new HashSet());
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo nome = '" + name + "' descricao = '" + description + "'>\n";
        text = String.valueOf(text) + "<no id = '" + nodeId + "'>\n";
        text = String.valueOf(text) + "<algoritmo nome = '" + algorithmName + "' versao = '" + algorithmVersionId + "'/>\n";
        text = String.valueOf(text) + "<ponto x = '" + x + "' y = '" + y + "'/>\n";
        text = String.valueOf(text) + "<tamanho altura = '" + height + "' largura = '" + width + "'/>\n";
        text = String.valueOf(text) + "</no>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadSingleNodeSingleParameterFlow() throws ParseException, OperationFailureException {
        int nodeId = 1;
        String algorithmName = "Nome do algoritmo";
        String description = "Descri\u00e7\u00e3o do fluxo";
        String name = "Nome do fluxo";
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(11, 22, 33);
        HashSet<NodeParameter> parameters = new HashSet<NodeParameter>();
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterType = "Tipo do par\u00e2metro";
        NodeParameter parameter = new NodeParameter(parameterName, parameterLabel, parameterType, null);
        parameters.add(parameter);
        int x = 10;
        int y = 20;
        int width = 30;
        int height = 40;
        FlowNode node = new FlowNode(nodeId, algorithmName, algorithmVersionId, parameters, x, y, width, height);
        HashSet<FlowNode> nodes = new HashSet<FlowNode>();
        nodes.add(node);
        Flow expectedFlow = new Flow(name, description, nodes, new HashSet());
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo nome = '" + name + "' descricao = '" + description + "'>\n";
        text = String.valueOf(text) + "<no id = '" + nodeId + "'>\n";
        text = String.valueOf(text) + "<algoritmo nome = '" + algorithmName + "' versao = '" + algorithmVersionId + "'>\n";
        text = String.valueOf(text) + "<parametro nome = '" + parameterName + "' rotulo = '" + parameterLabel + "' tipo = '" + parameterType + "'/>";
        text = String.valueOf(text) + "</algoritmo>\n";
        text = String.valueOf(text) + "<ponto x = '" + x + "' y = '" + y + "'/>\n";
        text = String.valueOf(text) + "<tamanho altura = '" + height + "' largura = '" + width + "'/>\n";
        text = String.valueOf(text) + "</no>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadSingleNodeSingleParameterWithAttributeValueFlow() throws ParseException, OperationFailureException {
        int nodeId = 1;
        String algorithmName = "Nome do algoritmo";
        String description = "Descri\u00e7\u00e3o do fluxo";
        String name = "Nome do fluxo";
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(11, 22, 33);
        HashSet<NodeParameter> parameters = new HashSet<NodeParameter>();
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterType = "Tipo do par\u00e2metro";
        String parameterValue = "Valor do par\u00e2metro";
        NodeParameter parameter = new NodeParameter(parameterName, parameterLabel, parameterType, parameterValue);
        parameters.add(parameter);
        int x = 10;
        int y = 20;
        int width = 30;
        int height = 40;
        FlowNode node = new FlowNode(nodeId, algorithmName, algorithmVersionId, parameters, x, y, width, height);
        HashSet<FlowNode> nodes = new HashSet<FlowNode>();
        nodes.add(node);
        Flow expectedFlow = new Flow(name, description, nodes, new HashSet());
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo nome = '" + name + "' descricao = '" + description + "'>\n";
        text = String.valueOf(text) + "<no id = '" + nodeId + "'>\n";
        text = String.valueOf(text) + "<algoritmo nome = '" + algorithmName + "' versao = '" + algorithmVersionId + "'>\n";
        text = String.valueOf(text) + "<parametro nome = '" + parameterName + "' rotulo = '" + parameterLabel + "' tipo = '" + parameterType + "' valor='" + parameterValue + "'/>";
        text = String.valueOf(text) + "</algoritmo>\n";
        text = String.valueOf(text) + "<ponto x = '" + x + "' y = '" + y + "'/>\n";
        text = String.valueOf(text) + "<tamanho altura = '" + height + "' largura = '" + width + "'/>\n";
        text = String.valueOf(text) + "</no>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadSingleNodeSingleParameterWithElementValueFlow() throws ParseException, OperationFailureException {
        int nodeId = 1;
        String algorithmName = "Nome do algoritmo";
        String name = "Nome do fluxo";
        String description = "Descri\u00e7\u00e3o do fluxo";
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(11, 22, 33);
        HashSet<NodeParameter> parameters = new HashSet<NodeParameter>();
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterType = "Tipo do par\u00e2metro";
        String parameterValue = "Valor do par\u00e2metro";
        NodeParameter parameter = new NodeParameter(parameterName, parameterLabel, parameterType, parameterValue);
        parameters.add(parameter);
        int x = 10;
        int y = 20;
        int width = 30;
        int height = 40;
        FlowNode node = new FlowNode(nodeId, algorithmName, algorithmVersionId, parameters, x, y, width, height);
        HashSet<FlowNode> nodes = new HashSet<FlowNode>();
        nodes.add(node);
        Flow expectedFlow = new Flow(name, description, nodes, new HashSet());
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo nome = '" + name + "' descricao = '" + description + "'>\n";
        text = String.valueOf(text) + "<no id = '" + nodeId + "'>\n";
        text = String.valueOf(text) + "<algoritmo nome = '" + algorithmName + "' versao = '" + algorithmVersionId + "'>\n";
        text = String.valueOf(text) + "<parametro nome = '" + parameterName + "' rotulo = '" + parameterLabel + "' tipo = '" + parameterType + "'>\n";
        text = String.valueOf(text) + "<valor>\n";
        text = String.valueOf(text) + "<![CDATA[" + parameterValue + "]]>";
        text = String.valueOf(text) + "</valor>\n";
        text = String.valueOf(text) + "</parametro>\n";
        text = String.valueOf(text) + "</algoritmo>\n";
        text = String.valueOf(text) + "<ponto x = '" + x + "' y = '" + y + "'/>\n";
        text = String.valueOf(text) + "<tamanho altura = '" + height + "' largura = '" + width + "'/>\n";
        text = String.valueOf(text) + "</no>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadInvalidLinkFlow() throws ParseException, OperationFailureException {
        HashSet nodes = new HashSet();
        HashSet links = new HashSet();
        int id = 1;
        Flow expectedFlow = new Flow(null, null, nodes, links);
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo>\n";
        text = String.valueOf(text) + "<conexao id = '" + id + "'/>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadLinkWithConnectedOutputFlow() throws ParseException, OperationFailureException {
        HashSet nodes = new HashSet();
        HashSet links = new HashSet();
        int id = 1;
        int nodeId = 2;
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        Flow expectedFlow = new Flow(null, null, nodes, links);
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo>\n";
        text = String.valueOf(text) + "<conexao id = '" + id + "'>\n";
        text = String.valueOf(text) + "<saida no='" + nodeId + "' parametro='" + parameterName + "' rotulo='" + parameterLabel + "'/>\n";
        text = String.valueOf(text) + "</conexao>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadLinkWithConnectedIntputFlow() throws ParseException, OperationFailureException {
        HashSet nodes = new HashSet();
        HashSet links = new HashSet();
        int id = 1;
        int nodeId = 2;
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        Flow expectedFlow = new Flow(null, null, nodes, links);
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo>\n";
        text = String.valueOf(text) + "<conexao id = '" + id + "'>\n";
        text = String.valueOf(text) + "<entrada no='" + nodeId + "' parametro='" + parameterName + "' rotulo='" + parameterLabel + "'/>\n";
        text = String.valueOf(text) + "</conexao>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testReadLinkWithPointsFlow() throws ParseException, OperationFailureException {
        int id = 1;
        HashSet nodes = new HashSet();
        HashSet links = new HashSet();
        LinkedList<Point> points = new LinkedList<Point>();
        int x1 = 11;
        int y1 = 111;
        points.add(new Point(x1, y1));
        int x2 = 22;
        int y2 = 222;
        points.add(new Point(x2, y2));
        Flow expectedFlow = new Flow(null, null, nodes, links);
        String text = "";
        text = String.valueOf(text) + "<?xml version='1.0' encoding='iso8859-1'?>\n";
        text = String.valueOf(text) + "<fluxo>\n";
        text = String.valueOf(text) + "<conexao id = '" + id + "'>\n";
        text = String.valueOf(text) + "<ponto x='" + x1 + "' y='" + y1 + "'/>\n";
        text = String.valueOf(text) + "<ponto x='" + x2 + "' y='" + y2 + "'/>\n";
        text = String.valueOf(text) + "</conexao>\n";
        text = String.valueOf(text) + "</fluxo>\n";
        this.checkDecodingFlow(text, expectedFlow);
    }

    public void testWriteEmptyFlow() throws ParseException, OperationFailureException {
        Flow expectedFlow = new Flow(null, null, new HashSet(), new HashSet());
        this.checkEncodingFlow(expectedFlow, expectedFlow);
    }

    public void testWriteSingleNodeFlow() throws ParseException, OperationFailureException {
        int nodeId = 1;
        String algorithmName = "Nome do algoritmo";
        String description = "Descri\u00e7\u00e3o do fluxo";
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(11, 22, 33);
        HashSet parameters = new HashSet();
        int x = 10;
        int y = 20;
        int width = 30;
        int height = 40;
        FlowNode node = new FlowNode(nodeId, algorithmName, algorithmVersionId, parameters, x, y, width, height);
        HashSet<FlowNode> nodes = new HashSet<FlowNode>();
        nodes.add(node);
        Flow expectedFlow = new Flow(algorithmName, description, nodes, new HashSet());
        this.checkEncodingFlow(expectedFlow, expectedFlow);
    }

    public void testWriteSingleNodeSingleParameterFlow() throws ParseException, OperationFailureException {
        int nodeId = 1;
        String algorithmName = "Nome do algoritmo";
        String description = "Descri\u00e7\u00e3o do fluxo";
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(11, 22, 33);
        HashSet<NodeParameter> parameters = new HashSet<NodeParameter>();
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterType = "Tipo do par\u00e2metro";
        NodeParameter parameter = new NodeParameter(parameterName, parameterLabel, parameterType, null);
        parameters.add(parameter);
        int x = 10;
        int y = 20;
        int width = 30;
        int height = 40;
        FlowNode node = new FlowNode(nodeId, algorithmName, algorithmVersionId, parameters, x, y, width, height);
        HashSet<FlowNode> nodes = new HashSet<FlowNode>();
        nodes.add(node);
        Flow expectedFlow = new Flow(algorithmName, description, nodes, new HashSet());
        this.checkEncodingFlow(expectedFlow, expectedFlow);
    }

    public void testWriteSingleNodeSingleParameterWithAttributeValueFlow() throws ParseException, OperationFailureException {
        int nodeId = 1;
        String algorithmName = "Nome do algoritmo";
        String description = "Descri\u00e7\u00e3o do fluxo";
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(11, 22, 33);
        HashSet<NodeParameter> parameters = new HashSet<NodeParameter>();
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterType = "Tipo do par\u00e2metro";
        String parameterValue = "Valor do par\u00e2metro";
        NodeParameter parameter = new NodeParameter(parameterName, parameterLabel, parameterType, parameterValue);
        parameters.add(parameter);
        int x = 10;
        int y = 20;
        int width = 30;
        int height = 40;
        FlowNode node = new FlowNode(nodeId, algorithmName, algorithmVersionId, parameters, x, y, width, height);
        HashSet<FlowNode> nodes = new HashSet<FlowNode>();
        nodes.add(node);
        Flow expectedFlow = new Flow(algorithmName, description, nodes, new HashSet());
        this.checkEncodingFlow(expectedFlow, expectedFlow);
    }

    public void testWriteLinkFlow() throws ParseException, OperationFailureException {
        HashSet nodes = new HashSet();
        HashSet<FlowLink> links = new HashSet<FlowLink>();
        int id = 1;
        FlowLink link = new FlowLink(id, null, null, new LinkedList());
        links.add(link);
        Flow originalFlow = new Flow(null, null, nodes, links);
        Flow expectedFlow = new Flow(null, null, nodes, new HashSet());
        this.checkEncodingFlow(originalFlow, expectedFlow);
    }

    public void testWriteLinkConnectedOutputFlow() throws ParseException, OperationFailureException {
        HashSet nodes = new HashSet();
        HashSet<FlowLink> links = new HashSet<FlowLink>();
        int id = 1;
        int nodeId = 2;
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        LinkParameter linkParameter = new LinkParameter(nodeId, parameterName, parameterLabel);
        FlowLink link = new FlowLink(id, linkParameter, null, new LinkedList());
        links.add(link);
        Flow originalFlow = new Flow(null, null, nodes, links);
        Flow expectedFlow = new Flow(null, null, nodes, new HashSet());
        this.checkEncodingFlow(originalFlow, expectedFlow);
    }

    public void testWriteLinkConnectedInputFlow() throws ParseException, OperationFailureException {
        HashSet nodes = new HashSet();
        HashSet<FlowLink> links = new HashSet<FlowLink>();
        int id = 1;
        int nodeId = 2;
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        LinkParameter linkParameter = new LinkParameter(nodeId, parameterName, parameterLabel);
        FlowLink link = new FlowLink(id, null, linkParameter, new LinkedList());
        links.add(link);
        Flow originalFlow = new Flow(null, null, nodes, links);
        Flow expectedFlow = new Flow(null, null, nodes, new HashSet());
        this.checkEncodingFlow(originalFlow, expectedFlow);
    }

    public void testWriteLinkWithPoinsFlow() throws ParseException, OperationFailureException {
        int id = 1;
        HashSet nodes = new HashSet();
        HashSet<FlowLink> links = new HashSet<FlowLink>();
        LinkedList<Point> points = new LinkedList<Point>();
        int x1 = 11;
        int y1 = 111;
        points.add(new Point(x1, y1));
        int x2 = 22;
        int y2 = 222;
        points.add(new Point(x2, y2));
        FlowLink link = new FlowLink(id, null, null, points);
        links.add(link);
        Flow originalFlow = new Flow(null, null, nodes, links);
        Flow expectedFlow = new Flow(null, null, nodes, new HashSet());
        this.checkEncodingFlow(originalFlow, expectedFlow);
    }

    private void assertFlows(Flow expectedFlow, Flow foundFlow) {
        FlowAlgorithmParserTest.assertEquals((String)expectedFlow.getName(), (String)foundFlow.getName());
        FlowAlgorithmParserTest.assertEquals((String)expectedFlow.getDescription(), (String)foundFlow.getDescription());
        FlowAlgorithmParserTest.assertEquals((Object)expectedFlow.getLinks(), (Object)foundFlow.getLinks());
        this.assertLinks(expectedFlow, foundFlow);
        this.assertNodes(expectedFlow, foundFlow);
    }

    private void assertLink(FlowLink expectedLink, FlowLink foundLink) {
        FlowAlgorithmParserTest.assertEquals((int)expectedLink.getId(), (int)foundLink.getId());
        this.assertLinkParameters(expectedLink.getInput(), foundLink.getInput());
        this.assertLinkParameters(expectedLink.getOutput(), foundLink.getOutput());
        FlowAlgorithmParserTest.assertEquals((Object)expectedLink.getPoints(), (Object)foundLink.getPoints());
    }

    private void assertLinkParameters(LinkParameter expectedParameter, LinkParameter foundParameter) {
        FlowAlgorithmParserTest.assertEquals((Object)expectedParameter, (Object)foundParameter);
        if (expectedParameter != null && foundParameter != null) {
            FlowAlgorithmParserTest.assertEquals((int)expectedParameter.getNodeId(), (int)foundParameter.getNodeId());
            FlowAlgorithmParserTest.assertEquals((String)expectedParameter.getName(), (String)foundParameter.getName());
            FlowAlgorithmParserTest.assertEquals((String)expectedParameter.getLabel(), (String)foundParameter.getLabel());
        }
    }

    private void assertLinks(Flow expectedFlow, Flow foundFlow) {
        for (FlowLink expectedLink : expectedFlow.getLinks()) {
            for (FlowLink foundLink : foundFlow.getLinks()) {
                if (!expectedLink.equals((Object)foundLink)) continue;
                this.assertLink(expectedLink, foundLink);
            }
        }
    }

    private void assertNodeParameters(FlowNode expectedNode, FlowNode foundNode) {
        FlowAlgorithmParserTest.assertEquals((Object)expectedNode.getParameters(), (Object)foundNode.getParameters());
        for (NodeParameter expectedNodeParameter : expectedNode.getParameters()) {
            for (NodeParameter foundNodeParameter : foundNode.getParameters()) {
                FlowAlgorithmParserTest.assertEquals((String)expectedNodeParameter.getName(), (String)foundNodeParameter.getName());
                FlowAlgorithmParserTest.assertEquals((String)expectedNodeParameter.getLabel(), (String)foundNodeParameter.getLabel());
                FlowAlgorithmParserTest.assertEquals((String)expectedNodeParameter.getType(), (String)foundNodeParameter.getType());
                FlowAlgorithmParserTest.assertEquals((String)expectedNodeParameter.getValue(), (String)foundNodeParameter.getValue());
            }
        }
    }

    private void assertNodes(Flow expectedFlow, Flow foundFlow) {
        FlowAlgorithmParserTest.assertEquals((Object)expectedFlow.getNodes(), (Object)foundFlow.getNodes());
        for (FlowNode expectedNode : expectedFlow.getNodes()) {
            for (FlowNode foundNode : foundFlow.getNodes()) {
                if (!expectedNode.equals((Object)foundNode)) continue;
                this.assertNodes(expectedNode, foundNode);
            }
        }
    }

    private void assertNodes(FlowNode expectedNode, FlowNode foundNode) {
        FlowAlgorithmParserTest.assertEquals((int)expectedNode.getId(), (int)foundNode.getId());
        FlowAlgorithmParserTest.assertEquals((String)expectedNode.getAlgorithmName(), (String)foundNode.getAlgorithmName());
        FlowAlgorithmParserTest.assertEquals((Object)expectedNode.getAlgorithmVersionId(), (Object)foundNode.getAlgorithmVersionId());
        this.assertNodeParameters(expectedNode, foundNode);
        FlowAlgorithmParserTest.assertEquals((int)expectedNode.getX(), (int)foundNode.getX());
        FlowAlgorithmParserTest.assertEquals((int)expectedNode.getY(), (int)foundNode.getY());
        FlowAlgorithmParserTest.assertEquals((int)expectedNode.getWidth(), (int)foundNode.getWidth());
        FlowAlgorithmParserTest.assertEquals((int)expectedNode.getHeight(), (int)foundNode.getHeight());
    }

    private void checkDecodingFlow(String text, Flow flow) throws ParseException, OperationFailureException {
        Flow foundFlow = this.decodeFlow(text);
        this.assertFlows(flow, foundFlow);
    }

    private void checkEncodingFlow(Flow originalFlow, Flow expectedFlow) throws ParseException, OperationFailureException {
        String text = this.encodeFlow(originalFlow);
        Flow foundFlow = this.decodeFlow(text);
        this.assertFlows(expectedFlow, foundFlow);
    }

    private Flow decodeFlow(String text) throws ConfigurationException, ParseException, OperationFailureException {
        FlowAlgorithmParser parser = new FlowAlgorithmParser();
        Flow foundFlow = parser.decode(text);
        return foundFlow;
    }

    private String encodeFlow(Flow flow) throws ConfigurationException {
        FlowAlgorithmParser parser = new FlowAlgorithmParser();
        return parser.encode(flow);
    }
}

