/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;

public final class BooleanParameterTest {
    @Test
    public void testBooleanParameter() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        String falseCommand = "FALSO";
        String trueCommand = "VERDADEIRO";
        BooleanParameter parameter = new BooleanParameter(name, label, description, defaultValue, true, commandLinePattern, falseCommand, trueCommand);
        Assert.assertNotNull((String)"O nome do par\u00e2metro n\u00e3o deveria ser nulo.", (Object)parameter.getName());
        Assert.assertEquals((String)"O nome do par\u00e2metro n\u00e3o \u00e9 igual ao nome esperado.", (Object)name, (Object)parameter.getName());
        Assert.assertNotNull((String)"A descri\u00e7\u00e3o do par\u00e2metro n\u00e3o deveria ser nula.", (Object)parameter.getDescription());
        Assert.assertEquals((String)"A descri\u00e7\u00e3o do par\u00e2metro n\u00e3o \u00e9 igual \u00e0 descri\u00e7\u00e3o esperada.", (Object)description, (Object)parameter.getDescription());
        Assert.assertNotNull((String)"O r\u00f3tulo do par\u00e2metro n\u00e3o deveria ser nulo.", (Object)parameter.getLabel());
        Assert.assertEquals((String)"O r\u00f3tulo do par\u00e2metro n\u00e3o \u00e9 igual ao r\u00f3tulo esperado.", (Object)label, (Object)parameter.getLabel());
        Assert.assertNotNull((String)"O valor-padr\u00e3o n\u00e3o deveria ser nulo.", (Object)parameter.getDefaultValue());
        Assert.assertEquals((String)"O valor-padr\u00e3o deveria n\u00e3o \u00e9 igual ao esperado.", (Object)new Boolean(defaultValue), (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals((Object)trueCommand, (Object)parameter.getTrueCommand());
        Assert.assertEquals((Object)falseCommand, (Object)parameter.getFalseCommand());
        Assert.assertFalse((boolean)parameter.isOptional());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBooleanParameterWithNullName() {
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        String falseCommand = "FALSO";
        String trueCommand = "VERDADEIRO";
        new BooleanParameter(null, label, description, defaultValue, true, commandLinePattern, falseCommand, trueCommand);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBooleanParameterWithNullLabel() {
        String name = "Nome do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        String falseCommand = "FALSO";
        String trueCommand = "VERDADEIRO";
        new BooleanParameter(name, null, description, defaultValue, true, commandLinePattern, falseCommand, trueCommand);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBooleanParameterWithNullDescription() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        String falseCommand = "FALSO";
        String trueCommand = "VERDADEIRO";
        new BooleanParameter(name, label, null, defaultValue, true, commandLinePattern, falseCommand, trueCommand);
    }

    @Test
    public void testBooleanParameterWithNullFalseCommand() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        String trueCommand = "VERDADEIRO";
        BooleanParameter parameter = new BooleanParameter(name, label, description, defaultValue, true, commandLinePattern, null, trueCommand);
        Assert.assertNotNull((String)"O nome do par\u00e2metro n\u00e3o deveria ser nulo.", (Object)parameter.getName());
        Assert.assertEquals((String)"O nome do par\u00e2metro n\u00e3o \u00e9 igual ao nome esperado.", (Object)name, (Object)parameter.getName());
        Assert.assertNotNull((String)"A descri\u00e7\u00e3o do par\u00e2metro n\u00e3o deveria ser nula.", (Object)parameter.getDescription());
        Assert.assertEquals((String)"A descri\u00e7\u00e3o do par\u00e2metro n\u00e3o \u00e9 igual \u00e0 descri\u00e7\u00e3o esperada.", (Object)description, (Object)parameter.getDescription());
        Assert.assertNotNull((String)"O r\u00f3tulo do par\u00e2metro n\u00e3o deveria ser nulo.", (Object)parameter.getLabel());
        Assert.assertEquals((String)"O r\u00f3tulo do par\u00e2metro n\u00e3o \u00e9 igual ao r\u00f3tulo esperado.", (Object)label, (Object)parameter.getLabel());
        Assert.assertNotNull((String)"O valor-padr\u00e3o n\u00e3o deveria ser nulo.", (Object)parameter.getDefaultValue());
        Assert.assertEquals((String)"O valor-padr\u00e3o deveria n\u00e3o \u00e9 igual ao esperado.", (Object)new Boolean(defaultValue), (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals((Object)trueCommand, (Object)parameter.getTrueCommand());
        Assert.assertEquals((Object)"0", (Object)parameter.getFalseCommand());
        Assert.assertFalse((boolean)parameter.isOptional());
    }

    @Test
    public void testBooleanParameterWithNullTrueCommand() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        String falseCommand = "FALSO";
        BooleanParameter parameter = new BooleanParameter(name, label, description, defaultValue, true, commandLinePattern, falseCommand, null);
        Assert.assertNotNull((String)"O nome do par\u00e2metro n\u00e3o deveria ser nulo.", (Object)parameter.getName());
        Assert.assertEquals((String)"O nome do par\u00e2metro n\u00e3o \u00e9 igual ao nome esperado.", (Object)name, (Object)parameter.getName());
        Assert.assertNotNull((String)"A descri\u00e7\u00e3o do par\u00e2metro n\u00e3o deveria ser nula.", (Object)parameter.getDescription());
        Assert.assertEquals((String)"A descri\u00e7\u00e3o do par\u00e2metro n\u00e3o \u00e9 igual \u00e0 descri\u00e7\u00e3o esperada.", (Object)description, (Object)parameter.getDescription());
        Assert.assertNotNull((String)"O r\u00f3tulo do par\u00e2metro n\u00e3o deveria ser nulo.", (Object)parameter.getLabel());
        Assert.assertEquals((String)"O r\u00f3tulo do par\u00e2metro n\u00e3o \u00e9 igual ao r\u00f3tulo esperado.", (Object)label, (Object)parameter.getLabel());
        Assert.assertNotNull((String)"O valor-padr\u00e3o n\u00e3o deveria ser nulo.", (Object)parameter.getDefaultValue());
        Assert.assertEquals((String)"O valor-padr\u00e3o deveria n\u00e3o \u00e9 igual ao esperado.", (Object)new Boolean(defaultValue), (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)"1", (Object)parameter.getTrueCommand());
        Assert.assertEquals((Object)falseCommand, (Object)parameter.getFalseCommand());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertFalse((boolean)parameter.isOptional());
    }

    @Test
    public void testGetValueAsText() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] defaultValues = blArray;
        String commandLinePattern = "{0}={1}";
        String[] textValues = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
        int i = 0;
        while (i < defaultValues.length) {
            BooleanParameter parameter = new BooleanParameter(name, label, description, defaultValues[i], true, commandLinePattern, null, null);
            Assert.assertEquals((Object)textValues[i], (Object)parameter.getValueAsText());
            ++i;
        }
    }

    @Test
    public void testSetValueAsText() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        BooleanParameter parameter = new BooleanParameter(name, label, description, defaultValue, true, commandLinePattern, null, null);
        parameter.setValueAsText(Boolean.TRUE.toString());
        Assert.assertEquals((Object)new Boolean(true), (Object)parameter.getValue());
        parameter.setValueAsText(Boolean.FALSE.toString());
        Assert.assertEquals((Object)new Boolean(false), (Object)parameter.getValue());
    }

    @Test(expected=ParseException.class)
    public void testSetValueAsTextWithIllegalTextValue() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        BooleanParameter parameter = new BooleanParameter(name, label, description, defaultValue, true, commandLinePattern, null, null);
        parameter.setValueAsText("Valor inv\u00e1lido.");
    }

    @Test
    public void testSetValueAsTextWithNullValue() throws ParseException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        BooleanParameter parameter = new BooleanParameter(name, label, description, defaultValue, true, commandLinePattern, null, null);
        Assert.assertEquals((Object)new Boolean(defaultValue), (Object)parameter.getValue());
        parameter.setValue((Object)new Boolean(!defaultValue));
        Assert.assertEquals((Object)new Boolean(!defaultValue), (Object)parameter.getValue());
        parameter.setValueAsText(null);
        Assert.assertEquals((Object)new Boolean(defaultValue), (Object)parameter.getValue());
    }

    @Test
    public void testGetCommandValueWithFalseValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String falseCommand = "Comando falso";
        String trueCommand = "Comando verdadeiro";
        boolean defaultValue = false;
        String commandLinePattern = "{0}={1}";
        BooleanParameter parameter = new BooleanParameter(name, label, description, defaultValue, true, commandLinePattern, falseCommand, trueCommand);
        Assert.assertEquals((Object)falseCommand, (Object)parameter.getCommandValue(null));
    }

    @Test
    public void testGetCommandValueWithTrueValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String falseCommand = "Comando falso";
        String trueCommand = "Comando verdadeiro";
        boolean defaultValue = true;
        String commandLinePattern = "{0}={1}";
        BooleanParameter parameter = new BooleanParameter(name, label, description, defaultValue, true, commandLinePattern, falseCommand, trueCommand);
        Assert.assertEquals((Object)trueCommand, (Object)parameter.getCommandValue(null));
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean defaultValue = true;
        String commandLinePattern = "--{0} {1}";
        String trueCommand = "s";
        String falseCommand = "n";
        BooleanParameter outputParameter = new BooleanParameter(name, label, description, defaultValue, true, commandLinePattern, falseCommand, trueCommand);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        BooleanParameter inputParameter = (BooleanParameter)objectInput.readObject();
        Assert.assertEquals((Object)outputParameter, (Object)inputParameter);
        Assert.assertEquals((Object)outputParameter.getName(), (Object)inputParameter.getName());
        Assert.assertEquals((Object)outputParameter.getLabel(), (Object)inputParameter.getLabel());
        Assert.assertEquals((Object)outputParameter.getDescription(), (Object)inputParameter.getDescription());
        Assert.assertEquals((Object)outputParameter.getDefaultValue(), (Object)inputParameter.getDefaultValue());
        Assert.assertEquals((Object)outputParameter.isOptional(), (Object)inputParameter.isOptional());
        Assert.assertEquals((Object)outputParameter.getCommandLinePattern(), (Object)inputParameter.getCommandLinePattern());
        Assert.assertEquals((Object)outputParameter.getTrueCommand(), (Object)inputParameter.getTrueCommand());
        Assert.assertEquals((Object)outputParameter.getFalseCommand(), (Object)inputParameter.getFalseCommand());
    }
}

