/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.ListExpressionFunction;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;

public final class CheckListExpressionFunction
extends ListExpressionFunction {
    private boolean canDoOperation;
    private Object[] expectedArguments;
    private List<Object> expectedValues;
    private Object expectedResult;
    private boolean wasDoneOperation;

    public CheckListExpressionFunction(String name, Class ... parameterTypes) {
        super(name, parameterTypes);
    }

    public void setExpected(List<Object> expectedValues, Object[] expectedArguments, Object expectedResult) {
        if (expectedValues == null) {
            throw new IllegalArgumentException("O par\u00e2metro expectedValues est\u00e1 nulo.");
        }
        if (expectedArguments == null) {
            throw new IllegalArgumentException("O par\u00e2metro expectedArguments est\u00e1 nulo.");
        }
        this.expectedValues = new LinkedList<Object>(expectedValues);
        this.expectedArguments = new Object[expectedArguments.length];
        System.arraycopy(expectedArguments, 0, this.expectedArguments, 0, expectedArguments.length);
        this.expectedResult = expectedResult;
        this.canDoOperation = true;
    }

    protected Object doOperation(List<?> values, Object ... arguments) {
        Assert.assertTrue((boolean)this.canDoOperation);
        Assert.assertEquals(this.expectedValues, values);
        Assert.assertNotNull((Object)arguments);
        Assert.assertEquals((int)this.expectedArguments.length, (int)arguments.length);
        int i = 0;
        while (i < this.expectedArguments.length) {
            Assert.assertEquals((Object)this.expectedArguments[i], (Object)arguments[i]);
            ++i;
        }
        this.wasDoneOperation = true;
        return this.expectedResult;
    }

    public boolean wasDoneOperation() {
        return this.wasDoneOperation;
    }
}

