/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.MockColumn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import junit.framework.TestCase;

public final class ColumnTest
extends TestCase {
    public void testColumn1() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        MockColumn column = new MockColumn(id, label, null, isOptional, isEditable);
        ColumnTest.assertEquals((String)id, (String)column.getId());
        ColumnTest.assertEquals((String)label, (String)column.getLabel());
        ColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        ColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        ColumnTest.assertNull((Object)column.getDefaultValue());
        ColumnTest.assertNotNull((Object)column.getRowIndexes());
        ColumnTest.assertTrue((boolean)column.getRowIndexes().isEmpty());
    }

    public void testColumn2() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = false;
        boolean isEditable = true;
        MockColumn column = new MockColumn(id, label, null, isOptional, isEditable);
        ColumnTest.assertEquals((String)id, (String)column.getId());
        ColumnTest.assertEquals((String)label, (String)column.getLabel());
        ColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        ColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        ColumnTest.assertNull((Object)column.getDefaultValue());
        ColumnTest.assertNotNull((Object)column.getRowIndexes());
        ColumnTest.assertTrue((boolean)column.getRowIndexes().isEmpty());
    }

    public void testColumn3() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        String defaultValue = "Valor-padr\u00e3o";
        MockColumn column = new MockColumn(id, label, defaultValue, isOptional, isEditable);
        ColumnTest.assertEquals((String)id, (String)column.getId());
        ColumnTest.assertEquals((String)label, (String)column.getLabel());
        ColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        ColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        ColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue());
        ColumnTest.assertNotNull((Object)column.getRowIndexes());
        ColumnTest.assertTrue((boolean)column.getRowIndexes().isEmpty());
    }

    public void testColumn4() {
        String id = "Identificador da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        try {
            new MockColumn(id, null, null, isOptional, isEditable);
            ColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com r\u00f3tulo nulo.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testColumn5() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = false;
        MockColumn column = new MockColumn(id, label, null, isOptional, isEditable);
        ColumnTest.assertEquals((String)id, (String)column.getId());
        ColumnTest.assertEquals((String)label, (String)column.getLabel());
        ColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        ColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        ColumnTest.assertNull((Object)column.getDefaultValue());
        ColumnTest.assertNotNull((Object)column.getRowIndexes());
        ColumnTest.assertTrue((boolean)column.getRowIndexes().isEmpty());
    }

    public void testColumn6() {
        String label = "R\u00f3tulo da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        try {
            new MockColumn(null, label, null, isOptional, isEditable);
            ColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com identificador nulo.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetDefaultValue1() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        MockColumn column = new MockColumn(id, label, null, isOptional, isEditable);
        ColumnTest.assertNull((Object)column.getDefaultValue());
        ColumnTest.assertNotNull((Object)column.getRowIndexes());
        ColumnTest.assertTrue((boolean)column.getRowIndexes().isEmpty());
        ColumnTest.assertNull((Object)column.getDefaultValue(0));
    }

    public void testGetDefaultValue2() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        String defaultValue = "Valor-padr\u00e3o geral";
        MockColumn column = new MockColumn(id, label, defaultValue, isOptional, isEditable);
        ColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue());
        ColumnTest.assertNotNull((Object)column.getRowIndexes());
        ColumnTest.assertTrue((boolean)column.getRowIndexes().isEmpty());
        ColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
    }

    public void testGetDefaultValue3() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        Object defaultValue = null;
        HashMap<Integer, String> defaultValuesByRowIndex = new HashMap<Integer, String>();
        defaultValuesByRowIndex.put(1, "Padr\u00e3o 1");
        defaultValuesByRowIndex.put(3, "Padr\u00e3o 3");
        MockColumn column = new MockColumn(id, label, defaultValue, isOptional, isEditable);
        column.addDefaultValue(1, defaultValuesByRowIndex.get(1));
        column.addDefaultValue(3, defaultValuesByRowIndex.get(3));
        ColumnTest.assertEquals(defaultValue, (Object)column.getDefaultValue());
        ColumnTest.assertEquals(defaultValue, (Object)column.getDefaultValue(0));
        ColumnTest.assertEquals(defaultValuesByRowIndex.get(1), (Object)column.getDefaultValue(1));
        ColumnTest.assertEquals(defaultValue, (Object)column.getDefaultValue(2));
        ColumnTest.assertEquals(defaultValuesByRowIndex.get(3), (Object)column.getDefaultValue(3));
        ColumnTest.assertEquals(defaultValue, (Object)column.getDefaultValue(4));
    }

    public void testGetDefaultValue4() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        String defaultValue = "Valor-padr\u00e3o geral";
        HashMap<Integer, String> defaultValuesByRowIndex = new HashMap<Integer, String>();
        defaultValuesByRowIndex.put(1, "Padr\u00e3o 1");
        defaultValuesByRowIndex.put(3, "Padr\u00e3o 3");
        MockColumn column = new MockColumn(id, label, defaultValue, isOptional, isEditable);
        column.addDefaultValue(1, defaultValuesByRowIndex.get(1));
        column.addDefaultValue(3, defaultValuesByRowIndex.get(3));
        ColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue());
        ColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        ColumnTest.assertEquals(defaultValuesByRowIndex.get(1), (Object)column.getDefaultValue(1));
        ColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(2));
        ColumnTest.assertEquals(defaultValuesByRowIndex.get(3), (Object)column.getDefaultValue(3));
        ColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(4));
    }

    public void testGetDefaultValue5() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        String defaultValue = "Valor-padr\u00e3o geral";
        MockColumn column = new MockColumn(id, label, defaultValue, isOptional, isEditable);
        column.addDefaultValue(1, null);
        ColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        ColumnTest.assertNull((Object)column.getDefaultValue(1));
        ColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(2));
    }

    public void testToString() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        MockColumn column = new MockColumn(id, label, null, isOptional, isEditable);
        ColumnTest.assertEquals((String)label, (String)column.toString());
    }

    public void testEquals1() {
        String id = "Identificador da coluna";
        String label1 = "Nome da coluna 1";
        boolean isOptional1 = true;
        boolean isEditable1 = true;
        MockColumn column1 = new MockColumn(id, label1, null, isOptional1, isEditable1);
        String label2 = "Nome da coluna 2";
        boolean isOptional2 = false;
        boolean isEditable2 = false;
        MockColumn column2 = new MockColumn(id, label2, null, isOptional2, isEditable2);
        ColumnTest.assertTrue((boolean)column1.equals((Object)column2));
    }

    public void testEquals2() {
        String id1 = "Identificador da coluna 1";
        String label1 = "Nome da coluna 1";
        boolean isOptional1 = true;
        boolean isEditable1 = true;
        MockColumn column1 = new MockColumn(id1, label1, null, isOptional1, isEditable1);
        ColumnTest.assertFalse((boolean)column1.equals(null));
    }

    public void testEquals3() {
        String id1 = "Identificador da coluna 1";
        String label1 = "Nome da coluna 1";
        boolean isOptional1 = true;
        boolean isEditable1 = true;
        MockColumn column1 = new MockColumn(id1, label1, null, isOptional1, isEditable1);
        ColumnTest.assertFalse((boolean)column1.equals("Objeto de outra classe"));
    }

    public void testHashCode1() {
        String id = "Identificador da coluna 1";
        String label1 = "Nome da coluna 1";
        boolean isOptional1 = true;
        boolean isEditable1 = true;
        MockColumn column1 = new MockColumn(id, label1, null, isOptional1, isEditable1);
        String label2 = "Nome da coluna 2";
        boolean isOptional2 = false;
        boolean isEditable2 = false;
        MockColumn column2 = new MockColumn(id, label2, null, isOptional2, isEditable2);
        ColumnTest.assertEquals((int)column1.hashCode(), (int)column2.hashCode());
    }

    public void testSerialize() throws IOException, ClassNotFoundException {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        boolean isOptional = true;
        boolean isEditable = true;
        String defaultValue = "Valor-padr\u00e3o";
        HashMap<Integer, String> defaultValuesByRowIndex = new HashMap<Integer, String>();
        defaultValuesByRowIndex.put(1, "Padr\u00e3o 1");
        defaultValuesByRowIndex.put(3, "Padr\u00e3o 3");
        MockColumn outputColumn = new MockColumn(id, label, defaultValue, isOptional, isEditable);
        outputColumn.addDefaultValue(1, defaultValuesByRowIndex.get(1));
        outputColumn.addDefaultValue(3, defaultValuesByRowIndex.get(3));
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject((Object)outputColumn);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        MockColumn inputColumn = (MockColumn)((Object)objectInput.readObject());
        ColumnTest.assertEquals((String)outputColumn.getId(), (String)outputColumn.getId());
        ColumnTest.assertEquals((String)outputColumn.getLabel(), (String)inputColumn.getLabel());
        ColumnTest.assertEquals((boolean)outputColumn.isOptional(), (boolean)inputColumn.isOptional());
        ColumnTest.assertEquals((boolean)outputColumn.isEditable(), (boolean)inputColumn.isEditable());
        ColumnTest.assertEquals((Object)outputColumn.getDefaultValue(), (Object)inputColumn.getDefaultValue());
        ColumnTest.assertEquals((Object)outputColumn.getRowIndexes(), (Object)inputColumn.getRowIndexes());
        for (Integer rowIndex : outputColumn.getRowIndexes()) {
            ColumnTest.assertEquals((Object)outputColumn.getDefaultValue(rowIndex), (Object)inputColumn.getDefaultValue(rowIndex));
        }
    }
}

