/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.exception.algorithms.ExpressionFunctionNotFoundException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.CheckExpressionFunction;
import csbase.logic.algorithms.parameters.ExpressionFunction;
import csbase.logic.algorithms.parameters.ExpressionFunctionExecutor;
import csbase.logic.algorithms.parameters.MockExpressionFunction;
import csbase.logic.algorithms.parameters.ReflectionExpressionFunction;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import junit.framework.TestCase;

public final class ExpressionFunctionExecutorTest
extends TestCase {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
    private Set<ExpressionFunction> executorInitialFunctions = new HashSet<ExpressionFunction>();

    protected void setUp() throws Exception {
        ExpressionFunctionExecutor expressionFunctionExecutor = ExpressionFunctionExecutor.getInstance();
        this.executorInitialFunctions.clear();
        this.executorInitialFunctions.addAll(expressionFunctionExecutor.getExpressionFunctions());
        expressionFunctionExecutor.clear();
    }

    protected void tearDown() throws Exception {
        ExpressionFunctionExecutor expressionFunctionExecutor = ExpressionFunctionExecutor.getInstance();
        expressionFunctionExecutor.clear();
        expressionFunctionExecutor.addAllExpressionFunction(this.executorInitialFunctions);
    }

    public void testGetInstance1() {
        ExpressionFunctionExecutorTest.assertNotNull((Object)ExpressionFunctionExecutor.getInstance());
        ExpressionFunctionExecutorTest.assertSame((Object)ExpressionFunctionExecutor.getInstance(), (Object)ExpressionFunctionExecutor.getInstance());
    }

    public void testAddExpressionFunction1() {
        MockExpressionFunction mockExpressionFunction = new MockExpressionFunction("Nome da fun\u00e7\u00e3o", new Class[0]);
        ExpressionFunctionExecutorTest.assertTrue((boolean)ExpressionFunctionExecutor.getInstance().addExpressionFunction((ExpressionFunction)mockExpressionFunction));
        HashSet<MockExpressionFunction> expressionFunctions = new HashSet<MockExpressionFunction>();
        expressionFunctions.add(mockExpressionFunction);
        ExpressionFunctionExecutorTest.assertEquals(expressionFunctions, (Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
    }

    public void testAddExpressionFunction2() {
        MockExpressionFunction mockExpressionFunction = new MockExpressionFunction("Nome da fun\u00e7\u00e3o", new Class[0]);
        ExpressionFunctionExecutorTest.assertTrue((boolean)ExpressionFunctionExecutor.getInstance().addExpressionFunction((ExpressionFunction)mockExpressionFunction));
        HashSet<MockExpressionFunction> expressionFunctions = new HashSet<MockExpressionFunction>();
        expressionFunctions.add(mockExpressionFunction);
        ExpressionFunctionExecutorTest.assertEquals(expressionFunctions, (Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
        ExpressionFunctionExecutorTest.assertFalse((boolean)ExpressionFunctionExecutor.getInstance().addExpressionFunction((ExpressionFunction)mockExpressionFunction));
        ExpressionFunctionExecutorTest.assertEquals(expressionFunctions, (Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
    }

    public void testAddExpressionFunction3() {
        try {
            ExpressionFunctionExecutor.getInstance().addExpressionFunction(null);
            ExpressionFunctionExecutorTest.fail((String)"Esperada IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetExpressionFunctions1() {
        Set expressionFunctions = ExpressionFunctionExecutor.getInstance().getExpressionFunctions();
        ExpressionFunctionExecutorTest.assertNotNull((Object)expressionFunctions);
        ExpressionFunctionExecutorTest.assertNotNull((Object)expressionFunctions.isEmpty());
    }

    public void testGetExpressionFunctions2() {
        MockExpressionFunction mockExpressionFunction = new MockExpressionFunction("Nome da fun\u00e7\u00e3o", new Class[0]);
        ExpressionFunctionExecutorTest.assertTrue((boolean)ExpressionFunctionExecutor.getInstance().addExpressionFunction((ExpressionFunction)mockExpressionFunction));
        HashSet<MockExpressionFunction> expressionFunctions = new HashSet<MockExpressionFunction>();
        expressionFunctions.add(mockExpressionFunction);
        ExpressionFunctionExecutorTest.assertEquals(expressionFunctions, (Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
        try {
            ExpressionFunctionExecutor.getInstance().getExpressionFunctions().clear();
            ExpressionFunctionExecutorTest.fail((String)"Esperada UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ExpressionFunctionExecutorTest.assertEquals(expressionFunctions, (Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
    }

    public void testExecute1() throws ExpressionFunctionExecutionException, ExpressionFunctionNotFoundException {
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{String.class, Integer.class};
        Object[] parameters = new Object[]{"Par\u00e2metro 1", 2};
        String result = "Resultado";
        CheckExpressionFunction function = new CheckExpressionFunction(functionName, parameterTypes, configurator, parameters, result);
        ExpressionFunctionExecutorTest.assertFalse((boolean)function.wasDoneOperation());
        ExpressionFunctionExecutor.getInstance().addExpressionFunction((ExpressionFunction)function);
        ExpressionFunctionExecutorTest.assertEquals((Object)result, (Object)ExpressionFunctionExecutor.getInstance().execute(functionName, configurator, parameters));
    }

    public void testExecute2() throws ExpressionFunctionExecutionException {
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        try {
            ExpressionFunctionExecutor.getInstance().execute("Fun\u00e7\u00e3o que n\u00e3o existe", configurator, new Object[0]);
            ExpressionFunctionExecutorTest.fail((String)ExpressionFunctionNotFoundException.class.getName());
        }
        catch (ExpressionFunctionNotFoundException expressionFunctionNotFoundException) {
            // empty catch block
        }
    }

    public void testExecute3() throws ExpressionFunctionExecutionException {
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{String.class, Integer.class};
        Object[] parameters = new Object[]{"Par\u00e2metro 1", 2};
        String result = "Resultado";
        CheckExpressionFunction function = new CheckExpressionFunction(functionName, parameterTypes, configurator, parameters, result);
        ExpressionFunctionExecutorTest.assertFalse((boolean)function.wasDoneOperation());
        ExpressionFunctionExecutor.getInstance().addExpressionFunction((ExpressionFunction)function);
        try {
            ExpressionFunctionExecutor.getInstance().execute("Nome de fun\u00e7\u00e3o que n\u00e3o existe", configurator, parameters);
            ExpressionFunctionExecutorTest.fail((String)ExpressionFunctionNotFoundException.class.getName());
        }
        catch (ExpressionFunctionNotFoundException expressionFunctionNotFoundException) {
            // empty catch block
        }
    }

    public void testExecute4() throws ExpressionFunctionExecutionException {
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{String.class, Integer.class};
        Object[] parameters = new Object[]{"Par\u00e2metro 1", 2};
        String result = "Resultado";
        CheckExpressionFunction function = new CheckExpressionFunction(functionName, parameterTypes, configurator, parameters, result);
        ExpressionFunctionExecutorTest.assertFalse((boolean)function.wasDoneOperation());
        ExpressionFunctionExecutor.getInstance().addExpressionFunction((ExpressionFunction)function);
        try {
            ExpressionFunctionExecutor.getInstance().execute(functionName, configurator, new Object[]{1.3, Character.valueOf('a'), true});
            ExpressionFunctionExecutorTest.fail((String)ExpressionFunctionNotFoundException.class.getName());
        }
        catch (ExpressionFunctionNotFoundException expressionFunctionNotFoundException) {
            // empty catch block
        }
    }

    public void testExecute5() throws ExpressionFunctionExecutionException, ExpressionFunctionNotFoundException {
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        try {
            ExpressionFunctionExecutor.getInstance().execute(null, configurator, new Object[]{1.3, Character.valueOf('a'), true});
            ExpressionFunctionExecutorTest.fail((String)IllegalArgumentException.class.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecute6() throws ExpressionFunctionExecutionException, ExpressionFunctionNotFoundException {
        try {
            ExpressionFunctionExecutor.getInstance().execute("Nome de fun\u00e7\u00e3o", null, new Object[]{1.3, Character.valueOf('a'), true});
            ExpressionFunctionExecutorTest.fail((String)IllegalArgumentException.class.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecute7() throws ExpressionFunctionExecutionException, ExpressionFunctionNotFoundException {
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        try {
            ExpressionFunctionExecutor.getInstance().execute("Nome de fun\u00e7\u00e3o", configurator, null);
            ExpressionFunctionExecutorTest.fail((String)IllegalArgumentException.class.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateReflexiveExpressionFunctions1() throws NoSuchMethodException {
        ExpressionFunctionExecutor.getInstance().createReflexiveExpressionFunctions(ClassWithOnlyOnePublicStaticMethod.class);
        String functionName = "method1";
        Class[] parameterTypes = new Class[]{Integer.class, Float.class, Object.class};
        ReflectionExpressionFunction expressionFunction = new ReflectionExpressionFunction(ClassWithOnlyOnePublicStaticMethod.class.getMethod(functionName, parameterTypes));
        HashSet<ReflectionExpressionFunction> expressionFunctions = new HashSet<ReflectionExpressionFunction>();
        expressionFunctions.add(expressionFunction);
        ExpressionFunctionExecutorTest.assertEquals(expressionFunctions, (Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
    }

    public void testCreateReflexiveExpressionFunctions2() {
        ExpressionFunctionExecutor.getInstance().createReflexiveExpressionFunctions(ClassWithoutStaticMethods.class);
        ExpressionFunctionExecutorTest.assertNotNull((Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
        ExpressionFunctionExecutorTest.assertTrue((boolean)ExpressionFunctionExecutor.getInstance().getExpressionFunctions().isEmpty());
    }

    public void testCreateReflexiveExpressionFunctions3() {
        ExpressionFunctionExecutor.getInstance().createReflexiveExpressionFunctions(ClassWithoutPublicMethods.class);
        ExpressionFunctionExecutorTest.assertNotNull((Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
        ExpressionFunctionExecutorTest.assertTrue((boolean)ExpressionFunctionExecutor.getInstance().getExpressionFunctions().isEmpty());
    }

    public void testCreateReflexiveExpressionFunctions4() throws NoSuchMethodException {
        ExpressionFunctionExecutor.getInstance().createReflexiveExpressionFunctions(ClassWithStaticAndNonStaticMethods.class);
        String functionName = "method1";
        Class[] parameterTypes = new Class[]{Integer.class, Float.class, Object.class};
        ReflectionExpressionFunction expressionFunction = new ReflectionExpressionFunction(ClassWithOnlyOnePublicStaticMethod.class.getMethod(functionName, parameterTypes));
        HashSet<ReflectionExpressionFunction> expressionFunctions = new HashSet<ReflectionExpressionFunction>();
        expressionFunctions.add(expressionFunction);
        ExpressionFunctionExecutorTest.assertEquals(expressionFunctions, (Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
    }

    public void testCreateReflexiveExpressionFunctions5() throws NoSuchMethodException {
        ExpressionFunctionExecutor.getInstance().createReflexiveExpressionFunctions(ClassWithPublicAndNonPublicMethods.class);
        String functionName = "method1";
        Class[] parameterTypes = new Class[]{Integer.class, Float.class, Object.class};
        ReflectionExpressionFunction expressionFunction = new ReflectionExpressionFunction(ClassWithOnlyOnePublicStaticMethod.class.getMethod(functionName, parameterTypes));
        HashSet<ReflectionExpressionFunction> expressionFunctions = new HashSet<ReflectionExpressionFunction>();
        expressionFunctions.add(expressionFunction);
        ExpressionFunctionExecutorTest.assertEquals(expressionFunctions, (Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
    }

    public void testCreateReflexiveExpressionFunctions6() {
        ExpressionFunctionExecutor.getInstance().createReflexiveExpressionFunctions(ClassWithoutMethods.class);
        ExpressionFunctionExecutorTest.assertNotNull((Object)ExpressionFunctionExecutor.getInstance().getExpressionFunctions());
        ExpressionFunctionExecutorTest.assertTrue((boolean)ExpressionFunctionExecutor.getInstance().getExpressionFunctions().isEmpty());
    }

    private static class ClassWithOnlyOnePublicStaticMethod {
        private ClassWithOnlyOnePublicStaticMethod() {
        }

        public static String method1(Integer param1, Float param2, Object param3) {
            return null;
        }
    }

    private static class ClassWithPublicAndNonPublicMethods {
        private ClassWithPublicAndNonPublicMethods() {
        }

        public static String method1(Integer param1, Float param2, Object param3) {
            return null;
        }

        static int method2() {
            return 0;
        }
    }

    private static class ClassWithStaticAndNonStaticMethods {
        private ClassWithStaticAndNonStaticMethods() {
        }

        public static String method1(Integer param1, Float param2, Object param3) {
            return null;
        }

        public int method2() {
            return 0;
        }
    }

    private static class ClassWithoutMethods {
        private ClassWithoutMethods() {
        }
    }

    private static class ClassWithoutPublicMethods {
        private ClassWithoutPublicMethods() {
        }

        static String method1(Integer param1, Float param2, Object param3) {
            return null;
        }
    }

    private static class ClassWithoutStaticMethods {
        private ClassWithoutStaticMethods() {
        }

        public String method1(Integer param1, Float param2, Object param3) {
            return null;
        }
    }
}

