/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.CheckExpressionFunction;
import csbase.logic.algorithms.parameters.ExpressionFunction;
import csbase.logic.algorithms.parameters.MockExpressionFunction;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import junit.framework.TestCase;

public final class ExpressionFunctionTest
extends TestCase {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    public void testExpressionFunction1() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Object.class, String.class, Integer.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        ExpressionFunctionTest.assertEquals((String)functionName, (String)expressionFunction.getName());
        ExpressionFunctionTest.assertEquals(Arrays.asList(parameterTypes), (Object)expressionFunction.getParameterTypes());
    }

    public void testExpressionFunction2() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, new Class[0]);
        ExpressionFunctionTest.assertEquals((String)functionName, (String)expressionFunction.getName());
        ExpressionFunctionTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)expressionFunction.getParameterTypes());
    }

    public void testExpressionFunction3() {
        try {
            new MockExpressionFunction(null, new Class[0]);
            ExpressionFunctionTest.fail((String)"Esperada IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExpressionFunction4() {
        try {
            new MockExpressionFunction("Nome da fun\u00e7\u00e3o", null);
            ExpressionFunctionTest.fail((String)"Esperada IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExpressionFunction5() {
        try {
            new MockExpressionFunction("Nome da fun\u00e7\u00e3o", new Class[1]);
            ExpressionFunctionTest.fail((String)"Esperada IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetParameterTypes1() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Object.class, String.class, Integer.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        ExpressionFunctionTest.assertEquals((String)functionName, (String)expressionFunction.getName());
        ExpressionFunctionTest.assertEquals(Arrays.asList(parameterTypes), (Object)expressionFunction.getParameterTypes());
        try {
            expressionFunction.getParameterTypes().clear();
            ExpressionFunctionTest.fail((String)"Esperada UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ExpressionFunctionTest.assertEquals(Arrays.asList(parameterTypes), (Object)expressionFunction.getParameterTypes());
    }

    public void testEquals1() {
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Object.class, String.class};
        MockExpressionFunction function1 = new MockExpressionFunction(name, parameterTypes);
        MockExpressionFunction function2 = new MockExpressionFunction(name, parameterTypes);
        ExpressionFunctionTest.assertTrue((boolean)function1.equals((Object)function2));
    }

    public void testEquals2() {
        String name = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes1 = new Class[]{Object.class, String.class};
        Class[] parameterTypes2 = new Class[]{Integer.class, Float.class};
        MockExpressionFunction function1 = new MockExpressionFunction(name, parameterTypes1);
        MockExpressionFunction function2 = new MockExpressionFunction(name, parameterTypes2);
        ExpressionFunctionTest.assertFalse((boolean)function1.equals((Object)function2));
    }

    public void testEquals3() {
        String name1 = "Nome da fun\u00e7\u00e3o 1";
        String name2 = "Nome da fun\u00e7\u00e3o 2";
        Class[] parameterTypes = new Class[]{Object.class, String.class};
        MockExpressionFunction function1 = new MockExpressionFunction(name1, parameterTypes);
        MockExpressionFunction function2 = new MockExpressionFunction(name2, parameterTypes);
        ExpressionFunctionTest.assertFalse((boolean)function1.equals((Object)function2));
    }

    public void testEquals4() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Object.class, String.class, Integer.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        ExpressionFunctionTest.assertFalse((boolean)expressionFunction.equals(null));
    }

    public void testEquals5() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Object.class, String.class, Integer.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        ExpressionFunctionTest.assertFalse((boolean)expressionFunction.equals(functionName));
    }

    public void testHashCode() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Object.class, String.class, Integer.class};
        MockExpressionFunction expressionFunction1 = new MockExpressionFunction(functionName, parameterTypes);
        MockExpressionFunction expressionFunction2 = new MockExpressionFunction(functionName, parameterTypes);
        ExpressionFunctionTest.assertEquals((int)expressionFunction1.hashCode(), (int)expressionFunction2.hashCode());
    }

    public void testAcceptParameters1() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Float.class, String.class, Integer.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        ExpressionFunctionTest.assertTrue((boolean)expressionFunction.acceptParameters(new Object[]{Float.valueOf(1.0f), "String", 10}));
    }

    public void testAcceptParameters2() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Float.class, String.class, Integer.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        ExpressionFunctionTest.assertFalse((boolean)expressionFunction.acceptParameters(new Object[]{Float.valueOf(1.0f), "String"}));
    }

    public void testAcceptParameters3() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Float.class, String.class, Integer.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        ExpressionFunctionTest.assertFalse((boolean)expressionFunction.acceptParameters(new Object[]{"String", 10, Float.valueOf(1.0f)}));
    }

    public void testAcceptParameters4() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{ExpressionFunction.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        ExpressionFunctionTest.assertTrue((boolean)expressionFunction.acceptParameters(new Object[]{expressionFunction}));
    }

    public void testAcceptParameters5() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{ExpressionFunction.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        try {
            expressionFunction.acceptParameters(null);
            ExpressionFunctionTest.fail((String)"Esperada IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAcceptParameters6() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{String.class, String.class};
        MockExpressionFunction expressionFunction = new MockExpressionFunction(functionName, parameterTypes);
        Object[] objectArray = new Object[2];
        objectArray[0] = "Par\u00e2metro 1";
        ExpressionFunctionTest.assertTrue((boolean)expressionFunction.acceptParameters(objectArray));
    }

    public void testExecute1() throws ExpressionFunctionExecutionException {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Float.class, String.class, Integer.class};
        String result = "Resultado";
        Object[] parameters = new Object[]{Float.valueOf(1.0f), "Texto", 3};
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        CheckExpressionFunction expressionFunction = new CheckExpressionFunction(functionName, parameterTypes, configurator, parameters, result);
        ExpressionFunctionTest.assertEquals((Object)result, (Object)expressionFunction.execute(configurator, parameters));
        ExpressionFunctionTest.assertTrue((boolean)expressionFunction.wasDoneOperation());
    }

    public void testExecute2() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Float.class, String.class, Integer.class};
        CheckExpressionFunction expressionFunction = new CheckExpressionFunction(functionName, parameterTypes);
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        try {
            expressionFunction.execute(configurator, new Object[]{Float.valueOf(1.0f), "Texto"});
            ExpressionFunctionTest.fail((String)ExpressionFunctionExecutionException.class.getName());
        }
        catch (ExpressionFunctionExecutionException expressionFunctionExecutionException) {
            // empty catch block
        }
        ExpressionFunctionTest.assertFalse((boolean)expressionFunction.wasDoneOperation());
    }

    public void testExecute3() {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Float.class, String.class, Integer.class};
        CheckExpressionFunction expressionFunction = new CheckExpressionFunction(functionName, parameterTypes);
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        try {
            expressionFunction.execute(configurator, new Object[]{"Texto", 1, Float.valueOf(1.0f)});
            ExpressionFunctionTest.fail((String)ExpressionFunctionExecutionException.class.getName());
        }
        catch (ExpressionFunctionExecutionException expressionFunctionExecutionException) {
            // empty catch block
        }
        ExpressionFunctionTest.assertFalse((boolean)expressionFunction.wasDoneOperation());
    }

    public void testExecute4() throws ExpressionFunctionExecutionException {
        String functionName = "Nome da fun\u00e7\u00e3o";
        Class[] parameterTypes = new Class[]{Float.class, String.class, Integer.class};
        CheckExpressionFunction expressionFunction = new CheckExpressionFunction(functionName, parameterTypes);
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        try {
            expressionFunction.execute(configurator, null);
            ExpressionFunctionTest.fail((String)IllegalArgumentException.class.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ExpressionFunctionTest.assertFalse((boolean)expressionFunction.wasDoneOperation());
    }
}

