/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.MockFileParameter;
import org.junit.Assert;
import org.junit.Test;

public final class FileParameterTest {
    @Test
    public void testFileParameterWithValidValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean isMultipleSelection = false;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustSort = true;
        boolean usesFilter = false;
        boolean mustExist = false;
        MockFileParameter parameter = new MockFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, isMultipleSelection, canUsePipe, mustSort, usesFilter, mustExist);
        this.assertFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, canUsePipe, mustExist, parameter);
    }

    @Test
    public void testFileParameterWithNonOptionalValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean isMultipleSelection = false;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustSort = true;
        boolean usesFilter = false;
        boolean mustExist = false;
        MockFileParameter parameter = new MockFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, isMultipleSelection, canUsePipe, mustSort, usesFilter, mustExist);
        this.assertFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, canUsePipe, mustExist, parameter);
    }

    @Test
    public void testFileParameterWithNullFileType() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean isMultipleSelection = false;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustSort = true;
        boolean usesFilter = false;
        boolean mustExist = false;
        MockFileParameter parameter = new MockFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, isMultipleSelection, canUsePipe, mustSort, usesFilter, mustExist);
        this.assertFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, canUsePipe, mustExist, parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFileParameterWithNullName() {
        new MockFileParameter(null, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFileParameterWithNullLabel() {
        new MockFileParameter("Nome do par\u00e2metro", null, "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFileParameterWithNullDescription() {
        new MockFileParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", null, FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
    }

    @Test
    public void testFileParameterWithValueOnlyCommandLinePattern() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        boolean isVisible = true;
        String commandLinePattern = "$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean isMultipleSelection = false;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustSort = true;
        boolean usesFilter = false;
        boolean mustExist = false;
        MockFileParameter parameter = new MockFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, isMultipleSelection, canUsePipe, mustSort, usesFilter, mustExist);
        this.assertFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, canUsePipe, mustExist, parameter);
    }

    @Test
    public void testFileParameterWithDirectoryMode() {
        FileParameterMode mode = FileParameterMode.DIRECTORY;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        boolean isMultipleSelection = false;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustSort = true;
        boolean usesFilter = false;
        boolean mustExist = false;
        MockFileParameter parameter = new MockFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, isMultipleSelection, canUsePipe, mustSort, usesFilter, mustExist);
        this.assertFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, canUsePipe, mustExist, parameter);
    }

    @Test
    public void testFileParameterWithDirectoryAndFileMode() {
        FileParameterMode mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        boolean isMultipleSelection = false;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustSort = true;
        boolean usesFilter = false;
        boolean mustExist = false;
        MockFileParameter parameter = new MockFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, isMultipleSelection, canUsePipe, mustSort, usesFilter, mustExist);
        this.assertFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, canUsePipe, mustExist, parameter);
    }

    @Test
    public void testFileParameterWithNoPipeAcceptance() {
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.FALSE;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean isMultipleSelection = false;
        boolean mustSort = true;
        boolean usesFilter = false;
        boolean mustExist = false;
        MockFileParameter parameter = new MockFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, isMultipleSelection, canUsePipe, mustSort, usesFilter, mustExist);
        this.assertFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, canUsePipe, mustExist, parameter);
    }

    @Test
    public void testFileParameterWithFilter() {
        boolean usesFilter = true;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean isMultipleSelection = false;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustSort = true;
        boolean mustExist = false;
        MockFileParameter parameter = new MockFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, isMultipleSelection, canUsePipe, mustSort, usesFilter, mustExist);
        this.assertFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, canUsePipe, mustExist, parameter);
    }

    @Test
    public void testFileParameterWithExistingFile() {
        boolean mustExist = true;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean isMultipleSelection = false;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustSort = true;
        boolean usesFilter = false;
        MockFileParameter parameter = new MockFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, isMultipleSelection, canUsePipe, mustSort, usesFilter, mustExist);
        this.assertFileParameter(name, label, description, isOptional, isVisible, commandLinePattern, type, mode, canUsePipe, mustExist, parameter);
    }

    @Test
    public void testGetValueAsTextWithNullValue() {
        MockFileParameter parameter = new MockFileParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "TEXT", FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
        Assert.assertNull((Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithFileType() {
        MockFileParameter parameter = new MockFileParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "TEXT", FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
        Assert.assertNull((Object)parameter.getValueAsText());
        FileParameterValue file = new FileParameterValue("dir1/dir2/arq", "DOC");
        parameter.setValue(file);
        Assert.assertEquals((Object)"dir1/dir2/arq:DOC", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithNoFileType() {
        MockFileParameter parameter = new MockFileParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "TEXT", FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
        Assert.assertNull((Object)parameter.getValueAsText());
        FileParameterValue file = new FileParameterValue("dir1/dir2/arq");
        parameter.setValue(file);
        Assert.assertEquals((Object)"dir1/dir2/arq:UNKNOWN", (Object)parameter.getValueAsText());
    }

    @Test
    public void testSetValueAsTextWithNullValue() {
        MockFileParameter parameter = new MockFileParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "TEXT", FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
        FileParameterValue file = new FileParameterValue("dir1/dir2/arq", "DOC");
        parameter.setValue(file);
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
        parameter.setValueAsText(null);
        Assert.assertNull((Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithNoFileType() {
        MockFileParameter parameter = new MockFileParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "TEXT", FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
        parameter.setValueAsText("dir1/dir2/arq:UNKNOWN");
        FileParameterValue file = new FileParameterValue("dir1/dir2/arq");
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithFileType() {
        MockFileParameter parameter = new MockFileParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "TEXT", FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
        parameter.setValueAsText("dir1/dir2/arq:DOC");
        FileParameterValue file = new FileParameterValue("dir1/dir2/arq", "DOC");
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testGetCommandLineWithUnixSeparator() {
        MockFileParameter parameter = new MockFileParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "TEXT", FileParameterMode.DIRECTORY, false, FileParameterPipeAcceptance.TRUE, true, false, false);
        CommandLineContext context = new CommandLineContext(null, null, '/', null, null, null, null, null, null, false, null, "TEST_CLIENT");
        parameter.setValueAsText("dir1/dir2/dir3:DIRECTORY_TYPE");
        Assert.assertEquals((Object)("PARAM_NAME=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + "/dir1/dir2/dir3"), (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithWindowsSeparator() {
        MockFileParameter parameter = new MockFileParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "TEXT", FileParameterMode.DIRECTORY, false, FileParameterPipeAcceptance.TRUE, true, false, false);
        CommandLineContext context = new CommandLineContext(null, null, '\\', null, null, null, null, null, null, false, null, "TEST_CLIENT");
        parameter.setValueAsText("dir1/dir2/dir3:DIRECTORY_TYPE");
        Assert.assertEquals((Object)("PARAM_NAME=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + "\\dir1\\dir2\\dir3"), (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithNullValue() {
        MockFileParameter parameter = new MockFileParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "TEXT", FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
        Assert.assertNull((Object)parameter.getCommandLine(null));
    }

    private void assertFileParameter(String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, String type, FileParameterMode mode, FileParameterPipeAcceptance canUsePipe, boolean mustExist, FileParameter parameter) {
        Assert.assertNotNull((Object)parameter);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals((Object)type, (Object)parameter.getFileType());
        Assert.assertEquals((Object)mode, (Object)parameter.getMode());
        Assert.assertEquals((Object)canUsePipe, (Object)parameter.usesPipe());
        Assert.assertEquals((Object)isVisible, (Object)parameter.isVisible());
        Assert.assertNull((Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)mustExist, (Object)parameter.mustExist());
    }
}

