/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.HiddenParameter;
import junit.framework.TestCase;

public final class HiddenParameterTest
extends TestCase {
    public void testHiddenParameter1() {
        String name = "NOME";
        String value = "VALOR";
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        HiddenParameter parameter = new HiddenParameter(name, value, commandLinePattern);
        HiddenParameterTest.assertEquals((String)name, (String)parameter.getName());
        HiddenParameterTest.assertEquals((String)value, (String)parameter.getValue());
        HiddenParameterTest.assertEquals((String)commandLinePattern, (String)parameter.getCommandLinePattern());
    }

    public void testHiddenParameter2() {
        try {
            new HiddenParameter(null, "VALOR", "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
            HiddenParameterTest.fail((String)"Esperada IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHiddenParameter3() {
        try {
            new HiddenParameter("NOME", null, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
            HiddenParameterTest.fail((String)"Esperada IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHiddenParameter4() {
        try {
            new HiddenParameter("NOME", "VALOR", null);
            HiddenParameterTest.fail((String)"Esperada IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCommandValue1() {
        String name = "nome_do_parametro";
        String value = "valor_do_parametro";
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        HiddenParameter parameter = new HiddenParameter(name, value, commandLinePattern);
        HiddenParameterTest.assertEquals((String)(String.valueOf(name) + "=" + value), (String)parameter.getCommandLine());
    }

    public void testGetCommandValue2() {
        String name = "nome_do_parametro";
        String value = "valor_do_parametro";
        String commandLinePattern = "--$NOME_DO_PARAMETRO";
        HiddenParameter parameter = new HiddenParameter(name, value, commandLinePattern);
        HiddenParameterTest.assertEquals((String)("--" + name), (String)parameter.getCommandLine());
    }

    public void testGetCommandValue3() {
        String name = "nome_do_parametro";
        String value = "valor_do_parametro";
        String commandLinePattern = "$VALOR_DO_PARAMETRO";
        HiddenParameter parameter = new HiddenParameter(name, value, commandLinePattern);
        HiddenParameterTest.assertEquals((String)value, (String)parameter.getCommandLine());
    }
}

