/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.IntegerColumn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;

public final class IntegerColumnTest
extends TestCase {
    public void testIntegerColumn1() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        Integer defaultValue = new Integer(123);
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maximum = new Integer(10);
        Integer minimum = new Integer(0);
        IntegerColumn column = new IntegerColumn(id, label, defaultValue, isOptional, isEditable, maximum, minimum);
        IntegerColumnTest.assertEquals((String)id, (String)column.getId());
        IntegerColumnTest.assertEquals((String)label, (String)column.getLabel());
        IntegerColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        IntegerColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        IntegerColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        IntegerColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        IntegerColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
    }

    public void testIntegerColumn2() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        Integer defaultValue = new Integer(123);
        boolean isOptional = false;
        boolean isEditable = true;
        Integer maximum = new Integer(10);
        Integer minimum = new Integer(0);
        IntegerColumn column = new IntegerColumn(id, label, defaultValue, isOptional, isEditable, maximum, minimum);
        IntegerColumnTest.assertEquals((String)id, (String)column.getId());
        IntegerColumnTest.assertEquals((String)label, (String)column.getLabel());
        IntegerColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        IntegerColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        IntegerColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        IntegerColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        IntegerColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
    }

    public void testIntegerColumn3() {
        String id = "Identificador da coluna";
        Integer defaultValue = new Integer(123);
        boolean isOptional = false;
        boolean isEditable = true;
        Integer maximum = new Integer(10);
        Integer minimum = new Integer(0);
        try {
            new IntegerColumn(id, null, defaultValue, isOptional, isEditable, maximum, minimum);
            IntegerColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com r\u00f3tulo nulo.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIntegerColumn4() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        Integer defaultValue = new Integer(123);
        boolean isOptional = true;
        boolean isEditable = true;
        Integer minimum = new Integer(0);
        IntegerColumn column = new IntegerColumn(id, label, defaultValue, isOptional, isEditable, null, minimum);
        IntegerColumnTest.assertEquals((String)id, (String)column.getId());
        IntegerColumnTest.assertEquals((String)label, (String)column.getLabel());
        IntegerColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        IntegerColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        IntegerColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        IntegerColumnTest.assertNull((Object)column.getMaximum());
        IntegerColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
    }

    public void testIntegerColumn5() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        Integer defaultValue = new Integer(123);
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maximum = new Integer(0);
        IntegerColumn column = new IntegerColumn(id, label, defaultValue, isOptional, isEditable, maximum, null);
        IntegerColumnTest.assertEquals((String)id, (String)column.getId());
        IntegerColumnTest.assertEquals((String)label, (String)column.getLabel());
        IntegerColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        IntegerColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        IntegerColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        IntegerColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        IntegerColumnTest.assertNull((Object)column.getMinimum());
    }

    public void testIntegerColumn6() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        Integer defaultValue = new Integer(123);
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maximum = new Integer(0);
        Integer minimum = new Integer(maximum + 1);
        try {
            new IntegerColumn(id, label, defaultValue, isOptional, isEditable, maximum, minimum);
            IntegerColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com o m\u00ednimo maior do que o m\u00e1ximo.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIntegerColumn7() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        Integer defaultValue = new Integer(123);
        boolean isOptional = true;
        boolean isEditable = false;
        Integer maximum = new Integer(10);
        Integer minimum = new Integer(0);
        IntegerColumn column = new IntegerColumn(id, label, defaultValue, isOptional, isEditable, maximum, minimum);
        IntegerColumnTest.assertEquals((String)id, (String)column.getId());
        IntegerColumnTest.assertEquals((String)label, (String)column.getLabel());
        IntegerColumnTest.assertEquals((Object)defaultValue, (Object)column.getDefaultValue(0));
        IntegerColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        IntegerColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        IntegerColumnTest.assertEquals((Object)maximum, (Object)column.getMaximum());
        IntegerColumnTest.assertEquals((Object)minimum, (Object)column.getMinimum());
    }

    public void testIntegerColumn8() {
        String label = "R\u00f3tulo da coluna";
        Integer defaultValue = new Integer(123);
        boolean isOptional = false;
        boolean isEditable = true;
        Integer maximum = new Integer(10);
        Integer minimum = new Integer(0);
        try {
            new IntegerColumn(null, label, defaultValue, isOptional, isEditable, maximum, minimum);
            IntegerColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com id nulo.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSerialize() throws IOException, ClassNotFoundException {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        Integer defaultValue = new Integer(123);
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maximum = new Integer(1000);
        Integer minimum = new Integer(100);
        IntegerColumn expectedColumn = new IntegerColumn(id, label, defaultValue, isOptional, isEditable, maximum, minimum);
        expectedColumn.addDefaultValue(1, (Object)10);
        expectedColumn.addDefaultValue(3, (Object)30);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(expectedColumn);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        IntegerColumn loadedColumn = (IntegerColumn)objectInput.readObject();
        IntegerColumnTest.assertEquals((Object)defaultValue, (Object)loadedColumn.getDefaultValue(0));
        IntegerColumnTest.assertEquals((Object)new Integer(10), (Object)loadedColumn.getDefaultValue(1));
        IntegerColumnTest.assertEquals((Object)defaultValue, (Object)loadedColumn.getDefaultValue(2));
        IntegerColumnTest.assertEquals((Object)new Integer(30), (Object)loadedColumn.getDefaultValue(3));
        IntegerColumnTest.assertEquals((Object)defaultValue, (Object)loadedColumn.getDefaultValue(4));
        IntegerColumnTest.assertEquals((Object)expectedColumn.getMaximum(), (Object)loadedColumn.getMaximum());
        IntegerColumnTest.assertEquals((Object)expectedColumn.getMinimum(), (Object)loadedColumn.getMinimum());
        IntegerColumnTest.assertEquals((String)expectedColumn.getLabel(), (String)loadedColumn.getLabel());
        IntegerColumnTest.assertEquals((boolean)expectedColumn.isOptional(), (boolean)loadedColumn.isOptional());
        IntegerColumnTest.assertEquals((boolean)expectedColumn.isEditable(), (boolean)loadedColumn.isEditable());
    }
}

