/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.ListMaxExpressionFunction;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class ListMaxExpressionFunctionTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testListMaxExpressionFunction1() {
        ListMaxExpressionFunction function = new ListMaxExpressionFunction();
        Assert.assertEquals((Object)"list_max", (Object)function.getName());
        Assert.assertNotNull((Object)function.getParameterTypes());
        Assert.assertEquals((long)1L, (long)function.getParameterTypes().size());
        Assert.assertEquals(String.class, function.getParameterTypes().get(0));
    }

    @Test
    public void testExecute1() throws ExpressionFunctionExecutionException {
        ListMaxExpressionFunction function = new ListMaxExpressionFunction();
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        DoubleListParameter parameter = new DoubleListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, null, false, null, false);
        parameter.addElement((Object)2.0);
        parameter.addElement((Object)1.0);
        parameter.addElement((Object)3.0);
        ParameterGroup group = new ParameterGroup("Grupo");
        group.addParameter((Parameter)parameter);
        SimpleAlgorithmConfigurator configurator = this.createConfigurator();
        configurator.addGroup(group);
        Assert.assertEquals((Object)3.0, (Object)function.execute(configurator, new Object[]{parameterName}));
    }

    @Test(expected=ExpressionFunctionExecutionException.class)
    public void testExecute2() throws ExpressionFunctionExecutionException {
        ListMaxExpressionFunction function = new ListMaxExpressionFunction();
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        DoubleListParameter parameter = new DoubleListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, null, false, null, false);
        ParameterGroup group = new ParameterGroup("Grupo");
        group.addParameter((Parameter)parameter);
        SimpleAlgorithmConfigurator configurator = this.createConfigurator();
        configurator.addGroup(group);
        function.execute(configurator, new Object[]{"Nome de par\u00e2metro que n\u00e3o existe"});
    }

    @Test(expected=ExpressionFunctionExecutionException.class)
    public void testExecute3() throws ExpressionFunctionExecutionException {
        ListMaxExpressionFunction function = new ListMaxExpressionFunction();
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        DoubleListParameter parameter = new DoubleListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, null, false, null, false);
        ParameterGroup group = new ParameterGroup("Grupo");
        group.addParameter((Parameter)parameter);
        SimpleAlgorithmConfigurator configurator = this.createConfigurator();
        configurator.addGroup(group);
        function.execute(configurator, new Object[]{parameterName});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExecute4() throws ExpressionFunctionExecutionException {
        ListMaxExpressionFunction function = new ListMaxExpressionFunction();
        String parameterName = "Nome do par\u00e2metro";
        function.execute(null, new Object[]{parameterName});
    }

    @Test(expected=ExpressionFunctionExecutionException.class)
    public void testExecute5() throws ExpressionFunctionExecutionException {
        ListMaxExpressionFunction function = new ListMaxExpressionFunction();
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        DoubleListParameter parameter = new DoubleListParameter(parameterName, parameterLabel, parameterDescription, null, false, true, null, null, false, null, false);
        ParameterGroup group = new ParameterGroup("Grupo");
        group.addParameter((Parameter)parameter);
        SimpleAlgorithmConfigurator configurator = this.createConfigurator();
        configurator.addGroup(group);
        function.execute(configurator, new Object[]{null});
    }

    private SimpleAlgorithmConfigurator createConfigurator() {
        String algorithmId = "Identificador do algoritmo";
        String algorithmName = "Nome do algoritmo";
        String algorithmDirectory = "Diret\u00f3rio do algoritmo";
        AlgorithmInfo algorithmInfo = new AlgorithmInfo(algorithmId, algorithmName, algorithmDirectory, "algorithms", new Hashtable(), new Hashtable());
        AlgorithmVersionInfo versionInfo = new AlgorithmVersionInfo(algorithmInfo, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(versionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        return configurator;
    }
}

