/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.CheckParameterListener;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.MockListParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public final class ListParameterTest {
    @Test
    public void testListParameterTestWithOptionalTrue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertNull((Object)parameter.getDefaultValue());
        Assert.assertTrue((boolean)parameter.isOptional());
        Assert.assertTrue((boolean)parameter.isVisible());
    }

    @Test
    public void testListParameterTestWithOptionalFalse() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertNull((Object)parameter.getDefaultValue());
        Assert.assertFalse((boolean)parameter.isOptional());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListParameterTestWithNameNull() {
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        new MockListParameter(null, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListParameterTestWithLabelNull() {
        String name = "Nome do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        new MockListParameter(name, null, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListParameterTestWithDescriptionNull() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        new MockListParameter(name, label, null, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
    }

    @Test
    public void testAddDifferentElements() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeValue();
        parameter.addSimpleParameterListener(listener);
        String value1 = "valor 1";
        parameter.addElement(value1);
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        String value2 = "valor 2";
        parameter.addElement(value2);
        Assert.assertEquals((long)2L, (long)listener.getHowManyEventsOccurred());
        LinkedList<String> values = new LinkedList<String>();
        values.add(value1);
        values.add(value2);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testAddValidDuplicateElements() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeValue();
        parameter.addSimpleParameterListener(listener);
        String value = "valor";
        parameter.addElement(value);
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        parameter.addElement(value);
        Assert.assertEquals((long)2L, (long)listener.getHowManyEventsOccurred());
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        values.add(value);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullElement() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        try {
            parameter.addElement(null);
        }
        finally {
            Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
            Assert.assertNull((Object)parameter.getValue());
        }
    }

    @Test
    public void testAddInvalidDuplicateElements() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = false;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeValue();
        parameter.addSimpleParameterListener(listener);
        String value = "valor";
        boolean wasAdded = parameter.addElement(value);
        Assert.assertTrue((boolean)wasAdded);
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        wasAdded = parameter.addElement(value);
        Assert.assertFalse((boolean)wasAdded);
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testAddWithSortedElements() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = true;
        boolean acceptDuplicates = false;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        String smallerValue = "valor1";
        String middleValue = "valor2";
        String greaterValue = "valor3";
        boolean wasAdded = parameter.addElement(middleValue);
        Assert.assertTrue((boolean)wasAdded);
        wasAdded = parameter.addElement(greaterValue);
        Assert.assertTrue((boolean)wasAdded);
        wasAdded = parameter.addElement(smallerValue);
        Assert.assertTrue((boolean)wasAdded);
        LinkedList<String> values = new LinkedList<String>();
        values.add(smallerValue);
        values.add(middleValue);
        values.add(greaterValue);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testAddWithUnsortedElements() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = false;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        String smallerValue = "valor1";
        String middleValue = "valor2";
        String greaterValue = "valor3";
        boolean wasAdded = parameter.addElement(middleValue);
        Assert.assertTrue((boolean)wasAdded);
        wasAdded = parameter.addElement(greaterValue);
        Assert.assertTrue((boolean)wasAdded);
        wasAdded = parameter.addElement(smallerValue);
        Assert.assertTrue((boolean)wasAdded);
        LinkedList<String> values = new LinkedList<String>();
        values.add(middleValue);
        values.add(greaterValue);
        values.add(smallerValue);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testRemoveValidElement() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeValue();
        parameter.addSimpleParameterListener(listener);
        String value1 = "valor 1";
        parameter.addElement(value1);
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        String value2 = "valor 2";
        parameter.addElement(value2);
        Assert.assertEquals((long)2L, (long)listener.getHowManyEventsOccurred());
        boolean elementWasRemoved = parameter.removeElement(0);
        Assert.assertTrue((boolean)elementWasRemoved);
        Assert.assertEquals((long)3L, (long)listener.getHowManyEventsOccurred());
        LinkedList<String> values = new LinkedList<String>();
        values.add(value2);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testRemoveAllElements() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeValue();
        parameter.addSimpleParameterListener(listener);
        String value1 = "valor 1";
        parameter.addElement(value1);
        Assert.assertEquals((long)1L, (long)listener.getHowManyEventsOccurred());
        String value2 = "valor 2";
        parameter.addElement(value2);
        Assert.assertEquals((long)2L, (long)listener.getHowManyEventsOccurred());
        boolean elementWasRemoved = parameter.removeElement(1);
        Assert.assertTrue((boolean)elementWasRemoved);
        Assert.assertEquals((long)3L, (long)listener.getHowManyEventsOccurred());
        elementWasRemoved = parameter.removeElement(0);
        Assert.assertTrue((boolean)elementWasRemoved);
        Assert.assertEquals((long)4L, (long)listener.getHowManyEventsOccurred());
        Assert.assertNull((Object)parameter.getValue());
    }

    @Test
    public void testRemoveElementWithEmptyList() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        boolean elementWasRemoved = parameter.removeElement(0);
        Assert.assertFalse((boolean)elementWasRemoved);
        Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
        Assert.assertNull((Object)parameter.getValue());
    }

    @Test
    public void testRemoveElementWithIndexOutOfRange() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        String value1 = "valor 1";
        parameter.addElement(value1);
        String value2 = "valor 2";
        parameter.addElement(value2);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        boolean elementWasRemoved = parameter.removeElement(2);
        Assert.assertFalse((boolean)elementWasRemoved);
        Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
        LinkedList<String> values = new LinkedList<String>();
        values.add(value1);
        values.add(value2);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testRemoveElementWithInvalidIndex() {
        String name = "LST";
        String label = "Lista";
        String description = "Par\u00e2metro do tipo lista";
        boolean isOptional = false;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter parameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        Assert.assertNull((Object)parameter.getValue());
        String value1 = "valor 1";
        parameter.addElement(value1);
        String value2 = "valor 2";
        parameter.addElement(value2);
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        boolean elementWasRemoved = parameter.removeElement(-1);
        Assert.assertFalse((boolean)elementWasRemoved);
        Assert.assertEquals((long)0L, (long)listener.getHowManyEventsOccurred());
        LinkedList<String> values = new LinkedList<String>();
        values.add(value1);
        values.add(value2);
        Assert.assertEquals(values, (Object)parameter.getValue());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        boolean isVisible = true;
        boolean mustSort = false;
        boolean acceptDuplicates = true;
        MockListParameter outputParameter = new MockListParameter(name, label, description, isOptional, isVisible, mustSort, acceptDuplicates, "{0}={1}");
        LinkedList<String> defaultValues = new LinkedList<String>();
        defaultValues.add("Valor-padr\u00e3o 1");
        defaultValues.add("Valor-padr\u00e3o 2");
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject((Object)outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        ListParameter inputParameter = (ListParameter)objectInput.readObject();
        Assert.assertEquals((Object)((Object)outputParameter), (Object)inputParameter);
        Assert.assertEquals((Object)outputParameter.getName(), (Object)inputParameter.getName());
        Assert.assertEquals((Object)outputParameter.getLabel(), (Object)inputParameter.getLabel());
        Assert.assertEquals((Object)outputParameter.getDescription(), (Object)inputParameter.getDescription());
        Assert.assertEquals((Object)outputParameter.getDefaultValue(), (Object)inputParameter.getDefaultValue());
        Assert.assertEquals((Object)outputParameter.isOptional(), (Object)inputParameter.isOptional());
    }
}

