/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.TextParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public final class ParameterGroupTest {
    @Test
    public void testParameterGroup1() {
        String name = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(name);
        Assert.assertNotNull((Object)parameterGroup.getName());
        Assert.assertEquals((Object)name, (Object)parameterGroup.getName());
        Assert.assertNotNull((Object)parameterGroup.getLabel());
        Assert.assertEquals((Object)name, (Object)parameterGroup.getName());
        Assert.assertNotNull((Object)parameterGroup.getInputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.getInputFileParameters().isEmpty());
        Assert.assertNotNull((Object)parameterGroup.getOutputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.getOutputFileParameters().isEmpty());
        Assert.assertNotNull((Object)parameterGroup.getParameters());
        Assert.assertTrue((boolean)parameterGroup.getParameters().isEmpty());
        Assert.assertNotNull((Object)parameterGroup.getParameters());
        Assert.assertTrue((boolean)parameterGroup.getParameters().isEmpty());
        Assert.assertFalse((boolean)parameterGroup.isVisible());
        Assert.assertFalse((boolean)parameterGroup.isCollapsible());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParameterGroup2() {
        new ParameterGroup(null);
    }

    @Test
    public void testParameterGroupWithId() {
        String label = "Nome do grupo";
        String id = "Id do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(id, label, false);
        Assert.assertNotNull((Object)parameterGroup.getName());
        Assert.assertEquals((Object)id, (Object)parameterGroup.getName());
        Assert.assertNotNull((Object)parameterGroup.getLabel());
        Assert.assertEquals((Object)label, (Object)parameterGroup.getLabel());
        Assert.assertNotNull((Object)parameterGroup.getInputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.getInputFileParameters().isEmpty());
        Assert.assertNotNull((Object)parameterGroup.getOutputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.getOutputFileParameters().isEmpty());
        Assert.assertNotNull((Object)parameterGroup.getParameters());
        Assert.assertTrue((boolean)parameterGroup.getParameters().isEmpty());
        Assert.assertNotNull((Object)parameterGroup.getParameters());
        Assert.assertTrue((boolean)parameterGroup.getParameters().isEmpty());
        Assert.assertFalse((boolean)parameterGroup.isVisible());
        Assert.assertFalse((boolean)parameterGroup.isCollapsible());
    }

    @Test
    public void testParameterGroupCollapsible() {
        String label = "Nome do grupo";
        String id = "Id do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(id, label, true);
        Assert.assertNotNull((Object)parameterGroup.getName());
        Assert.assertEquals((Object)id, (Object)parameterGroup.getName());
        Assert.assertNotNull((Object)parameterGroup.getLabel());
        Assert.assertEquals((Object)label, (Object)parameterGroup.getLabel());
        Assert.assertNotNull((Object)parameterGroup.getInputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.getInputFileParameters().isEmpty());
        Assert.assertNotNull((Object)parameterGroup.getOutputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.getOutputFileParameters().isEmpty());
        Assert.assertNotNull((Object)parameterGroup.getParameters());
        Assert.assertTrue((boolean)parameterGroup.getParameters().isEmpty());
        Assert.assertNotNull((Object)parameterGroup.getParameters());
        Assert.assertTrue((boolean)parameterGroup.getParameters().isEmpty());
        Assert.assertFalse((boolean)parameterGroup.isVisible());
        Assert.assertTrue((boolean)parameterGroup.isCollapsible());
    }

    @Test
    public void testToString() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        Assert.assertNotNull((Object)parameterGroup.toString());
        Assert.assertEquals((Object)groupName, (Object)parameterGroup.toString());
    }

    @Test
    public void testAddParameter1() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        ArrayList<InputFileParameter> parameters = new ArrayList<InputFileParameter>();
        LinkedList<InputFileParameter> inputFileParameters = new LinkedList<InputFileParameter>();
        int i = 0;
        while (i < 10) {
            String parameterName = "Nome do par\u00e2metro " + i;
            String parameterLabel = "R\u00f3tulo do par\u00e2metro " + i;
            String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro " + i;
            InputFileParameter parameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, true, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
            Assert.assertTrue((boolean)parameterGroup.addParameter((Parameter)parameter));
            parameters.add(parameter);
            inputFileParameters.add(parameter);
            ++i;
        }
        Assert.assertEquals(parameters, (Object)parameterGroup.getParameters());
        Assert.assertEquals(inputFileParameters, (Object)parameterGroup.getInputFileParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getOutputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.isVisible());
    }

    @Test
    public void testAddParameter2() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        InputFileParameter parameter = new InputFileParameter(parameterName, parameterLabel, parameterDescription, null, true, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        Assert.assertTrue((boolean)parameterGroup.addParameter((Parameter)parameter));
        ArrayList<InputFileParameter> parameters = new ArrayList<InputFileParameter>();
        parameters.add(parameter);
        LinkedList<InputFileParameter> inputFileParameters = new LinkedList<InputFileParameter>();
        inputFileParameters.add(parameter);
        Assert.assertFalse((boolean)parameterGroup.addParameter((Parameter)parameter));
        Assert.assertEquals(parameters, (Object)parameterGroup.getParameters());
        Assert.assertEquals(inputFileParameters, (Object)parameterGroup.getInputFileParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getOutputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.isVisible());
    }

    @Test
    public void testAddParameter3() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        ArrayList<OutputFileParameter> parameters = new ArrayList<OutputFileParameter>();
        LinkedList<OutputFileParameter> outputFileParameters = new LinkedList<OutputFileParameter>();
        int i = 0;
        while (i < 10) {
            String parameterName = "Nome do par\u00e2metro " + i;
            String parameterLabel = "R\u00f3tulo do par\u00e2metro " + i;
            String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro " + i;
            OutputFileParameter parameter = new OutputFileParameter(parameterName, parameterLabel, parameterDescription, null, true, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
            Assert.assertTrue((boolean)parameterGroup.addParameter((Parameter)parameter));
            parameters.add(parameter);
            outputFileParameters.add(parameter);
            ++i;
        }
        Assert.assertEquals(parameters, (Object)parameterGroup.getParameters());
        Assert.assertEquals(outputFileParameters, (Object)parameterGroup.getOutputFileParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getInputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.isVisible());
    }

    @Test
    public void testAddParameter4() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        OutputFileParameter parameter = new OutputFileParameter(parameterName, parameterLabel, parameterDescription, null, true, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        Assert.assertTrue((boolean)parameterGroup.addParameter((Parameter)parameter));
        ArrayList<OutputFileParameter> parameters = new ArrayList<OutputFileParameter>();
        parameters.add(parameter);
        LinkedList<OutputFileParameter> outputFileParameters = new LinkedList<OutputFileParameter>();
        outputFileParameters.add(parameter);
        Assert.assertFalse((boolean)parameterGroup.addParameter((Parameter)parameter));
        Assert.assertEquals(parameters, (Object)parameterGroup.getParameters());
        Assert.assertEquals(outputFileParameters, (Object)parameterGroup.getOutputFileParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getInputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.isVisible());
    }

    @Test
    public void testAddParameter5() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        ArrayList<TextParameter> parameters = new ArrayList<TextParameter>();
        HashSet<TextParameter> simpleParameters = new HashSet<TextParameter>();
        int i = 0;
        while (i < 10) {
            String parameterName = "Nome do par\u00e2metro " + i;
            String parameterLabel = "R\u00f3tulo do par\u00e2metro " + i;
            String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro " + i;
            String parameterDefaultValue = "Valor-padr\u00e3o do par\u00e2metro " + i;
            TextParameter parameter = new TextParameter(parameterName, parameterLabel, parameterDescription, parameterDefaultValue, true, true, null, null);
            Assert.assertTrue((boolean)parameterGroup.addParameter((Parameter)parameter));
            parameters.add(parameter);
            simpleParameters.add(parameter);
            ++i;
        }
        Assert.assertEquals(parameters, (Object)parameterGroup.getParameters());
        Assert.assertEquals(simpleParameters, (Object)parameterGroup.getSimpleParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getOutputFileParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getInputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.isVisible());
    }

    @Test
    public void testAddParameter6() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String parameterLabel = "R\u00f3tulo do par\u00e2metro";
        String parameterDescription = "Descri\u00e7\u00e3o do par\u00e2metro";
        String parameterDefaultValue = "Valor-padr\u00e3o do par\u00e2metro";
        TextParameter parameter = new TextParameter(parameterName, parameterLabel, parameterDescription, parameterDefaultValue, true, true, null, null);
        Assert.assertTrue((boolean)parameterGroup.addParameter((Parameter)parameter));
        ArrayList<TextParameter> parameters = new ArrayList<TextParameter>();
        parameters.add(parameter);
        HashSet<TextParameter> simpleParameters = new HashSet<TextParameter>();
        simpleParameters.add(parameter);
        Assert.assertFalse((boolean)parameterGroup.addParameter((Parameter)parameter));
        Assert.assertEquals(parameters, (Object)parameterGroup.getParameters());
        Assert.assertEquals(simpleParameters, (Object)parameterGroup.getSimpleParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getOutputFileParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getInputFileParameters());
        Assert.assertTrue((boolean)parameterGroup.isVisible());
    }

    @Test
    public void testAddParameter7() {
        String parentGroupName = "Grupo pai";
        ParameterGroup parameterGroup = new ParameterGroup(parentGroupName);
        String childGroupName = "Grupo filho";
        ParameterGroup childGroup = new ParameterGroup(childGroupName);
        Assert.assertTrue((boolean)parameterGroup.addParameter((Parameter)childGroup));
        ArrayList<ParameterGroup> parameters = new ArrayList<ParameterGroup>();
        parameters.add(childGroup);
        Assert.assertEquals(parameters, (Object)parameterGroup.getParameters());
        Assert.assertEquals(new HashSet(), (Object)parameterGroup.getSimpleParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getOutputFileParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getInputFileParameters());
        Assert.assertFalse((boolean)parameterGroup.isVisible());
    }

    @Test
    public void testAddParameter8() {
        String parentGroupName = "Grupo pai";
        ParameterGroup parameterGroup = new ParameterGroup(parentGroupName);
        String childGroupName = "Grupo filho";
        ParameterGroup childGroup = new ParameterGroup(childGroupName);
        Assert.assertTrue((boolean)parameterGroup.addParameter((Parameter)childGroup));
        Assert.assertFalse((boolean)parameterGroup.addParameter((Parameter)childGroup));
        ArrayList<ParameterGroup> parameters = new ArrayList<ParameterGroup>();
        parameters.add(childGroup);
        Assert.assertEquals(parameters, (Object)parameterGroup.getParameters());
        Assert.assertEquals(new HashSet(), (Object)parameterGroup.getSimpleParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getOutputFileParameters());
        Assert.assertEquals(new LinkedList(), (Object)parameterGroup.getInputFileParameters());
        Assert.assertFalse((boolean)parameterGroup.isVisible());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddParameter9() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        parameterGroup.addParameter(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetParameters() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        parameterGroup.getParameters().clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetInputFileParameters1() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        parameterGroup.getInputFileParameters().clear();
    }

    @Test
    public void testGetInputFileParameters2() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        InputFileParameter parameter1 = new InputFileParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        InputFileParameter parameter2 = new InputFileParameter("Nome do par\u00e2metro 2", "R\u00f3tulo do par\u00e2metro 2", "Descri\u00e7\u00e3o do par\u00e2metro 2", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        LinkedList<InputFileParameter> parameters = new LinkedList<InputFileParameter>();
        parameters.add(parameter1);
        parameters.add(parameter2);
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        Assert.assertEquals(parameters, (Object)parameterGroup.getInputFileParameters());
    }

    @Test
    public void testGetInputFileParameters3() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        InputFileParameter parameter2 = new InputFileParameter("Nome do par\u00e2metro 2", "R\u00f3tulo do par\u00e2metro 2", "Descri\u00e7\u00e3o do par\u00e2metro 2", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        InputFileParameter parameter3 = new InputFileParameter("Nome do par\u00e2metro 3", "R\u00f3tulo do par\u00e2metro 3", "Descri\u00e7\u00e3o do par\u00e2metro 3", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        LinkedList<InputFileParameter> parameters = new LinkedList<InputFileParameter>();
        parameters.add(parameter2);
        parameters.add(parameter3);
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        parameterGroup.addParameter((Parameter)parameter3);
        Assert.assertEquals(parameters, (Object)parameterGroup.getInputFileParameters());
    }

    @Test
    public void testGetInputFileParameters4() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        InputFileParameter parameter2 = new InputFileParameter("Nome do par\u00e2metro 2", "R\u00f3tulo do par\u00e2metro 2", "Descri\u00e7\u00e3o do par\u00e2metro 2", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        InputFileParameter parameter3 = new InputFileParameter("Nome do par\u00e2metro 3", "R\u00f3tulo do par\u00e2metro 3", "Descri\u00e7\u00e3o do par\u00e2metro 3", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        InputFileParameter parameter4 = new InputFileParameter("Nome do par\u00e2metro 4", "R\u00f3tulo do par\u00e2metro 4", "Descri\u00e7\u00e3o do par\u00e2metro 4", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        InputFileParameter parameter5 = new InputFileParameter("Nome do par\u00e2metro 5", "R\u00f3tulo do par\u00e2metro 5", "Descri\u00e7\u00e3o do par\u00e2metro 5", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        ParameterGroup childGroup = new ParameterGroup("Grupo filho");
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        parameterGroup.addParameter((Parameter)parameter3);
        childGroup.addParameter((Parameter)parameter4);
        childGroup.addParameter((Parameter)parameter5);
        parameterGroup.addParameter((Parameter)childGroup);
        LinkedList<InputFileParameter> parameters = new LinkedList<InputFileParameter>();
        parameters.add(parameter2);
        parameters.add(parameter3);
        parameters.add(parameter4);
        parameters.add(parameter5);
        Assert.assertEquals(parameters, (Object)parameterGroup.getInputFileParameters());
    }

    @Test
    public void testGetInputFileParameters5() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        InputFileParameter parameter2 = new InputFileParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        InputFileParameter parameter3 = new InputFileParameter("Nome do par\u00e2metro 2", "R\u00f3tulo do par\u00e2metro 2", "Descri\u00e7\u00e3o do par\u00e2metro 2", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        ParameterGroup childGroup = new ParameterGroup("Grupo filho");
        parameterGroup.addParameter((Parameter)childGroup);
        LinkedList<InputFileParameter> parameters = new LinkedList<InputFileParameter>();
        parameters.add(parameter2);
        parameters.add(parameter3);
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        parameterGroup.addParameter((Parameter)parameter3);
        Assert.assertEquals(parameters, (Object)parameterGroup.getInputFileParameters());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetOutputFileParameters1() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        parameterGroup.getOutputFileParameters().clear();
    }

    @Test
    public void testGetOutputFileParameters2() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        OutputFileParameter parameter1 = new OutputFileParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        OutputFileParameter parameter2 = new OutputFileParameter("Nome do par\u00e2metro 2", "R\u00f3tulo do par\u00e2metro 2", "Descri\u00e7\u00e3o do par\u00e2metro 2", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        LinkedList<OutputFileParameter> parameters = new LinkedList<OutputFileParameter>();
        parameters.add(parameter1);
        parameters.add(parameter2);
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        Assert.assertEquals(parameters, (Object)parameterGroup.getOutputFileParameters());
    }

    @Test
    public void testGetOutputFileParameters3() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        OutputFileParameter parameter2 = new OutputFileParameter("Nome do par\u00e2metro 2", "R\u00f3tulo do par\u00e2metro 2", "Descri\u00e7\u00e3o do par\u00e2metro 2", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        OutputFileParameter parameter3 = new OutputFileParameter("Nome do par\u00e2metro 3", "R\u00f3tulo do par\u00e2metro 3", "Descri\u00e7\u00e3o do par\u00e2metro 3", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        LinkedList<OutputFileParameter> parameters = new LinkedList<OutputFileParameter>();
        parameters.add(parameter2);
        parameters.add(parameter3);
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        parameterGroup.addParameter((Parameter)parameter3);
        Assert.assertEquals(parameters, (Object)parameterGroup.getOutputFileParameters());
    }

    @Test
    public void testGetOutputFileParameters4() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        OutputFileParameter parameter2 = new OutputFileParameter("Nome do par\u00e2metro 2", "R\u00f3tulo do par\u00e2metro 2", "Descri\u00e7\u00e3o do par\u00e2metro 2", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        OutputFileParameter parameter3 = new OutputFileParameter("Nome do par\u00e2metro 3", "R\u00f3tulo do par\u00e2metro 3", "Descri\u00e7\u00e3o do par\u00e2metro 3", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        OutputFileParameter parameter4 = new OutputFileParameter("Nome do par\u00e2metro 4", "R\u00f3tulo do par\u00e2metro 4", "Descri\u00e7\u00e3o do par\u00e2metro 4", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        OutputFileParameter parameter5 = new OutputFileParameter("Nome do par\u00e2metro 5", "R\u00f3tulo do par\u00e2metro 5", "Descri\u00e7\u00e3o do par\u00e2metro 5", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        ParameterGroup childGroup = new ParameterGroup("Grupo filho");
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        parameterGroup.addParameter((Parameter)parameter3);
        childGroup.addParameter((Parameter)parameter4);
        childGroup.addParameter((Parameter)parameter5);
        parameterGroup.addParameter((Parameter)childGroup);
        LinkedList<OutputFileParameter> parameters = new LinkedList<OutputFileParameter>();
        parameters.add(parameter2);
        parameters.add(parameter3);
        parameters.add(parameter4);
        parameters.add(parameter5);
        Assert.assertEquals(parameters, (Object)parameterGroup.getOutputFileParameters());
    }

    @Test
    public void testGetOutputFileParameters5() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        OutputFileParameter parameter2 = new OutputFileParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        OutputFileParameter parameter3 = new OutputFileParameter("Nome do par\u00e2metro 2", "R\u00f3tulo do par\u00e2metro 2", "Descri\u00e7\u00e3o do par\u00e2metro 2", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        ParameterGroup childGroup = new ParameterGroup("Grupo filho");
        parameterGroup.addParameter((Parameter)childGroup);
        LinkedList<OutputFileParameter> parameters = new LinkedList<OutputFileParameter>();
        parameters.add(parameter2);
        parameters.add(parameter3);
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        parameterGroup.addParameter((Parameter)parameter3);
        Assert.assertEquals(parameters, (Object)parameterGroup.getOutputFileParameters());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetSimpleParameters1() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        parameterGroup.getSimpleParameters().clear();
    }

    @Test
    public void testGetSimpleParameters2() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        MockSimpleParameter parameter2 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        HashSet<MockSimpleParameter> parameters = new HashSet<MockSimpleParameter>();
        parameters.add(parameter1);
        parameters.add(parameter2);
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        Assert.assertEquals(parameters, (Object)parameterGroup.getSimpleParameters());
    }

    @Test
    public void testGetSimpleParameters3() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        MockSimpleParameter parameter2 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        MockSimpleParameter parameter3 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        HashSet<MockSimpleParameter> parameters = new HashSet<MockSimpleParameter>();
        parameters.add(parameter2);
        parameters.add(parameter3);
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        parameterGroup.addParameter((Parameter)parameter3);
        Assert.assertEquals(parameters, (Object)parameterGroup.getSimpleParameters());
    }

    @Test
    public void testGetSimpleParameters4() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        MockSimpleParameter parameter2 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        MockSimpleParameter parameter3 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        MockSimpleParameter parameter4 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        MockSimpleParameter parameter5 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        ParameterGroup childGroup = new ParameterGroup("Grupo filho");
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        parameterGroup.addParameter((Parameter)parameter3);
        childGroup.addParameter((Parameter)parameter4);
        childGroup.addParameter((Parameter)parameter5);
        parameterGroup.addParameter((Parameter)childGroup);
        HashSet<MockSimpleParameter> parameters = new HashSet<MockSimpleParameter>();
        parameters.add(parameter2);
        parameters.add(parameter3);
        parameters.add(parameter4);
        parameters.add(parameter5);
        Assert.assertEquals(parameters, (Object)parameterGroup.getSimpleParameters());
    }

    @Test
    public void testGetSimpleParameters5() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        MockSimpleParameter parameter1 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        MockSimpleParameter parameter2 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        MockSimpleParameter parameter3 = new MockSimpleParameter("Nome do par\u00e2metro 1", "R\u00f3tulo do par\u00e2metro 1", "Descri\u00e7\u00e3o do par\u00e2metro 1", null, false, true, null);
        ParameterGroup childGroup = new ParameterGroup("Grupo filho");
        parameterGroup.addParameter((Parameter)childGroup);
        HashSet<MockSimpleParameter> parameters = new HashSet<MockSimpleParameter>();
        parameters.add(parameter2);
        parameters.add(parameter3);
        parameterGroup.addParameter((Parameter)parameter1);
        parameterGroup.addParameter((Parameter)parameter2);
        parameterGroup.addParameter((Parameter)parameter3);
        Assert.assertEquals(parameters, (Object)parameterGroup.getSimpleParameters());
    }

    @Test
    public void testEqualsObject1() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        ParameterGroup equalsParameterGroup = new ParameterGroup(groupName);
        Assert.assertEquals((Object)parameterGroup, (Object)equalsParameterGroup);
    }

    @Test
    public void testEqualsObject2() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        Assert.assertFalse((boolean)parameterGroup.equals(null));
    }

    @Test
    public void testEqualsObject3() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        String objectOfAnotherClass = "Objeto de outra classe";
        Assert.assertFalse((boolean)parameterGroup.equals((Object)objectOfAnotherClass));
    }

    @Test
    public void testEqualsObject4() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        String anotherGroupName = "Outro grupo";
        ParameterGroup equalsParameterGroup = new ParameterGroup(anotherGroupName);
        Assert.assertFalse((boolean)parameterGroup.equals((Object)equalsParameterGroup));
    }

    @Test
    public void testHashCode() {
        String groupName = "Nome do grupo";
        ParameterGroup parameterGroup = new ParameterGroup(groupName);
        ParameterGroup equalsParameterGroup = new ParameterGroup(groupName);
        Assert.assertEquals((long)parameterGroup.hashCode(), (long)equalsParameterGroup.hashCode());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        ParameterGroup expectedGroup = new ParameterGroup("Nome do grupo");
        InputFileParameter inputFileParameter = new InputFileParameter("Entrada", "Entrada", "Entrada", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false);
        expectedGroup.addParameter((Parameter)inputFileParameter);
        OutputFileParameter outputFileParameter = new OutputFileParameter("Saida", "Saida", "Saida", null, false, true, null, null, FileParameterMode.REGULAR_FILE, FileParameterPipeAcceptance.TRUE, false, false);
        expectedGroup.addParameter((Parameter)outputFileParameter);
        MockSimpleParameter simpleParameter = new MockSimpleParameter("Simples", "Simples", "Simples", null, false, true, null);
        expectedGroup.addParameter((Parameter)simpleParameter);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(expectedGroup);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        ParameterGroup loadedGroup = (ParameterGroup)objectInput.readObject();
        Assert.assertEquals((Object)expectedGroup.getName(), (Object)loadedGroup.getName());
        Assert.assertEquals((Object)expectedGroup.getInputFileParameters(), (Object)loadedGroup.getInputFileParameters());
        Assert.assertEquals((Object)expectedGroup.getOutputFileParameters(), (Object)loadedGroup.getOutputFileParameters());
        Assert.assertEquals((Object)expectedGroup.getParameters(), (Object)loadedGroup.getParameters());
        Assert.assertEquals((Object)expectedGroup.isVisible(), (Object)loadedGroup.isVisible());
        Assert.assertEquals((Object)expectedGroup.isCollapsible(), (Object)loadedGroup.isCollapsible());
    }
}

