/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.CheckParameterListener;
import csbase.logic.algorithms.parameters.MockParameterListener;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.SimpleParameterListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public final class SimpleParameterTest {
    public static <V> void assertEquals(SimpleParameter<V> expectedParameter, SimpleParameter<V> foundParameter) {
        SimpleParameterTest.assertEquals(expectedParameter.getName(), expectedParameter.getLabel(), expectedParameter.getDescription(), expectedParameter.getDefaultValue(), expectedParameter.isOptional(), expectedParameter.getCommandLinePattern(), expectedParameter.isEnabled(), expectedParameter.getSimpleParameterListeners(), foundParameter);
    }

    public static <V> void assertEquals(String name, String label, String description, Object defaultValue, boolean isOptional, String commandLinePattern, boolean isEnabled, List<SimpleParameterListener<V>> listeners, SimpleParameter<V> parameter) {
        junit.framework.Assert.assertEquals((String)name, (String)parameter.getName());
        junit.framework.Assert.assertEquals((String)label, (String)parameter.getLabel());
        junit.framework.Assert.assertEquals((String)commandLinePattern, (String)parameter.getCommandLinePattern());
        junit.framework.Assert.assertEquals((String)description, (String)parameter.getDescription());
        junit.framework.Assert.assertEquals((Object)defaultValue, (Object)parameter.getDefaultValue());
        junit.framework.Assert.assertEquals((boolean)isOptional, (boolean)parameter.isOptional());
        junit.framework.Assert.assertEquals((Object)defaultValue, (Object)parameter.getValue());
        junit.framework.Assert.assertEquals((boolean)isEnabled, (boolean)parameter.isEnabled());
        junit.framework.Assert.assertEquals(listeners, (Object)parameter.getSimpleParameterListeners());
    }

    public static SimpleParameter<Object> create() {
        return SimpleParameterTest.create(null);
    }

    public static SimpleParameter<Object> create(Object value) {
        return SimpleParameterTest.create(value, false, true);
    }

    public static SimpleParameter<Object> create(String name, Object value, String commandLinePattern) {
        return SimpleParameterTest.create(name, value, false, true, commandLinePattern);
    }

    public static SimpleParameter<Object> create(Object value, boolean isOptional, boolean isVisible) {
        return SimpleParameterTest.create("Nome do par\u00e2metro", value, isOptional, isVisible, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO");
    }

    public static SimpleParameter<Object> create(String name, Object value, boolean isOptional, boolean isVisible, String commandLinePattern) {
        return new MockSimpleParameter(name, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", value, isOptional, isVisible, commandLinePattern);
    }

    @Test
    public void testParameter1() {
        boolean isOptional = true;
        boolean isVisible = true;
        String name = "O nome do par\u00e2metro";
        String label = "O r\u00f3tulo do par\u00e2metro";
        String description = "A descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "O valor-padr\u00e3o do par\u00e2metro";
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        MockSimpleParameter parameter = new MockSimpleParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        SimpleParameterTest.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, true, new LinkedList(), parameter);
    }

    @Test
    public void testParameter2() {
        boolean isOptional = false;
        boolean isVisible = true;
        String name = "O nome do par\u00e2metro";
        String label = "O r\u00f3tulo do par\u00e2metro";
        String description = "A descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "O valor-padr\u00e3o do par\u00e2metro";
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        MockSimpleParameter parameter = new MockSimpleParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        SimpleParameterTest.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, true, new LinkedList(), parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParameter3() {
        new MockSimpleParameter(null, "O r\u00f3tulo do par\u00e2metro", "A descri\u00e7\u00e3o do par\u00e2metro", "O valor-padr\u00e3o do par\u00e2metro", false, true, "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParameter4() {
        new MockSimpleParameter("O nome do par\u00e2metro", null, "A descri\u00e7\u00e3o do par\u00e2metro", "O valor-padr\u00e3o do par\u00e2metro", false, true, "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParameter5() {
        new MockSimpleParameter("O nome do par\u00e2metro", "O r\u00f3tulo do par\u00e2metro", null, "O valor-padr\u00e3o do par\u00e2metro", false, true, "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO");
    }

    @Test
    public void testParameter6() {
        String name = "O nome do par\u00e2metro";
        String label = "O r\u00f3tulo do par\u00e2metro";
        String description = "A descri\u00e7\u00e3o do par\u00e2metro";
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        boolean isOptional = true;
        boolean isVisible = true;
        MockSimpleParameter parameter = new MockSimpleParameter(name, label, description, null, isOptional, isVisible, commandLinePattern);
        SimpleParameterTest.assertEquals(name, label, description, null, isOptional, commandLinePattern, true, new LinkedList(), parameter);
    }

    @Test
    public void testParameter7() {
        String name = "O nome do par\u00e2metro";
        String label = "O r\u00f3tulo do par\u00e2metro";
        String description = "A descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "O valor-padr\u00e3o do par\u00e2metro";
        String commandLinePattern = null;
        boolean isOptional = true;
        boolean isVisible = true;
        MockSimpleParameter parameter = new MockSimpleParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        SimpleParameterTest.assertEquals(name, label, description, defaultValue, isOptional, commandLinePattern, true, new LinkedList(), parameter);
    }

    @Test
    public void testToString1() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        junit.framework.Assert.assertEquals((String)parameter.getName(), (String)parameter.toString());
    }

    @Test
    public void testEquals1() {
        String name1 = "O nome do par\u00e2metro";
        String label1 = "O r\u00f3tulo do par\u00e2metro";
        String description1 = "A descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue1 = "O valor do par\u00e2metro";
        boolean isOptional1 = true;
        boolean isVisible1 = true;
        String commandLinePattern1 = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        MockSimpleParameter parameter1 = new MockSimpleParameter(name1, label1, description1, defaultValue1, isOptional1, isVisible1, commandLinePattern1);
        String label2 = "O r\u00f3tulo do par\u00e2metro 2";
        String description2 = "A descri\u00e7\u00e3o do par\u00e2metro 2";
        String defaultValue2 = "O valor do par\u00e2metro 2";
        boolean isOptional2 = false;
        boolean isVisible2 = true;
        String commandLinePattern2 = "--$VALOR_DO_PARAMETRO $NOME_DO_PARAMETRO";
        MockSimpleParameter parameter2 = new MockSimpleParameter(name1, label2, description2, defaultValue2, isOptional2, isVisible2, commandLinePattern2);
        Assert.assertTrue((boolean)parameter1.equals((Object)parameter2));
    }

    @Test
    public void testEquals2() {
        String name1 = "O nome do par\u00e2metro";
        String label1 = "O r\u00f3tulo do par\u00e2metro";
        String description1 = "A descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue1 = "O valor do par\u00e2metro";
        boolean isOptional1 = true;
        boolean isVisible1 = true;
        String commandLinePattern1 = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        MockSimpleParameter parameter1 = new MockSimpleParameter(name1, label1, description1, defaultValue1, isOptional1, isVisible1, commandLinePattern1);
        String name2 = "Outro nome de par\u00e2metro";
        MockSimpleParameter parameter2 = new MockSimpleParameter(name2, label1, description1, defaultValue1, isOptional1, isVisible1, commandLinePattern1);
        Assert.assertFalse((boolean)parameter1.equals((Object)parameter2));
    }

    @Test
    public void testEquals3() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        Assert.assertFalse((boolean)parameter.equals(null));
    }

    @Test
    public void testEquals4() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        Assert.assertFalse((boolean)parameter.equals((Object)"Objeto de outra classe"));
    }

    @Test
    public void testHashCode1() {
        String name1 = "O nome do par\u00e2metro";
        String label1 = "O r\u00f3tulo do par\u00e2metro";
        String description1 = "A descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue1 = "O valor do par\u00e2metro";
        boolean isOptional1 = true;
        boolean isVisible1 = true;
        String commandLinePattern1 = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        MockSimpleParameter parameter1 = new MockSimpleParameter(name1, label1, description1, defaultValue1, isOptional1, isVisible1, commandLinePattern1);
        String label2 = "O r\u00f3tulo do par\u00e2metro 2";
        String description2 = "A descri\u00e7\u00e3o do par\u00e2metro 2";
        String defaultValue2 = "O valor do par\u00e2metro 2";
        boolean isOptional2 = false;
        boolean isVisible2 = true;
        String commandLinePattern2 = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        MockSimpleParameter parameter2 = new MockSimpleParameter(name1, label2, description2, defaultValue2, isOptional2, isVisible2, commandLinePattern2);
        junit.framework.Assert.assertEquals((int)parameter1.hashCode(), (int)parameter2.hashCode());
    }

    @Test
    public void testAddListener1() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        Assert.assertNotNull((Object)parameter.getSimpleParameterListeners());
        Assert.assertTrue((boolean)parameter.getSimpleParameterListeners().isEmpty());
        LinkedList<MockParameterListener> listeners = new LinkedList<MockParameterListener>();
        MockParameterListener listener = new MockParameterListener();
        listeners.add(listener);
        parameter.addSimpleParameterListener((SimpleParameterListener)listener);
        junit.framework.Assert.assertEquals(listeners, (Object)parameter.getSimpleParameterListeners());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddListener2() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        parameter.addSimpleParameterListener(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetListeners1() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        Assert.assertNotNull((Object)parameter.getSimpleParameterListeners());
        Assert.assertTrue((boolean)parameter.getSimpleParameterListeners().isEmpty());
        LinkedList<MockParameterListener> listeners = new LinkedList<MockParameterListener>();
        MockParameterListener listener = new MockParameterListener();
        listeners.add(listener);
        parameter.addSimpleParameterListener((SimpleParameterListener)listener);
        junit.framework.Assert.assertEquals(listeners, (Object)parameter.getSimpleParameterListeners());
        try {
            parameter.getSimpleParameterListeners().clear();
        }
        finally {
            junit.framework.Assert.assertEquals(listeners, (Object)parameter.getSimpleParameterListeners());
        }
    }

    @Test
    public void testSetValue1() {
        String value = "Valor do par\u00e2metro";
        SimpleParameter<Object> parameter = SimpleParameterTest.create(value);
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeValue();
        parameter.addSimpleParameterListener(listener);
        String otherValue = "Outro valor do par\u00e2metro";
        Assert.assertTrue((boolean)parameter.setValue((Object)otherValue));
        junit.framework.Assert.assertEquals((int)1, (int)listener.getHowManyEventsOccurred());
        junit.framework.Assert.assertEquals((Object)otherValue, (Object)parameter.getValue());
    }

    @Test
    public void testSetValue2() {
        String value = "Valor do par\u00e2metro";
        SimpleParameter<Object> parameter = SimpleParameterTest.create(value);
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeValue();
        parameter.addSimpleParameterListener(listener);
        Assert.assertTrue((boolean)parameter.setValue(null));
        junit.framework.Assert.assertEquals((int)1, (int)listener.getHowManyEventsOccurred());
        Assert.assertNull((Object)parameter.getValue());
    }

    @Test
    public void testSetValue3() {
        String value = "Valor do par\u00e2metro";
        SimpleParameter<Object> parameter = SimpleParameterTest.create(value);
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        Assert.assertFalse((boolean)parameter.setValue((Object)value));
        junit.framework.Assert.assertEquals((int)0, (int)listener.getHowManyEventsOccurred());
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
    }

    @Test
    public void testSetValue4() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create(null);
        Assert.assertNull((Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeValue();
        parameter.addSimpleParameterListener(listener);
        String otherValue = "Outro valor do par\u00e2metro";
        Assert.assertTrue((boolean)parameter.setValue((Object)otherValue));
        junit.framework.Assert.assertEquals((int)1, (int)listener.getHowManyEventsOccurred());
        junit.framework.Assert.assertEquals((Object)otherValue, (Object)parameter.getValue());
    }

    @Test
    public void testSetValue5() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create(null);
        Assert.assertNull((Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        parameter.addSimpleParameterListener(listener);
        Assert.assertFalse((boolean)parameter.setValue(null));
        junit.framework.Assert.assertEquals((int)0, (int)listener.getHowManyEventsOccurred());
        Assert.assertNull((Object)parameter.getValue());
    }

    @Test
    public void testResetValue1() {
        String value = "Valor do par\u00e2metro";
        SimpleParameter<Object> parameter = SimpleParameterTest.create(value);
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeValue();
        parameter.addSimpleParameterListener(listener);
        String otherValue = "Outro valor do par\u00e2metro";
        Assert.assertTrue((boolean)parameter.setValue((Object)otherValue));
        junit.framework.Assert.assertEquals((int)1, (int)listener.getHowManyEventsOccurred());
        junit.framework.Assert.assertEquals((Object)otherValue, (Object)parameter.getValue());
        parameter.resetValue();
        junit.framework.Assert.assertEquals((int)2, (int)listener.getHowManyEventsOccurred());
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
    }

    @Test
    public void testGetCommandValue1() {
        String value = "Valor do par\u00e2metro";
        SimpleParameter<Object> parameter = SimpleParameterTest.create(value);
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getCommandValue(null));
    }

    @Test
    public void testGetCommandValue2() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create(null);
        Assert.assertNull((Object)parameter.getValue());
        junit.framework.Assert.assertEquals((Object)parameter.getValue(), (Object)parameter.getCommandValue(null));
    }

    @Test
    public void testGetCommandLine1() {
        String name = "nome";
        String value = "valor";
        String commandLinePattern = "--$NOME_DO_PARAMETRO $VALOR_DO_PARAMETRO";
        SimpleParameter<Object> parameter = SimpleParameterTest.create(name, value, commandLinePattern);
        String expectedCommandLine = "--nome valor";
        String foundCommandLine = parameter.getCommandLine(null);
        junit.framework.Assert.assertEquals((String)expectedCommandLine, (String)foundCommandLine);
    }

    @Test
    public void testGetCommandLine2() {
        String name = "nome";
        String value = "valor";
        String commandLinePattern = "<<$NOME_DO_PARAMETRO>>";
        SimpleParameter<Object> parameter = SimpleParameterTest.create(name, value, commandLinePattern);
        String expectedCommandLine = "<<nome>>";
        String foundCommandLine = parameter.getCommandLine(null);
        junit.framework.Assert.assertEquals((String)expectedCommandLine, (String)foundCommandLine);
    }

    @Test
    public void testGetCommandLine3() {
        String name = "nome";
        String value = "valor";
        String commandLinePattern = "[$VALOR_DO_PARAMETRO]";
        SimpleParameter<Object> parameter = SimpleParameterTest.create(name, value, commandLinePattern);
        String expectedCommandLine = "[valor]";
        String foundCommandLine = parameter.getCommandLine(null);
        junit.framework.Assert.assertEquals((String)expectedCommandLine, (String)foundCommandLine);
    }

    @Test
    public void testGetCommandLine4() {
        String name = "nome";
        String value = "valor";
        String commandLinePattern = null;
        SimpleParameter<Object> parameter = SimpleParameterTest.create(name, value, commandLinePattern);
        String expectedCommandLine = null;
        String foundCommandLine = parameter.getCommandLine(null);
        junit.framework.Assert.assertEquals(expectedCommandLine, (String)foundCommandLine);
    }

    @Test
    public void testSetEnabled1() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        Assert.assertTrue((boolean)parameter.isEnabled());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeEnabledStatus();
        parameter.addSimpleParameterListener(listener);
        Assert.assertTrue((boolean)parameter.setEnabled(false));
        junit.framework.Assert.assertEquals((int)1, (int)listener.getHowManyEventsOccurred());
        Assert.assertFalse((boolean)parameter.isEnabled());
    }

    @Test
    public void testSetEnabled2() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        Assert.assertTrue((boolean)parameter.isEnabled());
        CheckParameterListener listener = new CheckParameterListener();
        listener.allowChangeEnabledStatus();
        parameter.addSimpleParameterListener(listener);
        Assert.assertTrue((boolean)parameter.setEnabled(false));
        junit.framework.Assert.assertEquals((int)1, (int)listener.getHowManyEventsOccurred());
        Assert.assertFalse((boolean)parameter.isEnabled());
        Assert.assertTrue((boolean)parameter.setEnabled(true));
        junit.framework.Assert.assertEquals((int)2, (int)listener.getHowManyEventsOccurred());
        Assert.assertTrue((boolean)parameter.isEnabled());
    }

    @Test
    public void testSetEnabled3() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        Assert.assertTrue((boolean)parameter.isEnabled());
        CheckParameterListener listener = new CheckParameterListener();
        Assert.assertFalse((boolean)parameter.setEnabled(true));
        junit.framework.Assert.assertEquals((int)0, (int)listener.getHowManyEventsOccurred());
        Assert.assertTrue((boolean)parameter.isEnabled());
    }

    @Test
    public void testSetEnabled4() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        Assert.assertTrue((boolean)parameter.isEnabled());
        Assert.assertTrue((boolean)parameter.setEnabled(false));
        Assert.assertFalse((boolean)parameter.isEnabled());
        CheckParameterListener listener = new CheckParameterListener();
        Assert.assertFalse((boolean)parameter.setEnabled(false));
        junit.framework.Assert.assertEquals((int)0, (int)listener.getHowManyEventsOccurred());
        Assert.assertFalse((boolean)parameter.isEnabled());
    }

    @Test
    public void testExportAndImportValue1() {
        String value = "Valor do par\u00e2metro";
        SimpleParameter<Object> parameter = SimpleParameterTest.create(value);
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
        Map exportedValues = parameter.exportValue();
        String otherValue = "Outro valor do par\u00e2metro";
        Assert.assertTrue((boolean)parameter.setValue((Object)otherValue));
        junit.framework.Assert.assertEquals((Object)otherValue, (Object)parameter.getValue());
        parameter.importValue(exportedValues);
        junit.framework.Assert.assertEquals((Object)value, (Object)parameter.getValue());
    }

    @Test
    public void testExportAndImportValue2() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create(null);
        Assert.assertNull((Object)parameter.getValue());
        Map exportedValues = parameter.exportValue();
        String otherValue = "Outro valor do par\u00e2metro";
        Assert.assertTrue((boolean)parameter.setValue((Object)otherValue));
        junit.framework.Assert.assertEquals((Object)otherValue, (Object)parameter.getValue());
        parameter.importValue(exportedValues);
        Assert.assertNull((Object)parameter.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportValue1() {
        SimpleParameter<Object> parameter = SimpleParameterTest.create();
        parameter.importValue(null);
    }

    @Test
    public void testSerialize1() throws IOException, ClassNotFoundException {
        SimpleParameter<Object> outputParameter = SimpleParameterTest.create();
        MyParameterListener listener = new MyParameterListener(2);
        outputParameter.addSimpleParameterListener((SimpleParameterListener)listener);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        SimpleParameter inputParameter = (SimpleParameter)objectInput.readObject();
        junit.framework.Assert.assertEquals(outputParameter, (Object)inputParameter);
    }

    static class MyParameterListener
    implements SimpleParameterListener<Object> {
        private int id;

        public MyParameterListener(int id) {
            this.id = id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MyParameterListener other = (MyParameterListener)obj;
            return this.id == other.id;
        }

        public void capabilityWasChanged(SimpleParameter<Object> parameter) {
        }

        public void defaultValueWasChanged(SimpleParameter<Object> parameter) {
        }

        public void labelWasChanged(SimpleParameter<Object> parameter) {
        }

        public void valueWasChanged(SimpleParameter<Object> parameter) {
        }

        public void visibilityWasChanged(SimpleParameter<Object> parameter) {
        }
    }
}

