/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.TextColumn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import junit.framework.TestCase;

public final class TextColumnTest
extends TestCase {
    public void testTextColumn1() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maxCharacters = new Integer(1234);
        TextColumn column = new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
        TextColumnTest.assertEquals((String)id, (String)column.getId());
        TextColumnTest.assertEquals((String)label, (String)column.getLabel());
        TextColumnTest.assertEquals((String)defaultValue, (String)((String)column.getDefaultValue(0)));
        TextColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        TextColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        TextColumnTest.assertEquals((Object)maxCharacters, (Object)column.getMaxCharacters());
    }

    public void testTextColumn2() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = false;
        boolean isEditable = true;
        Integer maxCharacters = new Integer(1234);
        TextColumn column = new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
        TextColumnTest.assertEquals((String)id, (String)column.getId());
        TextColumnTest.assertEquals((String)label, (String)column.getLabel());
        TextColumnTest.assertEquals((String)defaultValue, (String)((String)column.getDefaultValue(0)));
        TextColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        TextColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        TextColumnTest.assertEquals((Object)maxCharacters, (Object)column.getMaxCharacters());
    }

    public void testTextColumn3() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        String defaultValue = null;
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maxCharacters = new Integer(1234);
        TextColumn column = new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
        TextColumnTest.assertEquals((String)id, (String)column.getId());
        TextColumnTest.assertEquals((String)label, (String)column.getLabel());
        TextColumnTest.assertEquals(defaultValue, (String)((String)column.getDefaultValue(0)));
        TextColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        TextColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        TextColumnTest.assertEquals((Object)maxCharacters, (Object)column.getMaxCharacters());
    }

    public void testTextColumn4() {
        String id = "Identificador da coluna";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maxCharacters = new Integer(1234);
        try {
            new TextColumn(id, null, defaultValue, isOptional, isEditable, maxCharacters);
            TextColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com r\u00f3tulo nulo.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTextColumn5() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        boolean isEditable = true;
        TextColumn column = new TextColumn(id, label, defaultValue, isOptional, isEditable, null);
        TextColumnTest.assertEquals((String)id, (String)column.getId());
        TextColumnTest.assertEquals((String)label, (String)column.getLabel());
        TextColumnTest.assertEquals((String)defaultValue, (String)((String)column.getDefaultValue(0)));
        TextColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        TextColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        TextColumnTest.assertNull((Object)column.getMaxCharacters());
    }

    public void testTextColumn6() {
        String id = "Identificador da coluna";
        String label = "Nome do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maxCharacters = new Integer(0);
        try {
            new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
            TextColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com quantidade de caracters n\u00e3o-positiva.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTextColumn7() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        boolean isEditable = false;
        Integer maxCharacters = new Integer(1234);
        TextColumn column = new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
        TextColumnTest.assertEquals((String)id, (String)column.getId());
        TextColumnTest.assertEquals((String)label, (String)column.getLabel());
        TextColumnTest.assertEquals((String)defaultValue, (String)((String)column.getDefaultValue(0)));
        TextColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        TextColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        TextColumnTest.assertEquals((Object)maxCharacters, (Object)column.getMaxCharacters());
    }

    public void testTextColumn8() {
        String label = "R\u00f3tulo da coluna";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maxCharacters = new Integer(1234);
        try {
            new TextColumn(null, label, defaultValue, isOptional, isEditable, maxCharacters);
            TextColumnTest.fail((String)"N\u00e3o deveria ser poss\u00edvel criar uma coluna com r\u00f3tulo nulo.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTextColumn9() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maxCharacters = new Integer(1234);
        HashMap<Integer, String> defaultValuesByRowIndex = new HashMap<Integer, String>();
        defaultValuesByRowIndex.put(1, "Padr\u00e3o 1");
        defaultValuesByRowIndex.put(3, "Padr\u00e3o 3");
        TextColumn column = new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
        column.addDefaultValue(1, (Object)((String)defaultValuesByRowIndex.get(1)));
        column.addDefaultValue(3, (Object)((String)defaultValuesByRowIndex.get(3)));
        TextColumnTest.assertEquals((String)id, (String)column.getId());
        TextColumnTest.assertEquals((String)label, (String)column.getLabel());
        TextColumnTest.assertEquals((String)defaultValue, (String)((String)column.getDefaultValue(0)));
        TextColumnTest.assertEquals((String)((String)defaultValuesByRowIndex.get(1)), (String)((String)column.getDefaultValue(1)));
        TextColumnTest.assertEquals((String)defaultValue, (String)((String)column.getDefaultValue(2)));
        TextColumnTest.assertEquals((String)((String)defaultValuesByRowIndex.get(3)), (String)((String)column.getDefaultValue(3)));
        TextColumnTest.assertEquals((String)defaultValue, (String)((String)column.getDefaultValue(4)));
        TextColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        TextColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        TextColumnTest.assertEquals((Object)maxCharacters, (Object)column.getMaxCharacters());
    }

    public void testTextColumn10() {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        String defaultValue = null;
        boolean isOptional = true;
        boolean isEditable = true;
        Integer maxCharacters = new Integer(1234);
        HashMap<Integer, String> defaultValuesByRowIndex = new HashMap<Integer, String>();
        defaultValuesByRowIndex.put(1, "Padr\u00e3o 1");
        defaultValuesByRowIndex.put(3, "Padr\u00e3o 3");
        TextColumn column = new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
        column.addDefaultValue(1, (Object)((String)defaultValuesByRowIndex.get(1)));
        column.addDefaultValue(3, (Object)((String)defaultValuesByRowIndex.get(3)));
        TextColumnTest.assertEquals((String)id, (String)column.getId());
        TextColumnTest.assertEquals((String)label, (String)column.getLabel());
        TextColumnTest.assertEquals(defaultValue, (String)((String)column.getDefaultValue(0)));
        TextColumnTest.assertEquals((String)((String)defaultValuesByRowIndex.get(1)), (String)((String)column.getDefaultValue(1)));
        TextColumnTest.assertEquals(defaultValue, (String)((String)column.getDefaultValue(2)));
        TextColumnTest.assertEquals((String)((String)defaultValuesByRowIndex.get(3)), (String)((String)column.getDefaultValue(3)));
        TextColumnTest.assertEquals(defaultValue, (String)((String)column.getDefaultValue(4)));
        TextColumnTest.assertEquals((boolean)isOptional, (boolean)column.isOptional());
        TextColumnTest.assertEquals((boolean)isEditable, (boolean)column.isEditable());
        TextColumnTest.assertEquals((Object)maxCharacters, (Object)column.getMaxCharacters());
    }

    public void testSerialize() throws IOException, ClassNotFoundException {
        String id = "Identificador da coluna";
        String label = "Nome da coluna";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        boolean isEditable = true;
        HashMap<Integer, String> defaultValuesByRowIndex = new HashMap<Integer, String>();
        defaultValuesByRowIndex.put(1, "Padr\u00e3o 1");
        defaultValuesByRowIndex.put(2, "Padr\u00e3o 2");
        Integer maxCharacters = new Integer(1);
        TextColumn outputColumn = new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputColumn);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        TextColumn inputColumn = (TextColumn)objectInput.readObject();
        TextColumnTest.assertEquals((String)outputColumn.getId(), (String)inputColumn.getId());
        TextColumnTest.assertEquals((String)outputColumn.getLabel(), (String)inputColumn.getLabel());
        TextColumnTest.assertEquals((String)((String)outputColumn.getDefaultValue(0)), (String)((String)inputColumn.getDefaultValue(0)));
        TextColumnTest.assertEquals((String)((String)outputColumn.getDefaultValue(1)), (String)((String)inputColumn.getDefaultValue(1)));
        TextColumnTest.assertEquals((String)((String)outputColumn.getDefaultValue(2)), (String)((String)inputColumn.getDefaultValue(2)));
        TextColumnTest.assertEquals((boolean)outputColumn.isOptional(), (boolean)inputColumn.isOptional());
        TextColumnTest.assertEquals((Object)outputColumn.getMaxCharacters(), (Object)inputColumn.getMaxCharacters());
    }
}

