/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.URLParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLValue;
import java.util.EnumSet;
import org.junit.Assert;
import org.junit.Test;

public final class URLParameterTest {
    private String clientHostName = "TEST_CLIENT";

    @Test
    public void testURLParameterWithValidValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean mustExist = true;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        URLValue value = new URLValue("test.txt");
        InputURLParameter parameter = new InputURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, localization, type, mode, allowedProtocols);
        this.assertURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, type, mode, mustExist, localization, allowedProtocols, (URLParameter)parameter);
    }

    @Test
    public void testURLParameterWithNonOptionalValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = false;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean mustExist = true;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        URLValue value = new URLValue("test.txt");
        InputURLParameter parameter = new InputURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, localization, type, mode, allowedProtocols);
        this.assertURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, type, mode, mustExist, localization, allowedProtocols, (URLParameter)parameter);
    }

    @Test
    public void testURLParameterWithNullFileType() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = false;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean mustExist = true;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        URLValue value = new URLValue("test.txt");
        InputURLParameter parameter = new InputURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, localization, type, mode, allowedProtocols);
        this.assertURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, type, mode, mustExist, localization, allowedProtocols, (URLParameter)parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testURLParameterWithNullName() {
        new InputURLParameter(null, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testURLParameterWithNullLabel() {
        new InputURLParameter("Nome do par\u00e2metro", null, "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testURLParameterWithNullDescription() {
        new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", null, null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", null, FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
    }

    @Test
    public void testURLParameterWithValueOnlyCommandLinePattern() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = false;
        boolean isVisible = true;
        String commandLinePattern = "$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        boolean mustExist = true;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        URLValue value = new URLValue("test.txt");
        InputURLParameter parameter = new InputURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, localization, type, mode, allowedProtocols);
        this.assertURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, type, mode, mustExist, localization, allowedProtocols, (URLParameter)parameter);
    }

    @Test
    public void testURLParameterWithDirectoryMode() {
        FileParameterMode mode = FileParameterMode.DIRECTORY;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        boolean mustExist = true;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        URLValue value = new URLValue("test.txt");
        InputURLParameter parameter = new InputURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, localization, type, mode, allowedProtocols);
        this.assertURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, type, mode, mustExist, localization, allowedProtocols, (URLParameter)parameter);
    }

    @Test
    public void testURLParameterWithDirectoryAndFileMode() {
        FileParameterMode mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        boolean mustExist = true;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        URLValue value = new URLValue("test.txt");
        InputURLParameter parameter = new InputURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, localization, type, mode, allowedProtocols);
        this.assertURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, type, mode, mustExist, localization, allowedProtocols, (URLParameter)parameter);
    }

    @Test
    public void testURLParameterWithExistingFile() {
        boolean mustExist = true;
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String localization = "Localizacao";
        boolean isOptional = true;
        boolean isVisible = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        String type = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        EnumSet<URLProtocol> allowedProtocols = EnumSet.allOf(URLProtocol.class);
        URLValue value = new URLValue("test.txt");
        InputURLParameter parameter = new InputURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, localization, type, mode, allowedProtocols);
        this.assertURLParameter(name, label, description, value, isOptional, isVisible, commandLinePattern, type, mode, mustExist, localization, allowedProtocols, (URLParameter)parameter);
    }

    @Test
    public void testGetValueAsTextWithNullValue() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        Assert.assertNull((Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithFileType() {
        URLValue file = new URLValue("dir1/dir2/arq", "DOC");
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:DOC:project", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithProjectProtocol() {
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.PROJECT);
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:TEXT:project", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithLocalProtocol() {
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.LOCAL);
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:TEXT:local", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithSGAProtocol() {
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.SGA);
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:TEXT:sga", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithHost() {
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.SGA, "sga-name");
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:TEXT:sga:sga-name", (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithNoFileType() {
        URLValue file = new URLValue("dir1/dir2/arq");
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        Assert.assertEquals((Object)"dir1/dir2/arq:UNKNOWN:project", (Object)parameter.getValueAsText());
    }

    @Test
    public void testSetValueAsTextWithNullValue() {
        URLValue file = new URLValue("dir1/dir2/arq", "DOC");
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        parameter.setValue((Object)file);
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
        parameter.setValueAsText(null);
        Assert.assertNull((Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithNoFileType() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:UNKNOWN");
        URLValue file = new URLValue("dir1/dir2/arq");
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithFileType() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:DOC");
        URLValue file = new URLValue("dir1/dir2/arq", "DOC");
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithProjectProtocol() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:project");
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.PROJECT);
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithLocalProtocol() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:local");
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.LOCAL);
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithWindowsSeparator() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        String path = "c:\\dir1\\dir2\\arq.txt";
        parameter.setValueAsText(String.valueOf(path) + ":TEXT:local");
        URLValue file = new URLValue(path, "TEXT", URLProtocol.LOCAL);
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithWindowsPathWithUnixSeparator() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        String path = "c:/dir1/dir2/arq.txt";
        parameter.setValueAsText(String.valueOf(path) + ":TEXT:local");
        URLValue file = new URLValue(path, "TEXT", URLProtocol.LOCAL);
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithWindowsRootDir() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        String path = "c:\\";
        parameter.setValueAsText(String.valueOf(path) + ":DIRECTORY_TYPE:local");
        URLValue file = new URLValue(path, "DIRECTORY_TYPE", URLProtocol.LOCAL);
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithWindowsSeparator() {
        String path = "c:\\dir1\\dir2\\arq.txt";
        URLValue file = new URLValue(path, "TEXT", URLProtocol.LOCAL);
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        String valueAsText = "c:/dir1/dir2/arq.txt:TEXT:local";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithWindowsPathWithUnixSeparator() {
        String path = "c:/dir1/dir2/arq.txt";
        URLValue file = new URLValue(path, "TEXT", URLProtocol.LOCAL);
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        String valueAsText = String.valueOf(path) + ":TEXT:local";
        Assert.assertEquals((Object)valueAsText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithFileValueWithWindowsRootDir() {
        String path = "c:\\";
        URLValue file = new URLValue(path, "DIRECTORY_TYPE", URLProtocol.LOCAL);
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", file, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        String valueText = "c:/:DIRECTORY_TYPE:local";
        Assert.assertEquals((Object)valueText, (Object)parameter.getValueAsText());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithSGAProtocol() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:sga");
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.SGA);
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithFileValueWithHost() {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:sga:sga-name");
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.SGA, "sga-name");
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetValueAsTextWithFileValueWithInvalidProtocol() throws ParseException {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:invalido");
    }

    @Test
    public void testSetValueAsTextWithFileValueWithNonAllowedProtocol() throws ParseException {
        InputURLParameter parameter = new InputURLParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.of(URLProtocol.SGA));
        parameter.setValueAsText("dir1/dir2/arq:TEXT:project");
        URLValue file = new URLValue("dir1/dir2/arq", "TEXT", URLProtocol.PROJECT);
        Assert.assertEquals((Object)file, (Object)parameter.getValue());
    }

    @Test
    public void testGetCommandLineWithProjectProtocolWithUnixSeparator() {
        InputURLParameter parameter = new InputURLParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '/', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("dir1/dir2/dir3:DIRECTORY_TYPE");
        Assert.assertEquals((Object)("PARAM_NAME=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + "/dir1/dir2/dir3 Localizacao=project"), (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithProjectProtocolWithWindowsSeparator() {
        InputURLParameter parameter = new InputURLParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '\\', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("dir1/dir2/dir3:DIRECTORY_TYPE");
        Assert.assertEquals((Object)("PARAM_NAME=" + CommandLineBuilder.makeEnvironmentVariableReference((EnvironmentVariable)EnvironmentVariable.PROJECT_DIR) + "\\dir1\\dir2\\dir3 Localizacao=project"), (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithLocalProtocolWithWindowsSeparator() throws ParseException {
        InputURLParameter parameter = new InputURLParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '\\', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("c:\\dir1\\dir2\\dir3:DIRECTORY_TYPE:LOCAL");
        Assert.assertEquals((Object)"PARAM_NAME=c:\\dir1\\dir2\\dir3 Localizacao=local", (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithSgaProtocolWithUnixSeparator() throws ParseException {
        InputURLParameter parameter = new InputURLParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '/', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("/dir1/dir2/dir3:DIRECTORY_TYPE:SGA");
        Assert.assertEquals((Object)"PARAM_NAME=/dir1/dir2/dir3 Localizacao=sga", (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithSgaProtocolWithWindowsSeparator() throws ParseException {
        InputURLParameter parameter = new InputURLParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '\\', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("c:\\dir1\\dir2\\dir3:DIRECTORY_TYPE:SGA");
        Assert.assertEquals((Object)"PARAM_NAME=c:\\dir1\\dir2\\dir3 Localizacao=sga", (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithLocalProtocolWithUnixSeparator() throws ParseException {
        InputURLParameter parameter = new InputURLParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.DIRECTORY, EnumSet.allOf(URLProtocol.class));
        CommandLineContext context = new CommandLineContext(null, null, '/', null, null, null, null, null, null, false, null, this.clientHostName);
        parameter.setValueAsText("/dir1/dir2/dir3:DIRECTORY_TYPE:LOCAL");
        Assert.assertEquals((Object)"PARAM_NAME=/dir1/dir2/dir3 Localizacao=local", (Object)parameter.getCommandLine(context));
    }

    @Test
    public void testGetCommandLineWithNullValue() {
        InputURLParameter parameter = new InputURLParameter("PARAM_NAME", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO", "Localizacao", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        Assert.assertNull((Object)parameter.getCommandLine(null));
    }

    private void assertURLParameter(String name, String label, String description, URLValue value, boolean isOptional, boolean isVisible, String commandLinePattern, String type, FileParameterMode mode, boolean mustExist, String localization, EnumSet<URLProtocol> allowedProtocols, URLParameter parameter) {
        Assert.assertNotNull((Object)parameter);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)value, (Object)parameter.getValue());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals((Object)type, (Object)parameter.getFileType());
        Assert.assertEquals((Object)mode, (Object)parameter.getMode());
        Assert.assertEquals((Object)isVisible, (Object)parameter.isVisible());
        Assert.assertEquals((Object)value, (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)mustExist, (Object)parameter.mustExist());
        Assert.assertEquals((Object)localization, (Object)parameter.getLocalization());
        Assert.assertEquals((Object)localization, (Object)parameter.getLocalization());
        Assert.assertEquals(allowedProtocols, (Object)parameter.getAllowedProtocols());
    }
}

