/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.conditions;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.AndOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.MockCondition;
import csbase.logic.algorithms.parameters.conditions.OrOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.OrOperatorConditionTest;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Hashtable;
import junit.framework.TestCase;

public final class AndOperatorConditionTest
extends TestCase {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    public static AndOperatorCondition create() {
        return new AndOperatorCondition(new Condition[]{new MockCondition(true), new MockCondition(false)});
    }

    public void testAndOperatorCondition() {
        MockCondition firstCondition = new MockCondition(true);
        MockCondition secondCondition = new MockCondition(false);
        MockCondition thirdCondition = new MockCondition(false);
        AndOperatorConditionTest.assertFalse((boolean)firstCondition.equals(secondCondition));
        AndOperatorCondition condition = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition, thirdCondition});
        AndOperatorConditionTest.assertEquals(Arrays.asList(firstCondition, secondCondition, thirdCondition), (Object)condition.getConditions());
    }

    public void testEquals() {
        MockCondition firstCondition = new MockCondition(true);
        MockCondition secondCondition = new MockCondition(false);
        AndOperatorCondition condition1 = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition});
        AndOperatorCondition condition2 = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition});
        AndOperatorConditionTest.assertTrue((boolean)condition1.equals((Object)condition2));
    }

    public void testEqualsWithNull() {
        AndOperatorCondition condition = AndOperatorConditionTest.create();
        AndOperatorConditionTest.assertFalse((boolean)condition.equals(null));
    }

    public void testEqualsWithObjectOfAnotherClass() {
        AndOperatorCondition condition1 = AndOperatorConditionTest.create();
        OrOperatorCondition condition2 = OrOperatorConditionTest.create();
        AndOperatorConditionTest.assertFalse((boolean)condition1.equals((Object)condition2));
    }

    public void testHashCode() {
        MockCondition firstCondition = new MockCondition(true);
        MockCondition secondCondition = new MockCondition(false);
        AndOperatorCondition condition1 = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition});
        AndOperatorCondition condition2 = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition});
        AndOperatorConditionTest.assertEquals((int)condition1.hashCode(), (int)condition2.hashCode());
    }

    public void testEvaluateWithTrueFirstConditionAndTrueSecondCondition() {
        MockCondition firstCondition = new MockCondition(true);
        MockCondition secondCondition = new MockCondition(true);
        AndOperatorCondition condition = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition});
        AndOperatorConditionTest.assertTrue((boolean)condition.evaluate(this.createAlgorithmVersion()));
    }

    public void testEvaluateWithTrueFirstConditionAndFalseSecondCondition() {
        MockCondition firstCondition = new MockCondition(true);
        MockCondition secondCondition = new MockCondition(false);
        AndOperatorCondition condition = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition});
        AndOperatorConditionTest.assertFalse((boolean)condition.evaluate(this.createAlgorithmVersion()));
    }

    public void testEvaluateWithFalseFirstConditionAndTrueSecondCondition() {
        MockCondition firstCondition = new MockCondition(false);
        MockCondition secondCondition = new MockCondition(true);
        AndOperatorCondition condition = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition});
        AndOperatorConditionTest.assertFalse((boolean)condition.evaluate(this.createAlgorithmVersion()));
    }

    public void testEvaluateWithFalseFirstConditionAndFalseSecondCondition() {
        MockCondition firstCondition = new MockCondition(false);
        MockCondition secondCondition = new MockCondition(false);
        AndOperatorCondition condition = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition});
        AndOperatorConditionTest.assertFalse((boolean)condition.evaluate(this.createAlgorithmVersion()));
    }

    public void testSerialize() throws IOException, ClassNotFoundException {
        String parameterName = "Nome do par\u00e2metro";
        String value = "Valor";
        SimpleCondition firstCondition = new SimpleCondition(parameterName, (Object)value);
        SimpleCondition secondCondition = new SimpleCondition(parameterName, (Object)value);
        AndOperatorCondition outputCondition = new AndOperatorCondition(new Condition[]{firstCondition, secondCondition});
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputCondition);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        AndOperatorCondition inputCondition = (AndOperatorCondition)objectInput.readObject();
        AndOperatorConditionTest.assertEquals((Object)outputCondition, (Object)inputCondition);
        AndOperatorConditionTest.assertEquals((Object)outputCondition.getConditions(), (Object)inputCondition.getConditions());
    }

    private SimpleAlgorithmConfigurator createAlgorithmVersion() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }
}

