/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForIntegersTrigger;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class ChangeMaximumForIntegersTriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testChangeMaximumTrigger1() {
        IntegerParameter parameter = this.createMockIntegerParameter();
        Condition condition = this.createMockCondition();
        Integer maximum = 10;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, condition, maximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)maximum, (Object)trigger.getMaximum());
    }

    @Test
    public void testChangeMaximumTrigger2() {
        IntegerParameter parameter = this.createMockIntegerParameter();
        Condition condition = this.createMockCondition();
        Integer maximum = null;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, condition, maximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(maximum, (Object)trigger.getMaximum());
    }

    @Test
    public void testChangeMaximumTrigger3() {
        IntegerListParameter parameter = this.createMockIntegerListParameter();
        Condition condition = this.createMockCondition();
        Integer maximum = 10;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, condition, maximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)maximum, (Object)trigger.getMaximum());
    }

    @Test
    public void testChangeMaximumTrigger4() {
        IntegerListParameter parameter = this.createMockIntegerListParameter();
        Condition condition = this.createMockCondition();
        Integer maximum = null;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, condition, maximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(maximum, (Object)trigger.getMaximum());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMaximumTrigger5() {
        IntegerParameter parameter = null;
        Condition condition = this.createMockCondition();
        Integer maximum = 10;
        new ChangeMaximumForIntegersTrigger(parameter, condition, maximum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMaximumTrigger6() {
        IntegerListParameter parameter = null;
        Condition condition = this.createMockCondition();
        Integer maximum = 10;
        new ChangeMaximumForIntegersTrigger(parameter, condition, maximum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMaximumTrigger7() {
        IntegerParameter parameter = this.createMockIntegerParameter();
        Condition condition = null;
        Integer maximum = 10;
        new ChangeMaximumForIntegersTrigger(parameter, condition, maximum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMaximumTrigger8() {
        IntegerListParameter parameter = this.createMockIntegerListParameter();
        Condition condition = null;
        Integer maximum = 10;
        new ChangeMaximumForIntegersTrigger(parameter, condition, maximum);
    }

    @Test
    public void testDoAction1() {
        String parameterName = "Nome do par\u00e2metro";
        Integer defaultValue = 10;
        Integer maximum = 21;
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName, defaultValue, maximum);
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)defaultValue);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        Integer newMaximum = 31;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, newMaximum);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
    }

    @Test
    public void testDoAction2() {
        String parameterName = "Nome do par\u00e2metro";
        Integer maximum = 21;
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName, maximum);
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        Integer newMaximum = 31;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, newMaximum);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
    }

    @Test
    public void testDoAction3() {
        String parameterName = "Nome do par\u00e2metro";
        Integer defaultValue = 10;
        Integer maximum = 21;
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName, defaultValue, maximum);
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        Integer newMaximum = 31;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, newMaximum);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
    }

    @Test
    public void testDoAction4() {
        String parameterName = "Nome do par\u00e2metro";
        Integer maximum = 21;
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName, maximum);
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Integer value = 34;
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)value);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        Integer newMaximum = 31;
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, newMaximum);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
    }

    @Test
    public void testEquals1() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName);
        Integer maximum = 10;
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        ChangeMaximumForIntegersTrigger trigger1 = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition1, maximum);
        ChangeMaximumForIntegersTrigger trigger2 = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition2, maximum);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals2() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName);
        Integer maximum = 10;
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        ChangeMaximumForIntegersTrigger trigger1 = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition1, maximum);
        ChangeMaximumForIntegersTrigger trigger2 = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition2, maximum);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals3() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        IntegerParameter parameter1 = this.createMockIntegerParameter(parameterName1);
        IntegerParameter parameter2 = this.createMockIntegerParameter(parameterName2);
        Integer maximum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForIntegersTrigger trigger1 = new ChangeMaximumForIntegersTrigger(parameter1, (Condition)condition, maximum);
        ChangeMaximumForIntegersTrigger trigger2 = new ChangeMaximumForIntegersTrigger(parameter2, (Condition)condition, maximum);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals4() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        IntegerListParameter parameter1 = this.createMockIntegerListParameter(parameterName1);
        IntegerListParameter parameter2 = this.createMockIntegerListParameter(parameterName2);
        Integer maximum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForIntegersTrigger trigger1 = new ChangeMaximumForIntegersTrigger(parameter1, (Condition)condition, maximum);
        ChangeMaximumForIntegersTrigger trigger2 = new ChangeMaximumForIntegersTrigger(parameter2, (Condition)condition, maximum);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals5() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName);
        Integer maximum1 = 11;
        Integer maximum2 = 22;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForIntegersTrigger trigger1 = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, maximum1);
        ChangeMaximumForIntegersTrigger trigger2 = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, maximum2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals6() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName);
        Integer maximum1 = 11;
        Integer maximum2 = 22;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForIntegersTrigger trigger1 = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, maximum1);
        ChangeMaximumForIntegersTrigger trigger2 = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, maximum2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals7() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter1 = this.createMockIntegerListParameter(parameterName);
        IntegerParameter parameter2 = this.createMockIntegerParameter(parameterName);
        Integer maximum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForIntegersTrigger trigger1 = new ChangeMaximumForIntegersTrigger(parameter1, (Condition)condition, maximum);
        ChangeMaximumForIntegersTrigger trigger2 = new ChangeMaximumForIntegersTrigger(parameter2, (Condition)condition, maximum);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals8() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName);
        Integer maximum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, maximum);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals9() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName);
        Integer maximum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, maximum);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    @Test
    public void testEquals10() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName);
        Integer maximum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, maximum);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals13() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName);
        Integer maximum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForIntegersTrigger trigger = new ChangeMaximumForIntegersTrigger(parameter, (Condition)condition, maximum);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    private SimpleAlgorithmConfigurator createMockAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private IntegerListParameter createMockIntegerListParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockIntegerListParameter(parameterName);
    }

    private IntegerListParameter createMockIntegerListParameter(String parameterName) {
        Integer maximum = null;
        return this.createMockIntegerListParameter(parameterName, maximum);
    }

    private IntegerListParameter createMockIntegerListParameter(String parameterName, Integer maximum) {
        return new IntegerListParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0}={1}", maximum, null);
    }

    private IntegerParameter createMockIntegerParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockIntegerParameter(parameterName);
    }

    private IntegerParameter createMockIntegerParameter(String parameterName) {
        Integer defaultValue = null;
        Integer maximum = null;
        return this.createMockIntegerParameter(parameterName, defaultValue, maximum);
    }

    private IntegerParameter createMockIntegerParameter(String parameterName, Integer defaultValue, Integer maximum) {
        return new IntegerParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, "{0}={1}", maximum, null);
    }

    private Condition createMockCondition() {
        return new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor qualquer");
    }
}

