/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.ChangeMinimumForIntegersTrigger;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class ChangeMinimumForIntegersTriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testChangeMinimumTrigger1() {
        IntegerParameter parameter = this.createMockIntegerParameter();
        Condition condition = this.createMockCondition();
        Integer minimum = 10;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, condition, minimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)minimum, (Object)trigger.getMinimum());
    }

    @Test
    public void testChangeMinimumTrigger2() {
        IntegerParameter parameter = this.createMockIntegerParameter();
        Condition condition = this.createMockCondition();
        Integer minimum = null;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, condition, minimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(minimum, (Object)trigger.getMinimum());
    }

    @Test
    public void testChangeMinimumTrigger3() {
        IntegerListParameter parameter = this.createMockIntegerListParameter();
        Condition condition = this.createMockCondition();
        Integer minimum = 10;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, condition, minimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)minimum, (Object)trigger.getMinimum());
    }

    @Test
    public void testChangeMinimumTrigger4() {
        IntegerListParameter parameter = this.createMockIntegerListParameter();
        Condition condition = this.createMockCondition();
        Integer minimum = null;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, condition, minimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(minimum, (Object)trigger.getMinimum());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMinimumTrigger5() {
        IntegerParameter parameter = null;
        Condition condition = this.createMockCondition();
        Integer minimum = 10;
        new ChangeMinimumForIntegersTrigger(parameter, condition, minimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMinimumTrigger6() {
        IntegerListParameter parameter = null;
        Condition condition = this.createMockCondition();
        Integer minimum = 10;
        new ChangeMinimumForIntegersTrigger(parameter, condition, minimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMinimumTrigger7() {
        IntegerParameter parameter = this.createMockIntegerParameter();
        Condition condition = null;
        Integer minimum = 10;
        new ChangeMinimumForIntegersTrigger(parameter, condition, minimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMinimumTrigger8() {
        IntegerListParameter parameter = this.createMockIntegerListParameter();
        Condition condition = null;
        Integer minimum = 10;
        new ChangeMinimumForIntegersTrigger(parameter, condition, minimum);
    }

    @Test
    public void testDoAction1() {
        String parameterName = "Nome do par\u00e2metro";
        Integer defaultValue = 10;
        Integer minimum = 21;
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName, defaultValue, minimum);
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)defaultValue);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        Integer newMinimum = 31;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, newMinimum);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
    }

    @Test
    public void testDoAction2() {
        String parameterName = "Nome do par\u00e2metro";
        Integer minimum = 21;
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName, minimum);
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        Integer newMinimum = 31;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, newMinimum);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
    }

    @Test
    public void testDoAction3() {
        String parameterName = "Nome do par\u00e2metro";
        Integer defaultValue = 10;
        Integer minimum = 21;
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName, defaultValue, minimum);
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        Integer newMinimum = 31;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, newMinimum);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
    }

    @Test
    public void testDoAction4() {
        String parameterName = "Nome do par\u00e2metro";
        Integer minimum = 21;
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName, minimum);
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Integer value = 34;
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)value);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        Integer newMinimum = 31;
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, newMinimum);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
    }

    @Test
    public void testEquals1() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName);
        Integer minimum = 10;
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        ChangeMinimumForIntegersTrigger trigger1 = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition1, minimum);
        ChangeMinimumForIntegersTrigger trigger2 = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition2, minimum);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals2() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName);
        Integer minimum = 10;
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        ChangeMinimumForIntegersTrigger trigger1 = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition1, minimum);
        ChangeMinimumForIntegersTrigger trigger2 = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition2, minimum);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals3() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        IntegerParameter parameter1 = this.createMockIntegerParameter(parameterName1);
        IntegerParameter parameter2 = this.createMockIntegerParameter(parameterName2);
        Integer minimum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForIntegersTrigger trigger1 = new ChangeMinimumForIntegersTrigger(parameter1, (Condition)condition, minimum);
        ChangeMinimumForIntegersTrigger trigger2 = new ChangeMinimumForIntegersTrigger(parameter2, (Condition)condition, minimum);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals4() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        IntegerListParameter parameter1 = this.createMockIntegerListParameter(parameterName1);
        IntegerListParameter parameter2 = this.createMockIntegerListParameter(parameterName2);
        Integer minimum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForIntegersTrigger trigger1 = new ChangeMinimumForIntegersTrigger(parameter1, (Condition)condition, minimum);
        ChangeMinimumForIntegersTrigger trigger2 = new ChangeMinimumForIntegersTrigger(parameter2, (Condition)condition, minimum);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals5() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName);
        Integer minimum1 = 11;
        Integer minimum2 = 22;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForIntegersTrigger trigger1 = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, minimum1);
        ChangeMinimumForIntegersTrigger trigger2 = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, minimum2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals6() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName);
        Integer minimum1 = 11;
        Integer minimum2 = 22;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForIntegersTrigger trigger1 = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, minimum1);
        ChangeMinimumForIntegersTrigger trigger2 = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, minimum2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals7() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter1 = this.createMockIntegerListParameter(parameterName);
        IntegerParameter parameter2 = this.createMockIntegerParameter(parameterName);
        Integer minimum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForIntegersTrigger trigger1 = new ChangeMinimumForIntegersTrigger(parameter1, (Condition)condition, minimum);
        ChangeMinimumForIntegersTrigger trigger2 = new ChangeMinimumForIntegersTrigger(parameter2, (Condition)condition, minimum);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals8() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName);
        Integer minimum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, minimum);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals9() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerParameter parameter = this.createMockIntegerParameter(parameterName);
        Integer minimum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, minimum);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    @Test
    public void testEquals10() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName);
        Integer minimum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, minimum);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals13() {
        String parameterName = "Nome do par\u00e2metro";
        IntegerListParameter parameter = this.createMockIntegerListParameter(parameterName);
        Integer minimum = 10;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForIntegersTrigger trigger = new ChangeMinimumForIntegersTrigger(parameter, (Condition)condition, minimum);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    private SimpleAlgorithmConfigurator createMockAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private IntegerListParameter createMockIntegerListParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockIntegerListParameter(parameterName);
    }

    private IntegerListParameter createMockIntegerListParameter(String parameterName) {
        Integer minimum = null;
        return this.createMockIntegerListParameter(parameterName, minimum);
    }

    private IntegerListParameter createMockIntegerListParameter(String parameterName, Integer minimum) {
        return new IntegerListParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, null, null, minimum);
    }

    private IntegerParameter createMockIntegerParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockIntegerParameter(parameterName);
    }

    private IntegerParameter createMockIntegerParameter(String parameterName) {
        Integer defaultValue = null;
        Integer minimum = null;
        return this.createMockIntegerParameter(parameterName, defaultValue, minimum);
    }

    private IntegerParameter createMockIntegerParameter(String parameterName, Integer defaultValue, Integer minimum) {
        return new IntegerParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, null, null, minimum);
    }

    private Condition createMockCondition() {
        return new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor qualquer");
    }
}

