/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.SetVisibleEnumerationItemTrigger;
import java.util.Hashtable;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public final class SetVisibleEnumerationItemTriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testSetVisibleEnumerationItemTrigger1() {
        EnumerationParameter parameter = this.createMockEnumerationParameter();
        Condition condition = this.createMockCondition();
        EnumerationItem item = parameter.getDefaultValue();
        String itemId = item.getId();
        boolean isVisible = true;
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter, condition, itemId, isVisible);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)itemId, (Object)trigger.getItemId());
        Assert.assertEquals((Object)isVisible, (Object)trigger.isVisible());
    }

    @Test
    public void testSetVisibleEnumerationItemTrigger2() {
        EnumerationParameter parameter = this.createMockEnumerationParameter();
        Condition condition = this.createMockCondition();
        EnumerationItem item = parameter.getDefaultValue();
        String itemId = item.getId();
        boolean isVisible = false;
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter, condition, itemId, isVisible);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)itemId, (Object)trigger.getItemId());
        Assert.assertEquals((Object)isVisible, (Object)trigger.isVisible());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetVisibleEnumerationItemTrigger3() {
        Condition condition = this.createMockCondition();
        EnumerationItem item = this.createMockEnumerationItem();
        String itemId = item.getId();
        new SetVisibleEnumerationItemTrigger(null, condition, itemId, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetVisibleEnumerationItemTrigger4() {
        EnumerationParameter parameter = this.createMockEnumerationParameter();
        EnumerationItem item = parameter.getDefaultValue();
        String itemId = item.getId();
        new SetVisibleEnumerationItemTrigger(parameter, null, itemId, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetVisibleEnumerationItemTrigger5() {
        EnumerationParameter parameter = this.createMockEnumerationParameter();
        Condition condition = this.createMockCondition();
        new SetVisibleEnumerationItemTrigger(parameter, condition, null, false);
    }

    @Test
    public void testUpdate1() {
        String defaultItemId = "Identificador do item padr\u00e3o";
        EnumerationItem defaultItem = this.createMockEnumerationItem(defaultItemId);
        String otherItemId = "Identificador de outro item.";
        EnumerationItem otherItem = this.createMockEnumerationItem(otherItemId);
        Assert.assertTrue((boolean)otherItem.isVisible());
        String parameterName = "Nome do par\u00e2metro";
        EnumerationParameter parameter = this.createMockEnumerationParameter(parameterName, defaultItem, otherItem);
        Assert.assertEquals((Object)defaultItem, (Object)parameter.getValue());
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)defaultItem);
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter((Parameter)parameter);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        parameter.setVisibleItem(otherItemId, false);
        Assert.assertFalse((boolean)otherItem.isVisible());
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter, (Condition)condition, otherItemId, true);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertTrue((boolean)otherItem.isVisible());
    }

    @Test
    public void testUpdate2() {
        String defaultItemId = "Identificador do item padr\u00e3o";
        EnumerationItem defaultItem = this.createMockEnumerationItem(defaultItemId);
        String otherItemId = "Identificador de outro item.";
        EnumerationItem otherItem = this.createMockEnumerationItem(otherItemId);
        Assert.assertTrue((boolean)otherItem.isVisible());
        String parameterName = "Nome do par\u00e2metro";
        EnumerationParameter parameter = this.createMockEnumerationParameter(parameterName, defaultItem, otherItem);
        Assert.assertEquals((Object)defaultItem, (Object)parameter.getValue());
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)defaultItem);
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter((Parameter)parameter);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter, (Condition)condition, otherItemId, false);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertFalse((boolean)otherItem.isVisible());
    }

    @Test
    public void testUpdate3() {
        String defaultItemId = "Identificador do item padr\u00e3o";
        EnumerationItem defaultItem = this.createMockEnumerationItem(defaultItemId);
        String otherItemId = "Identificador de outro item.";
        EnumerationItem otherItem = this.createMockEnumerationItem(otherItemId);
        Assert.assertTrue((boolean)otherItem.isVisible());
        String parameterName = "Nome do par\u00e2metro";
        EnumerationParameter parameter = this.createMockEnumerationParameter(parameterName, defaultItem, otherItem);
        Assert.assertEquals((Object)defaultItem, (Object)parameter.getValue());
        parameter.setVisibleItem(otherItemId, false);
        Assert.assertFalse((boolean)otherItem.isVisible());
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)otherItem);
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter((Parameter)parameter);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter, (Condition)condition, otherItemId, false);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertTrue((boolean)otherItem.isVisible());
    }

    @Test
    public void testUpdate4() {
        String defaultItemId = "Identificador do item padr\u00e3o";
        EnumerationItem defaultItem = this.createMockEnumerationItem(defaultItemId);
        String otherItemId = "Identificador de outro item.";
        EnumerationItem otherItem = this.createMockEnumerationItem(otherItemId);
        Assert.assertTrue((boolean)otherItem.isVisible());
        String parameterName = "Nome do par\u00e2metro";
        EnumerationParameter parameter = this.createMockEnumerationParameter(parameterName, defaultItem, otherItem);
        Assert.assertEquals((Object)defaultItem, (Object)parameter.getValue());
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)otherItem);
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter((Parameter)parameter);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter, (Condition)condition, otherItemId, true);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertFalse((boolean)otherItem.isVisible());
    }

    @Test
    public void testEquals1() {
        String parameterName = "Nome do par\u00e2metro";
        String itemId = "Identificador do item";
        EnumerationItem item = this.createMockEnumerationItem(itemId);
        EnumerationParameter parameter = this.createMockEnumerationParameter(parameterName, item, new EnumerationItem[0]);
        boolean isVisible = true;
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor do par\u00e2metro 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor do par\u00e2metro 2");
        SetVisibleEnumerationItemTrigger trigger1 = new SetVisibleEnumerationItemTrigger(parameter, (Condition)condition1, itemId, isVisible);
        SetVisibleEnumerationItemTrigger trigger2 = new SetVisibleEnumerationItemTrigger(parameter, (Condition)condition2, itemId, isVisible);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals2() {
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor do par\u00e2metro");
        String parameterName = "Nome do par\u00e2metro";
        String itemId1 = "Identificador do item 1";
        EnumerationItem item1 = this.createMockEnumerationItem(itemId1);
        String itemId2 = "Identificador do item 2";
        EnumerationItem item2 = this.createMockEnumerationItem(itemId2);
        EnumerationParameter parameter = this.createMockEnumerationParameter(parameterName, item1, item2);
        boolean isVisible1 = true;
        boolean isVisible2 = false;
        SetVisibleEnumerationItemTrigger trigger1 = new SetVisibleEnumerationItemTrigger(parameter, (Condition)condition, itemId1, isVisible1);
        SetVisibleEnumerationItemTrigger trigger2 = new SetVisibleEnumerationItemTrigger(parameter, (Condition)condition, itemId2, isVisible2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals4() {
        String itemId = "Identificador do item";
        EnumerationItem item = this.createMockEnumerationItem(itemId);
        String parameterName = "Nome do par\u00e2metro";
        EnumerationParameter parameter = this.createMockEnumerationParameter(parameterName, item, new EnumerationItem[0]);
        Condition condition = this.createMockCondition();
        boolean isVisible = true;
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter, condition, itemId, isVisible);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals5() {
        String itemId = "Identificador do item";
        EnumerationItem item = this.createMockEnumerationItem(itemId);
        String parameterName = "Nome do par\u00e2metro";
        EnumerationParameter parameter = this.createMockEnumerationParameter(parameterName, item, new EnumerationItem[0]);
        Condition condition = this.createMockCondition();
        boolean isVisible = true;
        SetVisibleEnumerationItemTrigger trigger = new SetVisibleEnumerationItemTrigger(parameter, condition, itemId, isVisible);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    private SimpleAlgorithmConfigurator createMockAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private Condition createMockCondition() {
        return new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor qualquer");
    }

    private EnumerationItem createMockEnumerationItem() {
        String itemId = "Identificador do item";
        return this.createMockEnumerationItem(itemId);
    }

    private EnumerationItem createMockEnumerationItem(String itemId) {
        return new EnumerationItem(itemId, "Nome do item " + itemId, "Valor do item " + itemId, "Descri\u00e7\u00e3o do item " + itemId);
    }

    private EnumerationParameter createMockEnumerationParameter() {
        String parameterName = "Nome do par\u00e2metro";
        EnumerationItem item = this.createMockEnumerationItem();
        return this.createMockEnumerationParameter(parameterName, item, new EnumerationItem[0]);
    }

    private EnumerationParameter createMockEnumerationParameter(String parameterName, EnumerationItem defaultValue, EnumerationItem ... otherItems) {
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(defaultValue);
        EnumerationItem[] enumerationItemArray = otherItems;
        int n = otherItems.length;
        int n2 = 0;
        while (n2 < n) {
            EnumerationItem otherItem = enumerationItemArray[n2];
            items.add(otherItem);
            ++n2;
        }
        return new EnumerationParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, true, null, items, true);
    }

    private ParameterGroup createMockParameterGroup() {
        return new ParameterGroup("Grupo de par\u00e2metros");
    }
}

