/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.CheckTrigger;
import csbase.logic.algorithms.parameters.triggers.MockTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class TriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testTrigger1() {
        SimpleParameter<?> parameter = this.createMockParameter();
        SimpleCondition condition = new SimpleCondition(parameter.getName(), null);
        MockTrigger trigger = new MockTrigger(parameter, (Condition)condition);
        Assert.assertEquals(parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTrigger2() {
        String parameterName = "Nome do par\u00e2metro";
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        new MockTrigger(null, (Condition)condition);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTriggerWithNullCondition() {
        SimpleParameter<?> parameter = this.createMockParameter();
        new MockTrigger(parameter, null);
    }

    @Test
    public void testEquals1() {
        String parameterName = "Nome do par\u00e2metro";
        SimpleCondition condition1 = new SimpleCondition(parameterName, (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition(parameterName, (Object)"Valor 2");
        SimpleParameter<?> parameter = this.createMockParameter();
        MockTrigger trigger1 = new MockTrigger(parameter, (Condition)condition1);
        MockTrigger trigger2 = new MockTrigger(parameter, (Condition)condition2);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals2() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        SimpleParameter<?> parameter1 = this.createMockParameter(parameterName1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        SimpleParameter<?> parameter2 = this.createMockParameter(parameterName2);
        String parameterName3 = "Nome do par\u00e2metro 3";
        SimpleCondition condition = new SimpleCondition(parameterName3, null);
        MockTrigger trigger1 = new MockTrigger(parameter1, (Condition)condition);
        MockTrigger trigger2 = new MockTrigger(parameter2, (Condition)condition);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals3() {
        SimpleParameter<?> parameter = this.createMockParameter();
        SimpleCondition condition1 = new SimpleCondition(parameter.getName(), (Object)"Valor 1");
        MockTrigger trigger1 = new MockTrigger(parameter, (Condition)condition1);
        Assert.assertFalse((boolean)trigger1.equals(null));
    }

    @Test
    public void testEquals4() {
        SimpleParameter<?> parameter = this.createMockParameter();
        SimpleCondition condition1 = new SimpleCondition(parameter.getName(), (Object)"Valor 1");
        MockTrigger trigger1 = new MockTrigger(parameter, (Condition)condition1);
        Assert.assertFalse((boolean)trigger1.equals("Um objeto de outra classe"));
    }

    @Test
    public void testHashCode() {
        String parameterName = "Nome do par\u00e2metro";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName);
        String parameterName1 = "Nome do par\u00e2metro 1";
        SimpleCondition condition1 = new SimpleCondition(parameterName1, null);
        String parameterName2 = "Nome do par\u00e2metro 2";
        SimpleCondition condition2 = new SimpleCondition(parameterName2, null);
        MockTrigger trigger1 = new MockTrigger(parameter, (Condition)condition1);
        MockTrigger trigger2 = new MockTrigger(parameter, (Condition)condition2);
        Assert.assertEquals((long)trigger1.hashCode(), (long)trigger2.hashCode());
    }

    @Test
    public void testUpdate1() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String defaultValue = "Valor-padr\u00e3o do par\u00e2metro";
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2mtro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, null);
        group.addParameter((Parameter)parameter);
        SimpleCondition condition = new SimpleCondition(parameter.getName(), (Object)defaultValue);
        CheckTrigger trigger = new CheckTrigger(parameter, (Condition)condition);
        trigger.allowDo();
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertTrue((boolean)trigger.wasDone());
    }

    @Test
    public void testUpdate2() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String defaultValue = "Valor-padr\u00e3o do par\u00e2metro";
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2mtro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, null);
        group.addParameter((Parameter)parameter);
        String value = "Outro valor";
        SimpleCondition condition = new SimpleCondition(parameter.getName(), (Object)value);
        CheckTrigger trigger = new CheckTrigger(parameter, (Condition)condition);
        trigger.allowUndo();
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertTrue((boolean)trigger.wasUndone());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String parameterName = "Nome do par\u00e2metro";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName);
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        MockTrigger outputTrigger = new MockTrigger(parameter, (Condition)condition);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject((Object)outputTrigger);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        Trigger inputTrigger = (Trigger)objectInput.readObject();
        Assert.assertEquals((Object)((Object)outputTrigger), (Object)inputTrigger);
        Assert.assertEquals((Object)outputTrigger.getCondition(), (Object)inputTrigger.getCondition());
        Assert.assertEquals((Object)outputTrigger.getParameter(), (Object)inputTrigger.getParameter());
    }

    private SimpleAlgorithmConfigurator createAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private SimpleParameter<?> createMockParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockParameter(parameterName);
    }

    private SimpleParameter<?> createMockParameter(String parameterName) {
        return new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", "Valor-padr\u00e3o do par\u00e2metro", false, true, null);
    }
}

