/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.BooleanParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import tecgraf.javautils.core.lng.LNG;

public final class BooleanParameterValidatorTest {
    static {
        LNG.load((String)"csbase.client.resources.properties.language.idiom", (Locale)new Locale("pt", "BR"));
    }

    @Test
    public void testBooleanParameterValidator() {
        BooleanParameterValidator validator = new BooleanParameterValidator();
        Assert.assertFalse((boolean)validator.isOptional());
    }

    @Test
    public void testValidateValueWithFalseDefaultValueAndTrueValue() {
        BooleanParameterValidator validator = new BooleanParameterValidator();
        BooleanParameter parameter = new BooleanParameter("Nome do par\u00e2metro", "R\u00f3tulo do Par\u00e2metro", "Descri\u00e7\u00e3o do Par\u00e2metro", false, true, "--{0} {1}", null, null);
        Validation result = validator.validateValue((SimpleParameter)parameter, new Boolean(true), null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithTrueDefaultValueAndFalseValue() {
        BooleanParameterValidator validator = new BooleanParameterValidator();
        BooleanParameter parameter = new BooleanParameter("Nome do par\u00e2metro", "R\u00f3tulo do Par\u00e2metro", "Descri\u00e7\u00e3o do Par\u00e2metro", true, true, "--{0} {1}", null, null);
        Validation result = validator.validateValue((SimpleParameter)parameter, new Boolean(false), null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithFalseDefaultValueAndFalseValue() {
        BooleanParameterValidator validator = new BooleanParameterValidator();
        BooleanParameter parameter = new BooleanParameter("Nome do par\u00e2metro", "R\u00f3tulo do Par\u00e2metro", "Descri\u00e7\u00e3o do Par\u00e2metro", false, true, "--{0} {1}", null, null);
        Validation result = validator.validateValue((SimpleParameter)parameter, new Boolean(false), null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithTrueDefaultValueAndTrueValue() {
        BooleanParameterValidator validator = new BooleanParameterValidator();
        BooleanParameter parameter = new BooleanParameter("Nome do par\u00e2metro", "R\u00f3tulo do Par\u00e2metro", "Descri\u00e7\u00e3o do Par\u00e2metro", true, true, "--{0} {1}", null, null);
        Validation result = validator.validateValue((SimpleParameter)parameter, new Boolean(true), null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateValueWithNullValue() {
        BooleanParameterValidator validator = new BooleanParameterValidator();
        BooleanParameter parameter = new BooleanParameter("Nome do par\u00e2metro", "R\u00f3tulo do Par\u00e2metro", "Descri\u00e7\u00e3o do Par\u00e2metro", false, true, "--{0} {1}", null, null);
        validator.validateValue((SimpleParameter)parameter, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateValueWithNotVisibleParameterWithNullValue() {
        BooleanParameterValidator validator = new BooleanParameterValidator();
        BooleanParameter parameter = new BooleanParameter("Nome do par\u00e2metro", "R\u00f3tulo do Par\u00e2metro", "Descri\u00e7\u00e3o do Par\u00e2metro", false, false, "--{0} {1}", null, null);
        validator.validateValue((SimpleParameter)parameter, null, null);
    }
}

