/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.EnumerationParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import tecgraf.javautils.core.lng.LNG;

public final class EnumerationParameterValidatorTest {
    static {
        LNG.load((String)"csbase.client.resources.properties.language.idiom", (Locale)new Locale("pt", "BR"));
    }

    @Test
    public void testValidateValueWithValidValue() throws RemoteException {
        EnumerationParameterValidator validator = new EnumerationParameterValidator(false);
        String id = "ID do item";
        String name = "Nome do item";
        String value = "Valor do item";
        EnumerationItem item = new EnumerationItem(id, name, value, null);
        String parameterName = "Nome da enumera\u00e7\u00e3o";
        String parameterLabel = "R\u00f3tulo da enumera\u00e7\u00e3o";
        String parameterDescription = "Descri\u00e7\u00e3o da enumera\u00e7\u00e3o";
        String commandLinePattern = "{0} {1}";
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item);
        boolean mustSortItems = true;
        EnumerationParameter parameter = new EnumerationParameter(parameterName, parameterLabel, parameterDescription, item, true, commandLinePattern, items, mustSortItems);
        Validation result = validator.validateValue((SimpleParameter)parameter, (Object)item, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithNullValue() throws RemoteException {
        EnumerationParameterValidator validator = new EnumerationParameterValidator(false);
        String id = "ID do item";
        String name = "Nome da enumera\u00e7\u00e3o";
        String label = "R\u00f3tulo da enumera\u00e7\u00e3o";
        String description = "Descri\u00e7\u00e3o da enumera\u00e7\u00e3o";
        EnumerationItem item = new EnumerationItem(id, "Nome do item", "Valor_do_item", null);
        String commandLinePattern = "{0} {1}";
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        items.add(item);
        boolean mustSortItems = true;
        EnumerationParameter parameter = new EnumerationParameter(name, label, description, item, true, commandLinePattern, items, mustSortItems);
        Validation result = validator.validateValue((SimpleParameter)parameter, null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }
}

