/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.FormulaParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.FormulaParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.lng.LNG;

public final class FormulaParameterValidatorTest {
    static {
        LNG.load((String)"csbase.client.resources.properties.language.idiom", (Locale)new Locale("pt", "BR"));
        try {
            ConfigurationManager.createInstance();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testFormulaParameterValidator1() {
        FormulaParameterValidator validator = new FormulaParameterValidator(true);
        Assert.assertTrue((boolean)validator.isOptional());
    }

    @Test
    public void testFormulaParameterValidator2() {
        FormulaParameterValidator validator = new FormulaParameterValidator(false);
        Assert.assertFalse((boolean)validator.isOptional());
    }

    @Test
    public void testValidateValue1() throws RemoteException {
        FormulaParameter parameter = new FormulaParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", true, true, "{0}={1}");
        FormulaParameterValidator validator = new FormulaParameterValidator(true);
        Assert.assertTrue((boolean)validator.isOptional());
        Validation result = validator.validateValue((SimpleParameter)parameter, null, null);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValue2() throws RemoteException {
        FormulaParameter parameter = new FormulaParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", true, true, "{0}={1}");
        FormulaParameterValidator validator = new FormulaParameterValidator(false);
        Assert.assertFalse((boolean)validator.isOptional());
        Validation result = validator.validateValue((SimpleParameter)parameter, null, null);
        Assert.assertFalse((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValue3() throws RemoteException {
        HashSet<Character> acceptedChars = new HashSet<Character>();
        char ch = 'a';
        while (ch <= 'z') {
            acceptedChars.add(Character.valueOf(ch));
            ch = (char)(ch + 1);
        }
        ch = 'A';
        while (ch <= 'Z') {
            acceptedChars.add(Character.valueOf(ch));
            ch = (char)(ch + '\u0001');
        }
        ch = '0';
        while (ch <= '9') {
            acceptedChars.add(Character.valueOf(ch));
            ch = (char)(ch + '\u0001');
        }
        acceptedChars.add(Character.valueOf('_'));
        acceptedChars.add(Character.valueOf('('));
        acceptedChars.add(Character.valueOf(')'));
        acceptedChars.add(Character.valueOf(';'));
        acceptedChars.add(Character.valueOf('['));
        acceptedChars.add(Character.valueOf(']'));
        acceptedChars.add(Character.valueOf('{'));
        acceptedChars.add(Character.valueOf('}'));
        acceptedChars.add(Character.valueOf('+'));
        acceptedChars.add(Character.valueOf('-'));
        acceptedChars.add(Character.valueOf('*'));
        acceptedChars.add(Character.valueOf('/'));
        acceptedChars.add(Character.valueOf('%'));
        acceptedChars.add(Character.valueOf('<'));
        acceptedChars.add(Character.valueOf('>'));
        acceptedChars.add(Character.valueOf(' '));
        acceptedChars.add(Character.valueOf('.'));
        acceptedChars.add(Character.valueOf('='));
        acceptedChars.add(Character.valueOf('^'));
        acceptedChars.add(Character.valueOf('&'));
        FormulaParameter parameter = new FormulaParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", true, true, "{0}={1}");
        FormulaParameterValidator validator = new FormulaParameterValidator(true);
        Assert.assertTrue((boolean)validator.isOptional());
        char ch2 = '\u0000';
        while (ch2 < '\uffff') {
            String value = Character.toString(ch2);
            parameter.setValue((Object)value);
            Validation result = validator.validateValue((SimpleParameter)parameter, value, null);
            boolean isWellSucceded = acceptedChars.contains(Character.valueOf(ch2));
            if (isWellSucceded != result.isWellSucceded()) {
                System.out.println("char '" + ch2 + "'");
            }
            ch2 = (char)(ch2 + '\u0001');
        }
    }
}

