/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.IntegerParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import java.rmi.RemoteException;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import tecgraf.javautils.core.lng.LNG;

public final class IntegerParameterValidatorTest {
    static {
        LNG.load((String)"csbase.client.resources.properties.language.idiom", (Locale)new Locale("pt", "BR"));
    }

    @Test
    public void testIntegerParameterValidatorWithTrueIsOptional() {
        boolean isOptional = true;
        Integer maximum = null;
        Integer minimum = null;
        IntegerParameterValidator validator = new IntegerParameterValidator(isOptional, maximum, minimum);
        this.assertValidator(isOptional, maximum, minimum, validator);
    }

    @Test
    public void testIntegerParameterValidatorWithFalseIsOptional() {
        boolean isOptional = false;
        Integer maximum = null;
        Integer minimum = null;
        IntegerParameterValidator validator = new IntegerParameterValidator(isOptional, maximum, minimum);
        this.assertValidator(isOptional, maximum, minimum, validator);
    }

    @Test
    public void testIntegerParameterValidatorWithMaximum() {
        boolean isOptional = false;
        Integer maximum = new Integer(1000);
        Integer minimum = null;
        IntegerParameterValidator validator = new IntegerParameterValidator(isOptional, maximum, minimum);
        this.assertValidator(isOptional, maximum, minimum, validator);
    }

    @Test
    public void testIntegerParameterValidatorWithMinimum() {
        boolean isOptional = false;
        Integer maximum = null;
        Integer minimum = new Integer(100);
        IntegerParameterValidator validator = new IntegerParameterValidator(isOptional, maximum, minimum);
        this.assertValidator(isOptional, maximum, minimum, validator);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIntegerParameterValidatorWithMaximumLesserThanMinimum() {
        Integer maximum = new Integer(10);
        Integer minimum = new Integer(10000);
        boolean isOptional = true;
        new IntegerParameterValidator(isOptional, maximum, minimum);
    }

    @Test
    public void testValidateValueOptionalAndWithoutMaximumNorMinimum() throws RemoteException {
        IntegerParameter parameter = new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "{0}{1}", null, null);
        IntegerParameterValidator validator = new IntegerParameterValidator(true, null, null);
        Integer value = new Integer(3);
        Validation result = validator.validateValue((SimpleParameter)parameter, value, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithValidWithAllRestrictions() throws RemoteException {
        IntegerParameter parameter = new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "{0}{1}", null, null);
        Integer maximum = new Integer(200);
        Integer minimum = new Integer(0);
        IntegerParameterValidator validator = new IntegerParameterValidator(false, maximum, minimum);
        Integer value = new Integer(100);
        Validation result = validator.validateValue((SimpleParameter)parameter, value, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithNullValueOptional() throws RemoteException {
        IntegerParameter parameter = new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "{0}{1}", null, null);
        IntegerParameterValidator validator = new IntegerParameterValidator(true, null, null);
        Validation result = validator.validateValue((SimpleParameter)parameter, null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithValidValueEqualsMaximum() throws RemoteException {
        IntegerParameter parameter = new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "{0}{1}", null, null);
        Integer maximum = new Integer(100);
        IntegerParameterValidator validator = new IntegerParameterValidator(false, maximum, null);
        Validation result = validator.validateValue((SimpleParameter)parameter, maximum, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithValueEqualsMinimum() throws RemoteException {
        IntegerParameter parameter = new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "{0}{1}", null, null);
        Integer minimum = new Integer(0);
        IntegerParameterValidator validator = new IntegerParameterValidator(false, null, minimum);
        Validation result = validator.validateValue((SimpleParameter)parameter, minimum, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithNullValueNonOptional() throws RemoteException {
        IntegerParameter parameter = new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "{0}{1}", null, null);
        IntegerParameterValidator validator = new IntegerParameterValidator(false, null, null);
        Validation result = validator.validateValue((SimpleParameter)parameter, null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    @Test
    public void testValidatValueWithValueLargerThanMaximum() throws RemoteException {
        IntegerParameter parameter = new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "{0}{1}", null, null);
        Integer maximum = new Integer(0);
        IntegerParameterValidator validator = new IntegerParameterValidator(false, maximum, null);
        Integer value = new Integer(maximum + 1);
        Validation result = validator.validateValue((SimpleParameter)parameter, value, null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    public void testValidateValueWithValueLesserThanMinimum() throws RemoteException {
        IntegerParameter parameter = new IntegerParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", new Integer(10), false, true, "{0}{1}", null, null);
        Integer minimum = new Integer(0);
        IntegerParameterValidator validator = new IntegerParameterValidator(false, null, minimum);
        Integer value = new Integer(minimum - 1);
        Validation result = validator.validateValue((SimpleParameter)parameter, value, null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    private void assertValidator(boolean isOptional, Integer maximum, Integer minimum, IntegerParameterValidator validator) {
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        Assert.assertEquals((Object)maximum, (Object)validator.getMaximum());
        Assert.assertEquals((Object)minimum, (Object)validator.getMinimum());
    }
}

