/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.URLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLValue;
import csbase.logic.algorithms.parameters.validators.URLListParameterValidator;
import csbase.logic.algorithms.parameters.validators.URLParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import tecgraf.javautils.core.lng.LNG;

public final class URLListParameterValidatorTest {
    static {
        LNG.load((String)"csbase.client.resources.properties.language.idiom", (Locale)new Locale("pt", "BR"));
    }

    @Test
    public void testURLListParameterValidatorWithNonOptionalValue() {
        boolean isOptional = false;
        URLListParameterValidator validator = new URLListParameterValidator(new URLParameterValidator(isOptional));
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
    }

    @Test
    public void testURLListParameterValidatorWithOptionalValue() {
        boolean isOptional = true;
        URLListParameterValidator validator = new URLListParameterValidator(new URLParameterValidator(isOptional));
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
    }

    @Test
    public void testValidateLocalValueWithColonChar() throws RemoteException {
        URLValue value = new URLValue("/abc.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithEmptyValueNonOptional() throws RemoteException {
        boolean isOptional = false;
        InputURLListParameter parameter = new InputURLListParameter("url", "url", "url", null, isOptional, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        ArrayList<URLValue> value = new ArrayList<URLValue>();
        Validation result = this.validateValue(value, (URLListParameter)parameter);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithEmptyValueOptional() throws RemoteException {
        ArrayList<URLValue> value = new ArrayList<URLValue>();
        Validation result = this.validateValueAsInput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithFileNameWithAccents() throws RemoteException {
        URLValue value = new URLValue("/tmp/nomeComVariosAcentos\u00c1\u00e9\u00e3\u00e7", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithFileNameWithNonAllowedCharacters() throws RemoteException {
        URLValue value = new URLValue("/nome@!#", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithFileNameWithSpaces() throws RemoteException {
        URLValue value = new URLValue("/nome com espaco", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithHifenChar() throws RemoteException {
        URLValue value = new URLValue("/abc-.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithNonAbsolutePath() throws RemoteException {
        URLValue value = new URLValue("abc.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithNonExistingFile() throws IOException {
        URLValue value = this.getNonExistingLocalURL();
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithNonExistingLocalFileAsOutput() throws IOException {
        URLValue value = this.getNonExistingLocalURL();
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithNullNonOptionalValue() throws RemoteException {
        boolean isOptional = false;
        InputURLListParameter parameter = new InputURLListParameter("url", "url", "url", null, isOptional, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, false, EnumSet.allOf(URLProtocol.class));
        List<URLValue> value = null;
        Validation result = this.validateValue(value, (URLListParameter)parameter);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithNullOptionalValue() throws RemoteException {
        List<URLValue> value = null;
        Validation result = this.validateValueAsInput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithUnderscoreChar() throws RemoteException {
        URLValue value = new URLValue("/abc_.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithValidFile() throws IOException {
        URLValue value = this.getLocalURL();
        Validation result = this.validateValueAsInput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithWindowsFileName() throws RemoteException {
        URLValue value = new URLValue("c:\\Test\\test.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithWindowsFileNameWithUnixSeparator() throws RemoteException {
        URLValue value = new URLValue("c:/Test/test.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateProjectValueWithAbsolutePath() throws RemoteException {
        URLValue value = new URLValue("c:\\abc.txt", "TEXT", URLProtocol.PROJECT);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateProjectValueWithFileNameWithAccents() throws RemoteException {
        URLValue value = new URLValue("/dir/nomeComVariosAcentos\u00c1\u00e9\u00e3\u00e7", "TEXT", URLProtocol.PROJECT);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateProjectValueWithFileNameWithNonAllowedCharacters() throws RemoteException {
        URLValue value = new URLValue("nome@!#", "TEXT", URLProtocol.PROJECT);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateProjectValueWithFileNameWithSpaces() throws RemoteException {
        URLValue value = new URLValue("nome com espaco", "TEXT", URLProtocol.PROJECT);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateProjectValueWithNonAllowedProtocol() throws IOException {
        EnumSet<URLProtocol> allowedProtocols = EnumSet.of(URLProtocol.PROJECT);
        InputURLListParameter parameter = new InputURLListParameter("url", "url", "url", null, true, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, true, allowedProtocols);
        URLValue value = this.getLocalURL();
        Validation result = this.validateValue(value, (URLListParameter)parameter);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateSGAValueWithFileNameWithAccents() throws RemoteException {
        URLValue value = new URLValue("c:/tmp/nomeComVariosAcentos\u00c1\u00e9\u00e3\u00e7", "TEXT", URLProtocol.SGA);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateSGAValueWithFileNameWithNonAllowedCharacters() throws RemoteException {
        URLValue value = new URLValue("/nome@!#", "TEXT", URLProtocol.SGA);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateSGAValueWithFileNameWithSpaces() throws RemoteException {
        URLValue value = new URLValue("/nome com espaco", "TEXT", URLProtocol.SGA);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateSGAValueWithNonAbsolutePath() throws RemoteException {
        URLValue value = new URLValue("abc.txt", "TEXT", URLProtocol.SGA, "sganame");
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateValueWithMultipleProtocols() throws IOException {
        URLValue value1 = this.getLocalURL();
        URLValue value2 = new URLValue("file.txt", "TEXT", URLProtocol.PROJECT);
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        values.add(value1);
        values.add(value2);
        Validation result = this.validateValueAsOutput(values);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateValueWithNonAllowedProtocol() throws IOException {
        EnumSet<URLProtocol> allowedProtocols = EnumSet.of(URLProtocol.PROJECT);
        URLValue value = this.getLocalURL();
        InputURLListParameter parameter = new InputURLListParameter("url", "url", "url", null, true, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, false, allowedProtocols);
        Validation result = this.validateValue(value, (URLListParameter)parameter);
        this.assertValidationFailed(result);
    }

    private void assertValidationFailed(Validation result) {
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    private void assertValidationSucceeded(Validation result) {
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    private URLListParameter createInputURLListParameter() {
        return new InputURLListParameter("url", "url", "url", null, true, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, true, EnumSet.allOf(URLProtocol.class));
    }

    private URLListParameter createOutputURLListParameter() {
        return new OutputURLListParameter("url", "url", "url", null, true, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, true, EnumSet.allOf(URLProtocol.class));
    }

    private URLValue getLocalURL() throws IOException {
        File tmpFile = File.createTempFile("validator", null);
        tmpFile.deleteOnExit();
        URLValue value = new URLValue(tmpFile.getPath(), "TEXT", URLProtocol.LOCAL);
        return value;
    }

    private URLValue getNonExistingLocalURL() throws IOException {
        File tmpFile = File.createTempFile("validator", null);
        tmpFile.delete();
        URLValue value = new URLValue(tmpFile.getPath(), "TEXT", URLProtocol.LOCAL);
        return value;
    }

    private Validation validateValue(List<URLValue> value, URLListParameter parameter) throws RemoteException {
        ValidationContext context = new ValidationContext(ValidationMode.FULL, (Object)"username/proj", (Object)"username");
        URLListParameterValidator validator = new URLListParameterValidator(new URLParameterValidator(parameter.isOptional()));
        parameter.setValue(value);
        Validation result = validator.validateValue((SimpleParameter)parameter, value, context);
        return result;
    }

    private Validation validateValue(URLValue value, URLListParameter parameter) throws RemoteException {
        ArrayList<URLValue> values = new ArrayList<URLValue>();
        values.add(value);
        return this.validateValue(values, parameter);
    }

    private Validation validateValueAsInput(List<URLValue> value) throws RemoteException {
        URLListParameter parameter = this.createInputURLListParameter();
        return this.validateValue(value, parameter);
    }

    private Validation validateValueAsInput(URLValue value) throws RemoteException {
        URLListParameter parameter = this.createInputURLListParameter();
        return this.validateValue(value, parameter);
    }

    private Validation validateValueAsOutput(List<URLValue> value) throws RemoteException {
        URLListParameter parameter = this.createOutputURLListParameter();
        return this.validateValue(value, parameter);
    }

    private Validation validateValueAsOutput(URLValue value) throws RemoteException {
        URLListParameter parameter = this.createOutputURLListParameter();
        return this.validateValue(value, parameter);
    }
}

