/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.URLParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLValue;
import csbase.logic.algorithms.parameters.validators.URLParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.EnumSet;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import tecgraf.javautils.core.lng.LNG;

public final class URLParameterValidatorTest {
    static {
        LNG.load((String)"csbase.client.resources.properties.language.idiom", (Locale)new Locale("pt", "BR"));
    }

    @Test
    public void testURLParameterValidatorWithNonOptionalValue() {
        boolean isOptional = false;
        URLParameterValidator validator = new URLParameterValidator(isOptional);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
    }

    @Test
    public void testURLParameterValidatorWithOptionalValue() {
        boolean isOptional = true;
        URLParameterValidator validator = new URLParameterValidator(isOptional);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
    }

    @Test
    public void testValidateLocalValueWithColonChar() throws RemoteException {
        URLValue value = new URLValue("/abc.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithFileNameWithAccents() throws RemoteException {
        URLValue value = new URLValue("/tmp/nomeComVariosAcentos\u00c1\u00e9\u00e3\u00e7", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithFileNameWithNonAllowedCharacters() throws RemoteException {
        URLValue value = new URLValue("/nome@!#", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithFileNameWithSpaces() throws RemoteException {
        URLValue value = new URLValue("/nome com espaco", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithHifenChar() throws RemoteException {
        URLValue value = new URLValue("/abc-.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithNonAbsolutePath() throws RemoteException {
        URLValue value = new URLValue("abc.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateLocalValueWithNonExistingFile() throws IOException {
        URLValue value = this.getNonExistingLocalURL();
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithUnderscoreChar() throws RemoteException {
        URLValue value = new URLValue("/abc_.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithValidFile() throws IOException {
        URLValue value = this.getLocalURL();
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithWindowsFileName() throws RemoteException {
        URLValue value = new URLValue("c:\\Test\\test.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateLocalValueWithWindowsFileNameWithUnixSeparator() throws RemoteException {
        URLValue value = new URLValue("c:/Test/test.txt", "TEXT", URLProtocol.LOCAL);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationSucceeded(result);
    }

    @Test
    public void testValidateProjectValueWithAbsolutePath() throws RemoteException {
        URLValue value = new URLValue("c:\\abc.txt", "TEXT", URLProtocol.PROJECT);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateProjectValueWithFileNameWithAccents() throws RemoteException {
        URLValue value = new URLValue("/dir/nomeComVariosAcentos\u00c1\u00e9\u00e3\u00e7", "TEXT", URLProtocol.PROJECT);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateProjectValueWithFileNameWithNonAllowedCharacters() throws RemoteException {
        URLValue value = new URLValue("nome@!#", "TEXT", URLProtocol.PROJECT);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateProjectValueWithFileNameWithSpaces() throws RemoteException {
        URLValue value = new URLValue("nome com espaco", "TEXT", URLProtocol.PROJECT);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateSGAValueWithFileNameWithAccents() throws RemoteException {
        URLValue value = new URLValue("c:/tmp/nomeComVariosAcentos\u00c1\u00e9\u00e3\u00e7", "TEXT", URLProtocol.SGA);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateSGAValueWithFileNameWithNonAllowedCharacters() throws RemoteException {
        URLValue value = new URLValue("nome@!#", "TEXT", URLProtocol.SGA);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateSGAValueWithFileNameWithSpaces() throws RemoteException {
        URLValue value = new URLValue("/nome com espaco", "TEXT", URLProtocol.SGA);
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateSGAValueWithNonAbsolutePath() throws RemoteException {
        URLValue value = new URLValue("abc.txt", "TEXT", URLProtocol.SGA, "sganame");
        Validation result = this.validateValueAsOutput(value);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateWithNonAllowedProtocol() throws IOException {
        EnumSet<URLProtocol> allowedProtocols = EnumSet.of(URLProtocol.PROJECT);
        InputURLParameter parameter = new InputURLParameter("url", "url", "url", null, true, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, allowedProtocols);
        URLValue value = this.getLocalURL();
        Validation result = this.validateValue(value, (URLParameter)parameter);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateWithNullValueNonOptional() throws IOException {
        boolean isOptional = false;
        InputURLParameter parameter = new InputURLParameter("url", "url", "url", null, isOptional, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
        URLValue value = null;
        Validation result = this.validateValue(value, (URLParameter)parameter);
        this.assertValidationFailed(result);
    }

    @Test
    public void testValidateWithNullValueOptional() throws RemoteException {
        URLValue value = null;
        Validation result = this.validateValueAsInput(value);
        this.assertValidationSucceeded(result);
    }

    private void assertValidationFailed(Validation result) {
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    private void assertValidationSucceeded(Validation result) {
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    private URLParameter createInputURLParameter() {
        return new InputURLParameter("url", "url", "url", null, true, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
    }

    private URLParameter createOutputURLParameter() {
        return new OutputURLParameter("url", "url", "url", null, true, true, null, "local", "TEXT", FileParameterMode.REGULAR_FILE, EnumSet.allOf(URLProtocol.class));
    }

    private URLValue getLocalURL() throws IOException {
        File tmpFile = File.createTempFile("validator", null);
        tmpFile.deleteOnExit();
        URLValue value = new URLValue(tmpFile.getPath(), "TEXT", URLProtocol.LOCAL);
        return value;
    }

    private URLValue getNonExistingLocalURL() throws IOException {
        File tmpFile = File.createTempFile("validator", null);
        tmpFile.delete();
        URLValue value = new URLValue(tmpFile.getPath(), "TEXT", URLProtocol.LOCAL);
        return value;
    }

    private Validation validateValue(URLValue value, URLParameter parameter) throws RemoteException {
        ValidationContext context = new ValidationContext(ValidationMode.FULL, (Object)"username/proj", (Object)"username");
        URLParameterValidator validator = new URLParameterValidator(parameter.isOptional());
        parameter.setValue((Object)value);
        Validation result = validator.validateValue((SimpleParameter)parameter, value, context);
        return result;
    }

    private Validation validateValueAsInput(URLValue value) throws RemoteException {
        URLParameter parameter = this.createInputURLParameter();
        return this.validateValue(value, parameter);
    }

    private Validation validateValueAsOutput(URLValue value) throws RemoteException {
        URLParameter parameter = this.createOutputURLParameter();
        return this.validateValue(value, parameter);
    }
}

