/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.OperationFailureException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.parsers.MockCategoryParser;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.SortedSet;
import junit.framework.TestCase;

public final class CategoryParserTest
extends TestCase {
    public void testRead1() throws OperationFailureException {
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<categories>";
        xml = String.valueOf(xml) + "</categories>";
        this.assertValidXml(xml, new AlgorithmInfo[0], new Category[0]);
    }

    public void testRead2() throws OperationFailureException {
        String id = "C.1";
        String name = "Categoria 1";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<categories>";
        xml = String.valueOf(xml) + String.format("<category id = '%s' name = '%s'/>", id, name);
        xml = String.valueOf(xml) + "</categories>";
        this.assertValidXml(xml, new AlgorithmInfo[0], new Category(null, id, name));
    }

    public void testRead3() throws OperationFailureException {
        String id1 = "C.1";
        String name1 = "Categoria 1";
        String id2 = "C.2";
        String name2 = "Categoria 2";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<categories>";
        xml = String.valueOf(xml) + String.format("<category id = '%s' name = '%s'/>", id1, name1);
        xml = String.valueOf(xml) + String.format("<category id = '%s' name = '%s'/>", id2, name2);
        xml = String.valueOf(xml) + "</categories>";
        this.assertValidXml(xml, new AlgorithmInfo[0], new Category(null, id1, name1), new Category(null, id2, name2));
    }

    public void testRead4() throws OperationFailureException {
        String id1 = "C.1";
        String name1 = "Categoria 1";
        String id11 = "C.1.1";
        String name11 = "Categoria 1.1";
        String id12 = "C.1.2";
        String name12 = "Categoria 1.2";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<categories>";
        xml = String.valueOf(xml) + String.format("<category id = '%s' name = '%s'>", id1, name1);
        xml = String.valueOf(xml) + String.format("<category id = '%s' name = '%s'/>", id11, name11);
        xml = String.valueOf(xml) + String.format("<category id = '%s' name = '%s'/>", id12, name12);
        xml = String.valueOf(xml) + "</category>";
        xml = String.valueOf(xml) + "</categories>";
        Category category1 = new Category(null, id1, name1);
        category1.addCategory(new Category(category1, id11, name11));
        category1.addCategory(new Category(category1, id12, name12));
        this.assertValidXml(xml, new AlgorithmInfo[0], category1);
    }

    public void testRead5() throws OperationFailureException {
        String id1 = "C.1";
        String name1 = "Categoria 1";
        String algorithmId1 = "A.1";
        String algorithmId2 = "A.2";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<categories>";
        xml = String.valueOf(xml) + String.format("<category id = '%s' name = '%s'>", id1, name1);
        xml = String.valueOf(xml) + String.format("<algorithm id = '%s'/>", algorithmId1);
        xml = String.valueOf(xml) + String.format("<algorithm id = '%s'/>", algorithmId2);
        xml = String.valueOf(xml) + "</category>";
        xml = String.valueOf(xml) + "</categories>";
        Category category1 = new Category(null, id1, name1);
        AlgorithmInfo algorithm1 = this.createMockAlgorithm(algorithmId1);
        AlgorithmInfo algorithm2 = this.createMockAlgorithm(algorithmId2);
        category1.addAlgorithm(algorithm1);
        category1.addAlgorithm(algorithm2);
        this.assertValidXml(xml, new AlgorithmInfo[]{algorithm1, algorithm2}, category1);
    }

    public void testRead6() {
        String name = "Categoria 1";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<categories>";
        xml = String.valueOf(xml) + String.format("<category name = '%s'/>", name);
        xml = String.valueOf(xml) + "</categories>";
        this.assertInvalidXml(xml);
    }

    public void testRead7() {
        String id = "C.1";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<categories>";
        xml = String.valueOf(xml) + String.format("<category id = '%s'/>", id);
        xml = String.valueOf(xml) + "</categories>";
        this.assertInvalidXml(xml);
    }

    public void testRead8() {
        String id1 = "C.1";
        String name1 = "Categoria 1";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<categories>";
        xml = String.valueOf(xml) + String.format("<category id = '%s' name = '%s'>", id1, name1);
        xml = String.valueOf(xml) + String.format("<algorithm/>", new Object[0]);
        xml = String.valueOf(xml) + "</category>";
        xml = String.valueOf(xml) + "</categories>";
        this.assertInvalidXml(xml);
    }

    private void assertCategories(Category expectedCategory, Category foundCategory) {
        CategoryParserTest.assertNotNull((Object)foundCategory);
        CategoryParserTest.assertEquals((Object)expectedCategory, (Object)foundCategory);
        CategoryParserTest.assertEquals((String)expectedCategory.getId(), (String)foundCategory.getId());
        CategoryParserTest.assertEquals((String)expectedCategory.getName(), (String)foundCategory.getName());
        SortedSet expectedCategories = expectedCategory.getCategories();
        SortedSet foundCategories = foundCategory.getCategories();
        this.assertCategories(expectedCategories, foundCategories);
        Set expectedAlgorithms = expectedCategory.getAlgorithms();
        Set foundAlgorithms = foundCategory.getAlgorithms();
        CategoryParserTest.assertEquals((Object)expectedAlgorithms, (Object)foundAlgorithms);
    }

    private void assertCategories(Set<Category> expectedCategories, Set<Category> foundCategories) {
        CategoryParserTest.assertNotNull(foundCategories);
        CategoryParserTest.assertEquals(expectedCategories, foundCategories);
        for (Category foundCategory : foundCategories) {
            for (Category expectedCategory : expectedCategories) {
                if (!expectedCategory.equals((Object)foundCategory)) continue;
                this.assertCategories(expectedCategory, foundCategory);
            }
        }
    }

    private void assertInvalidXml(String xml) {
        try {
            this.assertValidXml(xml, new AlgorithmInfo[0], new Category[0]);
            CategoryParserTest.fail();
        }
        catch (OperationFailureException operationFailureException) {
            // empty catch block
        }
    }

    private void assertValidXml(String xml, AlgorithmInfo[] algorithms, Category ... categories) throws OperationFailureException {
        MockCategoryParser parser = new MockCategoryParser(algorithms);
        Set foundCategories = parser.read(new StringReader(xml));
        HashSet<Category> expectedCategories = new HashSet<Category>(Arrays.asList(categories));
        this.assertCategories(expectedCategories, foundCategories);
    }

    private AlgorithmInfo createMockAlgorithm(String algorithmId) {
        AlgorithmInfo algorithm = new AlgorithmInfo(algorithmId, "Nome do " + algorithmId, "dir_" + algorithmId, "algorithms", new Hashtable());
        return algorithm;
    }
}

