/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.XmlParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import junit.framework.TestCase;

public final class XmlParserTest
extends TestCase {
    public void testParseDocument1() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz>";
        xml = String.valueOf(xml) + "<primeiro_filho/>";
        xml = String.valueOf(xml) + "</raiz>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
    }

    public void testParseDocument2() throws ParseException {
        XmlParser parser = new XmlParser();
        try {
            parser.parseDocument(null);
            XmlParserTest.fail((String)"Esperada IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGoToRoot1() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
    }

    public void testGoToRoot2() {
        XmlParser parser = new XmlParser();
        try {
            parser.goToRoot();
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGoToFirstChild1() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz>";
        xml = String.valueOf(xml) + "<primeiro_filho/>";
        xml = String.valueOf(xml) + "</raiz>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        XmlParserTest.assertTrue((boolean)parser.goToFirstChild());
    }

    public void testGoToFirstChild2() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz>";
        xml = String.valueOf(xml) + "</raiz>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        XmlParserTest.assertFalse((boolean)parser.goToFirstChild());
    }

    public void testGoToFirstChild3() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz>";
        xml = String.valueOf(xml) + "</raiz>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        try {
            parser.goToFirstChild();
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGoToFirstChild4() {
        XmlParser parser = new XmlParser();
        try {
            parser.goToFirstChild();
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGoToNextSibling1() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz>";
        xml = String.valueOf(xml) + "<primeiro_filho/>";
        xml = String.valueOf(xml) + "<segundo_filho/>";
        xml = String.valueOf(xml) + "</raiz>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        parser.goToFirstChild();
        XmlParserTest.assertTrue((boolean)parser.goToNextSibling());
    }

    public void testGoToNextSibling2() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz>";
        xml = String.valueOf(xml) + "<primeiro_filho/>";
        xml = String.valueOf(xml) + "</raiz>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        parser.goToFirstChild();
        XmlParserTest.assertFalse((boolean)parser.goToNextSibling());
    }

    public void testGoToNextSibling3() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz>";
        xml = String.valueOf(xml) + "<primeiro_filho/>";
        xml = String.valueOf(xml) + "<segundo_filho/>";
        xml = String.valueOf(xml) + "</raiz>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        try {
            parser.goToNextSibling();
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGoToNextSibling4() {
        XmlParser parser = new XmlParser();
        try {
            parser.goToNextSibling();
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEnsureElementName1() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        parser.ensureElementName("raiz");
    }

    public void testEnsureElementName2() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        try {
            parser.ensureElementName("elemento_inexistente");
            XmlParserTest.fail((String)"Esperada ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testEnsureElementName3() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        try {
            parser.ensureElementName("elemento_inexistente");
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEnsureElementName4() throws ParseException {
        XmlParser parser = new XmlParser();
        try {
            parser.ensureElementName("elemento_inexistente");
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueString1() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        String value = parser.getAttributeValue("atributo");
        XmlParserTest.assertNotNull((Object)value);
        XmlParserTest.assertEquals((String)"valor", (String)value);
    }

    public void testGetAttributeValueString2() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        try {
            parser.getAttributeValue("outro_atributo");
            XmlParserTest.fail((String)"Esperada ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueString3() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        try {
            parser.getAttributeValue("outro_atributo");
            XmlParserTest.fail((String)"Esperada ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueString4() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        try {
            parser.getAttributeValue("outro_atributo");
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueString5() throws ParseException {
        XmlParser parser = new XmlParser();
        try {
            parser.getAttributeValue("outro_atributo");
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueStringString1() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        String defaultValue = "valor-padr\u00e3o";
        String value = parser.getAttributeValue("atributo", defaultValue);
        XmlParserTest.assertNotNull((Object)value);
        XmlParserTest.assertEquals((String)"valor", (String)value);
    }

    public void testGetAttributeValueStringString2() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        String defaultValue = "valor-padr\u00e3o";
        String value = parser.getAttributeValue("outro_atributo", defaultValue);
        XmlParserTest.assertEquals((String)defaultValue, (String)value);
    }

    public void testGetAttributeValueStringString3() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        String defaultValue = "valor-padr\u00e3o";
        String value = parser.getAttributeValue("atributo", defaultValue);
        XmlParserTest.assertEquals((String)defaultValue, (String)value);
    }

    public void testGetAttributeValueStringString4() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        String value = parser.getAttributeValue("atributo", null);
        XmlParserTest.assertEquals((String)"valor", (String)value);
    }

    public void testGetAttributeValueStringString5() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        String value = parser.getAttributeValue("outro_atributo", null);
        XmlParserTest.assertNull((Object)value);
    }

    public void testGetAttributeValueStringString6() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        String value = parser.getAttributeValue("atributo", null);
        XmlParserTest.assertNull((Object)value);
    }

    public void testGetAttributeValueStringString7() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        try {
            parser.getAttributeValue("outro_atributo", null);
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueStringString8() {
        XmlParser parser = new XmlParser();
        try {
            parser.getAttributeValue("outro_atributo", null);
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueAsBooleanString1() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='false'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        boolean value = parser.getAttributeValueAsBoolean("atributo");
        XmlParserTest.assertFalse((boolean)value);
    }

    public void testGetAttributeValueAsBooleanString2() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='true'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        boolean value = parser.getAttributeValueAsBoolean("atributo");
        XmlParserTest.assertTrue((boolean)value);
    }

    public void testGetAttributeValueAsBooleanString3() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor n\u00e3o-booleano'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        try {
            parser.getAttributeValueAsBoolean("atributo");
            XmlParserTest.fail((String)"Esperada ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueAsBooleanString4() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        try {
            parser.getAttributeValueAsBoolean("outro_atributo");
            XmlParserTest.fail((String)"Esperada ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueAsBooleanString5() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        try {
            parser.getAttributeValueAsBoolean("outro_atributo");
            XmlParserTest.fail((String)"Esperada ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueAsBooleanString6() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='valor'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        try {
            parser.getAttributeValueAsBoolean("outro_atributo");
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueAsBooleanString7() throws ParseException {
        XmlParser parser = new XmlParser();
        try {
            parser.getAttributeValueAsBoolean("outro_atributo");
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetAttributeValueAsBooleanStringBoolean1() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='false'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        boolean value = parser.getAttributeValueAsBoolean("atributo", true);
        XmlParserTest.assertFalse((boolean)value);
    }

    public void testGetAttributeValueAsBooleanStringBoolean2() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='true'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        boolean value = parser.getAttributeValueAsBoolean("atributo", false);
        XmlParserTest.assertTrue((boolean)value);
    }

    public void testGetAttributeValueAsBooleanStringBoolean3() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='false'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        boolean value = parser.getAttributeValueAsBoolean("outro_atributo", true);
        XmlParserTest.assertTrue((boolean)value);
    }

    public void testGetAttributeValueAsBooleanStringBoolean4() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz atributo='true'/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        boolean value = parser.getAttributeValueAsBoolean("outro_atributo", false);
        XmlParserTest.assertFalse((boolean)value);
    }

    public void testGetAttributeValueAsBooleanStringBoolean5() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        boolean value = parser.getAttributeValueAsBoolean("outro_atributo", true);
        XmlParserTest.assertTrue((boolean)value);
    }

    public void testGetAttributeValueAsBooleanStringBoolean6() throws ParseException {
        XmlParser parser = new XmlParser();
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<raiz/>";
        StringReader reader = new StringReader(xml);
        parser.parseDocument((Reader)reader);
        parser.goToRoot();
        boolean value = parser.getAttributeValueAsBoolean("outro_atributo", false);
        XmlParserTest.assertFalse((boolean)value);
    }

    public void testGetAttributeValueAsBooleanStringBoolean7() throws ParseException {
        XmlParser parser = new XmlParser();
        try {
            parser.getAttributeValueAsBoolean("outro_atributo", true);
            XmlParserTest.fail((String)"Esperada IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testReplaceElement() throws ParseException {
        String inputElementName = "entrada";
        String outputElementName = "saida";
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put(inputElementName, "<" + outputElementName + "/>");
        XmlParser parser = new XmlParser(replacementMap);
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<" + inputElementName + "/>";
        parser.parseDocument((Reader)new StringReader(xml));
        parser.goToRoot();
        XmlParserTest.assertEquals((String)outputElementName, (String)parser.getElementName());
    }

    public void testReplaceElementWithOutputAttributes() throws ParseException {
        String inputElementName = "entrada";
        String outputElementName = "saida";
        String attribute = "atributo";
        String attributeValue = "valor";
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put(inputElementName, "<" + outputElementName + " " + attribute + " = '" + attributeValue + "'/>");
        XmlParser parser = new XmlParser(replacementMap);
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<" + inputElementName + "/>";
        parser.parseDocument((Reader)new StringReader(xml));
        parser.goToRoot();
        XmlParserTest.assertEquals((String)outputElementName, (String)parser.getElementName());
        XmlParserTest.assertEquals((String)attributeValue, (String)parser.getAttributeValue(attribute));
    }

    public void testReplaceElementWithInputAttributes() throws ParseException {
        String inputElementName = "entrada";
        String outputElementName = "saida";
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put(inputElementName, "<" + outputElementName + "/>");
        XmlParser parser = new XmlParser(replacementMap);
        String attribute = "atributo";
        String attributeValue = "valor";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<" + inputElementName + " " + attribute + " = '" + attributeValue + "'/>";
        parser.parseDocument((Reader)new StringReader(xml));
        parser.goToRoot();
        XmlParserTest.assertEquals((String)outputElementName, (String)parser.getElementName());
        XmlParserTest.assertEquals((String)attributeValue, (String)parser.getAttributeValue(attribute));
    }

    public void testReplaceElementWithInputAndOutputAttributes() throws ParseException {
        String inputElementName = "entrada";
        String outputElementName = "saida";
        String outputAttribute = "atributo_saida";
        String outputAttributeValue = "valor_saida";
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put(inputElementName, "<" + outputElementName + " " + outputAttribute + " = '" + outputAttributeValue + "'/>");
        XmlParser parser = new XmlParser(replacementMap);
        String inputAttribute = "atributo_entrada";
        String inputAttributeValue = "valor_entrada";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<" + inputElementName + " " + inputAttribute + " = '" + inputAttributeValue + "'/>";
        parser.parseDocument((Reader)new StringReader(xml));
        parser.goToRoot();
        XmlParserTest.assertEquals((String)outputElementName, (String)parser.getElementName());
        XmlParserTest.assertEquals((String)outputAttributeValue, (String)parser.getAttributeValue(outputAttribute));
        XmlParserTest.assertEquals((String)inputAttributeValue, (String)parser.getAttributeValue(inputAttribute));
    }

    public void testReplaceElementWithInputAndOutputCommonAttributes() throws ParseException {
        String inputElementName = "entrada";
        String outputElementName = "saida";
        String attribute = "atributo_saida";
        String outputAttributeValue = "valor_saida";
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put(inputElementName, "<" + outputElementName + " " + attribute + " = '" + outputAttributeValue + "'/>");
        XmlParser parser = new XmlParser(replacementMap);
        String inputAttributeValue = "valor_entrada";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<" + inputElementName + " " + attribute + " = '" + inputAttributeValue + "'/>";
        parser.parseDocument((Reader)new StringReader(xml));
        parser.goToRoot();
        XmlParserTest.assertEquals((String)outputElementName, (String)parser.getElementName());
        XmlParserTest.assertEquals((String)inputAttributeValue, (String)parser.getAttributeValue(attribute));
    }

    public void testReplaceElementWithInputChildNodes() throws ParseException {
        String inputElementName = "entrada";
        String outputElementName = "saida";
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put(inputElementName, "<" + outputElementName + "/>");
        XmlParser parser = new XmlParser(replacementMap);
        String childElement1 = "filho_1";
        String childElement2 = "filho_2";
        String childElement3 = "filho_3";
        String grandchildElement = "neto";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<" + inputElementName + ">\n";
        xml = String.valueOf(xml) + "<" + childElement1 + "/>\n";
        xml = String.valueOf(xml) + "<" + childElement2 + "/>\n";
        xml = String.valueOf(xml) + "<" + childElement3 + ">\n";
        xml = String.valueOf(xml) + "<" + grandchildElement + "/>\n";
        xml = String.valueOf(xml) + "</" + childElement3 + ">\n";
        xml = String.valueOf(xml) + "</" + inputElementName + ">";
        parser.parseDocument((Reader)new StringReader(xml));
        parser.goToRoot();
        XmlParserTest.assertEquals((String)outputElementName, (String)parser.getElementName());
        XmlParserTest.assertTrue((boolean)parser.goToFirstChild());
        XmlParserTest.assertEquals((String)childElement1, (String)parser.getElementName());
        XmlParserTest.assertTrue((boolean)parser.goToNextSibling());
        XmlParserTest.assertEquals((String)childElement2, (String)parser.getElementName());
        XmlParserTest.assertTrue((boolean)parser.goToNextSibling());
        XmlParserTest.assertEquals((String)childElement3, (String)parser.getElementName());
        XmlParserTest.assertTrue((boolean)parser.goToFirstChild());
        XmlParserTest.assertEquals((String)grandchildElement, (String)parser.getElementName());
    }

    public void testReplaceElementWithOutputChildNodes() throws ParseException {
        String inputElementName = "entrada";
        String outputElementName = "saida";
        String childElement1 = "filho_1";
        String childElement2 = "filho_2";
        String childElement3 = "filho_3";
        String grandchildElement = "neto";
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        String outputXml = "";
        outputXml = String.valueOf(outputXml) + "<" + outputElementName + ">\n";
        outputXml = String.valueOf(outputXml) + "<" + childElement1 + "/>\n";
        outputXml = String.valueOf(outputXml) + "<" + childElement2 + "/>\n";
        outputXml = String.valueOf(outputXml) + "<" + childElement3 + ">\n";
        outputXml = String.valueOf(outputXml) + "<" + grandchildElement + "/>\n";
        outputXml = String.valueOf(outputXml) + "</" + childElement3 + ">\n";
        outputXml = String.valueOf(outputXml) + "</" + outputElementName + ">";
        replacementMap.put(inputElementName, outputXml);
        XmlParser parser = new XmlParser(replacementMap);
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>\n";
        xml = String.valueOf(xml) + "<" + inputElementName + "/>";
        parser.parseDocument((Reader)new StringReader(xml));
        parser.goToRoot();
        XmlParserTest.assertEquals((String)outputElementName, (String)parser.getElementName());
        XmlParserTest.assertTrue((boolean)parser.goToFirstChild());
        XmlParserTest.assertEquals((String)childElement1, (String)parser.getElementName());
        XmlParserTest.assertTrue((boolean)parser.goToNextSibling());
        XmlParserTest.assertEquals((String)childElement2, (String)parser.getElementName());
        XmlParserTest.assertTrue((boolean)parser.goToNextSibling());
        XmlParserTest.assertEquals((String)childElement3, (String)parser.getElementName());
        XmlParserTest.assertTrue((boolean)parser.goToFirstChild());
        XmlParserTest.assertEquals((String)grandchildElement, (String)parser.getElementName());
    }

    public void testReplaceElementNotRootElement() throws ParseException {
        String inputElementName = "entrada";
        String outputElementName = "saida";
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put(inputElementName, "<" + outputElementName + "/>");
        XmlParser parser = new XmlParser(replacementMap);
        String rootElementName = "raiz";
        String xml = "";
        xml = String.valueOf(xml) + "<?xml version='1.0' encoding='utf-8'?>";
        xml = String.valueOf(xml) + "<" + rootElementName + ">";
        xml = String.valueOf(xml) + "<" + inputElementName + "/>";
        xml = String.valueOf(xml) + "</" + rootElementName + ">";
        parser.parseDocument((Reader)new StringReader(xml));
        parser.goToRoot();
        XmlParserTest.assertEquals((String)rootElementName, (String)parser.getElementName());
        XmlParserTest.assertTrue((boolean)parser.goToFirstChild());
        XmlParserTest.assertEquals((String)outputElementName, (String)parser.getElementName());
    }
}

