/*
 * Decompiled with CFR 0.152.
 */
package csbase.servlet;

import csbase.servlet.InitServlet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;

public class InitServletTest
extends TestCase {
    private InitServlet servlet = new InitServlet();
    private MockHttpServletRequest mockRequest = new MockHttpServletRequest();

    public void testGetCommonFileUrl1() {
        this.mockRequest.setServerName("localhost");
        this.mockRequest.setServerPort(8080);
        this.mockRequest.setRequestURI("/system/init");
        String expected = "http://localhost:8080/system/index.jnlp";
        InitServletTest.assertEquals((String)expected, (String)this.servlet.getBaseFileUrl((HttpServletRequest)this.mockRequest));
    }

    public void testGetCommonFileUrl2() {
        this.mockRequest.setServerName("localhost");
        this.mockRequest.setServerPort(8080);
        this.mockRequest.setRequestURI("/system/init?page=teste.jnlp");
        String expected = "http://localhost:8080/system/teste.jnlp";
        InitServletTest.assertEquals((String)expected, (String)this.servlet.getBaseFileUrl((HttpServletRequest)this.mockRequest));
    }

    public void testCustomizeCommonFile1() {
        this.mockRequest.setServerName("localhost");
        this.mockRequest.setServerPort(8080);
        this.mockRequest.setRemoteAddr("10.0.0.0");
        this.mockRequest.setRequestURI("/system/init");
        String input = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><jnlp spec=\"1.0+\" codebase=\"http://$server_host_name$:$server_port_http$/system/lib\" ><information><title>InfoGrid</title><vendor>TECGRAF/PUC-RIO</vendor><homepage href=\"http://www.tecgraf.puc-rio.br\" /><description>Aplica\u00e7\u00e3o para prover infraestrutura de GRID ao INFOPAE</description></information><resources><j2se version=\"1.5+\" /><jar href=\"system.jar\"/><jar href=\"csbase.jar\"/></resources><application-desc main-class=\"csbase.client.kernel.Client\" ><argument>--serverUrl $server_host_name$:$server_port_rmi$</argument><argument>--clientAddress $client_address$</argument></application-desc></jnlp>";
        String expected = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><jnlp spec=\"1.0+\" codebase=\"http://localhost:8080/system/lib\" ><information><title>InfoGrid</title><vendor>TECGRAF/PUC-RIO</vendor><homepage href=\"http://www.tecgraf.puc-rio.br\" /><description>Aplica\u00e7\u00e3o para prover infraestrutura de GRID ao INFOPAE</description></information><resources><j2se version=\"1.5+\" /><jar href=\"system.jar\"/><jar href=\"csbase.jar\"/></resources><application-desc main-class=\"csbase.client.kernel.Client\" ><argument>--serverUrl localhost:1099</argument><argument>--clientAddress 10.0.0.0</argument></application-desc></jnlp>";
    }

    public void testCustomizeCommonFile2() {
        this.mockRequest.setServerName("localhost");
        this.mockRequest.setServerPort(8080);
        this.mockRequest.setRemoteAddr("10.0.0.0");
        this.mockRequest.setRequestURI("/system/init?server_host_addr=127.0.0.1&userKey=XPTO&server_port_http=8080&server_port_rmi=9999&featureX=enabled&page=teste.jnlp");
        String input = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><jnlp spec=\"1.0+\" codebase=\"http://$server_host_name$:$server_port_http$/system/jar\" ><information><title>InfoGrid</title><vendor>TECGRAF/PUC-RIO</vendor><homepage href=\"http://www.tecgraf.puc-rio.br\" /><description>Aplica\u00e7\u00e3o para prover infraestrutura de GRID ao INFOPAE</description></information><resources><j2se version=\"1.5+\" /><jar href=\"system.jar\"/><jar href=\"csbase.jar\"/></resources><application-desc main-class=\"csbase.client.kernel.Client\" ><argument>--serverUrl $server_host_addr$:$server_port_rmi$</argument><argument>--properties /local/prod/lbarros/system/system.properties</argument><argument>--clientAddress $client_address$</argument></application-desc></jnlp>";
        String expected = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><jnlp spec=\"1.0+\" codebase=\"http://localhost:8080/system/jar\" ><information><title>InfoGrid</title><vendor>TECGRAF/PUC-RIO</vendor><homepage href=\"http://www.tecgraf.puc-rio.br\" /><description>Aplica\u00e7\u00e3o para prover infraestrutura de GRID ao INFOPAE</description></information><resources><j2se version=\"1.5+\" /><jar href=\"system.jar\"/><jar href=\"csbase.jar\"/></resources><application-desc main-class=\"csbase.client.kernel.Client\" ><argument>--serverUrl 127.0.0.1:9999</argument><argument>--properties /local/prod/lbarros/system/system.properties</argument><argument>--clientAddress 10.0.0.0</argument>  <argument>--userKey XPTO</argument>\n    <argument>--featureX enabled</argument>\n  </application-desc></jnlp>";
    }

    public void testAddParam() {
        String key = "userKey";
        String value = "XPTOBLABLABLA72372505047258347508345703485";
        String input = "<jnlp><resources>...</resources><application-desc><argument>--serverUrl localhost:8080</argument></application-desc></jnlp>";
        String expected = "<jnlp><resources>...</resources><application-desc><argument>--serverUrl localhost:8080</argument>  <argument>--userKey XPTOBLABLABLA72372505047258347508345703485</argument>\n  </application-desc></jnlp>";
        InitServletTest.assertEquals((String)expected, (String)this.servlet.appendParam(key, value, input));
    }

    private class MockHttpServletRequest
    implements HttpServletRequest {
        private String serverName;
        private int serverPort;
        private String requestURI;
        private Map<String, String> parameterMap = new HashMap<String, String>(){

            @Override
            public String remove(Object key) {
                throw new UnsupportedOperationException("O mapa n\u00e3o pode ser modificado");
            }
        };
        private String remoteAddr;

        private MockHttpServletRequest() {
        }

        public String getRequestURI() {
            return this.requestURI;
        }

        public String getServerName() {
            return this.serverName;
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public String getRemoteAddr() {
            return this.remoteAddr;
        }

        public void setRequestURI(String requestURI) {
            this.requestURI = requestURI;
            String[] URITokens = requestURI.split("\\?");
            if (URITokens != null && URITokens.length > 1) {
                String paramURI = URITokens[1];
                String[] params = paramURI.split("&");
                if (params == null) {
                    return;
                }
                int i = 0;
                while (i < params.length) {
                    String[] param = params[i].split("=");
                    if (param != null && param.length == 2) {
                        String key = param[0];
                        String value = param[1];
                        this.parameterMap.put(key, value);
                    }
                    ++i;
                }
            }
        }

        public void setServerPort(int serverPort) {
            this.serverPort = serverPort;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getParameter(String key) {
            return this.parameterMap.get(key);
        }

        public Enumeration getParameterNames() {
            return new Enumeration(){
                Iterator iter;
                {
                    this.iter = MockHttpServletRequest.this.parameterMap.keySet().iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iter.hasNext();
                }

                public Object nextElement() {
                    return this.iter.next();
                }
            };
        }

        public void setRemoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
        }

        public String getAuthType() {
            return null;
        }

        public Map getParameterMap() {
            return null;
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String arg0) {
            return 0L;
        }

        public String getHeader(String arg0) {
            return null;
        }

        public Enumeration getHeaders(String arg0) {
            return null;
        }

        public Enumeration getHeaderNames() {
            return null;
        }

        public int getIntHeader(String arg0) {
            return 0;
        }

        public String getMethod() {
            return null;
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public String getRemoteUser() {
            return null;
        }

        public boolean isUserInRole(String arg0) {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getServletPath() {
            return null;
        }

        public HttpSession getSession(boolean arg0) {
            return null;
        }

        public HttpSession getSession() {
            return null;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public Object getAttribute(String arg0) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public String[] getParameterValues(String arg0) {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public void setAttribute(String arg0, Object arg1) {
        }

        public void removeAttribute(String arg0) {
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration getLocales() {
            return null;
        }

        public boolean isSecure() {
            return false;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return null;
        }

        public String getRealPath(String arg0) {
            return null;
        }
    }
}

