/*
 * Decompiled with CFR 0.152.
 */
package csbase.test.unit;

import java.io.FileInputStream;
import java.util.Properties;

public class TestConfig {
    private static Properties properties = new Properties();
    private static String propertiesFileName = null;
    public static final String TEST_CONFIG_FILE = "test/properties/test.properties";
    public static final String SERVER_PROP = "server";
    public static final String LOGIN_PROP = "user.login";
    public static final String PASSWORD_PROP = "user.password";
    public static final String SYSTEM_DIR_PROP = "system.dir";
    public static final String CSBASE_DIR_PROP = "csbase.dir";
    public static final String LOCALE_LANGUAGE_PROP = "locale.language";
    public static final String LOCALE_COUNTRY_PROP = "locale.country";
    public static final String SETUP_SLEEP_PROP = "setup.sleep";
    public static final String SERVER_DEFAULT = "localhost:1099";
    public static final String LOGIN_DEFAULT = "admin";
    public static final String PASSWORD_DEFAULT = "1234";
    public static final String SYSTEM_DIR_DEFAULT = ".";
    public static final String CSBASE_DIR_DEFAULT = "../csbase";
    public static final String LOCALE_LANGUAGE_DEFAULT = "pt";
    public static final String LOCALE_COUNTRY_DEFAULT = "BR";
    public static final int SETUP_SLEEP_DEFAULT = 18000;

    public static boolean init() {
        propertiesFileName = System.getProperty("TestConfig.propFilePath");
        if (propertiesFileName == null) {
            propertiesFileName = TEST_CONFIG_FILE;
        }
        System.out.println("Arquivo de Propriedades:" + propertiesFileName);
        return TestConfig.loadProperties();
    }

    public static String getProperty(String key) {
        if (properties == null) {
            return null;
        }
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        if (properties == null) {
            return def;
        }
        String value = properties.getProperty(key, def);
        return value;
    }

    public static int getIntProperty(String key, int def) {
        if (properties == null) {
            return def;
        }
        try {
            return Integer.parseInt(properties.getProperty(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public static float getFloatProperty(String key, float def) {
        if (properties == null) {
            return def;
        }
        try {
            return Float.parseFloat(properties.getProperty(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Integer getIntegerProperty(String key, int def) {
        if (properties == null) {
            return new Integer(def);
        }
        try {
            return Integer.decode(properties.getProperty(key));
        }
        catch (Exception e) {
            return new Integer(def);
        }
    }

    public static boolean loadProperties() {
        block3: {
            try {
                if (propertiesFileName != null) break block3;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        FileInputStream in = new FileInputStream(propertiesFileName);
        properties.load(in);
        in.close();
        return true;
    }

    public static String setProperty(String key, String propertyVal) {
        String oldVal = properties.getProperty(key);
        properties.put(key, propertyVal);
        return oldVal;
    }
}

