/*
 * Decompiled with CFR 0.152.
 */
package csbase.test.unit.service.othervm;

import csbase.test.unit.TestConfig;
import csbase.test.unit.mock.MockCSBaseClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import junit.extensions.TestSetup;
import junit.framework.Test;
import tecgraf.javautils.configurationmanager.ConfigurationManager;

public abstract class CSBaseTestSetupOVM
extends TestSetup {
    private Process serverProcess = null;
    private boolean shutDownServer = false;

    public CSBaseTestSetupOVM(Test test) {
        super(test);
    }

    protected void setUp() throws Exception {
        if (!TestConfig.init()) {
            System.out.println("Arquivo de propridades n\u00e3o encontrado. Usaremos as configura\u00e7\u00f5es padr\u00e3o.");
        }
        try {
            System.out.println("Vai inicializar o servidor CSBase ...");
            StartServer thread = new StartServer();
            thread.start();
            int sleep = TestConfig.getIntProperty("setup.sleep", 18000);
            System.out.println("Esperando " + sleep / 6000 + "s para logar no servidor...");
            Thread.sleep(sleep);
            this.login();
        }
        catch (Exception e) {
            System.out.println("Falha no setup dos testes.");
            e.printStackTrace();
        }
    }

    protected String getJarFiles(String dirPath) {
        File dir = new File(dirPath);
        StringBuffer result = new StringBuffer();
        File[] children = dir.listFiles();
        if (children == null) {
            return "";
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                if (!child.getName().equals(".svn")) {
                    if (child.isDirectory()) {
                        result.append(this.getJarFiles(child.getPath()));
                    } else if (child.getName().indexOf(".jar") > 0 || child.getName().indexOf(".zip") > 0) {
                        result.append(String.valueOf(child.getPath()) + File.pathSeparatorChar);
                    }
                }
                ++i;
            }
        }
        return result.toString();
    }

    public abstract String defineCommandLine();

    protected void tearDown() throws Exception {
        if (this.serverProcess != null) {
            this.shutDownServer = true;
            this.serverProcess.destroy();
            System.out.println("    Processo do servidor encerrado...");
        }
    }

    public void login() throws Exception {
        String systemName = "Cliente de Testes";
        String server = TestConfig.getProperty("server", "localhost:1099");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("server_url", server);
        ConfigurationManager.createInstance();
        MockCSBaseClient client = new MockCSBaseClient(systemName, params);
        if (!client.execute()) {
            System.out.println("N\u00e3o foi poss\u00edvel iniciar o cliente.");
        }
    }

    class StartServer
    extends Thread {
        StartServer() {
        }

        @Override
        public void run() {
            try {
                String runServerCommand = CSBaseTestSetupOVM.this.defineCommandLine();
                CSBaseTestSetupOVM.this.serverProcess = Runtime.getRuntime().exec(runServerCommand);
                System.out.println("Imprimindo Saida do servidor ...");
                BufferedReader in = new BufferedReader(new InputStreamReader(CSBaseTestSetupOVM.this.serverProcess.getInputStream()));
                String lineIn = null;
                while (!CSBaseTestSetupOVM.this.shutDownServer && (lineIn = in.readLine()) != null) {
                    System.out.println(lineIn);
                }
            }
            catch (IOException ioe) {
                if (!CSBaseTestSetupOVM.this.shutDownServer) {
                    System.err.println("N\u00e3o foi poss\u00edvel ler a sa\u00edda do servidor.");
                    ioe.printStackTrace();
                }
            }
            catch (Throwable e) {
                System.err.println("O servidor nao pode ser instanciado.");
                e.printStackTrace();
            }
        }
    }
}

