/*
 * $Id$
 */
package csbase.test.unit.service;

import org.junit.Before;

import junit.framework.Test;

/**
 * Esta classe representa um caso de testes no Framework CSBase.
 */
public abstract class CSBaseTestCase {

  /**
   * Construtor.
   * 
   * @param name nome para o mtodo de teste.
   */
  public CSBaseTestCase(String name) {

  }

  /**
   * Construtor.
   */
  public CSBaseTestCase() {
    super();
  }

  /**
   * Retorna a coleo dos testes para o junit executar. As classes que estem
   * esta, devem se adicionar ao suite. Por exemplo: TestSuite suite = new
   * TestSuite(); suite.addTestSuite(this.getClass()); return new
   * CSBaseTestSetup(suite);
   * 
   * @return a coleo dos testes
   */
  public abstract Test suite();

  /**
   * 
   */
  @Before
  public void setUp() throws Exception {
    initService();
  }

  /**
   * Metodo que conter a inicializacao do servico que  singleton. Este metodo
   * precisa lancar uma excecao remote pois o getInstance do servico de login
   * lanca esta excecao.
   * 
   * @throws Exception
   */
  public abstract void initService() throws Exception;
}
