/*
 * $Id: FileConfigConverter.java 110728 2010-09-30 17:07:35Z clinio $
 */
package csbase.tools;

import java.io.File;

/**
 * Conversor de x.csbase(_description) para .x.csbase(_description)
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileConfigConverter {

  /**
   * MODO DE TESTES...
   */
  private static boolean TEST_MODE = false;

  /**
   * VERBOSE
   */
  private static boolean VERBOSE_MODE = true;

  /**
   * Imprime texto se em modo verbose
   * 
   * @param msg mensagem
   */
  static private void verbose(final String msg) {
    if (VERBOSE_MODE) {
      System.out.println(msg);
    }
  }

  /**
   * Entrada do programa
   * 
   * @param args diretrios a serem verificados.
   */
  static public void main(String[] args) {
    String dirPath = null;
    for (final String arg : args) {
      if (arg.equals("-t")) {
        TEST_MODE = true;
      }
      else if (arg.equals("-v")) {
        VERBOSE_MODE = true;
      }
      else {
        dirPath = arg;
      }
    }
    if (dirPath == null) {
      System.out.println("No foi especificado um diretrio!\n\n");
      System.out
        .println("Uso: java csbase.server.services.projectservice.TmpConverter [-t] [-v] <diretrio>");
      System.out.println("   -t -> modo de testes (no faz \"renames\") ");
      System.out.println("   -v -> modo verbose");
      return;
    }
    substitutePath(dirPath);
  }

  /**
   * Substi
   * 
   * @param dirPath path do diretrio
   */
  private static void substitutePath(final String dirPath) {
    System.out.println("# Analisando diretrio [" + dirPath + "]...");
    final File file = new File(dirPath);
    if (!file.exists()) {
      System.out.println("   [ERRO] Diretrio [" + file + "] no existe");
      return;
    }
    if (!file.isDirectory()) {
      System.out.println("   [ERRO] [" + file + "] no  diretrio");
      return;
    }
    substituteFile(file);
  }

  /**
   * Faz replacement
   * 
   * @param file arquivo/diretrio
   */
  private static void substituteFile(final File file) {
    if (!file.exists()) {
      return;
    }
    if (file.isDirectory()) {
      final File[] children = file.listFiles();
      for (File f : children) {
        substituteFile(f);
      }
    }
    else {
      final String fileName = file.getName();
      if (looksNewFormat(fileName)) {
        final String path = file.getAbsolutePath();
        final String msg =
          "   [NO MEXI] Arquivo j aparenta novo formato: " + path;
        verbose(msg);
      }
      else if (looksOldFormat(fileName)) {
        final String newFileName = "." + fileName;
        final File newFile = new File(file.getParent(), newFileName);
        if (newFile.exists()) {
          final String path = newFile.getAbsolutePath();
          final String msg = "   [SOBREESCREVI] Arquivo j existente: " + path;
          verbose(msg);
        }
        if (!TEST_MODE) {
          file.renameTo(newFile);
          final String pth1 = file.getAbsolutePath();
          final String pth2 = newFile.getAbsolutePath();
          final String msg = " **[MV] ==> " + pth1 + " -> " + pth2;
          verbose(msg);
        }
        else {
          final String pth1 = file.getAbsolutePath();
          final String pth2 = newFile.getAbsolutePath();
          final String msg = "   [SIMULAO-MV] " + pth1 + " ==> " + pth2;
          verbose(msg);
        }
      }
    }
  }

  /**
   * Verifica se nome est no formato antigo
   * 
   * @param fileName nome do arquivo
   * @return indicativo de formato antigo
   */
  private static boolean looksOldFormat(String fileName) {
    final boolean cs = fileName.endsWith(".csbase");
    final boolean csb = fileName.endsWith(".csbase_description");
    final boolean pt = fileName.startsWith(".");
    return (!pt && (cs || csb));
  }

  /**
   * Verifica se nome est no formato novo
   * 
   * @param fileName nome do arquivo
   * @return indicativo de formato novo
   */
  private static boolean looksNewFormat(final String fileName) {
    final boolean cs = fileName.endsWith(".csbase");
    final boolean csb = fileName.endsWith(".csbase_description");
    final boolean pt = fileName.startsWith(".");
    return (pt && (cs || csb));
  }
}
