package csbase.util.proxy;

import java.rmi.Remote;

/**
 * Interface remota criada para permitir que o {@link RMIInvocationHandlerImpl}
 * seja exportvel via RMI.
 * 
 * @author Tecgraf
 */
public interface RMIInvocationHandler extends Remote {
  /**
   * Mtodo responsvel por executar uma chamada em um determinado mtodo com os
   * dados parmetros.
   * 
   * @param methodName Nome do mtodo a ser executado.
   * @param parameterTypes Tipo dos parmetros do mtodo.
   * @param params Parmetros a serem passados para o mtodo.
   * 
   * @return O retorno da chamada.
   * 
   * @throws Throwable Se ocorreu algum erro durante a invoao do mtodo.
   */
  public Object invoke(String methodName, Class<?>[] parameterTypes,
    Object[] params) throws Throwable;
}
