/*
 * Decompiled with CFR 0.152.
 */
package validations;

import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectPermissions;
import csbase.util.FileSystemUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.core.io.FileUtils;
import validations.AbstractValidation;
import validations.ValidationException;
import validations.util.ValidatorUtils;

public class PrjPermsValidation
extends AbstractValidation {
    private static final String CONTROL_FILE_SUFFIX = ".csbase_project_info";
    private static final String IDENT1 = "    ";
    private static final String IDENT2 = "        ";
    private static final String OLD_IS_PUBLIC_KEY = "IS_PUBLIC";
    private static final String OLD_IS_READ_ONLY_KEY = "IS_READ_ONLY";
    private static final String OLD_USERS_KEY = "USERS";
    private File baseProjectDir;

    private boolean validateUserDir(File userDir) throws ValidationException {
        File[] cfgFiles = this.getProjectControlFilesForUser(userDir);
        if (cfgFiles == null || cfgFiles.length == 0) {
            String path = userDir.getAbsolutePath();
            this.logger.fine("Nada encontrado para validar em:" + path);
            return true;
        }
        boolean result = true;
        for (File cfgFile : cfgFiles) {
            String prjName = this.getPrjNameFromCfgFile(cfgFile);
            try {
                if (this.validate(cfgFile)) {
                    this.logger.fine(String.format("    %s ... OK", prjName));
                    continue;
                }
                this.logger.fine(String.format("    %s ... CONVERTER", prjName));
                result = false;
            }
            catch (IOException e) {
                String err = String.format("Erro lendo configura\u00e7\u00e3o: %s", prjName);
                throw new ValidationException(err, e);
            }
        }
        return result;
    }

    private boolean processUserDir(File userDir) {
        File[] cfgFiles = this.getProjectControlFilesForUser(userDir);
        if (cfgFiles == null || cfgFiles.length == 0) {
            String path = userDir.getAbsolutePath();
            this.logger.fine("Nada encontrado para processar em:" + path);
            return true;
        }
        int converted = 0;
        int alreadyConverted = 0;
        boolean succeeded = true;
        for (File cfgFile : cfgFiles) {
            String prjName = this.getPrjNameFromCfgFile(cfgFile);
            try {
                if (this.validate(cfgFile)) {
                    ++alreadyConverted;
                    continue;
                }
                ++converted;
                this.logger.fine(String.format("    projeto '%s'", prjName));
                if (this.fixPerms(cfgFile)) continue;
                succeeded = false;
            }
            catch (ValidationException e) {
                this.logger.exception("Erro validando configura\u00e7\u00e3o do projeto " + prjName, e);
                succeeded = false;
            }
            catch (IOException e) {
                this.logger.exception("Erro convertendo configura\u00e7\u00e3o do projeto" + prjName, e);
                succeeded = false;
            }
            break;
        }
        String msgPrefix = String.format("Usu\u00e1rio %10s :", userDir.getName());
        int count = succeeded ? alreadyConverted + converted : converted;
        this.logger.fine(String.format("%s %d de %d projetos convertidos", msgPrefix, count, cfgFiles.length));
        return succeeded;
    }

    private File[] getProjectControlFilesForUser(File userDir) {
        File[] cfgFiles = userDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean isFile = pathname.isFile();
                String name = pathname.getName();
                return isFile && name.endsWith(PrjPermsValidation.CONTROL_FILE_SUFFIX);
            }
        });
        return cfgFiles;
    }

    private String getPrjNameFromCfgFile(File cfgFile) {
        String cfgFileName = cfgFile.getName();
        return cfgFileName.substring(0, cfgFileName.lastIndexOf(46));
    }

    private boolean validate(File cfgFile) throws IOException, ValidationException {
        CommonProjectInfo info = this.readProjectInfo(cfgFile);
        if (info == null) {
            throw new ValidationException(String.format("erro processando configura\u00e7\u00e3o do projeto '%s'", this.getPrjNameFromCfgFile(cfgFile)));
        }
        try {
            ProjectPermissions.getSharingType((CommonProjectInfo)info);
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    private boolean fixPerms(File cfgFile) throws IOException {
        CommonProjectInfo info = this.readProjectInfo(cfgFile);
        if (info == null) {
            this.logger.severe("erro obtendo informacoes do projeto");
            return false;
        }
        if (this.fixPerms(info)) {
            return this.writeProjectInfo(cfgFile, info);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeProjectInfo(File cfgFile, CommonProjectInfo info) throws IOException {
        this.logger.fine("    gravando informacoes do projeto");
        boolean success = true;
        try (ObjectOutputStream out = null;){
            out = new ObjectOutputStream(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cfgFile))));
            out.writeObject(info);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonProjectInfo readProjectInfo(File cfgFile) throws IOException {
        CommonProjectInfo info;
        ObjectInputStream in = null;
        if (cfgFile.length() <= 0L) {
            String path = cfgFile.getAbsolutePath();
            String err = "Detectado arquivo de configura\u00e7\u00e3o zerado: " + path;
            throw new IOException(err);
        }
        try {
            in = new ObjectInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(cfgFile))));
            info = (CommonProjectInfo)in.readObject();
        }
        catch (ClassNotFoundException e) {
            this.logger.exception(e);
            CommonProjectInfo commonProjectInfo = null;
            return commonProjectInfo;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return info;
    }

    private boolean fixPerms(CommonProjectInfo info) {
        ProjectPermissions.SharingType sharing;
        try {
            if (ProjectPermissions.getSharingType((CommonProjectInfo)info) != null) {
                this.logger.fine("projeto j\u00e1 convertido");
                return false;
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Boolean isPublic = (Boolean)this.getAttribute(info, OLD_IS_PUBLIC_KEY);
        isPublic = isPublic == null ? Boolean.FALSE : isPublic;
        this.logger.fine("        IS_PUBLIC = " + isPublic);
        Boolean isRO = (Boolean)this.getAttribute(info, OLD_IS_READ_ONLY_KEY);
        isRO = isRO == null ? Boolean.FALSE : isRO;
        this.logger.fine("        IS_READ_ONLY = " + isRO);
        Object[] users = (Object[])this.getAttribute(info, OLD_USERS_KEY);
        if (isPublic.booleanValue()) {
            sharing = isRO != false ? ProjectPermissions.SharingType.ALL_RO : ProjectPermissions.SharingType.ALL_RW;
        } else if (users == null) {
            sharing = ProjectPermissions.SharingType.PRIVATE;
        } else {
            this.logger.fine("        USERS = " + Arrays.toString(users));
            sharing = ProjectPermissions.SharingType.PARTIAL;
            List<Object> usersList = Arrays.asList(users);
            if (isRO.booleanValue()) {
                this.setUsers(info, usersList, true);
                this.setUsers(info, new ArrayList<Object>(), false);
            } else {
                this.setUsers(info, usersList, false);
                this.setUsers(info, new ArrayList<Object>(), true);
            }
            this.removeAttribute(info, OLD_USERS_KEY);
        }
        this.removeAttribute(info, OLD_IS_PUBLIC_KEY);
        this.removeAttribute(info, OLD_IS_READ_ONLY_KEY);
        this.setSharingType(info, sharing);
        return true;
    }

    private Object getAttribute(CommonProjectInfo info, String attr) {
        return info.getAttribute(attr);
    }

    private void removeAttribute(CommonProjectInfo info, String attr) {
        this.logger.fine("        - removendo atributo " + attr);
        info.getAttributes().remove(attr);
    }

    @Override
    protected boolean init() {
        this.baseProjectDir = this.getProjectDir();
        return this.baseProjectDir != null;
    }

    @Override
    protected boolean validate() throws ValidationException {
        File[] usersProjects = FileSystemUtils.getSubDirs((File)this.baseProjectDir);
        if (usersProjects == null || usersProjects.length == 0) {
            String path = this.baseProjectDir.getAbsolutePath();
            this.logger.fine("Nada a validar em: " + path);
            return true;
        }
        for (File userPrj : usersProjects) {
            this.logger.fine("Verificando projetos de " + userPrj.getName());
            if (this.validateUserDir(userPrj)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean applyPatch() {
        File[] usersProjects = FileSystemUtils.getSubDirs((File)this.baseProjectDir);
        if (usersProjects == null || usersProjects.length == 0) {
            String path = this.baseProjectDir.getAbsolutePath();
            this.logger.fine("Nada a converter em: " + path);
            return true;
        }
        for (File userPrj : usersProjects) {
            this.logger.fine("Convertendo projetos de " + userPrj.getName());
            if (this.processUserDir(userPrj)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void finish() {
    }

    private void setSharingType(CommonProjectInfo prjInfo, ProjectPermissions.SharingType type) {
        this.logger.fine("        + compartilhamento = " + type.toString());
        ProjectPermissions.setSharingType((CommonProjectInfo)prjInfo, (ProjectPermissions.SharingType)type);
    }

    private void setUsers(CommonProjectInfo prjInfo, List<Object> users, boolean readOnly) {
        this.logger.fine(String.format("%s+ usuarios %s = %s", IDENT2, readOnly ? "RO" : "RW", users));
        ProjectPermissions.setUsers((CommonProjectInfo)prjInfo, new HashSet<Object>(users), (boolean)readOnly);
    }

    @Override
    protected String getStartMessage() {
        return "Convertendo permiss\u00f5es de compartilhamento dos projetos";
    }

    @Override
    protected void getSpecificFailureMessage(AbstractValidation.Status status, List<String> errors) {
        switch (status) {
            case VALIDATION_FAILED: {
                errors.add("*** EXISTEM PROJETOS NO FORMATO ANTIGO");
                break;
            }
            case PATCH_FAILED: {
                errors.add("*** A CONVERS\u00c3O DE UM OU MAIS PROJETOS RESULTOU EM ERRO");
                break;
            }
            case INIT_FAILED: {
                errors.add("*** FALHA NA INICIALIZA\u00c7\u00c3O");
                break;
            }
            default: {
                errors.add("ESTADO INV\u00c1LIDO: " + status.toString());
            }
        }
    }

    @Override
    protected String getSuccessMessage(AbstractValidation.Status status) {
        switch (status) {
            case VALIDATION_OK: {
                return "*** TODOS OS PROJETOS ENCONTRAM-SE NO NOVO FORMATO";
            }
            case PATCH_OK: {
                return "*** TODOS OS PROJETOS FORAM CONVERTIDOS COM SUCESSO";
            }
        }
        return "ESTADO INV\u00c1LIDO: " + status.toString();
    }

    @Override
    protected boolean backupData() {
        File[] usersDirs = FileSystemUtils.getSubDirs((File)this.baseProjectDir);
        if (usersDirs == null || usersDirs.length == 0) {
            String path = this.baseProjectDir.getAbsolutePath();
            this.logger.fine("Nada a fazer backup em: " + path);
            return true;
        }
        for (File userDir : usersDirs) {
            String userBackupDirPath = this.getBackupDirPath() + File.separatorChar + userDir.getName();
            File userBackupDir = new File(userBackupDirPath);
            if (!userBackupDir.exists() && !userBackupDir.mkdir()) {
                this.logger.severe("erro criando diret\u00f3rio de backup para o usu\u00e1rio " + userDir.getName());
                return false;
            }
            File[] controlFiles = this.getProjectControlFilesForUser(userDir);
            if (controlFiles == null || controlFiles.length == 0) {
                throw new RuntimeException("Erro interno: control-files! (backup)");
            }
            try {
                for (File ctrlFile : controlFiles) {
                    if (this.validate(ctrlFile) || ValidatorUtils.copyFile(ctrlFile, userBackupDir, this.logger, true)) continue;
                    this.logger.severe(String.format("erro fazendo backup do arquivo %s do usu\u00e1rio %s", ctrlFile.getName(), userDir.getName()));
                    return false;
                }
            }
            catch (Exception e) {
                this.logger.exception(e);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean restoreBackup() {
        File backupDir = new File(this.getBackupDirPath());
        File[] usersBkpDirs = FileSystemUtils.getSubDirs((File)backupDir);
        if (usersBkpDirs == null || usersBkpDirs.length == 0) {
            String path = backupDir.getAbsolutePath();
            this.logger.fine("Nada a restaurar backup em: " + path);
            return true;
        }
        Map<String, File> usersDirsMap = ValidatorUtils.getSubdirsMap(this.baseProjectDir);
        for (File usersBkpDir : usersBkpDirs) {
            File[] bkpControlFiles = this.getProjectControlFilesForUser(usersBkpDir);
            if (bkpControlFiles == null || bkpControlFiles.length == 0) {
                throw new RuntimeException("Erro interno: control-files (restore)!");
            }
            String dirName = usersBkpDir.getName();
            File userDir = usersDirsMap.get(dirName);
            if (userDir == null) {
                this.logger.severe("Diret\u00f3rio do usu\u00e1rio: " + dirName + " n\u00e3o existe");
                return false;
            }
            if (!ValidatorUtils.copyFiles(bkpControlFiles, userDir, this.logger, false)) {
                return false;
            }
            this.logger.info(String.format("%sUsu\u00e1rio %10s : arquivos restaurados com sucesso", IDENT1, dirName));
            FileUtils.delete((File)usersBkpDir);
        }
        return true;
    }

    @Override
    protected boolean runsOnlyOnce() {
        return true;
    }
}

