/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;

public class BeanPropertyComponentAdapter
extends DecoratingComponentAdapter {
    private Map properties;
    private transient Map setters = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$Class;

    public BeanPropertyComponentAdapter(ComponentAdapter componentAdapter) throws PicoInitializationException {
        super(componentAdapter);
    }

    public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object object = super.getComponentInstance(picoContainer);
        if (this.setters == null) {
            this.setters = this.getSetters(this.getComponentImplementation());
        }
        if (this.properties != null) {
            ComponentMonitor componentMonitor = this.currentMonitor();
            Set set = this.properties.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this.properties.get(string);
                Method method = (Method)this.setters.get(string);
                Object object2 = this.getSetterParameter(string, v, object, picoContainer);
                try {
                    componentMonitor.invoking(method, object);
                    long l = System.currentTimeMillis();
                    method.invoke(object, object2);
                    componentMonitor.invoked(method, object, System.currentTimeMillis() - l);
                }
                catch (Exception exception) {
                    componentMonitor.invocationFailed(method, object, exception);
                    throw new PicoInitializationException("Failed to set property " + string + " to " + v + ": " + exception.getMessage(), exception);
                }
            }
        }
        return object;
    }

    private Map getSetters(Class clazz) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        Method[] methodArray = this.getMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!this.isSetter(method)) continue;
            hashMap.put(this.getPropertyName(method), method);
        }
        return hashMap;
    }

    private Method[] getMethods(final Class clazz) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getMethods();
            }
        });
    }

    private String getPropertyName(Method method) {
        String string = method.getName();
        String string2 = string.substring(3);
        if (string2.length() > 1 && !Character.isUpperCase(string2.charAt(1))) {
            string2 = "" + Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
        } else if (string2.length() == 1) {
            string2 = string2.toLowerCase();
        }
        return string2;
    }

    private boolean isSetter(Method method) {
        String string = method.getName();
        return string.length() > 3 && string.startsWith("set") && method.getParameterTypes().length == 1;
    }

    private Object convertType(PicoContainer picoContainer, Method method, String string) throws ClassNotFoundException {
        Object object;
        if (string == null) {
            return null;
        }
        Class<?> clazz = method.getParameterTypes()[0];
        String string2 = clazz.getName();
        Object object2 = BeanPropertyComponentAdapter.convert(string2, string, Thread.currentThread().getContextClassLoader());
        if (object2 == null && picoContainer != null && (object = picoContainer.getComponentInstance(string)) != null && clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        return object2;
    }

    public static Object convert(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        if (string.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanPropertyComponentAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName()) || string.equals(Boolean.TYPE.getName())) {
            return Boolean.valueOf(string2);
        }
        if (string.equals((class$java$lang$Byte == null ? (class$java$lang$Byte = BeanPropertyComponentAdapter.class$("java.lang.Byte")) : class$java$lang$Byte).getName()) || string.equals(Byte.TYPE.getName())) {
            return Byte.valueOf(string2);
        }
        if (string.equals((class$java$lang$Short == null ? (class$java$lang$Short = BeanPropertyComponentAdapter.class$("java.lang.Short")) : class$java$lang$Short).getName()) || string.equals(Short.TYPE.getName())) {
            return Short.valueOf(string2);
        }
        if (string.equals((class$java$lang$Integer == null ? (class$java$lang$Integer = BeanPropertyComponentAdapter.class$("java.lang.Integer")) : class$java$lang$Integer).getName()) || string.equals(Integer.TYPE.getName())) {
            return Integer.valueOf(string2);
        }
        if (string.equals((class$java$lang$Long == null ? (class$java$lang$Long = BeanPropertyComponentAdapter.class$("java.lang.Long")) : class$java$lang$Long).getName()) || string.equals(Long.TYPE.getName())) {
            return Long.valueOf(string2);
        }
        if (string.equals((class$java$lang$Float == null ? (class$java$lang$Float = BeanPropertyComponentAdapter.class$("java.lang.Float")) : class$java$lang$Float).getName()) || string.equals(Float.TYPE.getName())) {
            return Float.valueOf(string2);
        }
        if (string.equals((class$java$lang$Double == null ? (class$java$lang$Double = BeanPropertyComponentAdapter.class$("java.lang.Double")) : class$java$lang$Double).getName()) || string.equals(Double.TYPE.getName())) {
            return Double.valueOf(string2);
        }
        if (string.equals((class$java$lang$Character == null ? (class$java$lang$Character = BeanPropertyComponentAdapter.class$("java.lang.Character")) : class$java$lang$Character).getName()) || string.equals(Character.TYPE.getName())) {
            return new Character(string2.toCharArray()[0]);
        }
        if (string.equals((class$java$lang$String == null ? (class$java$lang$String = BeanPropertyComponentAdapter.class$("java.lang.String")) : class$java$lang$String).getName()) || string.equals("string")) {
            return string2;
        }
        if (string.equals((class$java$io$File == null ? (class$java$io$File = BeanPropertyComponentAdapter.class$("java.io.File")) : class$java$io$File).getName()) || string.equals("file")) {
            return new File(string2);
        }
        if (string.equals((class$java$net$URL == null ? (class$java$net$URL = BeanPropertyComponentAdapter.class$("java.net.URL")) : class$java$net$URL).getName()) || string.equals("url")) {
            try {
                return new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new PicoInitializationException(malformedURLException);
            }
        }
        if (string.equals((class$java$lang$Class == null ? (class$java$lang$Class = BeanPropertyComponentAdapter.class$("java.lang.Class")) : class$java$lang$Class).getName()) || string.equals("class")) {
            return classLoader.loadClass(string2);
        }
        Class<?> clazz = classLoader.loadClass(string);
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
        if (propertyEditor != null) {
            propertyEditor.setAsText(string2);
            return propertyEditor.getValue();
        }
        return null;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    private Object getSetterParameter(String string, Object object, Object object2, PicoContainer picoContainer) throws PicoInitializationException, ClassCastException {
        if (object == null) {
            return null;
        }
        Method method = (Method)this.setters.get(string);
        Class<?> clazz = method.getParameterTypes()[0];
        Object object3 = null;
        Class<?> clazz2 = object.getClass();
        try {
            object3 = this.convertType(picoContainer, method, object.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PicoInvocationTargetInitializationException(classNotFoundException);
        }
        if (object3 == null) {
            if (clazz.isAssignableFrom(clazz2)) {
                object3 = object;
            } else {
                throw new ClassCastException("Setter: " + method.getName() + " for component: " + object2.toString() + " can only take objects of: " + clazz.getName() + " instead got: " + clazz2.getName());
            }
        }
        return object3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

