/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.Value;
import org.jacorb.idl.parser;

public class ValueBoxDecl
extends Value {
    private boolean written = false;
    private boolean parsed = false;
    TypeSpec typeSpec;

    public ValueBoxDecl(int num) {
        super(num);
        this.pack_name = "";
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public TypeDeclaration declaration() {
        return this;
    }

    @Override
    public String typeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        if (this.typeSpec.typeSpec() instanceof BaseType) {
            return this.typeName;
        }
        return this.unwindTypedefs(this.typeSpec).typeName();
    }

    public String boxTypeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    @Override
    public boolean basic() {
        return false;
    }

    @Override
    public void set_included(boolean i) {
        this.included = i;
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.typeSpec.setPackage(s);
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            parser.logger.log(Level.SEVERE, "was " + this.enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public void parse() {
        if (this.parsed) {
            throw new RuntimeException("Compiler error: Value box already parsed!");
        }
        this.escapeName();
        this.typeSpec.parse();
        try {
            ConstrTypeSpec ctspec = new ConstrTypeSpec(ValueBoxDecl.new_num());
            ctspec.c_type_spec = this;
            NameTable.define(this.full_name(), IDLTypes.TYPE);
            TypeMap.typedef(this.full_name(), ctspec);
        }
        catch (NameAlreadyDefined nad) {
            parser.error("Value box " + this.typeName() + " already defined", this.token);
        }
        this.parsed = true;
    }

    public String className() {
        String fullName = this.typeName();
        if (fullName.indexOf(46) > 0) {
            return fullName.substring(fullName.lastIndexOf(46) + 1);
        }
        return fullName;
    }

    @Override
    public String printReadExpression(String streamname) {
        return "(" + this.typeName() + ")((org.omg.CORBA_2_3.portable.InputStream)" + streamname + ").read_value (new " + this.helperName() + "())";
    }

    @Override
    public String printWriteStatement(String var_name, String streamname) {
        return "((org.omg.CORBA_2_3.portable.OutputStream)" + streamname + ").write_value (" + var_name + ", new " + this.helperName() + "());";
    }

    @Override
    public String holderName() {
        return this.boxTypeName() + "Holder";
    }

    @Override
    public String helperName() {
        return this.boxTypeName() + "Helper";
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        knownTypes.add(this);
        StringBuffer sb = new StringBuffer();
        String className = this.boxTypeName();
        if (className.indexOf(46) > 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        sb.append("org.omg.CORBA.ORB.init().create_value_box_tc(" + this.helperName() + ".id(),\"" + className + "\"," + this.typeSpec.typeSpec().getTypeCodeExpression(knownTypes) + ")");
        return sb.toString();
    }

    @Override
    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    private void printHolderClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + this.typeName() + " value;" + Environment.NL);
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder (final " + this.typeName() + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.helperName() + ".type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + this.helperName() + ".read (_in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream _out)");
        ps.println("\t{");
        ps.println("\t\t" + this.helperName() + ".write (_out,value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        ps.println("public" + parser.getFinalString() + " class " + className + "Helper");
        ps.println("\timplements org.omg.CORBA.portable.BoxedValueHelper");
        ps.println("{");
        ps.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        String type = this.typeName();
        ps.println("\tpublic static org.omg.CORBA.TypeCode type()");
        ps.println("\t{");
        ps.println("\t\treturn _type;");
        ps.println("\t}");
        ps.println();
        ps.println("\tpublic static void insert (final org.omg.CORBA.Any any, final " + type + " s)");
        ps.println("\t{");
        ps.println("\t\tany.insert_Value(s, type());");
        ps.println("\t}" + Environment.NL);
        ps.println("\tpublic static " + type + " extract (final org.omg.CORBA.Any any)");
        ps.println("\t{");
        ps.println("\t\treturn (" + type + ") any.extract_Value();");
        ps.println("\t}" + Environment.NL);
        this.printIdMethod(ps);
        ps.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        if (this.typeSpec.typeSpec() instanceof BaseType) {
            ps.println("\t\t" + type + " result = new " + type + "(" + this.typeSpec.typeSpec().printReadExpression("in") + ");");
        } else {
            ps.println("\t\t" + type + " result;");
            ps.println("\t\t" + this.typeSpec.typeSpec().printReadStatement("result", "in"));
        }
        ps.println("\t\treturn result;");
        ps.println("\t}");
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + type + " s)");
        ps.println("\t{");
        if (this.typeSpec.typeSpec() instanceof BaseType) {
            ps.println("\t\t" + this.typeSpec.typeSpec().printWriteStatement("s.value", "out"));
        } else {
            ps.println("\t\t" + this.typeSpec.typeSpec().printWriteStatement("s", "out"));
        }
        ps.println("\t}");
        ps.println("\tpublic java.io.Serializable read_value (final org.omg.CORBA.portable.InputStream is)");
        ps.println("\t{");
        ps.println("\t\treturn " + this.helperName() + ".read (is);");
        ps.println("\t}");
        ps.println("\tpublic void write_value (final org.omg.CORBA.portable.OutputStream os, final java.io.Serializable value)");
        ps.println("\t{");
        ps.println("\t\t" + this.helperName() + ".write (os, (" + type + ")value);");
        ps.println("\t}");
        ps.println("\tpublic java.lang.String get_id()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.helperName() + ".id();");
        ps.println("\t}");
        ps.println("}");
    }

    private void printValueClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        ps.println("public class " + className);
        ps.println("\timplements org.omg.CORBA.portable.ValueBase");
        ps.println("{");
        this.printSerialVersionUID(ps);
        ps.println("\tpublic " + this.typeSpec.typeName() + " value;");
        ps.println("\tprivate static String[] _ids = { " + className + "Helper.id() };");
        ps.println("\tpublic " + className + "(" + this.typeSpec.typeName() + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic String[] _truncatable_ids()");
        ps.println("\t{");
        ps.println("\t\treturn _ids;");
        ps.println("\t}");
        ps.println("}");
    }

    @Override
    public void print(PrintWriter ps) {
        this.setPrintPhaseNames();
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (!this.written) {
            try {
                PrintWriter decl_ps;
                String path;
                File dir;
                String className = this.boxTypeName();
                if (className.indexOf(46) > 0) {
                    className = className.substring(className.lastIndexOf(46) + 1);
                }
                if (!(dir = new File(path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator))).exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                String fname = className + ".java";
                File f = new File(dir, fname);
                if (this.typeSpec.typeSpec() instanceof BaseType && GlobalInputStream.isMoreRecentThan(f)) {
                    decl_ps = new PrintWriter(new FileWriter(f));
                    this.printValueClass(className, decl_ps);
                    decl_ps.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Holder.java"))) {
                    decl_ps = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, decl_ps);
                    decl_ps.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                    decl_ps = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, decl_ps);
                    decl_ps.close();
                }
                this.written = true;
            }
            catch (IOException i) {
                throw new RuntimeException("File IO error" + i);
            }
        }
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + ".type(" + this.getTypeCodeExpression() + ");");
        ps.println("\t\t" + this.helperName() + ".write(" + anyname + ".create_output_stream()," + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = (" + resulttype + ")" + anyname + ".extract_Value();");
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitValue(this);
    }

    private TypeSpec unwindTypedefs(TypeSpec typedef) {
        TypeSpec spec = typedef.typeSpec();
        TypeSpec typeSpec2 = spec.typeSpec();
        if (typeSpec2 instanceof ScopedName) {
            ScopedName scopedName = (ScopedName)typeSpec2;
            TypeSpec resolvedTSpec = scopedName.resolvedTypeSpec();
            while (resolvedTSpec instanceof AliasTypeSpec) {
                resolvedTSpec = ((AliasTypeSpec)resolvedTSpec).originalType();
            }
            return resolvedTSpec;
        }
        return typedef;
    }
}

