/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.BasicComponentParameter;
import org.picocontainer.defaults.CollectionComponentParameter;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ComponentParameter
extends BasicComponentParameter {
    public static final ComponentParameter DEFAULT = new ComponentParameter();
    public static final ComponentParameter ARRAY = new ComponentParameter(false);
    public static final ComponentParameter ARRAY_ALLOW_EMPTY = new ComponentParameter(true);
    private final Parameter collectionParameter;

    public ComponentParameter(Object object) {
        this(object, null);
    }

    public ComponentParameter() {
        this(false);
    }

    public ComponentParameter(boolean bl) {
        this(null, bl ? CollectionComponentParameter.ARRAY_ALLOW_EMPTY : CollectionComponentParameter.ARRAY);
    }

    public ComponentParameter(Class clazz, boolean bl) {
        this(null, new CollectionComponentParameter(clazz, bl));
    }

    public ComponentParameter(Class clazz, Class clazz2, boolean bl) {
        this(null, new CollectionComponentParameter(clazz, clazz2, bl));
    }

    private ComponentParameter(Object object, Parameter parameter) {
        super(object);
        this.collectionParameter = parameter;
    }

    public Object resolveInstance(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        Object object = super.resolveInstance(picoContainer, componentAdapter, clazz);
        if (object == null && this.collectionParameter != null) {
            object = this.collectionParameter.resolveInstance(picoContainer, componentAdapter, clazz);
        }
        return object;
    }

    public boolean isResolvable(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        if (!super.isResolvable(picoContainer, componentAdapter, clazz)) {
            if (this.collectionParameter != null) {
                return this.collectionParameter.isResolvable(picoContainer, componentAdapter, clazz);
            }
            return false;
        }
        return true;
    }

    public void verify(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        try {
            super.verify(picoContainer, componentAdapter, clazz);
        }
        catch (UnsatisfiableDependenciesException unsatisfiableDependenciesException) {
            if (this.collectionParameter != null) {
                this.collectionParameter.verify(picoContainer, componentAdapter, clazz);
                return;
            }
            throw unsatisfiableDependenciesException;
        }
    }

    public void accept(PicoVisitor picoVisitor) {
        super.accept(picoVisitor);
        if (this.collectionParameter != null) {
            this.collectionParameter.accept(picoVisitor);
        }
    }
}

