/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import org.picocontainer.LifecycleManager;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.monitors.DefaultComponentMonitor;

public class InstanceComponentAdapter
extends AbstractComponentAdapter
implements LifecycleManager,
LifecycleStrategy {
    private Object componentInstance;
    private LifecycleStrategy lifecycleStrategy;

    public InstanceComponentAdapter(Object object, Object object2) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(object, object2, new DefaultLifecycleStrategy(new DefaultComponentMonitor()));
    }

    public InstanceComponentAdapter(Object object, Object object2, LifecycleStrategy lifecycleStrategy) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(object, InstanceComponentAdapter.getInstanceClass(object2));
        this.componentInstance = object2;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    private static Class getInstanceClass(Object object) {
        if (object == null) {
            throw new NullPointerException("componentInstance cannot be null");
        }
        return object.getClass();
    }

    public Object getComponentInstance(PicoContainer picoContainer) {
        return this.componentInstance;
    }

    public void verify(PicoContainer picoContainer) {
    }

    public void start(PicoContainer picoContainer) {
        this.start(this.componentInstance);
    }

    public void stop(PicoContainer picoContainer) {
        this.stop(this.componentInstance);
    }

    public void dispose(PicoContainer picoContainer) {
        this.dispose(this.componentInstance);
    }

    public boolean hasLifecycle() {
        return this.hasLifecycle(this.componentInstance.getClass());
    }

    public void start(Object object) {
        this.lifecycleStrategy.start(this.componentInstance);
    }

    public void stop(Object object) {
        this.lifecycleStrategy.stop(this.componentInstance);
    }

    public void dispose(Object object) {
        this.lifecycleStrategy.dispose(this.componentInstance);
    }

    public boolean hasLifecycle(Class clazz) {
        return this.lifecycleStrategy.hasLifecycle(clazz);
    }
}

