/*
 * Decompiled with CFR 0.152.
 */
package csfs.remote;

import csfs.remote.FieldSequenceHelper;
import csfs.remote.FileAlreadyExistsException;
import csfs.remote.FileAlreadyExistsExceptionHelper;
import csfs.remote.FileInUseException;
import csfs.remote.FileInUseExceptionHelper;
import csfs.remote.FileNotFoundException;
import csfs.remote.FileNotFoundExceptionHelper;
import csfs.remote.FileSequenceHelper;
import csfs.remote.FileServerHelper;
import csfs.remote.InvalidPathException;
import csfs.remote.InvalidPathExceptionHelper;
import csfs.remote.InvalidStateException;
import csfs.remote.InvalidStateExceptionHelper;
import csfs.remote.Metadata;
import csfs.remote.MetadataSequenceHelper;
import csfs.remote.NotDirectoryException;
import csfs.remote.NotDirectoryExceptionHelper;
import csfs.remote.NotEmptyException;
import csfs.remote.NotEmptyExceptionHelper;
import csfs.remote.NotFileException;
import csfs.remote.NotFileExceptionHelper;
import csfs.remote.OctetSequenceHelper;
import csfs.remote.PathHelper;
import csfs.remote.RandomAccessChannelHelper;
import csfs.remote.ReadChannelHelper;
import csfs.remote.RemoteFile;
import csfs.remote.RemoteFileHelper;
import csfs.remote.RemoteFileOperations;
import csfs.remote.ServerException;
import csfs.remote.ServerExceptionHelper;
import csfs.remote.WriteChannelHelper;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class RemoteFilePOA
extends Servant
implements InvokeHandler,
RemoteFileOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:csfs/remote/RemoteFile:1.0"};

    public RemoteFile _this() {
        return RemoteFileHelper.narrow(this._this_object());
    }

    public RemoteFile _this(ORB oRB) {
        return RemoteFileHelper.narrow(this._this_object(oRB));
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (null == n) {
            throw new BAD_OPERATION(string + " not found");
        }
        switch (n) {
            case 0: {
                try {
                    outputStream = responseHandler.createReply();
                    FileServerHelper.write(outputStream, this.getFileServer());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                break;
            }
            case 1: {
                try {
                    String[] stringArray = FieldSequenceHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    MetadataSequenceHelper.write(outputStream, this.getMetadata(stringArray));
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 2: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_string(this.getName());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 3: {
                try {
                    outputStream = responseHandler.createReply();
                    this.enableExecutionPermission();
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 4: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_boolean(this.unlock());
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 5: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_longlong(this.lastModified());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 6: {
                try {
                    String[] stringArray = PathHelper.read(inputStream);
                    RemoteFile remoteFile = RemoteFileHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    outputStream.write_boolean(this.addMountPoint(stringArray, remoteFile));
                }
                catch (NotDirectoryException notDirectoryException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotDirectoryExceptionHelper.write(outputStream, notDirectoryException);
                }
                catch (InvalidPathException invalidPathException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPathExceptionHelper.write(outputStream, invalidPathException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    outputStream = responseHandler.createExceptionReply();
                    FileAlreadyExistsExceptionHelper.write(outputStream, fileAlreadyExistsException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 7: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_boolean(this.tryLock());
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 8: {
                try {
                    outputStream = responseHandler.createReply();
                    ReadChannelHelper.write(outputStream, this.getReadChannel());
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 9: {
                try {
                    outputStream = responseHandler.createReply();
                    FileSequenceHelper.write(outputStream, this.getChildren());
                }
                catch (NotDirectoryException notDirectoryException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotDirectoryExceptionHelper.write(outputStream, notDirectoryException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 10: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_boolean(this.remove());
                }
                catch (FileInUseException fileInUseException) {
                    outputStream = responseHandler.createExceptionReply();
                    FileInUseExceptionHelper.write(outputStream, fileInUseException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (NotEmptyException notEmptyException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotEmptyExceptionHelper.write(outputStream, notEmptyException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 11: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_boolean(this.isDirectory());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 12: {
                try {
                    RemoteFile remoteFile = RemoteFileHelper.read(inputStream);
                    String string2 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    outputStream.write_boolean(this.copyTo(remoteFile, string2));
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 13: {
                try {
                    String[] stringArray = PathHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    RemoteFileHelper.write(outputStream, this.createDirectory(stringArray));
                }
                catch (NotDirectoryException notDirectoryException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotDirectoryExceptionHelper.write(outputStream, notDirectoryException);
                }
                catch (InvalidPathException invalidPathException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPathExceptionHelper.write(outputStream, invalidPathException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    outputStream = responseHandler.createExceptionReply();
                    FileAlreadyExistsExceptionHelper.write(outputStream, fileAlreadyExistsException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 14: {
                try {
                    outputStream = responseHandler.createReply();
                    RandomAccessChannelHelper.write(outputStream, this.getRandomAccessChannel());
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 15: {
                try {
                    String[] stringArray = PathHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    RemoteFileHelper.write(outputStream, this.createFile(stringArray));
                }
                catch (NotDirectoryException notDirectoryException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotDirectoryExceptionHelper.write(outputStream, notDirectoryException);
                }
                catch (InvalidPathException invalidPathException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPathExceptionHelper.write(outputStream, invalidPathException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    outputStream = responseHandler.createExceptionReply();
                    FileAlreadyExistsExceptionHelper.write(outputStream, fileAlreadyExistsException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 16: {
                try {
                    outputStream = responseHandler.createReply();
                    outputStream.write_ulonglong(this.size());
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 17: {
                try {
                    RemoteFile remoteFile = RemoteFileHelper.read(inputStream);
                    String string3 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    outputStream.write_boolean(this.moveTo(remoteFile, string3));
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (FileInUseException fileInUseException) {
                    outputStream = responseHandler.createExceptionReply();
                    FileInUseExceptionHelper.write(outputStream, fileInUseException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 18: {
                try {
                    outputStream = responseHandler.createReply();
                    RemoteFileHelper.write(outputStream, this.getParent());
                }
                catch (InvalidPathException invalidPathException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPathExceptionHelper.write(outputStream, invalidPathException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 19: {
                try {
                    String[] stringArray = PathHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    RemoteFileHelper.write(outputStream, this.removeMountPoint(stringArray));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputStream = responseHandler.createExceptionReply();
                    FileNotFoundExceptionHelper.write(outputStream, fileNotFoundException);
                }
                catch (NotDirectoryException notDirectoryException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotDirectoryExceptionHelper.write(outputStream, notDirectoryException);
                }
                catch (InvalidPathException invalidPathException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPathExceptionHelper.write(outputStream, invalidPathException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 20: {
                try {
                    Metadata[] metadataArray = MetadataSequenceHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.setMetadata(metadataArray);
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 21: {
                try {
                    outputStream = responseHandler.createReply();
                    PathHelper.write(outputStream, this.getFullName());
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 22: {
                try {
                    outputStream = responseHandler.createReply();
                    WriteChannelHelper.write(outputStream, this.getWriteChannel());
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 23: {
                try {
                    Metadata[] metadataArray = MetadataSequenceHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.updateMetadata(metadataArray);
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 24: {
                try {
                    outputStream = responseHandler.createReply();
                    MetadataSequenceHelper.write(outputStream, this.getAllMetadata());
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 25: {
                try {
                    outputStream = responseHandler.createReply();
                    OctetSequenceHelper.write(outputStream, this.hash());
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 26: {
                try {
                    String[] stringArray = PathHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    RemoteFileHelper.write(outputStream, this.getChild(stringArray));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    outputStream = responseHandler.createExceptionReply();
                    FileNotFoundExceptionHelper.write(outputStream, fileNotFoundException);
                }
                catch (NotDirectoryException notDirectoryException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotDirectoryExceptionHelper.write(outputStream, notDirectoryException);
                }
                catch (InvalidPathException invalidPathException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPathExceptionHelper.write(outputStream, invalidPathException);
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
                break;
            }
            case 27: {
                try {
                    long l = inputStream.read_ulonglong();
                    outputStream = responseHandler.createReply();
                    outputStream.write_boolean(this.truncate(l));
                    break;
                }
                catch (NotFileException notFileException) {
                    outputStream = responseHandler.createExceptionReply();
                    NotFileExceptionHelper.write(outputStream, notFileException);
                    break;
                }
                catch (FileInUseException fileInUseException) {
                    outputStream = responseHandler.createExceptionReply();
                    FileInUseExceptionHelper.write(outputStream, fileInUseException);
                    break;
                }
                catch (ServerException serverException) {
                    outputStream = responseHandler.createExceptionReply();
                    ServerExceptionHelper.write(outputStream, serverException);
                    break;
                }
                catch (InvalidStateException invalidStateException) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidStateExceptionHelper.write(outputStream, invalidStateException);
                }
            }
        }
        return outputStream;
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    static {
        m_opsHash.put("getFileServer", new Integer(0));
        m_opsHash.put("getMetadata", new Integer(1));
        m_opsHash.put("getName", new Integer(2));
        m_opsHash.put("enableExecutionPermission", new Integer(3));
        m_opsHash.put("unlock", new Integer(4));
        m_opsHash.put("lastModified", new Integer(5));
        m_opsHash.put("addMountPoint", new Integer(6));
        m_opsHash.put("tryLock", new Integer(7));
        m_opsHash.put("getReadChannel", new Integer(8));
        m_opsHash.put("getChildren", new Integer(9));
        m_opsHash.put("remove", new Integer(10));
        m_opsHash.put("isDirectory", new Integer(11));
        m_opsHash.put("copyTo", new Integer(12));
        m_opsHash.put("createDirectory", new Integer(13));
        m_opsHash.put("getRandomAccessChannel", new Integer(14));
        m_opsHash.put("createFile", new Integer(15));
        m_opsHash.put("size", new Integer(16));
        m_opsHash.put("moveTo", new Integer(17));
        m_opsHash.put("getParent", new Integer(18));
        m_opsHash.put("removeMountPoint", new Integer(19));
        m_opsHash.put("setMetadata", new Integer(20));
        m_opsHash.put("getFullName", new Integer(21));
        m_opsHash.put("getWriteChannel", new Integer(22));
        m_opsHash.put("updateMetadata", new Integer(23));
        m_opsHash.put("getAllMetadata", new Integer(24));
        m_opsHash.put("hash", new Integer(25));
        m_opsHash.put("getChild", new Integer(26));
        m_opsHash.put("truncate", new Integer(27));
    }
}

