/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.corba;

import csfs.datatransfer.DataTransferMethod;
import csfs.datatransfer.corba.SegmentedCORBAManager;
import csfs.impl.util.ServerExceptionBuilder;
import csfs.impl.util.SystemProperties;
import csfs.remote.InvalidStateException;
import csfs.remote.NotFileException;
import csfs.remote.RandomAccessChannel;
import csfs.remote.RemoteFile;
import csfs.remote.ServerException;
import java.io.File;

public class SegmentedCORBAMethod
implements DataTransferMethod {
    @Override
    public boolean copy(File localFile, RemoteFile destination, String method) throws NotFileException, InvalidStateException, ServerException {
        boolean response = false;
        try {
            if (!localFile.isFile()) {
                throw new InvalidStateException("It is not possible to copy a directory", new String[0]);
            }
            int index = method.lastIndexOf(45) + 1;
            int numChannels = Integer.parseInt(method.substring(index));
            String bufferStr = method.substring(method.indexOf(45) + 1, index - 1);
            int corbaBuffer = Integer.parseInt(bufferStr);
            long size = localFile.length();
            long block = size / (long)numChannels;
            SegmentedCORBAManager manager = new SegmentedCORBAManager();
            for (int i = 0; i < numChannels; ++i) {
                RandomAccessChannel channel = destination.getRandomAccessChannel();
                if (i != numChannels - 1) {
                    manager.addSegment((long)i * block, block, localFile, channel, corbaBuffer);
                    continue;
                }
                manager.addSegment((long)i * block, size - (long)i * block, localFile, channel, corbaBuffer);
            }
            manager.copyFile();
            response = true;
        }
        catch (Exception ex) {
            throw ServerExceptionBuilder.createServerException(ex);
        }
        return response;
    }

    @Override
    public String getName() {
        return "SegmentedCORBA";
    }

    @Override
    public String getDetailedInfo() {
        return "SegmentedCORBA" + SystemProperties.getProperty("CORBA_BUFFER_SIZE");
    }
}

